window.useNativeConsole = true;

var dConsole, dConsoleContents, dConsoleIsSticky = false, dConsoleTimer;
function alertd() {

	if (useNativeConsole) {
		return;
	}

	if (!dConsole) {
		var alphaNormal = 0.5, alphaSticky = 0.75;
		dConsole = document.createElement('div');
		dConsole.style.position = 'fixed';
		dConsole.style.bottom = '0px';
		dConsole.style.width = '100%';
		dConsole.style.height = '150px';
		dConsole.style.zIndex = 1000000;
		dConsole.style.backgroundColor = 'rgba(0,0,0,'+alphaNormal+')';
		document.body.appendChild(dConsole);
		
		dConsole.ondblclick = function () {
			if (dConsoleIsSticky) {
				dConsole.style.visibility = 'hidden';
				dConsole.style.backgroundColor = 'rgba(0,0,0,'+alphaNormal+')';
			}
			else {
				dConsole.style.backgroundColor = 'rgba(0,0,0,'+alphaSticky+')';
				clearTimeout(dConsoleTimer);
			}
			dConsoleIsSticky = !dConsoleIsSticky;
		};
		dConsoleContents = document.createElement('div');;
		dConsoleContents.style.height = '140px';
		dConsoleContents.style.position = 'absolute';
		dConsoleContents.style.top = '0px';
		dConsoleContents.style.width = '100%';
		dConsoleContents.style.paddingTop = '10px';
		dConsoleContents.style.font = '11px Menlo';
		dConsoleContents.style.overflowY = 'scroll';
		dConsoleContents.style.color = '#fff';
		dConsole.appendChild(dConsoleContents);
		
		var clearButton = document.createElement('button');
		clearButton.textContent = 'Clear';
		clearButton.style.position = 'absolute';
		clearButton.style.right = '10px';
		clearButton.style.top = '2px';
		clearButton.onclick = function () {
			dConsoleContents.innerHTML = '';
		};
		dConsole.appendChild(clearButton);
		//alert(dConsole);
	}
	
	var msg = document.createElement('div');
	msg.style.paddingLeft = '10px';
	var str = '';
	
	function printArguments(args) {
		for (var i = 0, c = args.length; i < c; i++) {
			if (i !== 0) str += '   ';
			if (typeof args[i] === 'object' &&
				args[i] !== null) {
				if (args[i].UTI)
					str += '(object '+args[i].UTI+(args[i].$id?' <'+args[i].$id+'>':'')+')';
				else if (args[i].length && args[i][0]) {
					str += '[';
					printArguments(args[i]);
					str += ']';
				}
				else
					str += args[i];
			}
			else
				str += args[i];
		}
	}
	printArguments(arguments);

	msg.textContent = str;
	if (!dConsoleContents) return;
	dConsoleContents.appendChild(msg);
	dConsoleContents.scrollTop = 1000000;
	dConsole.style.visibility = '';
	
	if (dConsoleTimer) clearTimeout(dConsoleTimer);
	
	if (!dConsoleIsSticky)
	dConsoleTimer = setTimeout(function () {
		dConsoleTimer = null;
		dConsole.style.visibility = 'hidden';
	}, 2000);
}

window.onerror = function (err) {
	alertd('Error: '+err);
}
