
registerType('appdoo.iOS', (function () { function EditableSetOfItems() {} var __super = setSupertypeFromDomain(EditableSetOfItems, 'BasicEditableObject', 'appdoo');

EditableSetOfItems.prototype.createForContext = function EditableSetOfItems_createForContext(context) {

			var instance = createComponentFromDomain(
				this.constructor.name,
				this.__domain,
				context,
				{
				}
			);
		
		
		
		return instance;
		};
	

	Object.defineProperty(EditableSetOfItems.prototype, "inspectorProperties", {
		get: function () {
			var mainGroup = {
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
						{ name: LocalizedString('Name'), keyPath: 'e_name', placeholder: 'Name', undefinedValue:'', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
						{ type: 'custom', UTI: 'appdoo.iOS.EditableSetElementSeparator', properties: { size: { width:225, height:20 }, autoresizingMask: 2 }, fullWidth: true },
						{ type: 'space' },
					]
				};
			
			var i = 0;
			if (Array.isArray(this.objectInfos)) this.objectInfos.every(function (objectInfo) {
				var itemProperties = this.itemPropertiesAtIndex(i);
				if (Array.isArray(itemProperties)) itemProperties.every(function (p) {
					mainGroup.items.push(p);return true; }, this);
				
				mainGroup.items.push(
						
						{ type: 'custom', UTI: 'appdoo.iOS.EditableSetElementModifiers', properties: { size: { width:225, height:30 }, autoresizingMask: 2, index: i }, fullWidth: true }
						,{ type: 'space' }
						);
				i++;return true; }, this);
			
			
			mainGroup.items.push({ type: 'button', caption: this.addItemString, buttonStyle: 'flat', align:'', positionLeft: true, buttonWidth: this.addItemButtonWidth, actionKeyPath: 'addObject', marginTop:this.objectInfos&&this.objectInfos.length?-5:2 });
				
			return [mainGroup];
		}});
	

EditableSetOfItems.prototype.addObject = function EditableSetOfItems__addObject() {};
	

EditableSetOfItems.prototype.action = function EditableSetOfItems_action() {
		this.simulateAction();};
	

	Object.defineProperty(EditableSetOfItems.prototype, "readableValue", {
		get: function () {
			if (this.name) return this.name;
			var str = '';
			if (this.objectInfos.length > 2) return this.readableType;
			for (var i = 0, c = this.objectInfos.length; i < c; i++) {
				var objectInfo = this.objectInfos[i];
				if (!objectInfo) continue;
				var t = objectInfo.readableValue;
				if (!t) continue;
				if (str) str += ' & ';
				str += objectInfo.readableValue;
			}
			return str||this.readableType;
		}});
	

EditableSetOfItems.prototype.prepareForEditor = function EditableSetOfItems_prepareForEditor(editor) {
		
		if (!this.objectInfosController) {
			this.objectInfosController = createComponentFromDomain('ArrayController', 'Core', editor.context, {
				contents: this.objectInfos,
				canUndo: true
			});
			this.objectInfosController.parentObject = this;
			this.objectInfosController.controllerKey = 'objectInfosController';
			this.objectInfosController.undoDelegate = this;
		}
		};
	
	
EditableSetOfItems.prototype.objectControllerDidUndoChange = function EditableSetOfItems_objectControllerDidUndoChange(objectInfosController) {
		_context.editor.refreshInspector();	
		this.readableValueDidChange();};
	

	Object.defineProperty(EditableSetOfItems.prototype, "objectInfosController", {
	synthesized: true, get:function () { return this._objectInfosController; }, set:function (v) {if (!Object.hasOwnProperty(this, "_objectInfosController")) Object.defineProperty(this, "_objectInfosController", { writable: true, configurable: true }); this._objectInfosController = v; }});
	

EditableSetOfItems.prototype.expectedTypeForProperty = function EditableSetOfItems_expectedTypeForProperty(key) {
	if (key === "inspectorProperties") return "";
	if (key === "readableValue") return "";
	if (key === "objectInfosController") return "ArrayController";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return EditableSetOfItems; }()));
registerType('appdoo.iOS', (function () { function EditableSetElementModifiers() {} var __super = setSupertypeFromDomain(EditableSetElementModifiers, 'View', 'Core.UI');

	Object.defineProperty(EditableSetElementModifiers.prototype, "editableSet", {
		get: function () {
			return _context.editor.selection.contents[0];
		}});
	

	Object.defineProperty(EditableSetElementModifiers.prototype, "index", {
	outlet: true, get:function () { return this._index; }, set:function (v) {if (!Object.hasOwnProperty(this, "_index")) Object.defineProperty(this, "_index", { writable: true, configurable: true }); this._index = v; }});
	

	
EditableSetElementModifiers.prototype.init = function EditableSetElementModifiers_init() {
		__super.prototype.init.call(this);
		
		
		this.style({opacity:'.66'});
		this.createSubviews();
		return this;};
	
	
EditableSetElementModifiers.prototype.createSubviews = function EditableSetElementModifiers_createSubviews() {
		this.backgroundView = createComponentFromDomain("View", "Core.UI", this.context, {
			size: { width: 225+1, height: 10+2 },
			position: { left: 0, top: 10 },
			style: { border: '1px solid #bbb', borderTopColor:'transparent', boxSizing: 'border-box', borderBottomLeftRadius:'0px', borderBottomRightRadius:'0px' },
			autoresizingMask: 2})
		;
		this.addSubview(this.backgroundView);
		
		var moveUpButton = createComponentFromDomain("Button", "Core.UI", this.context, {
			
			imageSrc: 'Resources/MoveUp.png',
			size: { width: 16, height: 16 },
			position: { left: this.backgroundView.size.width-18*3-2+20-2-1-20-2-1, top: 0 },
			target: this,
			targetMethod: 'moveUpFromButton',
			autoresizingMask: 1,
			disabled: this.index <= 0})
		;
		this.addSubview(moveUpButton);
		
		var canMoveDown = false;
		var editableSet = this.editableSet;
		if (editableSet && editableSet.objectInfosController) {
			canMoveDown = editableSet.objectInfosController.numberOfValues-1 > this.index;
		}

		var moveDownButton = createComponentFromDomain("Button", "Core.UI", this.context, {
			
			imageSrc: 'Resources/MoveDown.png',
			size: { width: 16, height: 16 },
			position: { left: this.backgroundView.size.width-18*2-2+20-2-1-20-2-1, top: 0 },
			target: this,
			targetMethod: 'moveDownFromButton',
			autoresizingMask: 1,
			disabled: !canMoveDown})
		;
		this.addSubview(moveDownButton);

		var deleteButton = createComponentFromDomain("Button", "Core.UI", this.context, {
			
			imageSrc: 'Resources/DeleteItem.png',
			size: { width: 16, height: 16 },
			position: { left: this.backgroundView.size.width-18-2+20-2-1-20-2-1, top: 0 },
			target: this,
			targetMethod: 'deleteFromButton',
			autoresizingMask: 1,})
		;
		this.addSubview(deleteButton);};
	
	
EditableSetElementModifiers.prototype.moveUpFromButton = function EditableSetElementModifiers__moveUpFromButton(sender) {
		var editableSet = this.editableSet;
		if (!editableSet || !editableSet.objectInfosController) return;
		
		if (this.index <= 0) return;

		editableSet.objectInfosController.moveValueFromIndexToIndex(this.index, this.index-1, this);
		_context.editor.refreshInspector();	
		editableSet.readableValueDidChange();};
	

EditableSetElementModifiers.prototype.moveDownFromButton = function EditableSetElementModifiers__moveDownFromButton(sender) {
		var editableSet = this.editableSet;
		if (!editableSet || !editableSet.objectInfosController) return;

		editableSet.objectInfosController.moveValueFromIndexToIndex(this.index, this.index+1, this);
		_context.editor.refreshInspector();	
		editableSet.readableValueDidChange();};
	

EditableSetElementModifiers.prototype.deleteFromButton = function EditableSetElementModifiers__deleteFromButton(sender) {
		var editableSet = this.editableSet;
		if (!editableSet || !editableSet.objectInfosController) return;
		
		editableSet.objectInfosController.removeValueAtIndex(this.index, this);
		_context.editor.refreshInspector();	
		editableSet.readableValueDidChange();};
	
	
EditableSetElementModifiers.prototype.initPropertiesFromData = function EditableSetElementModifiers_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("index")) this.index = data.index;
};

EditableSetElementModifiers.prototype.decodeData = function EditableSetElementModifiers_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

EditableSetElementModifiers.prototype.encode = function EditableSetElementModifiers_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

EditableSetElementModifiers.prototype.encodeCloned = function EditableSetElementModifiers_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

EditableSetElementModifiers.prototype.expectedTypeForProperty = function EditableSetElementModifiers_expectedTypeForProperty(key) {
	if (key === "editableSet") return "EditableSetOfItems";
	if (key === "index") return "Number";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return EditableSetElementModifiers; }()));
registerType('appdoo.iOS', (function () { function EditableSetElementSeparator() {} var __super = setSupertypeFromDomain(EditableSetElementSeparator, 'View', 'Core.UI');
EditableSetElementSeparator.prototype.init = function EditableSetElementSeparator_init() {
		__super.prototype.init.call(this);
		
		
		this.style({opacity:'.66'});
		this.createSubviews();
		return this;};
	
	
EditableSetElementSeparator.prototype.createSubviews = function EditableSetElementSeparator_createSubviews() {
		this.backgroundView = createComponentFromDomain("View", "Core.UI", this.context, {
			size: { width: 225+1, height: 10+2 },
			position: { left: 0, top: 0 },
			style: { border: '1px solid #bbb', borderTopColor:'transparent', boxSizing: 'border-box', borderBottomLeftRadius:'0px', borderBottomRightRadius:'0px' },
			autoresizingMask: 2})
		;
		this.addSubview(this.backgroundView);};
	
EditableSetElementSeparator.prototype.expectedTypeForProperty = function EditableSetElementSeparator_expectedTypeForProperty(key) {
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return EditableSetElementSeparator; }()));
registerType('appdoo.iOS', (function () { function ActionSet() {} var __super = setSupertypeFromDomain(ActionSet, 'EditableSetOfItems', 'appdoo.iOS');

	Object.defineProperty(ActionSet.prototype, "outlineIconURL", {
		value: 'Resources/ActionSet.png'});
	

	Object.defineProperty(ActionSet.prototype, "iconURL", {
		value: 'Resources/ActionSet48.png'});
	

	Object.defineProperty(ActionSet.prototype, "requiresPreviewBuildVersion", {
		value: 8});
	

	Object.defineProperty(ActionSet.prototype, "performableActions", {
		get: function () {
			return {
				'perform': { name: LocalizedString('Execute'), }
			};
		}});
	

	Object.defineProperty(ActionSet.prototype, "readableDescription", {
		get: function () {
			return LocalizedString('Multiple actions that are performed at once');
		}});
	

	Object.defineProperty(ActionSet.prototype, "readableType", {
		get: function () {
			return LocalizedString('Action Set');
		}});
	
	
	Object.defineProperty(ActionSet.prototype, "addItemString", {
		get: function () {
			return LocalizedString('Add Action');
		}});
	

	Object.defineProperty(ActionSet.prototype, "addItemButtonWidth", {
		get: function () {
			return LocalizedNumber('ADD_ACTION_BUTTON_BUTTON_WIDTH')||120;
		}});
	

	Object.defineProperty(ActionSet.prototype, "actionInfos", {
	outlet: true, 
	enumerable: true, 
		get: function () {
			if (!this._actionInfos) this.actionInfos = [];
			return this._actionInfos;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_actionInfos")) Object.defineProperty(this, "_actionInfos", { writable: true, configurable: true }); this._actionInfos = v; }});
	
	
	Object.defineProperty(ActionSet.prototype, "objectInfos", {
		get: function () { return this.actionInfos; }, 
		set: function (v) { this.actionInfos = v; }});
	

ActionSet.prototype.addObject = function ActionSet__addObject() {
		
		
		var ai = createComponentFromDomain('ActionInfo', 'appdoo', this.context, {});
		
		if (this.objectInfosController) {
			this.objectInfosController.addValue(ai, this);
			_context.editor.refreshInspector();
			this.readableValueDidChange();
		}
		else {
			this.actionInfos.push(ai);
		}};
	
	
ActionSet.prototype.simulateAction = function ActionSet_simulateAction(name) {
		
		
			for (var i = 0, c = this.objectInfos.length; i < c; i++) {
				var actionInfo = this.actionInfos[i];
				if (!actionInfo) continue;
				_context.editor.simulateAction(null, actionInfo, true);
			}
		};
	

ActionSet.prototype.transformDataForObjectiveC = function ActionSet_transformDataForObjectiveC(data, generator) {
		var instructions = [];
		if (Array.isArray(data.actionInfos)) data.actionInfos.every(function (actionInfo) {

			var procedure = generator.createProcedureFromData(actionInfo.actionType, actionInfo);

			if (!procedure) return true;
			instructions.push(procedure.transformDataForObjectiveC(procedure, generator)||'');return true; }, this);
		
		return instructions.join('\n\t');
};
	

	
ActionSet.prototype.transformData = function ActionSet_transformData(data, transformer) {
		var result = transformer.createObject(data);
		transformer.setStringProperty(result, 'actionInfosJSON', JSON.stringify(data.actionInfos));
		result.$needsContextReference = true;
		result.$needsViewControllerReference = true;
		return result;};
	
	
ActionSet.prototype.itemPropertiesAtIndex = function ActionSet__itemPropertiesAtIndex(i) {
		return [{ name: LocalizedString('Action')+' '+(i+1), keyPath: 'objectInfos.'+i, type: 'action', context: 'actionset',  }];};
	
	
	Object.defineProperty(ActionSet.prototype, "inspectorProperties", {
		get: function () {
			var p = Object.getOwnPropertyDescriptor(__super.prototype, "inspectorProperties").get.call(this);
			p[0].items.unshift({type:'space'});
			return p;
		}});
	

ActionSet.prototype.initPropertiesFromData = function ActionSet_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("actionInfos")) this.actionInfos = data.actionInfos;
};

ActionSet.prototype.decodeData = function ActionSet_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("actionInfos")) decoded.actionInfos = []; if (Array.isArray(data.actionInfos)) { data.actionInfos.forEach(function (o) { decoded.actionInfos.push(this.context.decodeObjectTree(o)); }.bind(this)); }
return decoded; };

ActionSet.prototype.encode = function ActionSet_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._actionInfos && this._actionInfos.encode) {encoded.actionInfos = []; this._actionInfos.forEach(function (o) { encoded.actionInfos.push(o.encode()); });
}return encoded; };

ActionSet.prototype.encodeCloned = function ActionSet_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._actionInfos && this._actionInfos.encode) {encoded.actionInfos = []; this._actionInfos.forEach(function (o) { encoded.actionInfos.push(o.encodeCloned()); });
}return encoded; };

ActionSet.prototype.expectedTypeForProperty = function ActionSet_expectedTypeForProperty(key) {
	if (key === "outlineIconURL") return "";
	if (key === "iconURL") return "";
	if (key === "requiresPreviewBuildVersion") return "";
	if (key === "performableActions") return "";
	if (key === "readableDescription") return "";
	if (key === "readableType") return "";
	if (key === "addItemString") return "";
	if (key === "addItemButtonWidth") return "";
	if (key === "actionInfos") return "ActionInfo[]";
	if (key === "objectInfos") return "";
	if (key === "inspectorProperties") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ActionSet; }()));
registerType('info.appdoo-mac', (function () { function ConditionalAction() {} var __super = setSupertypeFromDomain(ConditionalAction, 'EditableSetOfItems', 'appdoo.iOS');

	
ConditionalAction.prototype.instancesCanBeLocal = function ConditionalAction_instancesCanBeLocal(obj) {
		return true;};
	

ConditionalAction.prototype.instancesCanBeGlobal = function ConditionalAction_instancesCanBeGlobal(obj) {
		return false;};
	

ConditionalAction.prototype.createForContext = function ConditionalAction_createForContext(context) {

			var instance = createComponentFromDomain(
				this.constructor.name,
				this.__domain,
				context,
				{
					comparisonMode: 'and'
				}
			);

		instance.addObject();
		instance.actionElse = createComponentFromDomain('ActionInfo', 'appdoo', context, { actionType: '' });
		
		return instance;
		};
	

	Object.defineProperty(ConditionalAction.prototype, "addItemString", {
		get: function () {
			return LocalizedString('Add Condition');
		}});
	

	Object.defineProperty(ConditionalAction.prototype, "addItemButtonWidth", {
		get: function () {
			return TRANSLATE(
				{
					'de': 135,
					'en': 90
				});
		}});
	

	Object.defineProperty(ConditionalAction.prototype, "objectInfos", {
	outlet: true, 
	enumerable: true, 
		get: function () {
			if (!this._objectInfos) this.objectInfos = [];
			return this._objectInfos;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_objectInfos")) Object.defineProperty(this, "_objectInfos", { writable: true, configurable: true }); this._objectInfos = v; }});
	

ConditionalAction.prototype.addObject = function ConditionalAction__addObject() {
		
		var ai = createComponentFromDomain('ConditionInfo', 'appdoo', this.context, { conditionType: 'equalTo' });
		if (this.objectInfosController) {
			this.objectInfosController.addValue(ai, this);
			_context.editor.refreshInspector();
			this.readableValueDidChange();
		}
		else {
			this.objectInfos.push(ai);
		}};
	

ConditionalAction.prototype.itemPropertiesAtIndex = function ConditionalAction__itemPropertiesAtIndex(i) {
		var n = LocalizedString('Intepret as a Number');
		var comparativeValueProperties = [
			{ type: 'textarea', isFirstInGroup: true, marginTop: -5, keyPath: 'objectInfos.'+i+'.comparativeValue' },
			{ name: n, type: 'boolean', positionLeft:true, keyPath: 'objectInfos.'+i+'.interpretsComparativeValueAsNumber' }
		];
		
		var comparativeNumberProperties = [
			{type: 'text', labelOnTop: true, marginTop: -5, keyPath: 'objectInfos.'+i+'.comparativeValue'},
			{ name: LocalizedString('Or Equal'), type: 'boolean', positionLeft:true, keyPath: 'objectInfos.'+i+'.orEqual' }
		];
		
		return [
			{ name: '', keyPath: 'objectInfos.'+i+'.conditionType', type: 'select', options: [
				
				
				['equalTo',LocalizedString('The Value is Equal To…'), comparativeValueProperties],
				['notEqualTo',LocalizedString('The Value is Not Equal To…'), comparativeValueProperties],
				['lowerThan',LocalizedString('The Value is Lower Than…'),comparativeNumberProperties],
				['greaterThan',LocalizedString('The Value is Greater Than…'),comparativeNumberProperties],
				['statement',LocalizedString('The Statement … is true'),[
					{ type: 'select', numberOfVisibleItems: 4, positionLeft: true, marginTop: -6, showsIcons: false, keyPath: 'objectInfos.'+i+'.conditionStatement', options: [
						['isNotEmpty',LocalizedString('The Value is not empty')],
						['isEmpty',LocalizedString('The Value is empty')],
						['isTrue',LocalizedString('The Value is true')],
						['isFalse',LocalizedString('The Value is false')],
					] },
				]],
				['isValidEmail',LocalizedString('The Value is a valid email address'), []],
				['isValidURL',LocalizedString('The Value is a valid URL'), []],
			], positionLeft: true }
		];};
	

	Object.defineProperty(ConditionalAction.prototype, "inspectorProperties", {
		get: function () {
			var properties = Object.getOwnPropertyDescriptor(__super.prototype, "inspectorProperties").get.call(this);
			

			properties.push({
					type: 'group',
					title: LocalizedString('Behavior'),
					id: this.constructor.name+'Action',
					items: [
					{ type: 'action', context: 'actionset', keyPath: 'actionIf', name: LocalizedString('then') },{type:'space'},
						{ type: 'action', context: 'actionset', keyPath: 'actionElse', name: LocalizedString('else') }
					]
				});

			properties.unshift({
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
					]
				});
			
			properties[1].title = LocalizedString('Conditions');
			properties[1].id = this.constructor.name+'Conditions';

			properties[0].items.unshift(
				{ name: '     '+LocalizedString('Data Value'), type: 'info', keyPath: "boundDataValue", html:'<span onclick="_context.editor.showDataLinksAndHighlight(0)" class="dataLinkPseudoLink">'+LocalizedString('Create a Link for the Data Value')+'</span>', height: 50, showIcon:true, positionLeft:true });
			properties[0].items.unshift(
				{ name: LocalizedString('Name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') });
			properties[2].items.unshift(
				{ type: 'select', options: [
					['and',LocalizedString('all')],
					['or',LocalizedString('At Least One')]
				], name: LocalizedString('if'), keyPath: 'comparisonMode' },
				
				{ type: 'info', html: LocalizedString('of the Conditions Are/Is Met'), height:30,marginTop:-5}
			);

			return properties;
		}});
	


	Object.defineProperty(ConditionalAction.prototype, "comparisonMode", {
	outlet: true, 
	enumerable: true, get:function () { return this._comparisonMode; }, set:function (v) {if (!Object.hasOwnProperty(this, "_comparisonMode")) Object.defineProperty(this, "_comparisonMode", { writable: true, configurable: true }); this._comparisonMode = v; }});
	


	Object.defineProperty(ConditionalAction.prototype, "actionIf", {
	outlet: true, 
	enumerable: true, get:function () { return this._actionIf; }, set:function (v) {if (!Object.hasOwnProperty(this, "_actionIf")) Object.defineProperty(this, "_actionIf", { writable: true, configurable: true }); this._actionIf = v; }});
	


	Object.defineProperty(ConditionalAction.prototype, "actionElse", {
	outlet: true, 
	enumerable: true, get:function () { return this._actionElse; }, set:function (v) {if (!Object.hasOwnProperty(this, "_actionElse")) Object.defineProperty(this, "_actionElse", { writable: true, configurable: true }); this._actionElse = v; }});
	

ConditionalAction.prototype.readableNameForProperty = function ConditionalAction_readableNameForProperty(name) {
		if (name === 'boundDataValue') return LocalizedString('Data Value');
		return __super.prototype.readableNameForProperty.call(this, name);};
	


	Object.defineProperty(ConditionalAction.prototype, "readableValue", {
		get: function () {
			if (this.name) return this.name;
			return this.readableType;










		}});
	

	Object.defineProperty(ConditionalAction.prototype, "bindableProperties", {
		get: function () {
			var result = [];
			['boundDataValue'].every(function (key) {
				result.push([key, this.readableNameForProperty(key)]);
				return true;
			}, this);
			return result;
		}});
	

	Object.defineProperty(ConditionalAction.prototype, "readableType", {
		get: function () {
			return LocalizedString('Conditional Action');
		}});
	

	Object.defineProperty(ConditionalAction.prototype, "performableActions", {
		get: function () {
			return {
				'perform': { name: LocalizedString('Execute'), }
			};
		}});
	

	
ConditionalAction.prototype.transformData = function ConditionalAction_transformData(data, transformer) {
		var result = transformer.createObject(data);
		result.$needsContextReference = true;
		transformer.setStringProperty(result, 'comparisonMode', data.comparisonMode);
		transformer.setStringProperty(result, 'actionIfInfoJSON', JSON.stringify(data.actionIf));
		transformer.setStringProperty(result, 'actionElseInfoJSON', JSON.stringify(data.actionElse));
		transformer.setStringProperty(result, 'conditionsInfoJSON', JSON.stringify(data.objectInfos));
		var binding = this.bindingForKey.call(data, 'boundDataValue');
		if (binding) {
			transformer.setReferenceProperty(result, 'valueObject', data.$id, binding.destination);
			transformer.setStringProperty(result, 'valueObjectKeyPath', binding.destinationKeyPath);
		}
		return result;};
	

ConditionalAction.prototype.transformDataForObjectiveC = function ConditionalAction_transformDataForObjectiveC(data, generator) {
		var binding = this.bindingForKey.call(data, 'boundDataValue');
		if (!binding) return '// Missing Value Data Link\n';
		var codePath = generator.codePathForProjectID(binding.destination);
		if (!codePath) return '// Invalid Data Link\n';
		var code = '{\n\t\tid value = ['+codePath+' valueForKeyPath:'+generator.transformString(binding.destinationKeyPath)+'];\n\t';
		code += '\tif (';
		if (Array.isArray(data.objectInfos)) data.objectInfos.every(function (conditionInfo) {
			code += getPrototype('appdoo.ConditionInfo').transformDataForObjectiveC(conditionInfo, generator);
			if (data.objectInfos.indexOf(conditionInfo) !== data.objectInfos.length -1)
				code += data.comparisonMode === 'and' ? ' && ' : ' || ';return true; }, this);
		
		code += ') {\n'
		code += '\t\t';
		var p1 = generator.createProcedureFromData(null, data.actionIf.encode());
		code += (generator.codeForInstruction(p1)||'').split('\n').join('\n\t\t');
		
		
		code += '}';
		code +=  ' else {\n';
		code += '\t\t';
		var p2 = generator.createProcedureFromData(null, data.actionElse.encode());
		code += (generator.codeForInstruction(p2)||'').split('\n').join('\n\t\t');
		
		code += '}\n\t}';
		
		return code;};
	

	Object.defineProperty(ConditionalAction.prototype, "outlineIconURL", {
		value: 'Resources/ConditionalAction.png'});
	

	Object.defineProperty(ConditionalAction.prototype, "iconURL", {
		value: 'Resources/ConditionalAction48.png'});
	
	
	Object.defineProperty(ConditionalAction.prototype, "readableDescription", {
		get: function () {
			return TRANSLATE({'de':'Führt eine Aktion aus, falls Bedingungen zutreffen','en':'Performs an action de&shy;pen&shy;ding on conditions'});
		}});
	
	
ConditionalAction.prototype.simulateAction = function ConditionalAction_simulateAction(name) {
		var binding = this.bindingForKey('boundDataValue');
		if (!binding || !binding.destinationIsMutable || !binding.destinationObject || !binding.destinationObject)
			return false;

		var value = binding.destinationObject.get(binding.destinationKeyPath);
		var result = true;
		
		if (Array.isArray(this.objectInfos)) this.objectInfos.every(function (conditionInfo) {
			try {
				result = result && conditionInfo.test(value);
			} catch (err) {
				result = false;
			}
			
			if (!result) return false;return true; }, this);
		
		if (result) {
			if (this.actionIf) {
				
				_context.editor.simulateAction(null, this.actionIf, true);
			}
		}
		else {
			if (this.actionElse) {
				
				_context.editor.simulateAction(null, this.actionElse, true);
			}
		}};
	

ConditionalAction.prototype.initPropertiesFromData = function ConditionalAction_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("objectInfos")) this.objectInfos = data.objectInfos;
if (data.hasOwnProperty("comparisonMode")) this.comparisonMode = data.comparisonMode;
if (data.hasOwnProperty("actionIf")) this.actionIf = data.actionIf;
if (data.hasOwnProperty("actionElse")) this.actionElse = data.actionElse;
};

ConditionalAction.prototype.decodeData = function ConditionalAction_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("objectInfos")) decoded.objectInfos = []; if (Array.isArray(data.objectInfos)) { data.objectInfos.forEach(function (o) { decoded.objectInfos.push(this.context.decodeObjectTree(o)); }.bind(this)); }
if (data.hasOwnProperty("actionIf")) decoded.actionIf = this.context.decodeObjectTree(data.actionIf);
if (data.hasOwnProperty("actionElse")) decoded.actionElse = this.context.decodeObjectTree(data.actionElse);
return decoded; };

ConditionalAction.prototype.encode = function ConditionalAction_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._objectInfos && this._objectInfos.encode) {encoded.objectInfos = []; this._objectInfos.forEach(function (o) { encoded.objectInfos.push(o.encode()); });
}if (this._actionIf && this._actionIf.encode) {encoded.actionIf = this.actionIf.encode();
}if (this._actionElse && this._actionElse.encode) {encoded.actionElse = this.actionElse.encode();
}return encoded; };

ConditionalAction.prototype.encodeCloned = function ConditionalAction_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._objectInfos && this._objectInfos.encode) {encoded.objectInfos = []; this._objectInfos.forEach(function (o) { encoded.objectInfos.push(o.encodeCloned()); });
}if (this._actionIf && this._actionIf.encode) {encoded.actionIf = this.actionIf.encodeCloned();
}if (this._actionElse && this._actionElse.encode) {encoded.actionElse = this.actionElse.encodeCloned();
}return encoded; };

ConditionalAction.prototype.expectedTypeForProperty = function ConditionalAction_expectedTypeForProperty(key) {
	if (key === "addItemString") return "";
	if (key === "addItemButtonWidth") return "";
	if (key === "objectInfos") return "BasicObject[]";
	if (key === "inspectorProperties") return "";
	if (key === "comparisonMode") return "String";
	if (key === "actionIf") return "ActionInfo";
	if (key === "actionElse") return "ActionInfo";
	if (key === "readableValue") return "";
	if (key === "bindableProperties") return "";
	if (key === "readableType") return "";
	if (key === "performableActions") return "";
	if (key === "outlineIconURL") return "";
	if (key === "iconURL") return "";
	if (key === "readableDescription") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ConditionalAction; }()));
registerType('appdoo', (function () { function ConditionInfo() {} var __super = setSupertypeFromDomain(ConditionInfo, 'BasicObject', 'Core');


	Object.defineProperty(ConditionInfo.prototype, "conditionType", {
	outlet: true, 
	enumerable: true, get:function () { return this._conditionType; }, set:function (v) {if (!Object.hasOwnProperty(this, "_conditionType")) Object.defineProperty(this, "_conditionType", { writable: true, configurable: true }); this._conditionType = v; }});
	

	Object.defineProperty(ConditionInfo.prototype, "conditionStatement", {
	outlet: true, 
	enumerable: true, get:function () { return this._conditionStatement; }, set:function (v) {if (!Object.hasOwnProperty(this, "_conditionStatement")) Object.defineProperty(this, "_conditionStatement", { writable: true, configurable: true }); this._conditionStatement = v; }});
	

	Object.defineProperty(ConditionInfo.prototype, "comparativeValue", {
	outlet: true, 
	enumerable: true, get:function () { return this._comparativeValue; }, set:function (v) {if (!Object.hasOwnProperty(this, "_comparativeValue")) Object.defineProperty(this, "_comparativeValue", { writable: true, configurable: true }); this._comparativeValue = v; }});
	

	Object.defineProperty(ConditionInfo.prototype, "interpretsComparativeValueAsNumber", {
	outlet: true, 
	enumerable: true, get:function () { return this._interpretsComparativeValueAsNumber; }, set:function (v) {if (!Object.hasOwnProperty(this, "_interpretsComparativeValueAsNumber")) Object.defineProperty(this, "_interpretsComparativeValueAsNumber", { writable: true, configurable: true }); this._interpretsComparativeValueAsNumber = v; }});
	

	Object.defineProperty(ConditionInfo.prototype, "orEqual", {
	outlet: true, 
	enumerable: true, get:function () { return this._orEqual; }, set:function (v) {if (!Object.hasOwnProperty(this, "_orEqual")) Object.defineProperty(this, "_orEqual", { writable: true, configurable: true }); this._orEqual = v; }});
	
	
ConditionInfo.prototype.test = function ConditionInfo_test(value) {
		if (this.conditionType === 'equalTo' || this.conditionType === 'notEqualTo') {
			
			if (this.interpretsComparativeValueAsNumber) {
				if (this.conditionType === 'equalTo')
					return value*1 === this.comparativeValue*1;
				if (this.conditionType === 'notEqualTo')
					return value*1 !== this.comparativeValue*1;
			}
			else {
				if (this.conditionType === 'equalTo')
					return value === this.comparativeValue;
				if (this.conditionType === 'notEqualTo')
					return value !== this.comparativeValue;
			}
		}
		if (this.conditionType === 'greaterThan' || this.conditionType === 'lowerThan') {
			if (this.conditionType === 'greaterThan')
				if (this.orEqual)
					return value >= this.comparativeValue;
				else
					return value > this.comparativeValue;
			else
				if (this.orEqual)
					return value <= this.comparativeValue;
				else
					return value < this.comparativeValue;
		}
		if (this.conditionType === 'statement') {
			switch (this.conditionStatement) {
				case 'isNotEmpty':
					if (Array.isArray(value)) return value.length !== 0;
					if (typeof value === 'object') return Object.keys(value).length !== 0;
					if (typeof value === 'string') return value.length !== 0;
					return !!v;
					break;
				case 'isEmpty':
					if (Array.isArray(value)) return value.length === 0;
					if (typeof value === 'object') return Object.keys(value).length === 0;
					if (typeof value === 'string') return value.length === 0;
					return !v;
					break;
				case 'isTrue':
					return (typeof value === 'boolean' || typeof value === 'number') && !!value; 
					break;
				case 'isFalse':
					return (typeof value === 'boolean' || typeof value === 'number') && !value; 
					break;
			}
		}
		if (this.conditionType === 'isValidEmail') {
            return  value.match(/^(([^<>()\[\]\.,;:\s@\"]+(\.[^<>()\[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i);
		}
		if (this.conditionType === 'isValidURL') {
			return value.match(/^(http|https|ftp):\/\/(([A-Z0-9][A-Z0-9_-]*)(\.[A-Z0-9][A-Z0-9_-]*)+)(:(\d+))?\/?/i)
		}
		return false;};
	





ConditionInfo.prototype.transformDataForObjectiveC = function ConditionInfo_transformDataForObjectiveC(data, generator) {
		if (data.conditionType === 'equalTo' || data.conditionType === 'notEqualTo') {
			
			if (data.interpretsComparativeValueAsNumber) {
				var op;
				if (data.conditionType === 'equalTo')
					op = '==';
				if (data.conditionType === 'notEqualTo')
					op = '!=';
				return '[value doubleValue] '+op+' '+generator.transformNumber(data.comparativeValue);
			}
			else {
				var s = '[value isKindOfClass:[NSString class]] && [value isEqualToString:'+generator.transformString(data.comparativeValue)+']';
			
				if (data.conditionType === 'equalTo')
					return s;
				if (data.conditionType === 'notEqualTo')
					return '!('+s+')';
			}
		}
		if (data.conditionType === 'greaterThan' || data.conditionType === 'lowerThan') {
			var op;
			if (data.conditionType === 'greaterThan')
				op = '>';
			else
				op = '<';
			if (data.orEqual)
				op += '=';

			return '[value doubleValue] '+op+' '+generator.transformNumber(data.comparativeValue);
		}
		if (data.conditionType === 'statement') {
			switch (data.conditionStatement) {
				case 'isNotEmpty':
					return '([value isKindOfClass:[NSArray class]] || [value isKindOfClass:[NSDictionary class]]) ? [value count] : [value length]'; 
					break;
				case 'isEmpty':
					return '([value isKindOfClass:[NSArray class]] || [value isKindOfClass:[NSDictionary class]]) ? ![value count] : ![value length]'; 
					break;
				case 'isTrue':
					return '[value isKindOfClass:[NSNumber class]] && [value boolValue] == TRUE'; 
					break;
				case 'isFalse':
					return '[value isKindOfClass:[NSNumber class]] && [value boolValue] == FALSE'; 
					break;
			}
		}
		if (data.conditionType === 'isValidEmail') {
			return '[[NSRegularExpression regularExpressionWithPattern:@"^[A-Z0-9a-z._%+-]+@[A-Za-z0-9.-]+\.[A-Za-z0-9.-]{2,4}$" options:NSRegularExpressionCaseInsensitive error:nil] numberOfMatchesInString:[(NSString*)value encodedURLString] options:NSMatchingReportCompletion range:NSMakeRange(0, [(NSString*)value length])] > 0';
		}
		if (data.conditionType === 'isValidURL') {
			return '[NSURL URLWithString:[(NSString*)value encodedURLString]] != nil';
		}
		return '0';};
	
	
ConditionInfo.prototype.initPropertiesFromData = function ConditionInfo_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("conditionType")) this.conditionType = data.conditionType;
if (data.hasOwnProperty("conditionStatement")) this.conditionStatement = data.conditionStatement;
if (data.hasOwnProperty("comparativeValue")) this.comparativeValue = data.comparativeValue;
if (data.hasOwnProperty("interpretsComparativeValueAsNumber")) this.interpretsComparativeValueAsNumber = data.interpretsComparativeValueAsNumber;
if (data.hasOwnProperty("orEqual")) this.orEqual = data.orEqual;
};

ConditionInfo.prototype.decodeData = function ConditionInfo_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

ConditionInfo.prototype.encode = function ConditionInfo_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

ConditionInfo.prototype.encodeCloned = function ConditionInfo_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

ConditionInfo.prototype.expectedTypeForProperty = function ConditionInfo_expectedTypeForProperty(key) {
	if (key === "conditionType") return "String";
	if (key === "conditionStatement") return "String";
	if (key === "comparativeValue") return "String";
	if (key === "interpretsComparativeValueAsNumber") return "Boolean";
	if (key === "orEqual") return "Boolean";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ConditionInfo; }()));