
registerType('info.appdoo-mac', (function () { function ActivityViewGenerator() {} var __super = setSupertypeFromDomain(ActivityViewGenerator, 'BasicEditableObject', 'appdoo');

	Object.defineProperty(ActivityViewGenerator.prototype, "readableType", {
		get: function () { return LocalizedString('Share Menu'); }});
	

	Object.defineProperty(ActivityViewGenerator.prototype, "readableDescription", {
		get: function () { return LocalizedString('Shows a menu with various sharing options'); }});
	
	
	Object.defineProperty(ActivityViewGenerator.prototype, "string", {
	outlet: true, 
	enumerable: true, get:function () { return this._string; }, set:function (v) {if (!Object.hasOwnProperty(this, "_string")) Object.defineProperty(this, "_string", { writable: true, configurable: true }); this._string = v; }});
	

	Object.defineProperty(ActivityViewGenerator.prototype, "URLString", {
	outlet: true, 
	enumerable: true, get:function () { return this._URLString; }, set:function (v) {if (!Object.hasOwnProperty(this, "_URLString")) Object.defineProperty(this, "_URLString", { writable: true, configurable: true }); this._URLString = v; }});
	

	Object.defineProperty(ActivityViewGenerator.prototype, "sharesString", {
	outlet: true, 
	enumerable: true, get:function () { return this._sharesString; }, set:function (v) {if (!Object.hasOwnProperty(this, "_sharesString")) Object.defineProperty(this, "_sharesString", { writable: true, configurable: true }); this._sharesString = v; }});
	

	Object.defineProperty(ActivityViewGenerator.prototype, "sharesURL", {
	outlet: true, 
	enumerable: true, get:function () { return this._sharesURL; }, set:function (v) {if (!Object.hasOwnProperty(this, "_sharesURL")) Object.defineProperty(this, "_sharesURL", { writable: true, configurable: true }); this._sharesURL = v; }});
	

	Object.defineProperty(ActivityViewGenerator.prototype, "inspectorProperties", {
		get: function () {

			return [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
						{ name: LocalizedString('Name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', labelOnTop: true, positionLeft: true, placeholder:LocalizedString('Optional') },
						{ type: 'boolean', name: this.readableNameForProperty('sharesString'), keyPath: 'sharesString', positionLeft: true, conditionalProperties: [
								{ dataName: this.readableNameForProperty('string'), keyPath: 'string', type: 'textarea', labelOnTop:true },
						
						] },
						
						{ type: 'boolean', name: this.readableNameForProperty('sharesURL'), keyPath: 'sharesURL', positionLeft: true, conditionalProperties: [
							{ dataName: this.readableNameForProperty('URLString'), keyPath: 'URLString', type: 'textarea', labelOnTop:true },
						] },

					]
				}
			]
		}});
	

	Object.defineProperty(ActivityViewGenerator.prototype, "bindableProperties", {
		get: function () {
			var result = Object.getOwnPropertyDescriptor(__super.prototype, "bindableProperties").get.call(this);
			['URLString','string'].every(function (key) {
				result.unshift([key, this.readableNameForProperty(key)]);
				return true;
			}, this);
			return result;
		}});
	

ActivityViewGenerator.prototype.readableNameForProperty = function ActivityViewGenerator_readableNameForProperty(name) {
		switch (name) {
			case 'string': return LocalizedString('Text');
			case 'URLString': return LocalizedString('URL');
			case 'sharesString': return LocalizedString('Share Text');
			case 'sharesURL': return LocalizedString('Share URL');
		}
		return __super.prototype.readableNameForProperty.call(this, name);};
	

	Object.defineProperty(ActivityViewGenerator.prototype, "performableActions", {
		get: function () {
			return {
				'show': { name: LocalizedString('Show') },
			};
		}});
	
		
	Object.defineProperty(ActivityViewGenerator.prototype, "isPlugin", {
		value: true});
	
	
	Object.defineProperty(ActivityViewGenerator.prototype, "iconURL", {
		value: 'Resources/ActivityViewGenerator48.png'});
	

	Object.defineProperty(ActivityViewGenerator.prototype, "outlineIconURL", {
		value: 'Resources/ActivityViewGenerator.png'});
	

ActivityViewGenerator.prototype.transformData = function ActivityViewGenerator_transformData(data, transformer) {
		if (transformer.isXIBGenerator) return this.avg_transformDataForXIB(data, transformer);
		else return this.avg_transformDataForPreview(data, transformer);};
	

ActivityViewGenerator.prototype.avg_transformDataForXIB = function ActivityViewGenerator_avg_transformDataForXIB(data, transformer) {

		var result = {
			customClass: this.constructor.name,
			userDefinedRuntimeAttributes: {},
			userLabel: data.name||undefined
		};

		if (data.sharesString)
		result.userDefinedRuntimeAttributes['userDefinedRuntimeAttribute 1'] = {
			keyPath: 'string',
			type: 'string',
			value: data.string||''
		};
		
		if (data.sharesURL)
		result.userDefinedRuntimeAttributes['userDefinedRuntimeAttribute 2'] = {
			keyPath: 'URLString',
			type: 'string',
			value: data.URLString||''
		};












		
		transformer.object__addOutlet__from__to__(result, 'viewController', data.$id, transformer.currentViewControllerId);

		return result;
	};
	

ActivityViewGenerator.prototype.avg_transformDataForPreview = function ActivityViewGenerator_avg_transformDataForPreview(data, transformer) {

		var result = {
			$type: this.constructor.name,
			$domain: this.__domain,
			$id: data.$id,
		};
		
		result.string = transformer.transformString(data.string);
		result.URLString = transformer.transformString(data.URLString);
		transformer.addConnection({
			source: data.$id,
			destinationObject: {$type: '$CurrentViewController'},
			type: 'outlet',
			key: 'viewController'
		});
		
		return result;
		};
	

ActivityViewGenerator.prototype.initPropertiesFromData = function ActivityViewGenerator_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("string")) this.string = data.string;
if (data.hasOwnProperty("URLString")) this.URLString = data.URLString;
if (data.hasOwnProperty("sharesString")) this.sharesString = data.sharesString;
if (data.hasOwnProperty("sharesURL")) this.sharesURL = data.sharesURL;
};

ActivityViewGenerator.prototype.decodeData = function ActivityViewGenerator_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

ActivityViewGenerator.prototype.encode = function ActivityViewGenerator_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

ActivityViewGenerator.prototype.encodeCloned = function ActivityViewGenerator_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

ActivityViewGenerator.prototype.expectedTypeForProperty = function ActivityViewGenerator_expectedTypeForProperty(key) {
	if (key === "readableType") return "";
	if (key === "readableDescription") return "";
	if (key === "string") return "String";
	if (key === "URLString") return "String";
	if (key === "sharesString") return "Boolean";
	if (key === "sharesURL") return "Boolean";
	if (key === "inspectorProperties") return "";
	if (key === "bindableProperties") return "";
	if (key === "performableActions") return "";
	if (key === "isPlugin") return "";
	if (key === "iconURL") return "";
	if (key === "outlineIconURL") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ActivityViewGenerator; }()));