
registerType('info.appdoo-mac', (function () { function AlertViewGenerator() {} var __super = setSupertypeFromDomain(AlertViewGenerator, 'BasicEditableObject', 'appdoo');

	Object.defineProperty(AlertViewGenerator.prototype, "title", {
	outlet: true, 
	enumerable: true, get:function () { return this._title; }, set:function (v) {if (!Object.hasOwnProperty(this, "_title")) Object.defineProperty(this, "_title", { writable: true, configurable: true }); this._title = v; }});
	

	Object.defineProperty(AlertViewGenerator.prototype, "message", {
	outlet: true, 
	enumerable: true, get:function () { return this._message; }, set:function (v) {if (!Object.hasOwnProperty(this, "_message")) Object.defineProperty(this, "_message", { writable: true, configurable: true }); this._message = v; }});
	

	Object.defineProperty(AlertViewGenerator.prototype, "readableType", {
		get: function () { return TRANSLATE({'en':'Alert View','de':'Hinweisdialog'}); }});
	

	Object.defineProperty(AlertViewGenerator.prototype, "readableValue", {
		get: function () {
			return this.name || this.title || this.readableType;
		}});
	

AlertViewGenerator.prototype.readableNameForProperty = function AlertViewGenerator_readableNameForProperty(name) {
		if (name === 'name') return LocalizedString('Name');
		return __super.prototype.readableNameForProperty.call(this, name);};
	

	Object.defineProperty(AlertViewGenerator.prototype, "nameIsEditable", {
		value: true});
	

	Object.defineProperty(AlertViewGenerator.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
						{ name: this.readableNameForProperty('name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, labelOnTop:true },
						{ name: this.readableNameForProperty('title'), keyPath: 'title', type: 'text', labelOnTop:true },
						{ name: this.readableNameForProperty('message'), keyPath: 'message', type: 'textarea' },

					]
				}
			]
		}});
	

	Object.defineProperty(AlertViewGenerator.prototype, "bindableProperties", {
		get: function () {
			var result = Object.getOwnPropertyDescriptor(__super.prototype, "bindableProperties").get.call(this);
			['title','message'].every(function (key) {
				result.push([key, this.readableNameForProperty(key)]);
				return true;
			}, this);
			return result;
		}});
	

AlertViewGenerator.prototype.readableNameForProperty = function AlertViewGenerator_readableNameForProperty(name) {
		switch (name) {
			case 'title': return LocalizedString('Headline');
			case 'message': return LocalizedString('Message');
		}
		return __super.prototype.readableNameForProperty.call(this, name);};
	

	Object.defineProperty(AlertViewGenerator.prototype, "performableActions", {
		get: function () {
			return {
				'show': { name: LocalizedString('Show') },
			};
		}});
	
	
AlertViewGenerator.prototype.simulateAction = function AlertViewGenerator_simulateAction(actionID) {
		if (actionID === 'show') {
			_context.nativeProxy.sendMessage('alertWithDetails', JSON.stringify({
				message: LocalizedString(this.title),
				details: LocalizedString(this.message)
			}));
		}};
	
	
AlertViewGenerator.prototype.action = function AlertViewGenerator_action(sender) {
		this.simulateAction('show');};
	
	
	Object.defineProperty(AlertViewGenerator.prototype, "isPlugin", {
		value: true});
	
	
	Object.defineProperty(AlertViewGenerator.prototype, "outlineIconURL", {
		value: 'Resources/AlertViewGenerator.png'});
	

	Object.defineProperty(AlertViewGenerator.prototype, "iconURL", {
		value: 'Resources/AlertViewGenerator48.png'});
	

AlertViewGenerator.prototype.transformData = function AlertViewGenerator_transformData(data, transformer) {

		var result = transformer.createObject(data);
		
		transformer.setStringProperty(result, 'title', data.title);
		transformer.setStringProperty(result, 'message', data.message);
		
		return result;
		};
	

























AlertViewGenerator.prototype.initPropertiesFromData = function AlertViewGenerator_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("title")) this.title = data.title;
if (data.hasOwnProperty("message")) this.message = data.message;
};

AlertViewGenerator.prototype.decodeData = function AlertViewGenerator_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

AlertViewGenerator.prototype.encode = function AlertViewGenerator_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

AlertViewGenerator.prototype.encodeCloned = function AlertViewGenerator_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

AlertViewGenerator.prototype.expectedTypeForProperty = function AlertViewGenerator_expectedTypeForProperty(key) {
	if (key === "title") return "String";
	if (key === "message") return "String";
	if (key === "readableType") return "";
	if (key === "readableValue") return "";
	if (key === "nameIsEditable") return "";
	if (key === "inspectorProperties") return "";
	if (key === "bindableProperties") return "";
	if (key === "performableActions") return "";
	if (key === "isPlugin") return "";
	if (key === "outlineIconURL") return "";
	if (key === "iconURL") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return AlertViewGenerator; }()));