
registerType('info.appdoo-mac', (function () { function AtomDataSource() {} var __super = setSupertypeFromDomain(AtomDataSource, 'BasicDataSource', 'appdoo');

	Object.defineProperty(AtomDataSource.prototype, "readableDescription", {
		get: function () {
			return LocalizedString('Provides data from the Atom 1.0 feed format');
		}});
	

AtomDataSource.prototype.init = function AtomDataSource_init() {
		__super.prototype.init.call(this);
		if (!this.location) this.location = 'remote';
		return this;};
	




AtomDataSource.prototype.createForContext = function AtomDataSource_createForContext(context, options) {
		var inst = __super.prototype.createForContext.call(this, context);
		if (options && options.droppedOnView) {
			this.createUITableViewForSuperview(options.droppedOnView, inst);
		}
		return inst;};
	

	Object.defineProperty(AtomDataSource.prototype, "feedObject", {
	synthesized: true, get:function () { return this._feedObject; }, set:function (v) {if (!Object.hasOwnProperty(this, "_feedObject")) Object.defineProperty(this, "_feedObject", { writable: true, configurable: true }); this._feedObject = v; }});
	

	Object.defineProperty(AtomDataSource.prototype, "rootData", {
		get: function () {
			var r = {};
			if (!this.feedObject) {
				return r;
			}
			r.entry = this.feedObject.entry;
			r.title = this.feedObject.title;
			r.subtitle = this.feedObject.subtitle;
			for (var key in this.feedObject) {
				r[key] = this.feedObject[key];
			}
			return r;
		}});
	

	Object.defineProperty(AtomDataSource.prototype, "itemArray", {
		get: function () {
			if (this.feedObject) return this.feedObject.entry;
		}});
	
	
	Object.defineProperty(AtomDataSource.prototype, "itemArrayKeyPath", {
		value: 'entry'});
	
	

	Object.defineProperty(AtomDataSource.prototype, "providesRootData", {
		value: true});
	

	Object.defineProperty(AtomDataSource.prototype, "data", {
		set: function (data) {

			

			var contents;

			try {
				var jsonString = this.context.nativeProxy.sendMessage('convertAtomToJSON', data);
				this.feedObject = JSON.parse(jsonString);
				contents = this.feedObject;
				if (!this.name) {
					this.e_name = contents.title;
				}
			}
			catch (err) {
				console.warn('The feed JSON could not be parsed.', err);
				contents = [];
			}
			
			this.lastCheckWasValid = (contents&&(contents.title||contents.link)) || !data;
			
			
			
			this.contents = contents;

		}});
	
	
AtomDataSource.prototype.determineFirstItemKey = function AtomDataSource__determineFirstItemKey(item) {
		return 'title';};
	


	Object.defineProperty(AtomDataSource.prototype, "readableType", {
		get: function () { return LocalizedString('Atom Feed'); }});
	






	Object.defineProperty(AtomDataSource.prototype, "outlineIconURL", {
		get: function () {
			return 'Resources/AtomDataSource.png';
		}});
	

	Object.defineProperty(AtomDataSource.prototype, "iconURL", {
		get: function () {
			return 'Resources/AtomDataSource48.png';
		}});
	

	Object.defineProperty(AtomDataSource.prototype, "readableValue", {
		get: function () { return this.name || this.readableType; }});
	









AtomDataSource.prototype.nameForKeyPath = function AtomDataSource_nameForKeyPath(keyPath) {
		if (keyPath === 'contents.link' || keyPath === 'link') return LocalizedString('Link');
		if (keyPath === 'contents.title' || keyPath === 'title') return LocalizedString('Title');
		if (keyPath === 'contents.subtitle') return LocalizedString('Subtitle');
		if (keyPath === 'content' || keyPath === 'contents.content') return LocalizedString('Content');
		if (keyPath === 'summary' || keyPath === 'contents.summary') return LocalizedString('Summary');
		if (keyPath === 'contents.rights') return LocalizedString('Rights');
		if (keyPath === 'contents.entry') return LocalizedString('Entries');
		if (keyPath === 'updated' || 'contents.updated') return LocalizedString('Date');
		return keyPath;};
	

	
	Object.defineProperty(AtomDataSource.prototype, "URLString", {
		set: function (v) { this.e_URL = v; }, 
		get: function ( ) { return this.e_URL; }});
	

	Object.defineProperty(AtomDataSource.prototype, "isPlugin", {
		value: true});
	

AtomDataSource.prototype.expectedTypeForProperty = function AtomDataSource_expectedTypeForProperty(key) {
	if (key === "readableDescription") return "";
	if (key === "feedObject") return "";
	if (key === "rootData") return "";
	if (key === "itemArray") return "";
	if (key === "itemArrayKeyPath") return "";
	if (key === "providesRootData") return "";
	if (key === "data") return "";
	if (key === "readableType") return "";
	if (key === "outlineIconURL") return "";
	if (key === "iconURL") return "";
	if (key === "readableValue") return "";
	if (key === "URLString") return "String";
	if (key === "isPlugin") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return AtomDataSource; }()));