
registerType('info.appdoo-mac', (function () { function ButtonWithSubviews() {} var __super = setSupertypeFromDomain(ButtonWithSubviews, 'ViewGroup', 'appdoo.iOS');

	Object.defineProperty(ButtonWithSubviews.prototype, "actionType", {
	outlet: true, 
	enumerable: true, get:function () { return this._actionType; }, set:function (v) {if (!Object.hasOwnProperty(this, "_actionType")) Object.defineProperty(this, "_actionType", { writable: true, configurable: true }); this._actionType = v; }});
	
	
	Object.defineProperty(ButtonWithSubviews.prototype, "actionInfo", {
	outlet: true, 
	enumerable: true, 
		get: function () { return EditableObjectGetActionInfoProperty.call(this); }, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_actionInfo")) Object.defineProperty(this, "_actionInfo", { writable: true, configurable: true }); EditableObjectSetActionInfoProperty.call(this, v); }});
	

ButtonWithSubviews.prototype.init = function ButtonWithSubviews_init() {
		__super.prototype.init.call(this);
		if (this.actionType === undefined) this.actionType = 'objectAction';
		return this;};
	

	Object.defineProperty(ButtonWithSubviews.prototype, "readableType", {
		get: function () {
			return LocalizedString('Text Button');
		}});
	
	
	Object.defineProperty(ButtonWithSubviews.prototype, "viewMayScroll", {
		value: false});
	

	Object.defineProperty(ButtonWithSubviews.prototype, "readableValue", {
		get: function () {
			if (this.name) return this.name;
			if (this.subviews.length === 1 &&
				this.subviews[0].UTI === 'appdoo.iOS.UILabel') return this.readableType+' „'+this.subviews[0].readableValue+'“';
			return this.readableType;
		}});
	

	Object.defineProperty(ButtonWithSubviews.prototype, "outlineIconURL", {
		value: 'Resources/ButtonWithSubviews.png'});
	

	Object.defineProperty(ButtonWithSubviews.prototype, "nameIsEditable", {
		value: true});
	

ButtonWithSubviews.prototype.editDefault = function ButtonWithSubviews_editDefault(editor) {
		if (this.subviews.length === 1 &&
			this.subviews[0].editDefault) {
			_context.editor.selectSingleObject(this.subviews[0]);
			return this.subviews[0].editDefault(editor);
		}
		return editor.beginEditingSubview(this);};
	
	
	Object.defineProperty(ButtonWithSubviews.prototype, "e_actionObjectID", {
		get: function ( ) { return this.actionInfo.objectID; }, 
		set: function (v) { this.actionInfo.objectID = v; _context.editor.refreshInspector(); }});
	
	
	Object.defineProperty(ButtonWithSubviews.prototype, "inspectorProperties", {
		get: function () {
		
			return [
				{
					type: 'group',
					title: this.readableType,
					id: 'view',
					items: [
						
						{ type: 'action', currentActionType: this.actionType, currentActionObjectID: this.e_actionObjectID },


						{ type: 'space' },
						{ name: LocalizedString('Background Color'), keyPath: 'backgroundColor', type: 'color', undefinedValue: this.defaultBackgroundColor, }
					]
				}
			];
		}});
	
	
	Object.defineProperty(ButtonWithSubviews.prototype, "cocoaType", {
	configurable: true, 
		value: 'UIView'});
	

	Object.defineProperty(ButtonWithSubviews.prototype, "cocoaCustomType", {
	configurable: true, 
		value: 'ButtonWithSubviews'});
	
	
	Object.defineProperty(ButtonWithSubviews.prototype, "isPlugin", {
		value: true});
	
	
	Object.defineProperty(ButtonWithSubviews.prototype, "pluginIdentifier", {
		value: 'info.appdoo-mac.ButtonWithSubviews'});
	
	
	
ButtonWithSubviews.prototype.action = function ButtonWithSubviews_action(sender) {
		_context.editor.simulateAction(this.actionType, this.actionInfo);};
	

ButtonWithSubviews.prototype.prepareForEditor = function ButtonWithSubviews_prepareForEditor(editor) {
		
		__super.prototype.prepareForEditor.call(this, editor);
		this.DOMNode.onclick = function (e) {
			if (editor.isActionClick(e)) this.action();
		}.bind(this);
		this.DOMNode.className += ' canClickInActionMode';
		this.updateTextColor();};
	
	
ButtonWithSubviews.prototype.updateTextColor = function ButtonWithSubviews__updateTextColor() {

		var labelType = getType('appdoo.iOS.UILabel');
		if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
			if (subview instanceof labelType) {
				if (subview.textColor) return true;
				
				subview.textColor = this.context.defaultOrSystemTintColor;
			}return true; }, this);
		
	};
	
	
ButtonWithSubviews.prototype.addSubview = function ButtonWithSubviews_addSubview(subview) {
		__super.prototype.addSubview.call(this, subview);
		this.updateTextColor();};
	
	
ButtonWithSubviews.prototype.insertSubviewAtIndex = function ButtonWithSubviews_insertSubviewAtIndex(subview, index) {
		__super.prototype.insertSubviewAtIndex.call(this, subview, index);
		this.updateTextColor();};
	

ButtonWithSubviews.prototype.removeSubview = function ButtonWithSubviews_removeSubview(subview, doNotDestroy) {
		__super.prototype.removeSubview.call(this, subview, doNotDestroy);
		var labelType = getType('appdoo.iOS.UILabel');
		if (doNotDestroy && subview instanceof labelType) {
			if (subview.textColor === this.context.defaultOrSystemTintColor)
				subview.textColor = '';
		}};
	
	
ButtonWithSubviews.prototype.transformData = function ButtonWithSubviews_transformData(data, transformer) {

		var result = __super.prototype.transformData.call(this, data, transformer);
		transformer.setType(result, 'UIButton');
		
		transformer.demandPlugin('info.appdoo-mac.ButtonWithSubviews');

		
		transformer.forEachSubview(result, function (subview) {

			
			transformer.setBooleanProperty(subview, 'userInteractionEnabled', false, true);


		});
		
		if (transformer.isXIBGenerator)
			transformer.transformAndAddActionToObject(null, data.actionInfo, result, data.$id);
		else
			transformer.addActionFromDataToResult(data, result);

		return result;
		};
	

ButtonWithSubviews.prototype.initPropertiesFromData = function ButtonWithSubviews_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("actionType")) this.actionType = data.actionType;
if (data.hasOwnProperty("actionInfo")) this.actionInfo = data.actionInfo;
};

ButtonWithSubviews.prototype.decodeData = function ButtonWithSubviews_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("actionInfo")) decoded.actionInfo = this.context.decodeObjectTree(data.actionInfo);
return decoded; };

ButtonWithSubviews.prototype.encode = function ButtonWithSubviews_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._actionInfo && this._actionInfo.encode) {encoded.actionInfo = this.actionInfo.encode();
}return encoded; };

ButtonWithSubviews.prototype.encodeCloned = function ButtonWithSubviews_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._actionInfo && this._actionInfo.encode) {encoded.actionInfo = this.actionInfo.encodeCloned();
}return encoded; };

ButtonWithSubviews.prototype.expectedTypeForProperty = function ButtonWithSubviews_expectedTypeForProperty(key) {
	if (key === "actionType") return "String";
	if (key === "actionInfo") return "ActionInfo";
	if (key === "readableType") return "";
	if (key === "viewMayScroll") return "";
	if (key === "readableValue") return "";
	if (key === "outlineIconURL") return "";
	if (key === "nameIsEditable") return "";
	if (key === "e_actionObjectID") return "";
	if (key === "inspectorProperties") return "";
	if (key === "cocoaType") return "";
	if (key === "cocoaCustomType") return "";
	if (key === "isPlugin") return "";
	if (key === "pluginIdentifier") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ButtonWithSubviews; }()));
registerType('appdoo.iOS', (function () { function ButtonWithSubviews() {} var __super = setSupertypeFromDomain(ButtonWithSubviews, 'ButtonWithSubviews', 'info.appdoo-mac');

	Object.defineProperty(ButtonWithSubviews.prototype, "isPlugin", {
		value: true});
	
	
	Object.defineProperty(ButtonWithSubviews.prototype, "pluginIdentifier", {
		value: 'info.appdoo-mac.ButtonWithSubviews'});
	

ButtonWithSubviews.prototype.expectedTypeForProperty = function ButtonWithSubviews_expectedTypeForProperty(key) {
	if (key === "isPlugin") return "";
	if (key === "pluginIdentifier") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ButtonWithSubviews; }()));