//
//  ButtonWithSubviews.m
//
//

#import "ButtonWithSubviews.h"

@implementation ButtonWithSubviews {
	CGFloat _alphaBeforeHighlighting;
}

- (void)setHighlighted:(BOOL)highlighted {
	if (highlighted == self.isHighlighted) return;
	[super setHighlighted:(BOOL)highlighted];
	if (highlighted) {
		_alphaBeforeHighlighting = self.alpha;
		self.alpha /= 2;
	}
	else {
		self.alpha = _alphaBeforeHighlighting;
	}
}

@end
