//
//  CPSObservable
//  Keeps track of all state observers and emmits specific changes.
//
//  Created by Jon Raphael 2015. No rights reserved.
//

#import <Foundation/Foundation.h>


@interface CPSObservable : NSObject

- (id)initWithObject:(id)object;

// The object that is observed.
@property (nonatomic, weak) id object;

// Adds an observer.
- (void)addObserver:(id)observer;

// Removes an observer.
- (void)removeObserver:(id)observer;

// Sends a observeValueForKeyPath:ofObject:change: message to each observer.
- (void)notifyObserversForKeyPath:(NSString *)keyPath;

@end
