#import "CPSObservable.h"

@implementation CPSObservable {
	NSHashTable * _observers;
}

- (id)initWithObject:(id)object {
	self.object = object;
	return self;
}

- (void)addObserver:(id)observer {
	if (_observers == nil) _observers = [[NSHashTable alloc] initWithOptions:(NSHashTableWeakMemory) capacity:10];
	[_observers addObject:observer];
}

- (void)removeObserver:(id)observer {
	[_observers removeObject:observer];
}

- (void)notifyObserversForKeyPath:(NSString *)keyPath {
	for (id observer in _observers) {
		[observer observeValueForKeyPath:keyPath ofObject:self.object change:nil context:0];
	}
}

@end
