//
//  CPSUITableView
//  A subclass of UITableView that is emmiting selection data.
//
//  Created by Jon Raphael 2015. No rights reserved.
//

#import <UIKit/UIKit.h>
#import "CPSObservable.h"

@interface CPSUITableView : UITableView <UITableViewDelegate>

// A single index for the current selection in the first section.
// If no row is selected, the value is -1.
@property (nonatomic) NSInteger selectedItemIndex;

// All indices for the current selection in the first section.
@property (nonatomic) NSArray * selectedItemIndices;

// Observable proxy
@property (nonatomic) CPSObservable * observable;

// cell heights for static cells only
@property (nonatomic, strong) NSString *staticCellHeights;

@end
