
registerType('info.appdoo-mac', (function () { function CSVDataSource() {} var __super = setSupertypeFromDomain(CSVDataSource, 'BasicDataSource', 'appdoo');
	
	Object.defineProperty(CSVDataSource.prototype, "readableDescription", {
		get: function () {
			return LocalizedString('Provides data from the CSV format');
		}});
	
	
CSVDataSource.prototype.createForContext = function CSVDataSource_createForContext(context) {
		var inst = __super.prototype.createForContext.call(this, context);
		inst.location = 'local';
		return inst;};
	

CSVDataSource.prototype.createForSuperview = function CSVDataSource_createForSuperview(view) {
		return this.createUITableViewForSuperview(view);};
	
	
	Object.defineProperty(CSVDataSource.prototype, "CSVData", {
		set: function (csv) {
		
			var contents, columnNames;
			
			

			try {
				var jsonString = this.context.nativeProxy.sendMessage('convertCSVToJSON', csv);
				var data = JSON.parse(jsonString);
				this.testObjectForKVCCompliance(data.contents);
				contents = data.contents;
				columnNames = data.columnNames;
			}
			catch (err) {
				console.warn('The CSV is invalid.', {CSV:csv}, err);
				contents = [];
				columnNames = [];
			}
			this.lastCheckWasValid = (contents && contents.length) || !csv;
						
			this.contents = contents;
			this.columnNames = columnNames;

		}});
	

	Object.defineProperty(CSVDataSource.prototype, "data", {
		set: function (v) {
			this.CSVData = v;
		}, 
		get: function (v) {
			return this.CSVData;
		}});
	

	Object.defineProperty(CSVDataSource.prototype, "providesRootData", {
		get: function () {
			return true;
		}});
	

	Object.defineProperty(CSVDataSource.prototype, "rootData", {
		get: function () {
			var d = {
				'contents': this.contents,
				
			};
			return d;
		}});
	
	
	Object.defineProperty(CSVDataSource.prototype, "rootDataKeyPath", {
		value: ''});
	

CSVDataSource.prototype.nameForKeyPath = function CSVDataSource_nameForKeyPath(keyPath) {
		
		if (keyPath === 'contents') return LocalizedString('Contents');
		if (keyPath === 'columnNames') return LocalizedString('Column Names');};
	

CSVDataSource.prototype.dataForIndexPath = function CSVDataSource_dataForIndexPath(indexPath) {
		var unorderedData = this.dataForItemInSectionAtIndex(indexPath.section, indexPath.item);
		var orderedData = {};
		
		if (Array.isArray(this.columnNames)) this.columnNames.every(function (columnName) {
			orderedData[columnName] = unorderedData[columnName];return true; }, this);
		
		
		return orderedData;};
	

CSVDataSource.prototype.determineFirstItemKey = function CSVDataSource__determineFirstItemKey(item) {

		if (this.columnNames) {
			return this.columnNames[0];
		}
};
	

	Object.defineProperty(CSVDataSource.prototype, "localCSVData", {
		set: function (v) {
			this.localData = v;
		}, 
		get: function (v) {
			return this.localData;
		}});
	

	Object.defineProperty(CSVDataSource.prototype, "iconURL", {
		get: function () {
			return 'Resources/CSVDataSource48.png';
		}});
	
	
	Object.defineProperty(CSVDataSource.prototype, "outlineIconURL", {
		get: function () {
			return 'Resources/CSVDataSource.png';
		}});
	
	
	Object.defineProperty(CSVDataSource.prototype, "readableType", {
		get: function () { return LocalizedString('CSV'); }});
	

	





	Object.defineProperty(CSVDataSource.prototype, "fileExtensionsForImport", {
		value: ['csv','tab','txt']});
	


	
	Object.defineProperty(CSVDataSource.prototype, "URLString", {
		set: function (v) { this.e_URL = v; }, 
		get: function ( ) { return this.e_URL; }});
	
	
	Object.defineProperty(CSVDataSource.prototype, "isPlugin", {
		value: true});
	

	Object.defineProperty(CSVDataSource.prototype, "pluginIdentifier", {
		value: 'info.appdoo-mac.CSVDataSource'});
	

CSVDataSource.prototype.expectedTypeForProperty = function CSVDataSource_expectedTypeForProperty(key) {
	if (key === "readableDescription") return "";
	if (key === "CSVData") return "";
	if (key === "data") return "";
	if (key === "providesRootData") return "";
	if (key === "rootData") return "";
	if (key === "rootDataKeyPath") return "";
	if (key === "localCSVData") return "";
	if (key === "iconURL") return "";
	if (key === "outlineIconURL") return "";
	if (key === "readableType") return "";
	if (key === "fileExtensionsForImport") return "";
	if (key === "URLString") return "String";
	if (key === "isPlugin") return "";
	if (key === "pluginIdentifier") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return CSVDataSource; }()));