
registerType('info.appdoo-mac', (function () { function DataSensor() {} var __super = setSupertypeFromDomain(DataSensor, 'BasicEditableObject', 'appdoo');
	
	Object.defineProperty(DataSensor.prototype, "readableType", {
		get: function () { return TRANSLATE({de:'Sensor',en:'Sensor'}); }});
	

	Object.defineProperty(DataSensor.prototype, "performableActions", {
		get: function () {
			return {
				'setBoundDataValue:<#string#>': { name: LocalizedString('Set Data Value'), parameters: [{ type:'text', name:LocalizedString('Value'), key:'string', }] },
				

				
			};
		}});
	

DataSensor.prototype.init = function DataSensor_init() {
		__super.prototype.init.call(this);
		if (this.enabled === undefined) this.enabled = true;
		return this;};
	

DataSensor.prototype.createForContext = function DataSensor_createForContext(context) {

		return createComponentFromDomain(
			this.constructor.name,
			this.__domain,
			context,
			{
				sensorBehaviour: 'valueChanges',
				
				triggersRepeatedly: true,
				enabled: true
			}
		);
		};
	

	Object.defineProperty(DataSensor.prototype, "sensorBehaviour", {
	outlet: true, 
	enumerable: true, get:function () { return this._sensorBehaviour; }, set:function (v) {if (!Object.hasOwnProperty(this, "_sensorBehaviour")) Object.defineProperty(this, "_sensorBehaviour", { writable: true, configurable: true }); this._sensorBehaviour = v; }});
	

	Object.defineProperty(DataSensor.prototype, "sensorConstraint", {
	outlet: true, 
	enumerable: true, get:function () { return this._sensorConstraint; }, set:function (v) {if (!Object.hasOwnProperty(this, "_sensorConstraint")) Object.defineProperty(this, "_sensorConstraint", { writable: true, configurable: true }); this._sensorConstraint = v; }});
	

	Object.defineProperty(DataSensor.prototype, "triggersRepeatedly", {
	outlet: true, 
	enumerable: true, get:function () { return this._triggersRepeatedly; }, set:function (v) {if (!Object.hasOwnProperty(this, "_triggersRepeatedly")) Object.defineProperty(this, "_triggersRepeatedly", { writable: true, configurable: true }); this._triggersRepeatedly = v; }});
	

	Object.defineProperty(DataSensor.prototype, "triggersInitially", {
	outlet: true, 
	enumerable: true, get:function () { return this._triggersInitially; }, set:function (v) {if (!Object.hasOwnProperty(this, "_triggersInitially")) Object.defineProperty(this, "_triggersInitially", { writable: true, configurable: true }); this._triggersInitially = v; }});
	

	Object.defineProperty(DataSensor.prototype, "interpretsComparativeValueAsNumber", {
	outlet: true, 
	enumerable: true, get:function () { return this._interpretsComparativeValueAsNumber; }, set:function (v) {if (!Object.hasOwnProperty(this, "_interpretsComparativeValueAsNumber")) Object.defineProperty(this, "_interpretsComparativeValueAsNumber", { writable: true, configurable: true }); this._interpretsComparativeValueAsNumber = v; }});
	

	Object.defineProperty(DataSensor.prototype, "comparativeValue", {
	outlet: true, 
	enumerable: true, get:function () { return this._comparativeValue; }, set:function (v) {if (!Object.hasOwnProperty(this, "_comparativeValue")) Object.defineProperty(this, "_comparativeValue", { writable: true, configurable: true }); this._comparativeValue = v; }});
	

	Object.defineProperty(DataSensor.prototype, "bindableProperties", {
		get: function () {
			var result = Object.getOwnPropertyDescriptor(__super.prototype, "bindableProperties").get.call(this);
			['boundDataValue'].every(function (key) {
				result.push([key, this.readableNameForProperty(key)]);
				return true;
			}, this);
			return result;
		}});
	
	
	Object.defineProperty(DataSensor.prototype, "boundDataValue", {
	synthesized: true, get:function () { return this._boundDataValue; }, set:function (v) {if (!Object.hasOwnProperty(this, "_boundDataValue")) Object.defineProperty(this, "_boundDataValue", { writable: true, configurable: true }); this._boundDataValue = v; }});
	
	
DataSensor.prototype.readableNameForProperty = function DataSensor_readableNameForProperty(name) {
		if (name === 'boundDataValue') return LocalizedString('Data Value');
		if (name === 'enabled') return LocalizedString('Enabled');
		return __super.prototype.readableNameForProperty.call(this, name);};
	
	
	Object.defineProperty(DataSensor.prototype, "enabled", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_enabled")) Object.defineProperty(this, "_enabled", { writable: true, configurable: true });
			if (this.enabled !== undefined) {
				this._enabled = v;
				this.outlineIconURLDidChange();
			}
			else this._enabled = v;
		}, get:function () { return this._enabled; }});
	

	Object.defineProperty(DataSensor.prototype, "inspectorProperties", {
		get: function () {

			return [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
						{ name: LocalizedString('Name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
						{ type: 'boolean', keyPath: 'enabled', name: this.readableNameForProperty('enabled'), positionLeft:true },
						{ type: 'space' },
						{ name: '     '+LocalizedString('Data Value'), type: 'info', keyPath: "boundDataValue", html:'<span onclick="_context.editor.showDataLinksAndHighlight(0)" class="dataLinkPseudoLink">'+LocalizedString('Create a data link to enable this sensor.')+'</span>', height: 50, showIcon:true, positionLeft:true },
						

						{ name:LocalizedString('Trigger an Action once'), 'keyPath':'sensorBehaviour', labelOnTop:true,type:'select',options:[

							
							['valueChanges',LocalizedString('the data value changes'),[
								{ name: LocalizedString('Always Trigger Initially'), type: 'boolean', keyPath: "triggersInitially", positionLeft:true },
								{type:"boolean", name:LocalizedString("Trigger Repeatedly"), keyPath: "triggersRepeatedly", positionLeft:true},
							]],

							['valueMatchesValue',LocalizedString('the data value is equal to'),[{labelOnTop:true,type:'textarea',keyPath:'comparativeValue'},{ name: LocalizedString('Compare numerically'), type: 'boolean', positionLeft:true, keyPath: 'interpretsComparativeValueAsNumber' },
								{type:"boolean", name:LocalizedString("Trigger Repeatedly"), keyPath: "triggersRepeatedly", positionLeft:true},
							]],
							
							['valueMatchesConstraint',LocalizedString('the statement … is true'),[{name:'',labelOnTop:true, type:'select',numberOfVisibleItems:2, showsIcons: false, keyPath:'sensorConstraint', options:[
									['0',LocalizedString('the Value is empty')],
									['1',LocalizedString('the Value is not empty')],
									
									
								]},
								{type:"boolean", name:LocalizedString("Trigger Repeatedly"), keyPath: "triggersRepeatedly", positionLeft:true},
							]],
							
							], },
						

						{ type: 'space' },
					]
				},
				{
					type: 'group',
					title: LocalizedString('Action'),
					id: this.constructor.name,
					items: [
						{ 
							name: '', labelOnTop: true, type: 'action', currentActionType: this.actionType, currentActionObjectID: this.e_actionObjectID, isFirstInGroup:true },

					]
				},
			];
		}});
	


	
DataSensor.prototype.action = function DataSensor_action(sender) {
		_context.editor.simulateAction(this.actionType, this.actionInfo);};
	

	Object.defineProperty(DataSensor.prototype, "isPlugin", {
		value: true});
	

	Object.defineProperty(DataSensor.prototype, "outlineIconURL", {
		get: function () {
			if (this.enabled) return 'Resources/DataSensor.png';
			return 'Resources/DataSensorDisabled.png';
		}});
	

	Object.defineProperty(DataSensor.prototype, "iconURL", {
		get: function () {
			return 'Resources/DataSensor48.png';
		}});
	
	
	var DataSensorBehaviourValueChanges = 0,
		DataSensorBehaviourValueMatchesValue = 1,
		DataSensorBehaviourValueMatchesConstraint = 2;

	var DataSensorConstraintValueEmpty = 0,
		DataSensorConstraintValueNotEmpty = 1;

	var sensorBehaviourByString = { 'valueChanges': DataSensorBehaviourValueChanges, 'valueMatchesValue': DataSensorBehaviourValueMatchesValue, 'valueMatchesConstraint': DataSensorBehaviourValueMatchesConstraint };

DataSensor.prototype.transformData = function DataSensor_transformData(data, transformer) {
		if (transformer.isXIBGenerator) return this.dataSensor_transformDataForXIB(data, transformer);
		else return this.dataSensor_transformDataForPreview(data, transformer);};
	

DataSensor.prototype.dataSensor_transformDataForXIB = function DataSensor_dataSensor_transformDataForXIB(data, transformer) {

		var result = {
			customClass: this.constructor.name,
			userDefinedRuntimeAttributes: {},
			userLabel: data.name||undefined
		};
		

		if (data.actionInfo) {
			var procedure = transformer.createProcedureFromData(null, data.actionInfo);
			if (procedure) {
				var actionID = transformer.registerInlineObject(procedure);
				
				transformer.addConnectionFrom__to__type__info__(data.$id, transformer.currentViewControllerId, 'customAction', {
							selector: transformer.selectorNameForProcedureID(actionID),
							destination: transformer.currentViewControllerXID,
							eventType: "action",
							id: transformer.createStoryboardID()
					}, result);
			}
		}

		transformer.object__addUserDefinedRuntimeAttribute__(result, {
			keyPath: 'enabled',
			type: 'boolean',
			value: transformer.transformBoolean(data.enabled)
		});

		var sensorBehaviourNumber = sensorBehaviourByString[data.sensorBehaviour];
		
		

		transformer.object__addUserDefinedRuntimeAttribute__(result, {
			keyPath: 'sensorBehaviour',
			type: 'number',
			integer: { key: 'value', value: sensorBehaviourNumber }
		});

		transformer.object__addUserDefinedRuntimeAttribute__(result, {
			keyPath: 'sensorConstraint',
			type: 'number',
			integer: { key: 'value', value: data.sensorConstraint }
		});

		transformer.object__addUserDefinedRuntimeAttribute__(result, {
			keyPath: 'triggersRepeatedly',
			type: 'boolean',
			value: transformer.transformBoolean(data.triggersRepeatedly)
		});

		transformer.object__addUserDefinedRuntimeAttribute__(result, {
			keyPath: 'triggersInitially',
			type: 'boolean',
			value: transformer.transformBoolean(data.triggersInitially)
		});

		transformer.object__addUserDefinedRuntimeAttribute__(result, {
			keyPath: 'interpretsComparativeValueAsNumber',
			type: 'boolean',
			value: transformer.transformBoolean(data.interpretsComparativeValueAsNumber)
		});

		if (typeof data.comparativeValue === 'string')
			transformer.object__addUserDefinedRuntimeAttribute__(result, {
				keyPath: 'comparativeValue',
				type: 'string',
				value: data.comparativeValue
			});

		return result;
	};
	
	
DataSensor.prototype.dataSensor_transformDataForPreview = function DataSensor_dataSensor_transformDataForPreview(data, transformer) {

		var result = {
			$type: this.constructor.name,
			$domain: this.__domain,
			$id: data.$id,
			$initialMethodCalls: []
		};
		
		result.enabled = transformer.transformBoolean(data.enabled);
		result.sensorBehaviour = sensorBehaviourByString[data.sensorBehaviour];
		result.sensorConstraint = transformer.transformInteger(data.sensorConstraint*1);
		result.comparativeValue = transformer.transformString(data.comparativeValue);
		result.triggersRepeatedly = transformer.transformBoolean(data.triggersRepeatedly);
		
		if (data.sensorBehaviour === 'valueChanges')
			result.triggersInitially = transformer.transformBoolean(data.triggersInitially);
		else
			result.triggersInitially = true;
		result.interpretsComparativeValueAsNumber = transformer.transformBoolean(data.interpretsComparativeValueAsNumber);

		if (data.actionInfo) {
			
			result.$initialMethodCalls.push({
					name: 'addTarget:action:forEvents:',
					arguments: [
						transformer.generateActionObject(null, data.actionInfo), 
						{ $type:'SEL', name:'action:' },
						"action"
					]});
		}

		return result;
};
	

DataSensor.prototype.initPropertiesFromData = function DataSensor_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("sensorBehaviour")) this.sensorBehaviour = data.sensorBehaviour;
if (data.hasOwnProperty("sensorConstraint")) this.sensorConstraint = data.sensorConstraint;
if (data.hasOwnProperty("triggersRepeatedly")) this.triggersRepeatedly = data.triggersRepeatedly;
if (data.hasOwnProperty("triggersInitially")) this.triggersInitially = data.triggersInitially;
if (data.hasOwnProperty("interpretsComparativeValueAsNumber")) this.interpretsComparativeValueAsNumber = data.interpretsComparativeValueAsNumber;
if (data.hasOwnProperty("comparativeValue")) this.comparativeValue = data.comparativeValue;
if (data.hasOwnProperty("enabled")) this.enabled = data.enabled;
};

DataSensor.prototype.decodeData = function DataSensor_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

DataSensor.prototype.encode = function DataSensor_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

DataSensor.prototype.encodeCloned = function DataSensor_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

DataSensor.prototype.expectedTypeForProperty = function DataSensor_expectedTypeForProperty(key) {
	if (key === "readableType") return "";
	if (key === "performableActions") return "";
	if (key === "sensorBehaviour") return "String";
	if (key === "sensorConstraint") return "String";
	if (key === "triggersRepeatedly") return "Boolean";
	if (key === "triggersInitially") return "Boolean";
	if (key === "interpretsComparativeValueAsNumber") return "Boolean";
	if (key === "comparativeValue") return "String";
	if (key === "bindableProperties") return "";
	if (key === "boundDataValue") return "";
	if (key === "enabled") return "Boolean";
	if (key === "inspectorProperties") return "";
	if (key === "isPlugin") return "";
	if (key === "outlineIconURL") return "";
	if (key === "iconURL") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return DataSensor; }()));