//
//  DataSensor.h
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSInteger, DataSensorBehaviour) {
	DataSensorBehaviourValueChanges = 0,
	DataSensorBehaviourValueMatchesValue = 1,
	DataSensorBehaviourValueMatchesConstraint = 2
};

typedef NS_ENUM(NSInteger, DataSensorConstraint) {
	DataSensorConstraintValueEmpty = 0,
	DataSensorConstraintValueNotEmpty = 1,
};

@interface DataSensor : NSObject

@property BOOL enabled;
@property DataSensorBehaviour sensorBehaviour;
@property DataSensorConstraint sensorConstraint;
@property (nonatomic, copy) NSString * comparativeValue;
@property BOOL triggersRepeatedly;
@property BOOL triggersInitially;
@property BOOL interpretsComparativeValueAsNumber;

- (void)setBoundDataValue:(id)value;
- (void)addTarget:(id)target action:(SEL)selector forEvents:(NSString *)eventIdentifier;
- (void)removeTarget:(id)target;
- (void)addObserver:(id)observer;
- (void)removeObserver:(id)observer;

@end
