
registerType('info.appdoo-mac', (function () { function Drawable() {} var __super = setSupertypeFromDomain(Drawable, 'UIView', 'appdoo.iOS');

Drawable.prototype.init = function Drawable_init() {
		__super.prototype.init.call(this);
		this.createCanvas();
		this.layoutSubviews();
		return this;};
	
	
Drawable.prototype.createCanvas = function Drawable_createCanvas() {
		Object.defineProperty(this, 'canvas', {
			value: document.createElement('canvas'),
			enumerable: false
		});
		this.DOMNode.appendChild(this.canvas);
		this.canvas.style.width = '100%';
		this.canvas.style.height = '100%';};
	
	
Drawable.prototype.layoutSubviews = function Drawable_layoutSubviews() {
		var contentScale = this.context.highResolutionEnabled ? 2 : 1;
		this.canvas.width = this.size.width * contentScale;
		this.canvas.height = this.size.height * contentScale;
		
		this.needsRedraw();};
	

Drawable.prototype.needsRedraw = function Drawable_needsRedraw() {
		if (this.canvas) {
			this.redraw(this.canvas.getContext('2d'), this.canvas.width, this.canvas.height);
		}};
	
	
Drawable.prototype.redraw = function Drawable_redraw(ctx, width, height) {
		};
	
	
	Object.defineProperty(Drawable.prototype, "isPlugin", {
		value: true});
	
	
	Object.defineProperty(Drawable.prototype, "pluginIdentifier", {
		value: 'info.appdoo-mac.Drawables'});
	
	
Drawable.prototype.expectedTypeForProperty = function Drawable_expectedTypeForProperty(key) {
	if (key === "isPlugin") return "";
	if (key === "pluginIdentifier") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return Drawable; }()));
registerType('info.appdoo-mac', (function () { function DrawableEllipse() {} var __super = setSupertypeFromDomain(DrawableEllipse, 'Drawable', 'info.appdoo-mac');

	Object.defineProperty(DrawableEllipse.prototype, "readableDescription", {
		get: function () { return LocalizedString('Draws circles and ellipses'); }});
	

	Object.defineProperty(DrawableEllipse.prototype, "fillColor", {
	outlet: true, 
	enumerable: true, 
		set: function (s) {if (!Object.hasOwnProperty(this, "_fillColor")) Object.defineProperty(this, "_fillColor", { writable: true, configurable: true });
			this._fillColor = s;
			this.needsRedraw();
		}, get:function () { return this._fillColor; }});
	
	
    Object.defineProperty(DrawableEllipse.prototype, "borderColor", {
    outlet: true, 
    enumerable: true, 
        set: function (s) {if (!Object.hasOwnProperty(this, "_borderColor")) Object.defineProperty(this, "_borderColor", { writable: true, configurable: true });
            this._borderColor = s;
            this.needsRedraw();
        }, get:function () { return this._borderColor; }});
    

    Object.defineProperty(DrawableEllipse.prototype, "borderWidth", {
    outlet: true, 
    enumerable: true, 
        set: function (s) {if (!Object.hasOwnProperty(this, "_borderWidth")) Object.defineProperty(this, "_borderWidth", { writable: true, configurable: true });
            this._borderWidth = s;
            this.needsRedraw();
        }, get:function () { return this._borderWidth; }});
    
	
	Object.defineProperty(DrawableEllipse.prototype, "outlineIconURL", {
		get: function () {
			return 'Resources/BasicShapeEllipse.png';
		}});
	

	Object.defineProperty(DrawableEllipse.prototype, "iconURL", {
		get: function () {
			return 'Resources/BasicShapeEllipse48.png';
		}});
	

	function drawEllipse(ctx, x, y, w, h) {
        
		if(ctx.lineWidth > 0) {
	        var offset = (ctx.lineWidth/2);
			x += offset;
			y += offset;
			w -= (2*offset);
			h -= (2*offset);
			var kappa = .5522848,
	        ox = (w / 2) * kappa, 
			oy = (h / 2) * kappa, 
			xe = x + w,           
			ye = y + h,           
			xm = x + w / 2,       
			ym = y + h / 2;       
            ctx.beginPath();
			ctx.moveTo(x, ym);
			ctx.bezierCurveTo(x, ym - oy, xm - ox, y, xm, y);
			ctx.bezierCurveTo(xm + ox, y, xe, ym - oy, xe, ym);
			ctx.bezierCurveTo(xe, ym + oy, xm + ox, ye, xm, ye);
			ctx.bezierCurveTo(xm - ox, ye, x, ym + oy, x, ym);
            ctx.stroke();
		}
		
        
		if(ctx.lineWidth > 0) {
			x += (ctx.lineWidth/2);
			y += (ctx.lineWidth/2);
			w -= ctx.lineWidth;
			h -= ctx.lineWidth;
		}
		
        
		var kappa = .5522848,
        ox = (w / 2) * kappa, 
		oy = (h / 2) * kappa, 
		xe = x + w,           
		ye = y + h,           
		xm = x + w / 2,       
		ym = y + h / 2;       
		
		ctx.beginPath();
		ctx.moveTo(x, ym);
		ctx.bezierCurveTo(x, ym - oy, xm - ox, y, xm, y);
		ctx.bezierCurveTo(xm + ox, y, xe, ym - oy, xe, ym);
		ctx.bezierCurveTo(xe, ym + oy, xm + ox, ye, xm, ye);
		ctx.bezierCurveTo(xm - ox, ye, x, ym + oy, x, ym);
		ctx.fill();
    }

DrawableEllipse.prototype.redraw = function DrawableEllipse_redraw(ctx, width, height) {
		ctx.clearRect(0,0,width,height);
		ctx.fillStyle = this.fillColor || 'rgba(119, 118, 119, 1)';
        if(this.borderWidth > 0) {
            ctx.strokeStyle = this.borderColor || 'rgba(119, 118, 119, 1)';
            ctx.lineWidth = this.borderWidth;
        } else {
            ctx.strokeStyle = 'rgba(119, 118, 119, 1)';
            ctx.lineWidth = 0;
        }
		drawEllipse(ctx, 0, 0, width, height);};
	

	Object.defineProperty(DrawableEllipse.prototype, "readableType", {
		get: function () { return 'Ellipse'; }});
	

	Object.defineProperty(DrawableEllipse.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: 'ellipse',
					items: [
						{
							name: this.readableNameForProperty('name'),
							keyPath: 'e_name',
							dataKeyPath: 'name',
							type: 'text',
							positionLeft: true,
							placeholder:LocalizedString('Optional')
						},
						{
							name: LocalizedString('Fill Color'),
							keyPath: 'fillColor',
							type: 'color',
							undefinedValue: 'rgba(119, 118, 119, 1)'
						},
						{
                            name: LocalizedString('Border Color'),
                            keyPath: 'borderColor',
                            type: 'color',
                            undefinedValue: 'rgba(119, 118, 119, 1)'
						},
						{
                            name: LocalizedString('Border Width'),
							labelOnTop: true,
                            keyPath: 'borderWidth',
                            type: 'number',
							onlyPositive: true, 
                            suffix:'pt',
                            undefinedValue: '0'
                        },
					]
				},
				{
					type: 'group',
					title: LocalizedString('Advanced'),
					id: this.constructor.name+'Advanced',
					items: [
					
					{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft: true },
					
					]
				},
			];
		}});
	

DrawableEllipse.prototype.transformData = function DrawableEllipse_transformData(data, transformer, options) {
		var result = __super.prototype.transformData.call(this, data, transformer, options);
		transformer.setColorProperty(result, 'fillColor', (data.fillColor || 'rgba(119, 118, 119, 1)'));
		transformer.setColorProperty(result, 'borderColor', data.borderColor);
		transformer.setFloatProperty(result, 'borderWidth', data.borderWidth);
		transformer.setColorProperty(result, 'backgroundColor', 'rgba(119, 118, 119,0)');
		return result;};
	

DrawableEllipse.prototype.initPropertiesFromData = function DrawableEllipse_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("fillColor")) this.fillColor = data.fillColor;
if (data.hasOwnProperty("borderColor")) this.borderColor = data.borderColor;
if (data.hasOwnProperty("borderWidth")) this.borderWidth = data.borderWidth;
};

DrawableEllipse.prototype.decodeData = function DrawableEllipse_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

DrawableEllipse.prototype.encode = function DrawableEllipse_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

DrawableEllipse.prototype.encodeCloned = function DrawableEllipse_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

DrawableEllipse.prototype.expectedTypeForProperty = function DrawableEllipse_expectedTypeForProperty(key) {
	if (key === "readableDescription") return "";
	if (key === "fillColor") return "String";
	if (key === "borderColor") return "String";
	if (key === "borderWidth") return "Number";
	if (key === "outlineIconURL") return "";
	if (key === "iconURL") return "";
	if (key === "readableType") return "";
	if (key === "inspectorProperties") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return DrawableEllipse; }()));
registerType('info.appdoo-mac', (function () { function DrawableRectangle() {} var __super = setSupertypeFromDomain(DrawableRectangle, 'Drawable', 'info.appdoo-mac');
	
	Object.defineProperty(DrawableRectangle.prototype, "readableDescription", {
		get: function () { return LocalizedString('Draws rectangles'); }});
	

	Object.defineProperty(DrawableRectangle.prototype, "fillColor", {
	outlet: true, 
	enumerable: true, 
		set: function (s) {if (!Object.hasOwnProperty(this, "_fillColor")) Object.defineProperty(this, "_fillColor", { writable: true, configurable: true });
			this._fillColor = s;
			this.needsRedraw();
		}, get:function () { return this._fillColor; }});
	
	
    Object.defineProperty(DrawableRectangle.prototype, "borderColor", {
    outlet: true, 
    enumerable: true, 
        set: function (s) {if (!Object.hasOwnProperty(this, "_borderColor")) Object.defineProperty(this, "_borderColor", { writable: true, configurable: true });
            this._borderColor = s;
            this.needsRedraw();
        }, get:function () { return this._borderColor; }});
    

    Object.defineProperty(DrawableRectangle.prototype, "borderWidth", {
    outlet: true, 
    enumerable: true, 
        set: function (s) {if (!Object.hasOwnProperty(this, "_borderWidth")) Object.defineProperty(this, "_borderWidth", { writable: true, configurable: true });
            this._borderWidth = s;
            this.needsRedraw();
        }, get:function () { return this._borderWidth; }});
    

    Object.defineProperty(DrawableRectangle.prototype, "cornerRadius", {
    outlet: true, 
    enumerable: true, 
        set: function (s) {if (!Object.hasOwnProperty(this, "_cornerRadius")) Object.defineProperty(this, "_cornerRadius", { writable: true, configurable: true });
            this._cornerRadius = s;
            this.needsRedraw();
        }, get:function () { return this._cornerRadius; }});
    

	Object.defineProperty(DrawableRectangle.prototype, "outlineIconURL", {
		get: function () {
			return 'Resources/BasicShapeRectangle.png';
		}});
	

	Object.defineProperty(DrawableRectangle.prototype, "iconURL", {
		get: function () {
			return 'Resources/BasicShapeRectangle48.png';
		}});
	

	function drawRectangle(ctx, x, y, w, h, r, lw) {
		if(lw == 0) {
			if(r == 0) {
				ctx.fillRect(x,y,w,h);
			} else {
				if (w < 2 * r) r = w / 2;
				if (h < 2 * r) r = h / 2;
				ctx.beginPath();
				ctx.moveTo(x+r, y);
				ctx.arcTo(x+w, y,   x+w, y+h, r);
				ctx.arcTo(x+w, y+h, x,   y+h, r);
				ctx.arcTo(x,   y+h, x,   y,   r);
				ctx.arcTo(x,   y,   x+w, y,   r);
				ctx.closePath();
				ctx.fill();
			}
		} else {
			ctx.lineWidth = lw;
	        var offset = 0;
			if(lw > 0) {
				offset = (lw/2);
				y += offset;
				x += offset;
				w -= (2*offset);
				h -= (2*offset);
			}
			ctx.beginPath();
			ctx.moveTo(x + r, y);
			ctx.lineTo(x + w - r, y);
			ctx.quadraticCurveTo(x + w, y, x + w, y + r);
			ctx.lineTo(x + w, y + h - r);
			ctx.quadraticCurveTo(x + w, y + h, x + w - r, y + h);
			ctx.lineTo(x + r, y + h);
			ctx.quadraticCurveTo(x, y + h, x, y + h - r);
			ctx.lineTo(x, y + r);
			ctx.quadraticCurveTo(x, y, x + r, y);
			ctx.closePath();
			var lineColor = ctx.strokeStyle;
			ctx.strokeStyle = 'rgba(119, 118, 119, 1)';
			
			var oldGlobalCompositeOperation = ctx.globalCompositeOperation;
			ctx.stroke();
			ctx.strokeStyle = lineColor;
			ctx.globalCompositeOperation = "source-out";
			ctx.fill();
			
			ctx.globalCompositeOperation = oldGlobalCompositeOperation;
			ctx.stroke();
		}
		
	}
	
DrawableRectangle.prototype.redraw = function DrawableRectangle_redraw(ctx, width, height) {
		
		ctx.clearRect(0,0,width,height);
		ctx.fillStyle = this.fillColor || 'rgba(119, 118, 119, 1)';
		if(this.borderWidth == undefined) {
			this.borderWidth = 0;
		}
		if(this.borderWidth > height/2) {
			this.borderWidth = Math.floor(height/2);
		}
        if(this.borderWidth > 0) {
            ctx.strokeStyle = this.borderColor || 'rgba(119, 118, 119, 1)';
        } else {
			ctx.restore();
            ctx.strokeStyle = 'rgba(119, 118, 119, 0)';
        }
		var radius = this.cornerRadius || 0;
		if(radius == 0 && this.borderWidth == 0) {
			this.backgroundColor = ctx.fillStyle;
			return;
		} else {
			this.backgroundColor = 'rgba(119, 118, 119, 1)';
		}
		if(width < (2*radius)) {
			radius = (width/2);
		}
		if(height < (2*radius)) {
			radius = (height/2);
		}
		drawRectangle(ctx, 0, 0, width, height, radius, this.borderWidth);};
	

	Object.defineProperty(DrawableRectangle.prototype, "readableType", {
		get: function () { return 'Rectangle'; }});
	

	Object.defineProperty(DrawableRectangle.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: 'rectangle',
					items: [
						{
							name: this.readableNameForProperty('name'),
							keyPath: 'e_name',
							dataKeyPath: 'name',
							type: 'text',
							positionLeft: true,
							placeholder:LocalizedString('Optional')
						},
						{
							name: LocalizedString('Fill Color'),
							keyPath: 'fillColor',
							type: 'color',
							undefinedValue: 'rgba(119, 118, 119, 1)'
						},
						{
                            name: LocalizedString('Border Color'),
                            keyPath: 'borderColor',
                            type: 'color',
                            undefinedValue: 'rgba(119, 118, 119, 1)'
						},
						{
                            name: LocalizedString('Border Width'),
							labelOnTop: true,
                            keyPath: 'borderWidth',
                            type: 'number',
							onlyPositive: true, 
                            suffix:'pt',
                            undefinedValue: '0'
                        },
						{
                            name: LocalizedString('Corner Radius'),
							labelOnTop: true,
                            keyPath: 'cornerRadius',
                            type: 'number',
							onlyPositive: true, 
                            suffix:'pt',
                            undefinedValue: '0'
                        },
					]
				},
				{
					type: 'group',
					title: LocalizedString('Advanced'),
					id: this.constructor.name+'Advanced',
					items: [
					
					{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft: true },
					
					]
				},
			];
		}});
	

DrawableRectangle.prototype.transformData = function DrawableRectangle_transformData(data, transformer, options) {
		var result = __super.prototype.transformData.call(this, data, transformer, options);
		transformer.setColorProperty(result, 'fillColor', (data.fillColor || 'rgba(119, 118, 119, 1)'));
		transformer.setColorProperty(result, 'borderColor', data.borderColor);
		transformer.setFloatProperty(result, 'borderWidth', data.borderWidth);
		transformer.setFloatProperty(result, 'cornerRadius', data.cornerRadius);
		transformer.setColorProperty(result, 'backgroundColor', 'rgba(119, 118, 119,0)');
		return result;};
	
	
DrawableRectangle.prototype.initPropertiesFromData = function DrawableRectangle_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("fillColor")) this.fillColor = data.fillColor;
if (data.hasOwnProperty("borderColor")) this.borderColor = data.borderColor;
if (data.hasOwnProperty("borderWidth")) this.borderWidth = data.borderWidth;
if (data.hasOwnProperty("cornerRadius")) this.cornerRadius = data.cornerRadius;
};

DrawableRectangle.prototype.decodeData = function DrawableRectangle_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

DrawableRectangle.prototype.encode = function DrawableRectangle_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

DrawableRectangle.prototype.encodeCloned = function DrawableRectangle_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

DrawableRectangle.prototype.expectedTypeForProperty = function DrawableRectangle_expectedTypeForProperty(key) {
	if (key === "readableDescription") return "";
	if (key === "fillColor") return "String";
	if (key === "borderColor") return "String";
	if (key === "borderWidth") return "Number";
	if (key === "cornerRadius") return "Number";
	if (key === "outlineIconURL") return "";
	if (key === "iconURL") return "";
	if (key === "readableType") return "";
	if (key === "inspectorProperties") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return DrawableRectangle; }()));
registerType('info.appdoo-mac', (function () { function DrawableTriangle() {} var __super = setSupertypeFromDomain(DrawableTriangle, 'Drawable', 'info.appdoo-mac');
	
	Object.defineProperty(DrawableTriangle.prototype, "readableDescription", {
		get: function () { return LocalizedString('Draws triangles'); }});
	

	Object.defineProperty(DrawableTriangle.prototype, "fillColor", {
	outlet: true, 
	enumerable: true, 
		set: function (s) {if (!Object.hasOwnProperty(this, "_fillColor")) Object.defineProperty(this, "_fillColor", { writable: true, configurable: true });
			this._fillColor = s;
			this.needsRedraw();
		}, get:function () { return this._fillColor; }});
	
	
    Object.defineProperty(DrawableTriangle.prototype, "borderColor", {
    outlet: true, 
    enumerable: true, 
        set: function (s) {if (!Object.hasOwnProperty(this, "_borderColor")) Object.defineProperty(this, "_borderColor", { writable: true, configurable: true });
            
            this.needsRedraw();
        }, get:function () { return this._borderColor; }});
    

    Object.defineProperty(DrawableTriangle.prototype, "borderWidth", {
    outlet: true, 
    enumerable: true, 
        set: function (s) {if (!Object.hasOwnProperty(this, "_borderWidth")) Object.defineProperty(this, "_borderWidth", { writable: true, configurable: true });
            
            this.needsRedraw();
        }, get:function () { return this._borderWidth; }});
    

    Object.defineProperty(DrawableTriangle.prototype, "rotation", {
    outlet: true, 
    enumerable: true, 
        set: function (s) {if (!Object.hasOwnProperty(this, "_rotation")) Object.defineProperty(this, "_rotation", { writable: true, configurable: true });
			if(s > 360 || s < -360) {
				s = s%360;
			}
            this._rotation = s;
            this.needsRedraw();
        }, get:function () { return this._rotation; }});
    
	
	Object.defineProperty(DrawableTriangle.prototype, "outlineIconURL", {
		get: function () {
			return 'Resources/BasicShapeTriangle.png';
		}});
	

	Object.defineProperty(DrawableTriangle.prototype, "iconURL", {
		get: function () {
			return 'Resources/BasicShapeTriangle48.png';
		}});
	

	function drawTriangle(ctx, x, y, w, h, r, bc, fc, lw) {
		
		
		
        var offset = 0;
		var oldGlobalCompositeOperation = ctx.globalCompositeOperation;
		
		
		if(lw > 0) {
			ctx.fillStyle = bc;
		} else {
			ctx.fillStyle = fc;
		}
		ctx.beginPath();
		ctx.moveTo(x + (w/2), y);
		ctx.lineTo(x + w, y + h);
		ctx.lineTo(x, y + h);
		ctx.lineTo(x + (w/2), y);
		ctx.closePath();
		ctx.fill();
		
		if(ctx.lineWidth > 0) {
			
			var sideLength = Math.sqrt( ((w/2) * (w/2)) + (h*h) );
			var posY = 2*(ctx.lineWidth/sideLength)*h;
			var posX = 2*(ctx.lineWidth/sideLength)*w;
			
			
			ctx.beginPath();
			ctx.moveTo(x + (w/2), y+posY);
			ctx.lineTo(x + w - posX, y + h - ctx.lineWidth);
			ctx.lineTo(x + posX, y + h - ctx.lineWidth);
			ctx.lineTo(x + (w/2), y+posY);
			
			ctx.closePath();
			
			ctx.fillStyle = "#000000";
			ctx.globalCompositeOperation = "destination-out";
			ctx.fill();
		
			ctx.globalCompositeOperation = oldGlobalCompositeOperation;
			
			
			ctx.fillStyle = fc;
			ctx.fill();
		}
	}
	
DrawableTriangle.prototype.redraw = function DrawableTriangle_redraw(ctx, width, height) {
		ctx.clearRect(0,0,width,height);
		ctx.fillStyle = this.fillColor || 'rgba(119, 118, 119, 1)';
        if(this.borderWidth > 0) {
			if(this.borderWidth > width/2) {
				this.borderWidth = width/2;
			}
            ctx.strokeStyle = this.borderColor || 'rgba(119, 118, 119, 1)';
            ctx.lineWidth = this.borderWidth;
        } else {
            ctx.strokeStyle = 'rgba(119, 118, 119, 1)';
            ctx.lineWidth = 0;
        }
		var rotation = this.rotation || 0;
		drawTriangle(ctx, 0, 0, width, height, rotation, (this.borderColor || 'rgba(119, 118, 119, 1)'), (this.fillColor || 'rgba(119, 118, 119, 1)'), this.borderWidth);};
	

	Object.defineProperty(DrawableTriangle.prototype, "readableType", {
		get: function () { return 'Triangle'; }});
	

	Object.defineProperty(DrawableTriangle.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: 'triangle',
					items: [
						{
							name: this.readableNameForProperty('name'),
							keyPath: 'e_name',
							dataKeyPath: 'name',
							type: 'text',
							positionLeft: true,
							placeholder:LocalizedString('Optional')
						},
						{
							name: LocalizedString('Fill Color'),
							keyPath: 'fillColor',
							type: 'color',
							undefinedValue: 'rgba(119, 118, 119, 1)'
						},
						
















						








						
					]
				},
				{
					type: 'group',
					title: LocalizedString('Advanced'),
					id: this.constructor.name+'Advanced',
					items: [
					
					{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft: true },
					
					]
				},

			];
		}});
	

DrawableTriangle.prototype.transformData = function DrawableTriangle_transformData(data, transformer, options) {
		var result = __super.prototype.transformData.call(this, data, transformer, options);
		transformer.setColorProperty(result, 'fillColor', (data.fillColor || 'rgba(119, 118, 119, 1)'));
		transformer.setColorProperty(result, 'borderColor', data.borderColor);
		transformer.setFloatProperty(result, 'borderWidth', data.borderWidth);
		
		transformer.setColorProperty(result, 'backgroundColor', 'rgba(119, 118, 119,0)');
		return result;};
	
	
DrawableTriangle.prototype.initPropertiesFromData = function DrawableTriangle_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("fillColor")) this.fillColor = data.fillColor;
if (data.hasOwnProperty("borderColor")) this.borderColor = data.borderColor;
if (data.hasOwnProperty("borderWidth")) this.borderWidth = data.borderWidth;
if (data.hasOwnProperty("rotation")) this.rotation = data.rotation;
};

DrawableTriangle.prototype.decodeData = function DrawableTriangle_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

DrawableTriangle.prototype.encode = function DrawableTriangle_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

DrawableTriangle.prototype.encodeCloned = function DrawableTriangle_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

DrawableTriangle.prototype.expectedTypeForProperty = function DrawableTriangle_expectedTypeForProperty(key) {
	if (key === "readableDescription") return "";
	if (key === "fillColor") return "String";
	if (key === "borderColor") return "String";
	if (key === "borderWidth") return "Number";
	if (key === "rotation") return "Number";
	if (key === "outlineIconURL") return "";
	if (key === "iconURL") return "";
	if (key === "readableType") return "";
	if (key === "inspectorProperties") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return DrawableTriangle; }()));