#import "Drawables.h"

@implementation DrawableEllipse

- (void)drawRect:(CGRect)rect {
	[super drawRect:rect];
	if(self.borderColor != nil && self.borderWidth > 0) {
		UIBezierPath *bezierPath = [UIBezierPath bezierPathWithOvalInRect:CGRectMake((int)(rect.origin.x+(self.borderWidth/2)),
																					 (int)(rect.origin.y+(self.borderWidth/2)),
																					 rect.size.width-self.borderWidth,
																					 rect.size.height-self.borderWidth)];
		if(self.fillColor) {
			[self.fillColor setFill];
			[bezierPath fill];
		}
		[self.borderColor setStroke];
		[bezierPath setLineWidth:self.borderWidth];
		[bezierPath strokeWithBlendMode:kCGBlendModeClear alpha:CGColorGetAlpha(self.borderColor.CGColor)];
		[bezierPath stroke];
	} else if(self.fillColor) {
		UIBezierPath *bezierPath = [UIBezierPath bezierPathWithOvalInRect:rect];
		[self.fillColor setFill];
		[bezierPath fill];
	}
}

@end

@implementation DrawableRectangle

- (void)drawRect:(CGRect)rect {
	[super drawRect:rect];
	if(self.borderColor != nil && self.borderWidth > 0) {
		CGSize radii = CGSizeMake(
								  self.cornerRadius/(rect.size.width/(rect.size.width-(2*self.borderWidth))),
								  self.cornerRadius/(rect.size.height/(rect.size.height-(2*self.borderWidth)))
								  );
		UIBezierPath *bezierPath;
		if(self.cornerRadius > 0) {
			bezierPath = [UIBezierPath bezierPathWithRoundedRect:CGRectMake((int)(rect.origin.x+(self.borderWidth/2)),
																			(int)(rect.origin.y+(self.borderWidth/2)),
																			rect.size.width-self.borderWidth,
																			rect.size.height-self.borderWidth)
											   byRoundingCorners:UIRectCornerAllCorners
													 cornerRadii:radii];
		} else {
			bezierPath = [UIBezierPath bezierPathWithRect:CGRectMake((int)(rect.origin.x+(self.borderWidth/2)),
																	 (int)(rect.origin.y+(self.borderWidth/2)),
																	 rect.size.width-self.borderWidth,
																	 rect.size.height-self.borderWidth)];
		}
		if(self.fillColor) {
			[self.fillColor setFill];
			[bezierPath fill];
		}
		[self.borderColor setStroke];
		[bezierPath setLineWidth:self.borderWidth];
		[bezierPath strokeWithBlendMode:kCGBlendModeClear alpha:CGColorGetAlpha(self.borderColor.CGColor)];
		[bezierPath stroke];
	} else if(self.fillColor) {
		UIBezierPath *bezierPath = [UIBezierPath bezierPathWithRoundedRect:rect cornerRadius:self.cornerRadius];
		[self.fillColor setFill];
		[bezierPath fill];
	}
}

@end

@implementation DrawableTriangle

- (void)drawRect:(CGRect)rect {
	[super drawRect:rect];
	
	if(self.borderColor != nil && self.borderWidth > 0) {
		
		UIBezierPath *bezierPath = [UIBezierPath bezierPath];
		[bezierPath moveToPoint:CGPointMake(rect.origin.x+(rect.size.width/2), rect.origin.y)];
		[bezierPath addLineToPoint:CGPointMake(rect.origin.x+rect.size.width, rect.origin.y+rect.size.height)];
		[bezierPath addLineToPoint:CGPointMake(rect.origin.x, rect.origin.y+rect.size.height)];
		[bezierPath addLineToPoint:CGPointMake(rect.origin.x+(rect.size.width/2), rect.origin.y)];
		[bezierPath closePath];
		[self.borderColor setFill];
		[bezierPath fill];
		// cut out inner triangle:
		CGFloat sideLength = sqrt(((rect.size.width/2)*(rect.size.width/2)) + (rect.size.height*rect.size.height));
		CGFloat posY = 2*(self.borderWidth/sideLength)*rect.size.height;
		CGFloat posX = 2*(self.borderWidth/sideLength)*rect.size.width;
		bezierPath = [UIBezierPath bezierPath];
		[bezierPath moveToPoint:CGPointMake(rect.origin.x+(rect.size.width/2), rect.origin.y+posY)];
		[bezierPath addLineToPoint:CGPointMake(rect.origin.x+rect.size.width-posX, rect.origin.y+rect.size.height-self.borderWidth)];
		[bezierPath addLineToPoint:CGPointMake(rect.origin.x+posX, rect.origin.y+rect.size.height-self.borderWidth)];
		[bezierPath addLineToPoint:CGPointMake(rect.origin.x+(rect.size.width/2), rect.origin.y+posY)];
		[bezierPath closePath];
		[[UIColor blackColor] setFill];
		[bezierPath fillWithBlendMode:kCGBlendModeDestinationOut alpha:1.0];
		if(self.fillColor) {
			[self.fillColor setFill];
			[bezierPath fill];
		}
		
	} else {
		if(self.fillColor) {
			UIBezierPath *bezierPath = [UIBezierPath bezierPath];
			[bezierPath moveToPoint:CGPointMake(rect.origin.x+(rect.size.width/2), rect.origin.y)];
			[bezierPath addLineToPoint:CGPointMake(rect.origin.x+rect.size.width, rect.origin.y+rect.size.height)];
			[bezierPath addLineToPoint:CGPointMake(rect.origin.x, rect.origin.y+rect.size.height)];
			[bezierPath addLineToPoint:CGPointMake(rect.origin.x+(rect.size.width/2), rect.origin.y)];
			[bezierPath closePath];
			[self.fillColor setFill];
			[bezierPath fill];
		}
	}
}

@end
