
registerType('info.appdoo-mac', (function () { function FilteredDataSource() {} var __super = setSupertypeFromDomain(FilteredDataSource, 'BasicDataSource', 'appdoo');

	Object.defineProperty(FilteredDataSource.prototype, "readableDescription", {
		get: function () {
			return LocalizedString('Filters a data source by path or term');
		}});
	

	Object.defineProperty(FilteredDataSource.prototype, "isPlugin", {
		value: true});
	

FilteredDataSource.prototype.createForContext = function FilteredDataSource_createForContext(context) {

		return createComponentFromDomain(
			this.constructor.name,
			this.__domain,
			context,
			{
				searchesCaseSensitive: false,
				doFilterByQuery: true,
				dataSourceID: ''
			}
		);
		};
	
	
FilteredDataSource.prototype.init = function FilteredDataSource_init() {
		__super.prototype.init.call(this);
		if (this.searchesCaseSensitive === undefined) this.searchesCaseSensitive = true;
		return this;};
	

	Object.defineProperty(FilteredDataSource.prototype, "readableType", {
		get: function () { return LocalizedString('Data Filter'); 
		}});
	

	Object.defineProperty(FilteredDataSource.prototype, "readableValue", {
		get: function ( ) {
			if (this.name) return this.name;
			if (!this.dataSource) return this.readableType;
			if (this.doFilterByQuery) {
				if (this.filterQuery)
					return '„'+(this.filterQuery)+'“ in '+this.dataSource.readableValue;
				else return this.dataSource.readableValue+' '+LocalizedString('Search');
			}
			if (this.doFilterByKeyPath) return (this.filterKeyPath === undefined ? '' : this.filterKeyPath)+' in '+this.dataSource.readableValue;
			return this.dataSource.readableValue;
		}});
	
	
	Object.defineProperty(FilteredDataSource.prototype, "name", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_name")) Object.defineProperty(this, "_name", { writable: true, configurable: true });
			this._name = v;
			this.readableValueDidChange();
		}, get:function () { return this._name; }});
	

	Object.defineProperty(FilteredDataSource.prototype, "iconURL", {
		value: 'Resources/FilteredDataSource48.png'});
	

	Object.defineProperty(FilteredDataSource.prototype, "outlineIconURL", {
		value: 'Resources/FilteredDataSource.png'});
	
	
	Object.defineProperty(FilteredDataSource.prototype, "dataSourceID", {
	outlet: true, 
	enumerable: true, get:function () { return this._dataSourceID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataSourceID")) Object.defineProperty(this, "_dataSourceID", { writable: true, configurable: true }); this._dataSourceID = v; }});
	

	Object.defineProperty(FilteredDataSource.prototype, "e_dataSourceID", {
		get: function ( ) { return this.dataSourceID; }, 
		set: function (v) {
			this.dataSourceID = v;
			this._dataSource = undefined;
			this.disableFilter();
			this.loadDataSourceIfNeeded();
			if (this.dataSource) {
				if (this.dataSource.itemArrayKeyPath && !this.filterKeyPath) {
					this.dataController.setValueForKeyPath(true, 'doFilterByKeyPath', this.dataController);
					this.dataController.setValueForKeyPath(this.dataSource.itemArrayKeyPath, 'filterKeyPath', this.dataController);
				}
			}
			this.enableFilter();
			_context.editor.refreshInspector();
			this.filter(); this.notifyObservers(); this.readableValueDidChange();
		}});
	

	Object.defineProperty(FilteredDataSource.prototype, "dataSource", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_dataSource")) Object.defineProperty(this, "_dataSource", { writable: true, configurable: true });
			if (!v) return;
			if (this._dataSource) this._dataSource.removeObserver(this);
			if (v === this) return;
			this._dataSource = v;
			
			v.addObserver(this);
		}, get:function () { return this._dataSource; }});
	

	Object.defineProperty(FilteredDataSource.prototype, "filterKeyPath", {
	outlet: true, 
	enumerable: true, 
		get: function ( ) { return this._filterKeyPath; }, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_filterKeyPath")) Object.defineProperty(this, "_filterKeyPath", { writable: true, configurable: true });
			
			if (v === undefined) v = '';
			if (this._filterKeyPath !== undefined && v !== this._filterKeyPath) {
				this._filterKeyPath = v;
				this.filter();
				this.notifyObservers();
				this.readableValueDidChange();
			} else this._filterKeyPath = v;
		}});
	

	Object.defineProperty(FilteredDataSource.prototype, "filterQuery", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_filterQuery")) Object.defineProperty(this, "_filterQuery", { writable: true, configurable: true }); if (typeof v !== 'string') v = ''; if (this._filterQuery === v) return; var isUpdating = (this._filterQuery !== undefined); this._filterQuery = v; if (isUpdating) { this.filter(); this.notifyObservers(); this.readableValueDidChange(); }  }, get:function () { return this._filterQuery; }});
	
	
	Object.defineProperty(FilteredDataSource.prototype, "filterLazyTimer", {
	synthesized: true, get:function () { return this._filterLazyTimer; }, set:function (v) {if (!Object.hasOwnProperty(this, "_filterLazyTimer")) Object.defineProperty(this, "_filterLazyTimer", { writable: true, configurable: true }); this._filterLazyTimer = v; }});
	
	









	

	Object.defineProperty(FilteredDataSource.prototype, "outlineAccessoryType", {
		get: function () {
		}});
	
	
FilteredDataSource.prototype.disableFilter = function FilteredDataSource__disableFilter() {
		this.disabled = true;};
	

FilteredDataSource.prototype.enableFilter = function FilteredDataSource__enableFilter() {
		this.disabled = false;};
	

FilteredDataSource.prototype.filter = function FilteredDataSource__filter() {
		
		
	
		if (!this.dataSource) return;
		if (this.disabled) return;
	






	
		
		
		
		

		if (this.doFilterByKeyPath) {
			try {
				this.contents = this.context.dissolveKeyPathWithContextObject(this.filterKeyPath+'', this.dataSource.contents);
				
			}
			catch (err) {
				 alertd('Could not find '+this.filterKeyPath+' in', this.dataSource);
				 console.log(err);
			}
			if (!this.contents) this.contents = [];
		}
		else {
			this.contents = this.dataSource.contents;
		}
		
		if (this.doFilterByQuery) {
			this.contents = filterItemsByQuery(this.contents, this.filterQuery, !this.searchesCaseSensitive, this.showsAllItemsOnEmptyQuery);
		}
		

		return true;
	};
	
	
	function stringContainsString(haystack, needle, caseInsensitive) {
		if (caseInsensitive)
			return haystack.match(new RegExp(needle, "i"));
		else
			return (haystack.indexOf(needle) !== -1);
	}
	
	function filterItemsByQuery(items, query, caseInsensitive, showsAllItemsOnEmptyQuery) {
	
		
		if (!query) return showsAllItemsOnEmptyQuery ? items : [];
		var result = [];
		
		for (var i = 0, c = items.length; i < c; i++) {
			var item = items[i];
			var queryFound = false;
			if (typeof item === 'string') {
				queryFound = stringContainsString(item, query, caseInsensitive);
			}
			else {
				for (var key in item) {
					if (typeof item[key] === 'string') {
						queryFound = stringContainsString(item[key], query, caseInsensitive);
					}
					if (queryFound) break;
				}
			}
			if (queryFound) result.push(item);
		}
		
		return result;
	}
	
FilteredDataSource.prototype.loadDataSourceIfNeeded = function FilteredDataSource__loadDataSourceIfNeeded() {

		if (!this.dataSource) {
			this.dataSource = this.context.getLivingDataSourceWithId(this.dataSourceID);
		}
	};
	
	
FilteredDataSource.prototype.dataSourceDidLoad = function FilteredDataSource_dataSourceDidLoad(dataSource) {
		
		if (this.filter()) {
			this.notifyObservers();
		}};
	



	







FilteredDataSource.prototype.addObserver = function FilteredDataSource_addObserver(observer) {
			this.loadDataSourceIfNeeded();
			return __super.prototype.addObserver.call(this, observer);};
		













































	
	
	Object.defineProperty(FilteredDataSource.prototype, "searchesCaseSensitive", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_searchesCaseSensitive")) Object.defineProperty(this, "_searchesCaseSensitive", { writable: true, configurable: true });
			var isUpdating = this._searchesCaseSensitive !== undefined;
			this._searchesCaseSensitive = v;
			if (isUpdating) { this.filter(); this.notifyObservers(); }
		}, get:function () { return this._searchesCaseSensitive; }});
	

	Object.defineProperty(FilteredDataSource.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
						{ name: this.readableNameForProperty('name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },

						
						
						
						{ name: LocalizedString("Data Source to be filtered"), keyPath: 'e_dataSourceID', type: "object", objectType: 'dataSource', numberOfVisibleItems: 4, labelOnTop: true, excludeSelection: true, allowsEmptySelection: true },
						
						
						
						{ type:'space'},

						{ type: 'boolean', keyPath: 'e_doFilterByQuery', name: LocalizedString('Filter by Term'), positionLeft: true,  },

						
						{ name:'', placeholder: LocalizedString('Search Term'), dataName: '   '+this.readableNameForProperty('filterQuery'), keyPath: 'filterQuery', spellcheck: false, type: 'textarea', spellcheck: false, labelOnTop: true, hidden: !this.doFilterByQuery,textFieldHeight: 30,boundOffsetY:-2 },
						
						{ name: LocalizedString('Case-Sensitive'), keyPath: 'searchesCaseSensitive', type: 'boolean', hidden: !this.doFilterByQuery, positionLeft: true, offsetX:0 },

						{ name: LocalizedString('Don\'t filter with an empty term'), keyPath: 'showsAllItemsOnEmptyQuery', type: 'boolean', hidden: !this.doFilterByQuery, positionLeft: true, offsetX: 0,  },
						
						{ type:'space'},
						{ type:'space'},
						{ type:'space'},

						{ type: 'boolean', keyPath: 'e_doFilterByKeyPath', name: LocalizedString('Key Path'), positionLeft: true },
						
						{ name:'', placeholder: LocalizedString('Key Path'), keyPath: 'e_filterKeyPath', dataKeyPath: 'filterKeyPath', dataName: this.readableNameForProperty('filterKeyPath'), type: "textarea", spellcheck: false, labelOnTop: true, hidden: !this.doFilterByKeyPath, textFieldHeight: 30, boundOffsetY: 10 },

						
						
						

						
						
						
		
					]
				}
			];
		}});
	
	
	Object.defineProperty(FilteredDataSource.prototype, "shouldFilterWithKeyPath", {
	outlet: true, 
	enumerable: true, get:function () { return this._shouldFilterWithKeyPath; }, set:function (v) {if (!Object.hasOwnProperty(this, "_shouldFilterWithKeyPath")) Object.defineProperty(this, "_shouldFilterWithKeyPath", { writable: true, configurable: true }); this._shouldFilterWithKeyPath = v; }});
	

	Object.defineProperty(FilteredDataSource.prototype, "shouldFilterWithQuery", {
	outlet: true, 
	enumerable: true, get:function () { return this._shouldFilterWithQuery; }, set:function (v) {if (!Object.hasOwnProperty(this, "_shouldFilterWithQuery")) Object.defineProperty(this, "_shouldFilterWithQuery", { writable: true, configurable: true }); this._shouldFilterWithQuery = v; }});
	


	Object.defineProperty(FilteredDataSource.prototype, "doFilterByKeyPath", {
	outlet: true, 
		get: function ( ) { return this.shouldFilterWithKeyPath; }, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_doFilterByKeyPath")) Object.defineProperty(this, "_doFilterByKeyPath", { writable: true, configurable: true }); this.shouldFilterWithKeyPath = v; }});
	

	Object.defineProperty(FilteredDataSource.prototype, "doFilterByQuery", {
	outlet: true, 
		get: function ( ) { return this.shouldFilterWithQuery; }, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_doFilterByQuery")) Object.defineProperty(this, "_doFilterByQuery", { writable: true, configurable: true }); this.shouldFilterWithQuery = v; }});
	






	
	Object.defineProperty(FilteredDataSource.prototype, "showsAllItemsOnEmptyQuery", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_showsAllItemsOnEmptyQuery")) Object.defineProperty(this, "_showsAllItemsOnEmptyQuery", { writable: true, configurable: true });
			var isUpdating = this._showsAllItemsOnEmptyQuery !== undefined;
			this._showsAllItemsOnEmptyQuery = v;
			if (isUpdating) { this.filter(); this.notifyObservers(); }
		}, get:function () { return this._showsAllItemsOnEmptyQuery; }});
	

	Object.defineProperty(FilteredDataSource.prototype, "e_doFilterByKeyPath", {
		get: function ( ) { return this.doFilterByKeyPath; }, 
		set: function (v) { this.doFilterByKeyPath = v; _context.editor.refreshInspector(); this.filter(); this.notifyObservers(); this.readableValueDidChange(); }});
	

	Object.defineProperty(FilteredDataSource.prototype, "e_doFilterByQuery", {
		get: function ( ) { return this.doFilterByQuery; }, 
		set: function (v) { this.doFilterByQuery = v; _context.editor.refreshInspector(); this.filter(); this.notifyObservers(); this.readableValueDidChange(); }});
	

	Object.defineProperty(FilteredDataSource.prototype, "e_filterKeyPath", {
		get: function ( ) { return this.filterKeyPath; }, 
		set: function (v) { this.filterKeyPath = v; }});
	










	

	Object.defineProperty(FilteredDataSource.prototype, "providesRootData", {
		get: function () {
			return typeof this.contents === 'object' && !Array.isArray(this.contents);
		}});
	
	
FilteredDataSource.prototype.determineFirstItemKey = function FilteredDataSource__determineFirstItemKey(item) {
		this.loadDataSourceIfNeeded();
		this.filter();
		if (this.dataSource)
			return this.dataSource.determineFirstItemKey(item);};
	

FilteredDataSource.prototype.transformData = function FilteredDataSource_transformData(data, transformer) {
		if (transformer.isXIBGenerator) return this.fds_transformDataForXIB(data, transformer);
		return this.fds_transformDataForPreview(data, transformer);};
	

FilteredDataSource.prototype.fds_transformDataForXIB = function FilteredDataSource_fds_transformDataForXIB(data, transformer) {

		transformer.demandPlugin('info.appdoo-mac.DataSourceBase');
		transformer.demandPlugin('info.appdoo-mac.NSStringPunycodeAdditions');

		var result = {
			customClass: this.constructor.name,
			userDefinedRuntimeAttributes: {},
			connections: {},
			userLabel: data.name||undefined
		};
		
		['filterKeyPath', 'filterQuery'].every(function (key) {
			if (this.bindingForKey.call(data, key)) return true;
			transformer.object__addUserDefinedRuntimeAttribute__(result, {
				type: 'string',
				keyPath: key,
				value: data[key]
			});return true; }, this);
		

		['shouldFilterWithKeyPath', 'shouldFilterWithQuery', 'searchesCaseSensitive', 'showsAllItemsOnEmptyQuery'].every(function (key) {
			if (this.bindingForKey.call(data, key)) return true;
			transformer.object__addUserDefinedRuntimeAttribute__(result, {
				type: 'boolean',
				keyPath: key,
				value: transformer.transformBoolean(data[key])
			});return true; }, this);
		

		transformer.object__addOutlet__from__to__(result, 'originalDataSource', data.$id, data.dataSourceID);

		return result;
};
	

FilteredDataSource.prototype.fds_transformDataForPreview = function FilteredDataSource_fds_transformDataForPreview(data, transformer) {

		var result = __super.prototype.transformData.call(this, data, transformer);
		result.filterKeyPath = transformer.transformString(data.filterKeyPath);
		
		['filterKeyPath', 'filterQuery'].every(function (key) {
			if (this.bindingForKey.call(data, key)) return true;
			result[key] = transformer.transformString(data[key]);return true; }, this);
		

		['shouldFilterWithKeyPath', 'shouldFilterWithQuery', 'searchesCaseSensitive', 'showsAllItemsOnEmptyQuery'].every(function (key) {
			if (this.bindingForKey.call(data, key)) return true;
			result[key] = transformer.transformBoolean(data[key]);return true; }, this);
		

		
		
		
		transformer.addConnection({
				source: data.$id,
				destination: data.dataSourceID,
				type: 'outlet',
				key: 'originalDataSource'
			});

		return result;
};
	

	Object.defineProperty(FilteredDataSource.prototype, "bindableProperties", {
		get: function () {
			var result = [];
			['filterQuery', 'filterKeyPath'].every(function (key) {
				result.push([key, this.readableNameForProperty(key)]);
				return true;
			}, this);
			return result;
		}});
	
	
FilteredDataSource.prototype.readableNameForProperty = function FilteredDataSource_readableNameForProperty(name) {
		switch (name) {
			case 'filterQuery': return LocalizedString('Search Term');
			case 'filterKeyPath': return LocalizedString('Key Path');
		}
		return __super.prototype.readableNameForProperty.call(this, name);};
	

FilteredDataSource.prototype.initPropertiesFromData = function FilteredDataSource_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("name")) this.name = data.name;
if (data.hasOwnProperty("dataSourceID")) this.dataSourceID = data.dataSourceID;
if (data.hasOwnProperty("filterKeyPath")) this.filterKeyPath = data.filterKeyPath;
if (data.hasOwnProperty("filterQuery")) this.filterQuery = data.filterQuery;
if (data.hasOwnProperty("searchesCaseSensitive")) this.searchesCaseSensitive = data.searchesCaseSensitive;
if (data.hasOwnProperty("shouldFilterWithKeyPath")) this.shouldFilterWithKeyPath = data.shouldFilterWithKeyPath;
if (data.hasOwnProperty("shouldFilterWithQuery")) this.shouldFilterWithQuery = data.shouldFilterWithQuery;
if (data.hasOwnProperty("doFilterByKeyPath")) this.doFilterByKeyPath = data.doFilterByKeyPath;
if (data.hasOwnProperty("doFilterByQuery")) this.doFilterByQuery = data.doFilterByQuery;
if (data.hasOwnProperty("showsAllItemsOnEmptyQuery")) this.showsAllItemsOnEmptyQuery = data.showsAllItemsOnEmptyQuery;
};

FilteredDataSource.prototype.decodeData = function FilteredDataSource_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

FilteredDataSource.prototype.encode = function FilteredDataSource_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

FilteredDataSource.prototype.encodeCloned = function FilteredDataSource_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

FilteredDataSource.prototype.expectedTypeForProperty = function FilteredDataSource_expectedTypeForProperty(key) {
	if (key === "readableDescription") return "";
	if (key === "isPlugin") return "";
	if (key === "readableType") return "";
	if (key === "readableValue") return "";
	if (key === "name") return "";
	if (key === "iconURL") return "";
	if (key === "outlineIconURL") return "";
	if (key === "dataSourceID") return "";
	if (key === "e_dataSourceID") return "";
	if (key === "dataSource") return "";
	if (key === "filterKeyPath") return "String";
	if (key === "filterQuery") return "String";
	if (key === "filterLazyTimer") return "";
	if (key === "outlineAccessoryType") return "";
	if (key === "searchesCaseSensitive") return "Boolean";
	if (key === "inspectorProperties") return "";
	if (key === "shouldFilterWithKeyPath") return "Boolean";
	if (key === "shouldFilterWithQuery") return "Boolean";
	if (key === "doFilterByKeyPath") return "Boolean";
	if (key === "doFilterByQuery") return "Boolean";
	if (key === "showsAllItemsOnEmptyQuery") return "Boolean";
	if (key === "e_doFilterByKeyPath") return "";
	if (key === "e_doFilterByQuery") return "";
	if (key === "e_filterKeyPath") return "";
	if (key === "providesRootData") return "";
	if (key === "bindableProperties") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return FilteredDataSource; }()));