
registerType('info.appdoo-mac', (function () { function FormProcessor() {} var __super = setSupertypeFromDomain(FormProcessor, 'BasicEditableObject', 'appdoo');

	Object.defineProperty(FormProcessor.prototype, "outlineIconURL", {
		value: 'Resources/FormProcessor@2x.png'});
	

	Object.defineProperty(FormProcessor.prototype, "isPlugin", {
		value: true});
	

	Object.defineProperty(FormProcessor.prototype, "readableType", {
		
		get: function () { return LocalizedString('Form Data Transmission'); }});
	

FormProcessor.prototype.createForContext = function FormProcessor_createForContext(context) {

		return createComponentFromDomain(
			this.constructor.name,
			this.__domain,
			context,
			{
				sendMethod: 'post',
				blocksUserInteractionWhileTransmitting: true,
				dataSourceIDForResponse: '',
				destinationURLString: 'https://',
				actionInfo: createComponentFromDomain('ActionInfo', 'appdoo', context, {
		            "modalTransitionStyle" : "-1",
		            "actionType" : "",
		            "objectActionID" : "",
				})
			}
		);
};
	
	
	
	Object.defineProperty(FormProcessor.prototype, "targetType", {
	outlet: true, 
	enumerable: true, get:function () { return this._targetType; }, set:function (v) {if (!Object.hasOwnProperty(this, "_targetType")) Object.defineProperty(this, "_targetType", { writable: true, configurable: true }); this._targetType = v; }});
	

	Object.defineProperty(FormProcessor.prototype, "destinationURLString", {
	outlet: true, 
	enumerable: true, get:function () { return this._destinationURLString; }, set:function (v) {if (!Object.hasOwnProperty(this, "_destinationURLString")) Object.defineProperty(this, "_destinationURLString", { writable: true, configurable: true }); this._destinationURLString = v; }});
	

	Object.defineProperty(FormProcessor.prototype, "sendMethod", {
	outlet: true, 
	enumerable: true, get:function () { return this._sendMethod; }, set:function (v) {if (!Object.hasOwnProperty(this, "_sendMethod")) Object.defineProperty(this, "_sendMethod", { writable: true, configurable: true }); this._sendMethod = v; }});
	




	Object.defineProperty(FormProcessor.prototype, "blocksUserInteractionWhileTransmitting", {
	outlet: true, 
	enumerable: true, get:function () { return this._blocksUserInteractionWhileTransmitting; }, set:function (v) {if (!Object.hasOwnProperty(this, "_blocksUserInteractionWhileTransmitting")) Object.defineProperty(this, "_blocksUserInteractionWhileTransmitting", { writable: true, configurable: true }); this._blocksUserInteractionWhileTransmitting = v; }});
	
	
	Object.defineProperty(FormProcessor.prototype, "dataSourceIDForResponse", {
	outlet: true, 
	enumerable: true, get:function () { return this._dataSourceIDForResponse; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataSourceIDForResponse")) Object.defineProperty(this, "_dataSourceIDForResponse", { writable: true, configurable: true }); this._dataSourceIDForResponse = v; }});
	

	Object.defineProperty(FormProcessor.prototype, "dataSourceForResponse", {
		get: function () {
			return this.context.connectableObjects[this.dataSourceIDForResponse];
		}});
	

	Object.defineProperty(FormProcessor.prototype, "inspectorProperties", {
		get: function () {
			var preview = this.generatePreview();
			var previewHeight = Math.max(preview.split('\n').length*13+6,20*4);
			return [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [

						{ name: LocalizedString('Name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
							
						

						{ name: LocalizedString('Method'), keyPath: 'sendMethod', type: 'select', options:[
							['get','HTTP (GET)'],
							['post','HTTP (POST)']
						] },

						{ name: LocalizedString('Send to URL'), keyPath: 'destinationURLString', spellcheck: false, type: 'textarea', textFieldHeight: 60 },



					]
				},
				{
					type: 'group',
					title: TRANSLATE({de:'Ereignisse',en:'Events'}),
					id: this.constructor.name+'Events',
					items: [

						{ name: LocalizedString('On Successful Delivery'), labelOnTop: true, type: 'action', currentActionType: this.actionType, currentActionObjectID: this.e_actionObjectID },

						

					]
				},
				{
					type: 'group',
					title: LocalizedString('Advanced'),
					id: this.constructor.name+'Advanced',
					items: [


						{ type:'boolean',name: LocalizedString('Show Activity Indicator'), positionLeft:true,keyPath:'blocksUserInteractionWhileTransmitting'},

						{type:'space'},
						{type:'space'},


						
						
						
					
	

						
						{ name: LocalizedString('Pass returned data on to'), keyPath: 'dataSourceIDForResponse', type: 'object', objectType:'dataSource', labelOnTop:true, numberOfVisibleItems:4, allowsEmptySelection:true, emptySelectionTitle: LocalizedString('Don\'t Store'), spaceBefore: true
						



						},
						


					]
				},
				{
					type: 'group',
					title: 'Test',
					id: this.constructor.name+'Test',
					items: [

						{ type: 'info', html: LocalizedString('Preview')+'<br>'+selectableTextElement(preview,previewHeight), left: 26, height: previewHeight+25 },


						{ type: 'button', caption: LocalizedString('Execute'), buttonWidth: 70, buttonStyle: 'flat', positionLeft: 1, action: function (selectedObjects) { for (var i in selectedObjects) { if (isNaN(i)) continue; selectedObjects[i].simulateProcess(this); } } },

						
						(typeof this.responseText === 'string') ? {
							type: 'info', html: '<span style="float:right">'+prettyPrintStatus(this.statusCode)+'</span>'+LocalizedString('Response')+'<br>'+selectableTextElement(this.htmlEscapedResponseText,125), left: 26, height: 150 } : {hidden:true},

					]
				},
			];
		}});
	
	


	Object.defineProperty(FormProcessor.prototype, "htmlEscapedResponseText", {
		get: function () {
			var str = this.responseText;
			if (str.length > 1000) {
				str = str.substr(0,1000)+'…';
			}
			str = str.replace(/</g,'&lt;');
			str = str.replace(/>/g,'&gt;');
			return str;
		}});
	

	Object.defineProperty(FormProcessor.prototype, "performableActions", {
		get: function () {
			return {
				
				'process': { name: LocalizedString('send') },
			};
		}});
	
	
FormProcessor.prototype.simulateAction = function FormProcessor_simulateAction(actionID) {
		if (actionID === 'process') this.simulateProcess();};
	
	
FormProcessor.prototype.generateFormData = function FormProcessor__generateFormData() {
		return window.namesForFormElements(_context.editor.editedView);};
	
	
FormProcessor.prototype.generatePreview = function FormProcessor__generatePreview() {
		var dict = this.generateFormData();

		var text = '';
		for (var key in dict) {
			if (dict[key] === undefined) continue;
			if (text.length) text += '\n';
			text += key+': '+dict[key];
		}
		
		if (!text) text = TRANSLATE({'en':'No Form Data','de':'Keine Formular-Daten'});
		
		return text;};
	
	
	Object.defineProperty(FormProcessor.prototype, "xmlHttpRequest", {
	synthesized: true, get:function () { return this._xmlHttpRequest; }, set:function (v) {if (!Object.hasOwnProperty(this, "_xmlHttpRequest")) Object.defineProperty(this, "_xmlHttpRequest", { writable: true, configurable: true }); this._xmlHttpRequest = v; }});
	
	
	function serialize(obj) {
	  var str = [];
	  for(var p in obj)
		if (obj.hasOwnProperty(p)) {
		  str.push(encodeURIComponent(p) + "=" + encodeURIComponent(obj[p]));
		}
	  return str.join("&");
	}
	
FormProcessor.prototype.simulateProcess = function FormProcessor__simulateProcess(sender, sender2) {
		
		if (sender && sender.UTI === 'Editor.Inspector.Button'){
			sender.disabled = true;
		}
	
		var dict = this.generateFormData();
		
		
		
		var xmlHttp = new XMLHttpRequest();
		this.xmlHttpRequest = xmlHttp;

		var method = (this.sendMethod === 'post') ? 'POST' : 'GET';
		var url = this.destinationURLString;
		if (method === 'GET') {
			url += (url.indexOf('?') === -1) ? '?' : '&';
			url += serialize(dict);
		}
		else {
			var formData = new FormData();
			for (var key in dict) {
				formData.append(key, dict[key]);
			}
		}
		
		xmlHttp.open(method, url, true);
		xmlHttp.onreadystatechange = function () {
			if (xmlHttp.readyState == 4) {
				this.xmlHttpRequest = null;
				this.handleResponse(xmlHttp.responseText, xmlHttp);
				
			}
		}.bind(this);
		
		if (method === 'GET') {
			xmlHttp.send();
		} else {
			xmlHttp.send(formData);
		}};
	
	
	Object.defineProperty(FormProcessor.prototype, "responseText", {
	synthesized: true, get:function () { return this._responseText; }, set:function (v) {if (!Object.hasOwnProperty(this, "_responseText")) Object.defineProperty(this, "_responseText", { writable: true, configurable: true }); this._responseText = v; }});
	

	Object.defineProperty(FormProcessor.prototype, "statusCode", {
	synthesized: true, get:function () { return this._statusCode; }, set:function (v) {if (!Object.hasOwnProperty(this, "_statusCode")) Object.defineProperty(this, "_statusCode", { writable: true, configurable: true }); this._statusCode = v; }});
	

FormProcessor.prototype.handleResponse = function FormProcessor__handleResponse(responseText, xmlHttp) {
		
		this.responseText = responseText;
		this.statusCode = xmlHttp.status;
		
		
		_context.editor.refreshInspector();
		
		var dataSourceForResponse = this.dataSourceForResponse;
		if (dataSourceForResponse) {
			
			dataSourceForResponse.data = responseText;
			dataSourceForResponse.notifyObservers();
		}};
	
	
	function prettyPrintStatus(statusCode) {
		var messageByCode = {};
		
		messageByCode[100] = 'Continue';
		messageByCode[101] = 'Switching Protocols';
		messageByCode[102] = 'Processing';
		
		messageByCode[200] = LocalizedString('OK');
		messageByCode[201] = 'Created';
		messageByCode[202] = 'Accepted';
		messageByCode[203] = 'Non-Authoritative Information';
		messageByCode[204] = 'No Content';
		messageByCode[205] = 'Reset Content';
		messageByCode[206] = 'Partial Content';
		messageByCode[207] = 'Multi-Status';
		messageByCode[208] = 'Already Reported';
		messageByCode[226] = 'IM Used';

		messageByCode[300] = 'Multiple Choices';
		messageByCode[301] = 'Moved Permanently';
		messageByCode[302] = 'Found';
		messageByCode[303] = 'See Other';
		messageByCode[304] = 'Not Modified';
		messageByCode[305] = 'Use Proxy';
		messageByCode[306] = 'Switch Proxy';
		messageByCode[307] = 'Temporary Redirect';
		messageByCode[308] = 'Permanent Redirect';

		messageByCode[400] = 'Bad Request';
		messageByCode[401] = 'Unauthorized';
		messageByCode[402] = 'Payment Required';
		messageByCode[403] = 'Forbidden';
		messageByCode[404] = 'Not Found';
		messageByCode[405] = 'Method Not Allowed';
		messageByCode[406] = 'Not Acceptable';
		messageByCode[407] = 'Proxy Authentication Required';
		messageByCode[408] = 'Request Timeout';
		messageByCode[409] = 'Conflict';
		messageByCode[410] = 'Gone';
		messageByCode[411] = 'Length Required';
		messageByCode[412] = 'Precondition Failed';
		messageByCode[413] = 'Request Entity Too Large';
		messageByCode[414] = 'Request-URI Too Long';
		messageByCode[415] = 'Unsupported Media Type';
		messageByCode[416] = 'Requested Range Not Satisfiable';
		messageByCode[417] = 'Expectation Failed';
		messageByCode[418] = 'I\'m a teapot';
		messageByCode[419] = 'Authentication Timeout';
		
		messageByCode[420] = 'Enhance Your Calm';
		messageByCode[422] = 'Unprocessable Entity';
		messageByCode[423] = 'Locked';
		
		messageByCode[424] = 'Method Failure';
		messageByCode[425] = 'Unordered Collection';
		messageByCode[426] = 'Upgrade Required';
		messageByCode[428] = 'Precondition Required';
		messageByCode[429] = 'Too Many Requests';
		messageByCode[431] = 'Request Header Fields Too Large';

		messageByCode[500] = 'Internal Server Error';
		messageByCode[501] = 'Not Implemented';
		messageByCode[502] = 'Bad Gateway';
		messageByCode[503] = 'Service Unavailable';
		messageByCode[504] = 'Gateway Timeout';
		messageByCode[505] = 'HTTP Version Not Supported';
		messageByCode[506] = 'Variant Also Negotiates';
		messageByCode[507] = 'Insufficient Storage';
		messageByCode[508] = 'Loop Detected';
		messageByCode[509] = 'Bandwidth Limit Exceeded';
		messageByCode[510] = 'Not Extended';
		messageByCode[511] = 'Network Authentication Required';
		messageByCode[522] = 'Connection timed out';

		var color;
		if (statusCode >= 100 && statusCode < 200) color = 'orange';
		if (statusCode >= 200 && statusCode < 300) color = 'green';
		if (statusCode >= 300 && statusCode < 400) color = 'orange';
		if (statusCode >= 400 && statusCode < 600) color = 'red';
		
		var message = messageByCode[statusCode];
		var toolTip = 'HTTP status code '+statusCode;
		
		
		
		
		
		
		if (statusCode === 0) message = '?';
		else {
			if (message) message = statusCode+' '+message;
			else message = LocalizedString('Error')+' '+statusCode;
		}
		
		
		return '<span style="color:'+color+';border-bottom:1px dotted '+color+';cursor:pointer" title="'+toolTip+'" onclick="_context.nativeProxy.sendMessage(\'openURL\',\'http://en.wikipedia.org/wiki/List_of_HTTP_status_codes#'+statusCode+'\');">'+(message)+'</span>';

	}
	
	
	function collectFormElementsDataFromView(dict, formElementNamesWithViewTag, formView, transformer) {
		
		updateSubviewsWithCallback(formView, function (subview) {
			switch (subview.$type) {
				case 'UITextField':
				case 'UITextView':
				case 'UISegmentedControl':
				case 'UISwitch':
				case 'UISlider':
				case 'UIPickerView':
				case 'UIDatePicker':
				case 'UISearchBar':
					if (subview.name) {
						dict[subview.name] = subview.$id;
						formElementNamesWithViewTag[subview.name] = transformer.tagForViewWithCID(subview.$id);
					}
					break;
			}
		}, false, true);
	
	}

FormProcessor.prototype.formProcessor_transformDataForXIB = function FormProcessor_formProcessor_transformDataForXIB(data, transformer) {

		var result = {
			customClass: this.constructor.name,
			userDefinedRuntimeAttributes: {},
			userLabel: data.name||undefined
		};
		
		if (transformer.productGenerator.isTransformingGlobalObjects) 
			return result;

		var dict = {};
		var formElementNamesWithViewTag = {};
		var formView = transformer.currentViewControllerData.viewData;
		
		collectFormElementsDataFromView(dict, formElementNamesWithViewTag, formView, transformer);
		
		for (var name in dict) {
			var $id = dict[name];

			transformer.addConnectionFrom__to__type__info__(data.$id, $id, 'outletCollection', {
				property: "formControls",
				destination: transformer.storyboardIDForObjectID($id),
				id: transformer.createStoryboardID()
			}, result);
		
		}
		















		

		result.userDefinedRuntimeAttributes['userDefinedRuntimeAttribute formElementNamesWithViewTagJSONString'] = {
			keyPath: 'formElementNamesWithViewTagJSONString',
			type: 'string',
			value: JSON.stringify(formElementNamesWithViewTag)
		};

		result.userDefinedRuntimeAttributes['userDefinedRuntimeAttribute destinationURLString'] = {
			keyPath: 'destinationURLString',
			type: 'string',
			value: data.destinationURLString
		};

		result.userDefinedRuntimeAttributes['userDefinedRuntimeAttribute sendMethod'] = {
			keyPath: 'sendMethod',
			type: 'string',
			value: data.sendMethod
		};

		result.userDefinedRuntimeAttributes['userDefinedRuntimeAttribute blocksUserInteractionWhileTransmitting'] = {
			keyPath: 'blocksUserInteractionWhileTransmitting',
			type: 'boolean',
			value: transformer.transformBoolean(data.blocksUserInteractionWhileTransmitting)
		};
		
		if (data.dataSourceIDForResponse)
			transformer.addConnectionFrom__to__type__info__(data.$id, data.dataSourceIDForResponse, 'outlet', {
							property: "dataSourceForResponse",
							destination: transformer.storyboardIDForObjectID(data.dataSourceIDForResponse),
							id: transformer.createStoryboardID()
						}, result);

		if (data.actionInfo) {
			var procedure = transformer.createProcedureFromData(null, data.actionInfo);
			if (procedure) {
				var actionID = transformer.registerInlineObject(procedure);
				
				transformer.addConnectionFrom__to__type__info__(data.$id, transformer.currentViewControllerId, 'customAction', {
							selector: transformer.selectorNameForProcedureID(actionID),
							destination: transformer.currentViewControllerXID,
							eventType: "success",
							id: transformer.createStoryboardID()
					}, result);
			}
		}
		









					
		return result;
	};
	

FormProcessor.prototype.formProcessor_transformDataForPreview = function FormProcessor_formProcessor_transformDataForPreview(data, transformer) {

		var result = {
			$type: this.constructor.name,
			$domain: this.__domain,
			$id: data.$id,
			$initialMethodCalls: []
		};

		var dict = {};
		var formElementNamesWithViewTag = {};
		var formView = transformer.currentViewControllerData.viewData;
		
		collectFormElementsDataFromView(dict, formElementNamesWithViewTag, formView, transformer);
		












		
		
		for (var name in dict) {

			transformer.addConnection({
				source: data.$id,
				destination: dict[name],
				type: 'collection',
				key: 'formControls'
			});
		}
		
		result.formElementNamesWithViewTagJSONString = JSON.stringify(formElementNamesWithViewTag);
		result.destinationURLString = transformer.transformString(data.destinationURLString);
		result.sendMethod = transformer.transformString(data.sendMethod);
		result.blocksUserInteractionWhileTransmitting = transformer.transformBoolean(data.blocksUserInteractionWhileTransmitting);
		
		if (data.dataSourceIDForResponse)
			transformer.addConnection({
				source: data.$id,
				destination: data.dataSourceIDForResponse,
				key: 'dataSourceForResponse'
			});
		

		if (data.actionInfo) {
			
			result.$initialMethodCalls.push({
					name: 'addTarget:action:forEvents:',
					arguments: [
						transformer.generateActionObject(null, data.actionInfo), 
						{ $type:'SEL', name:'action:' },
						"success"
					]});
		}
		
		return result;
		};
	

FormProcessor.prototype.transformData = function FormProcessor_transformData(data, transformer) {
		if (transformer.isXIBGenerator) return this.formProcessor_transformDataForXIB(data, transformer);
		else return this.formProcessor_transformDataForPreview(data, transformer);};
	

FormProcessor.prototype.initPropertiesFromData = function FormProcessor_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("targetType")) this.targetType = data.targetType;
if (data.hasOwnProperty("destinationURLString")) this.destinationURLString = data.destinationURLString;
if (data.hasOwnProperty("sendMethod")) this.sendMethod = data.sendMethod;
if (data.hasOwnProperty("blocksUserInteractionWhileTransmitting")) this.blocksUserInteractionWhileTransmitting = data.blocksUserInteractionWhileTransmitting;
if (data.hasOwnProperty("dataSourceIDForResponse")) this.dataSourceIDForResponse = data.dataSourceIDForResponse;
};

FormProcessor.prototype.decodeData = function FormProcessor_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

FormProcessor.prototype.encode = function FormProcessor_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

FormProcessor.prototype.encodeCloned = function FormProcessor_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

FormProcessor.prototype.expectedTypeForProperty = function FormProcessor_expectedTypeForProperty(key) {
	if (key === "outlineIconURL") return "";
	if (key === "isPlugin") return "";
	if (key === "readableType") return "";
	if (key === "targetType") return "String";
	if (key === "destinationURLString") return "String";
	if (key === "sendMethod") return "String";
	if (key === "blocksUserInteractionWhileTransmitting") return "Boolean";
	if (key === "dataSourceIDForResponse") return "String";
	if (key === "dataSourceForResponse") return "BasicDataSource";
	if (key === "inspectorProperties") return "";
	if (key === "htmlEscapedResponseText") return "";
	if (key === "performableActions") return "";
	if (key === "xmlHttpRequest") return "";
	if (key === "responseText") return "String";
	if (key === "statusCode") return "Number";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return FormProcessor; }()));