
registerType('info.appdoo-mac', (function () { function FormValidator() {} var __super = setSupertypeFromDomain(FormValidator, 'EditableSetOfItems', 'appdoo.iOS');
	
FormValidator.prototype.init = function FormValidator_init() {
		__super.prototype.init.call(this);
		
		return this;};
	
	
FormValidator.prototype.createForContext = function FormValidator_createForContext(context) {

			var instance = createComponentFromDomain(
				this.constructor.name,
				this.__domain,
				context,
				{
				}
			);

		instance.addObject();
		
		return instance;
		};
	
	
FormValidator.prototype.instancesCanBeLocal = function FormValidator_instancesCanBeLocal(obj) {
		return true;};
	

FormValidator.prototype.instancesCanBeGlobal = function FormValidator_instancesCanBeGlobal(obj) {
		return false;};
	

	Object.defineProperty(FormValidator.prototype, "objectInfos", {
	outlet: true, 
	enumerable: true, 
		get: function () {
			if (!this._objectInfos) this.objectInfos = [];
			return this._objectInfos;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_objectInfos")) Object.defineProperty(this, "_objectInfos", { writable: true, configurable: true }); this._objectInfos = v; }});
	

	Object.defineProperty(FormValidator.prototype, "inspectorProperties", {
		get: function () {
			var properties = Object.getOwnPropertyDescriptor(__super.prototype, "inspectorProperties").get.call(this);
			
			return properties;
		}});
	

	Object.defineProperty(FormValidator.prototype, "addItemString", {
		get: function () {
			return TRANSLATE(
				{
					'de': 'Regel hinzufügen',
					'en': 'Add Rule'
				});
		}});
	
	
	Object.defineProperty(FormValidator.prototype, "addItemButtonWidth", {
		get: function () {
			return TRANSLATE(
				{
					'de': 115,
					'en': 80
				});
		}});
	

	Object.defineProperty(FormValidator.prototype, "readableType", {
		get: function () {
			return LocalizedString('Form Validator');
		}});
	
	
	Object.defineProperty(FormValidator.prototype, "readableValue", {
		get: function () {
			return this.name||this.readableType;
		}});
	

FormValidator.prototype.addObject = function FormValidator__addObject() {
		
		var ai = createComponentFromDomain('ConditionInfo', 'appdoo', this.context, { conditionType: 'equalTo' });
		
		if (this.objectInfosController) {
			this.objectInfosController.addValue(ai, this);
			_context.editor.refreshInspector();
			
		}
		else {
			this.objectInfos.push(ai);
		}};
	

FormValidator.prototype.itemPropertiesAtIndex = function FormValidator__itemPropertiesAtIndex(i) {
		
		var n = LocalizedString('Intepret as a Number');
		var comparativeValueProperties = [




					{ type: 'textarea', spellcheck: false, isFirstInGroup: true, marginTop: -5, keyPath: 'objectInfos.'+i+'.comparativeValue' },
					{ name: n, type: 'boolean', positionLeft:true, keyPath: 'objectInfos.'+i+'.interpretsComparativeValueAsNumber' }
				];
		
		var comparativeNumberProperties = [
			{type: 'text', labelOnTop: true, marginTop: -5, keyPath: 'objectInfos.'+i+'.comparativeValue'},
			{ name: TRANSLATE({'en':'Or Equal','de':'oder gleich groß'}), type: 'boolean', positionLeft:true, keyPath: 'objectInfos.'+i+'.orEqual' }
		];
		
		return [
			{ name: '', keyPath: 'objectInfos.'+i+'.conditionType', type: 'select', options: [
				
				
				['equalTo',LocalizedString('The Value is Equal To…'), comparativeValueProperties],
				['notEqualTo',LocalizedString('The Value is Equal To…'), comparativeValueProperties],
				['lowerThan',LocalizedString('The Value is Lower Than…'),comparativeNumberProperties],
				['greaterThan',LocalizedString('The Value is Greater Than…'),comparativeNumberProperties],


				['statement',LocalizedString('The Statement … is true'),[
					{ type: 'select', numberOfVisibleItems: 4, positionLeft: true, marginTop: -6, showsIcons: false, keyPath: 'objectInfos.'+i+'.conditionStatement', options: [
						['isNotEmpty',LocalizedString('the Value is not empty')],
						['isEmpty',LocalizedString('the Value is empty')],
						['isTrue',LocalizedString('The Value is True')],
						['isFalse',LocalizedString('The Value is False')],
					] },
				]],
			], positionLeft: true }
		];};
	

FormValidator.prototype.initPropertiesFromData = function FormValidator_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("objectInfos")) this.objectInfos = data.objectInfos;
};

FormValidator.prototype.decodeData = function FormValidator_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("objectInfos")) decoded.objectInfos = []; if (Array.isArray(data.objectInfos)) { data.objectInfos.forEach(function (o) { decoded.objectInfos.push(this.context.decodeObjectTree(o)); }.bind(this)); }
return decoded; };

FormValidator.prototype.encode = function FormValidator_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._objectInfos && this._objectInfos.encode) {encoded.objectInfos = []; this._objectInfos.forEach(function (o) { encoded.objectInfos.push(o.encode()); });
}return encoded; };

FormValidator.prototype.encodeCloned = function FormValidator_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._objectInfos && this._objectInfos.encode) {encoded.objectInfos = []; this._objectInfos.forEach(function (o) { encoded.objectInfos.push(o.encodeCloned()); });
}return encoded; };

FormValidator.prototype.expectedTypeForProperty = function FormValidator_expectedTypeForProperty(key) {
	if (key === "objectInfos") return "BasicObject[]";
	if (key === "inspectorProperties") return "";
	if (key === "addItemString") return "";
	if (key === "addItemButtonWidth") return "";
	if (key === "readableType") return "";
	if (key === "readableValue") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return FormValidator; }()));