
registerType('info.appdoo-mac', (function () { function FormattedTextContainer() {} var __super = setSupertypeFromDomain(FormattedTextContainer, 'UIView', 'appdoo.iOS');

	Object.defineProperty(FormattedTextContainer.prototype, "htmlValue", {
	enumerable: true, 
	outlet: true, 
		set: function (s) {if (!Object.hasOwnProperty(this, "_htmlValue")) Object.defineProperty(this, "_htmlValue", { writable: true, configurable: true });
			this._htmlValue = s;
			if (this.inputNode) this.inputNode.innerHTML = s;
		}, get:function () { return this._htmlValue; }});
	

	Object.defineProperty(FormattedTextContainer.prototype, "editingSource", {
	outlet: true, 
	enumerable: true, get:function () { return this._editingSource; }, set:function (v) {if (!Object.hasOwnProperty(this, "_editingSource")) Object.defineProperty(this, "_editingSource", { writable: true, configurable: true }); this._editingSource = v; }});
	
	
	
	Object.defineProperty(FormattedTextContainer.prototype, "inputNode", {
	writable: true});
	

FormattedTextContainer.prototype.init = function FormattedTextContainer_init() {
		__super.prototype.init.call(this);
		
		
		this.inputNode = document.createElement('div');
		this.inputNode.contentEditable = true;
		this.inputNode.style.webkitUserSelect = 'auto';
		this.inputNode.style.overflow = 'hidden';
		this.inputNode.style.cursor = 'text';
		this.inputNode.style.pointerEvents = 'none';
		this.inputNode.style.outline = 'none';
		this.inputNode.innerHTML = this.htmlValue || '&nbsp;';
		this.DOMNode.appendChild(this.inputNode);
		this.layoutSubviews();
		
		return this;};
	
	
FormattedTextContainer.prototype.layoutSubviews = function FormattedTextContainer_layoutSubviews() {
		this.inputNode.style.width = this.size.width+'px';
		this.inputNode.style.height = this.size.height+'px';};
	
	
	
FormattedTextContainer.prototype.prepareForEditor = function FormattedTextContainer_prepareForEditor(editor) {
		
		this.DOMNode.ondblclick = function (e) {
			if (!editor.isInSubviewEditingMode)
				this.editDefault(editor);
		}.bind(this);
		
		this.inputNode.onmousedown = function (e) { e.stopPropagation(); };
		this.inputNode.onkeydown = function (e) {	e.stopPropagation(); };
		this.inputNode.onkeypress = function (e) {	e.stopPropagation();
			if (editor.context.isCancelEvent(e)) {
				editor.endEditingSubview();
				e.preventDefault(); 
			}
		};};
	

FormattedTextContainer.prototype.unprepareForEditor = function FormattedTextContainer_unprepareForEditor(editor) {};
	
	
FormattedTextContainer.prototype.editDefault = function FormattedTextContainer_editDefault(editor) {
		editor.beginEditingSubview(this);};
	

FormattedTextContainer.prototype.editorDidBeginExclusiveEditing = function FormattedTextContainer_editorDidBeginExclusiveEditing(editor) {

		this.inputNode.style.pointerEvents = '';
		
		this.inputNode.focus();
		editor.context.registerFocus(this);
		
		this.showToolbar();
		editor.context.enableModalUndoManager();
		};
	
	
FormattedTextContainer.prototype.editorDidFinishExclusiveEditing = function FormattedTextContainer_editorDidFinishExclusiveEditing(editor) {
	
		this.inputNode.style.pointerEvents = 'none';
		this.hideToolbar();
		editor.context.disableModalUndoManager();
		
		
		this.dataController.setValueForKeyPath(this.inputNode.innerHTML, 'htmlValue', this);
};
	
	
	
FormattedTextContainer.prototype.showToolbar = function FormattedTextContainer__showToolbar() {
	
		
		Object.defineProperty(this, "toolbar", {
		writable: true});
		

		if (!this.toolbar) {
			this.toolbar = createComponentFromDomain("View", "Core.UI", this.context, {
				size: { width: 100, height: 30 },
				position: { left: 0, top: -30 },
				style: { position: 'absolute', backgroundColor: '#eee' }})
			;
			this.toolbar.DOMNode.onmousedown = function (e) { e.stopPropagation(); };
			this.addSubview(this.toolbar);
			
			var buttonDataList = [
				{ 'command':'bold','label':'', 'imageSrc': 'Resources/TextBold.png'},
				{ 'command':'italic','label':'', 'imageSrc': 'Resources/TextItalic.png'},
				{ 'command':'justifyLeft','label':'', 'imageSrc': 'Resources/AlignLeft.png'},
				{ 'command':'justifyCenter','label':'', 'imageSrc': 'Resources/AlignCenter.png'},
                { 'command':'justifyRight','label':'', 'imageSrc': 'Resources/AlignRight.png'},
				
			];
			
			var x = 2;
			if (Array.isArray(buttonDataList)) buttonDataList.every(function (data) {
				var button = createComponentFromDomain("Button", "Core.UI", this.context, {
					size: { width: 26, height: 26 },
					position: { left: x, top: 2 },
					text: data.label,
					imageSrc: data.imageSrc,
					buttonStyle: 'default',
					action: function () {
						if(data.command == 'editSource') {
							if(this.editingSource) {
								this.editingSource = false;
								
							} else {
								this.editingSource = true;
								
							}
						} else {
							document.execCommand(data.command);
						}
					}})
				;
				this.toolbar.addSubview(button);
				x += 28;return true; }, this);
			
		}
		this.toolbar.size.width = this.size.width;
		this.toolbar.hidden = false;};
	

FormattedTextContainer.prototype.hideToolbar = function FormattedTextContainer__hideToolbar() {
		if (this.toolbar)
			this.toolbar.hidden = true;};
	
	
	Object.defineProperty(FormattedTextContainer.prototype, "inspectorProperties", {
		get: function () {

			return [

				{
					type: 'group',
					title: this.readableType,
					id: 'FormattedTextContainerContent',
					items: [
						{ name: LocalizedString('Name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
						{ name: LocalizedString('Background Color'), keyPath: 'e_backgroundColor', type: 'color', undefinedValue: 'rgba(255,255,255, 1)' },
					]
				},
				{
					type: 'group',
					title: LocalizedString('Advanced'),
					id: this.constructor.name+'Advanced',
					items: [
					
					{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft: true },
					
					]
				}
				];
			}});
		
	
// role EditActionResponder 
	
FormattedTextContainer.prototype.canSelectAll = function FormattedTextContainer_canSelectAll() {
			return true;};
		

FormattedTextContainer.prototype.canDelete = function FormattedTextContainer_canDelete() {
			return true;};
		
	
FormattedTextContainer.prototype.selectAll = function FormattedTextContainer_selectAll() {
			document.execCommand('selectAll',false,null);};
		
	
FormattedTextContainer.prototype.copy = function FormattedTextContainer_copy() {
			};
		
	
FormattedTextContainer.prototype.paste = function FormattedTextContainer_paste() {
			};
		
	
FormattedTextContainer.prototype.cut = function FormattedTextContainer_cut() {
			};
		
	
FormattedTextContainer.prototype.deleteSelection = function FormattedTextContainer_deleteSelection() {
			document.execCommand('delete');};
		

	
	
	Object.defineProperty(FormattedTextContainer.prototype, "readableType", {
		get: function () { return LocalizedString('WYSIWYG Editor'); }});
	
	
	Object.defineProperty(FormattedTextContainer.prototype, "outlineIconURL", {
		get: function () {
			return this.context.pathForResource('WYSIWYG.png')
		}});
	

	Object.defineProperty(FormattedTextContainer.prototype, "iconURL", {
		get: function () {
			return _context.pathForResource('WYSIWYG48.png')
		}});
	

	Object.defineProperty(FormattedTextContainer.prototype, "isPlugin", {
		value: true});
	

FormattedTextContainer.prototype.transformData = function FormattedTextContainer_transformData(data, transformer, options) {
		var result = __super.prototype.transformData.call(this, data, transformer, options);
		transformer.setStringProperty(result, 'htmlValue', (typeof(data.htmlValue) != "undefined" ? data.htmlValue : ' '));
		return result;};
	

FormattedTextContainer.prototype.initPropertiesFromData = function FormattedTextContainer_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("htmlValue")) this.htmlValue = data.htmlValue;
if (data.hasOwnProperty("editingSource")) this.editingSource = data.editingSource;
};

FormattedTextContainer.prototype.decodeData = function FormattedTextContainer_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

FormattedTextContainer.prototype.encode = function FormattedTextContainer_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

FormattedTextContainer.prototype.encodeCloned = function FormattedTextContainer_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

FormattedTextContainer.prototype.expectedTypeForProperty = function FormattedTextContainer_expectedTypeForProperty(key) {
	if (key === "htmlValue") return "String";
	if (key === "editingSource") return "Boolean";
	if (key === "inputNode") return "";
	if (key === "toolbar") return "";
	if (key === "inspectorProperties") return "";
	if (key === "readableType") return "";
	if (key === "outlineIconURL") return "";
	if (key === "iconURL") return "";
	if (key === "isPlugin") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return FormattedTextContainer; }()));