
{
	var _GenericPlugIn_get_readableType = function () {
			var info = this.pluginInfo;
			if (info) return info.name;
			return LocalizedString('Missing Plug-in');
		};

	var _GenericPlugIn_get_readableValue = function () {
			return this.name || this.readableType;
		};

	var _GenericPlugIn_get_requiresPreviewBuildVersion = function () {
			var info = this.pluginInfo;
			if (info && info.requiresPreviewBuildVersion) return info.requiresPreviewBuildVersion;
			return Infinity;
		};

	var _GenericPlugIn_get_propertyValues = function () { if (!this._propertyValues) { this.propertyValues = {}; } return this._propertyValues; }

	
	var _GenericPlugIn_init = function () {
		
		
		setTimeout(function () {
			this.listen(_context.userPlugInManager, 'change', function (e) {
				if (e.which === this.pluginInfo) {
					this.pluginInfoCached = null;
					
					this.readableValueDidChange();
					this.outlineIconURLDidChange();
				}
			}.bind(this));
		}.bind(this), 1);

		return this;
	};

	var _GenericPlugIn_plugInInfoForUTI = function (uti) {
		var result = availablePlugins[uti];
		if (result) return result;
		if (Array.isArray(window.userPlugIns)) window.userPlugIns.every(function (p) {
			if (p.pluginIdentifier === uti) {
				result = p; return false;
			}return true; }, this);
		
		return result;
	};


	var loc = function (dict) {
		return dict[window.language] || dict['en'];
	};
	
	var preparePluginInfo = function (pluginInfo) {
	
		if (!pluginInfo || pluginInfo.isPrepared) return pluginInfo;
		pluginInfo.isPrepared = true;

		if (pluginInfo.localizedName)
			pluginInfo.name = loc(pluginInfo.localizedName);
			
		if (Array.isArray(pluginInfo.objectProperties)) pluginInfo.objectProperties.every(function (p) {
			if (p.localizedName) p.name = loc(p.localizedName);
			if (p.type === 'select') {
				if (Array.isArray(p.options)) p.options.every(function (o) {
					if (Array.isArray(o[2])) o[2].every(function (op) {
						if (op.localizedName) op.name = loc(op.localizedName);
						op.keyPath = 'propertyValues.'+op.key;
						op.dataKeyPath = op.key;
						if (op.type === 'info') {
							if (op.localizedHTML) op.html = loc(op.localizedHTML);
						}return true; }, this);
					return true; }, this);
				
			}
			if (p.type === 'boolean') {
				if (Array.isArray(p.conditionalProperties)) p.conditionalProperties.every(function (op) {
					if (op.localizedName) op.name = loc(op.localizedName);
					op.keyPath = 'propertyValues.'+op.key;
					op.dataKeyPath = op.key;
					if (op.type === 'info') {
						if (op.localizedHTML) op.html = loc(op.localizedHTML);
					}return true; }, this);
				
			}
			if (p.type === 'dataSourceTestContentsJSON') {
				p.keyPath = 'dataSourceTestContentsJSON';
				p.type = 'textarea';
				p.textFieldHeight = 250;
				return true;
			}

			if (p.type === 'info') {
				if (p.localizedHTML) p.html = loc(p.localizedHTML);
			}

			p.keyPath = 'propertyValues.'+p.key;
			p.dataKeyPath = p.key;return true; }, this);
		

		for (var key in pluginInfo.performableActions) {
			var a = pluginInfo.performableActions[key];
			if (a.localizedName) a.name = loc(a.localizedName);
		}
		
		return pluginInfo;
	
	};

	var _GenericPlugIn_get_pluginInfo = function () {
		if (!this.pluginInfoCached) {
			var info = _GenericPlugIn_plugInInfoForUTI(this.pluginIdentifier);
			if (info) {
				Object.defineProperty(this, 'pluginInfoCached', {
					configurable: true,
					writable: true,
					value: preparePluginInfo(info),
				});
			}
		}
		return this.pluginInfoCached;
	};
	
	var _GenericPlugIn_get_inspectorProperties = function () {

			var groups = [

				{
					type: 'group',
					title: this.readableType,
					id: this.pluginIdentifier,
					items: [
						{ name: this.readableNameForProperty('name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
						

					]
				},
				{
					type: 'group',
					title: LocalizedString('Advanced'),
					id: this.constructor.name+'Advanced',
					items: [
					{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft: true },
					]
				}

			];

			if (!this.objectProperties) {
			
				if (!this.pluginInfo)
					groups[0].items.push({
						type: 'info',
						html: LocalizedString1("The plug-in \"%1\" is not installed.", this.pluginIdentifier),
						showIcon: true,
						positionLeft: true,
						height: 100
					});
				return groups;
			}
			
			for (var i in this.objectProperties) {







				if (isNaN(i)) continue;
				
				groups[0].items.push(this.objectProperties[i]);
			}
			return groups;

		};

	var _GenericPlugIn_get_performableActions = function () {
			var info = this.pluginInfo;
			if (info) return this.pluginInfo.performableActions;
		};
	
	var _GenericPlugIn_get_objectProperties = function () {
			var info = this.pluginInfo;
			if (info) return this.pluginInfo.objectProperties;
		};

	var _GenericPlugIn_get_isDataSource = function () {
			var info = this.pluginInfo;
			if (info) return this.pluginInfo.isDataSource;
		};

	var _GenericPlugIn_get_storesContents = function () {
			var info = this.pluginInfo;
			if (info) return this.pluginInfo.storesContents;
		};

	var _GenericPlugIn_get_outlineIconURL = function () { if (this.pluginInfo) return this.pluginInfo.outlineIconURL||this.pluginInfo.icon; return 'Resources/MissingPlugIn.png'; };

	var _GenericPlugIn_cocoaCustomTypeForData = function(data) {
		var pluginInfo = _GenericPlugIn_plugInInfoForUTI(data.pluginIdentifier);
		if (pluginInfo) return pluginInfo.cocoaCustomType;
	};

	var _GenericPlugIn_transformDataForXIB = function (data, transformer) {
		return _GenericPlugIn_transformData.call(this, data, transformer);
	};

	var _GenericPlugIn_transformDataForPreview = function (data, transformer) {
		return _GenericPlugIn_transformData.call(this, data, transformer);
	};

	var _GenericPlugIn_transformData = function (data, transformer) {
	
		transformer.demandPlugin(data.pluginIdentifier);
		transformer.demandPlugin('info.appdoo-mac.FileURLHelper');

		var result;
	
		var info = this.plugInInfoForUTI(data.pluginIdentifier);
		if (!info) return result;


		if (info.pluginDependencies) {
			for (var id in info.pluginDependencies) {
				transformer.demandPlugin(id);
			}
		}

		if (info.appDelegateCode) {
			for (var key in info.appDelegateCode) {
				transformer.registerAppDelegateCode(key, info.appDelegateCode[key]);
			}
		}
		
		if (!data.propertyValues) data.propertyValues = {};
		
		if (info.configurationScript) {
		
			var args = [info.path+'/'+info.configurationScript, JSON.stringify(data.propertyValues)];
			
			transformer.context.nativeProxy.sendMessage(
				'scheduleExtensionConfigurationScript', args[0], args[1]
			);
			

		}

		if (!info.cocoaCustomType) return result;

		

		if (info.isView) {
			result = getPrototype('appdoo.iOS.UIView').transformData(data, transformer);
				
				
			
			
		}
		else {
			result = transformer.createObject(data);
			
			
			
			
			
		}
		transformer.setType(result, info.cocoaCustomType);
		
		function handleProperty(p) {
			if (!p.key) return;
			if (this.bindingForKey.call(data, p.key) !== undefined) return;
			
			if (p.type === 'object' || p.type === 'dataSource') {
				if (data.propertyValues[p.key] === undefined && p.hidden) return;
				
				var objectID = data.propertyValues[p.key];
				try { 
					if (objectID.indexOf('SceneInputDataSource') !== -1) {
						objectID = transformer.getInputDataSourceForCurrentScene().$id;
					}
					transformer.setReferenceProperty(result, p.key, data.$id, objectID);
				} catch (err) { return; }

				
				
				
				
				
			}
			else if (p.type === 'currentViewController') {
				if (transformer.currentViewController) {
					transformer.setReferenceProperty(result, p.key, data.$id, transformer.currentViewControllerId);

					
					
					
					
					
				}
			}
			else if (p.type === 'currentInputDataSource') {
				var ds = 
					transformer.getInputDataSourceForCurrentScene();
				
				if (ds)
					transformer.setReferenceProperty(result, p.key, data.$id, ds.$id);
					
					
					
					
					
					
			}
			else if (p.type === 'text' || p.type === 'textarea' || !p.type) {
				if (data.propertyValues[p.key] === undefined && p.hidden) return;
				transformer.setStringProperty(result, p.key, data.propertyValues[p.key]);





			}
			else if (p.type === 'select') {
				if (data.propertyValues[p.key] === undefined && p.hidden) return;
			
				if (p.valueType === 'integer') {
					transformer.setIntegerProperty(result, p.key, data.propertyValues[p.key]*1);
				}
				else if (p.valueType === 'number' || p.valueType === 'float') {
					transformer.setFloatProperty(result, p.key, data.propertyValues[p.key]*1);
				}
				else {
					transformer.setStringProperty(result, p.key, data.propertyValues[p.key]);
				}
			
				if (Array.isArray(p.options)) p.options.every(function (option) {
					if (option[0] !== data.propertyValues[p.key]) return true;
					if (Array.isArray(option[2])) option[2].every(function (sp) {
						handleProperty.call(this, sp);return true; }, this);
					
					return false;return true; }, this);
				
			}
			else if (p.type === 'boolean') {
				if (data.propertyValues[p.key] === undefined && p.hidden) return;
				transformer.setBooleanProperty(result, p.key, data.propertyValues[p.key]);
				if (data.propertyValues[p.key]) {
					if (Array.isArray(p.conditionalProperties)) p.conditionalProperties.every(function (sp) {
						handleProperty.call(this, sp);return true; }, this);
					
				}
			}
			else if (p.type === 'number' || p.type === 'range') {
				if (data.propertyValues[p.key] === undefined && p.hidden) return;
				transformer.setFloatProperty(result, p.key, data.propertyValues[p.key]);





			}
			else if (p.type === 'imageURL') {
				if (data.propertyValues[p.key] === undefined && p.hidden) return;
				transformer.setStringProperty(result, p.key, transformer.transformImageURL(data.propertyValues[p.key]));





			}
			else if (p.type === 'fileReference') {
				if (data.propertyValues[p.key] === undefined && p.hidden) return;
				transformer.setStringProperty(result, p.key, transformer.transformFileReference(data.propertyValues[p.key]));





			}
			else if (p.type === 'scene') {
				if (data.propertyValues[p.key] === undefined && p.hidden) return;
				transformer.setStringProperty(result, p.key, data.propertyValues[p.key]);





			}
			else if (p.type === 'bindingsInfoString') {
				transformer.setStringProperty(result, p.key, JSON.stringify(data.bindings));





			}
			else if (p.type === 'action') {
				if (data.propertyValues[p.key] === undefined && p.hidden) return;
				var actionInfo = data.propertyValues[p.key];
				if (actionInfo) {
					if (transformer.isXIBGenerator) {
						var procedure = transformer.createProcedureFromData(null, actionInfo);
						if (procedure) {
							var actionID = transformer.registerInlineObject(procedure);
							transformer.addConnectionFrom__to__type__info__(data.$id, transformer.currentViewControllerId, 'customAction', {
										selector: transformer.selectorNameForProcedureID(actionID),
										destination: transformer.currentViewControllerXID,
										eventType: p.key,
										id: transformer.createStoryboardID()
								}, result);
						}
					}
				}


			}
			else if (p.type === 'color') {
				if (data.propertyValues[p.key] === undefined && p.hidden) return;
				var setAsProperty = !(key === 'backgroundColor' || key === 'tintColor' || key === 'textColor');
				transformer.setColorProperty(result, p.key, data.propertyValues[p.key], setAsProperty);
			}

				if (data.propertyValues[p.key] === undefined && p.hidden) return;


			else {
				 alertd('Type not transformed: '+p.type);
			}

			
			
		}

		var objectProperties = info.objectProperties;
		for (var i in objectProperties) {
			if (isNaN(i)) continue;
			var p = objectProperties[i];
			handleProperty.call(this, p);
		}
		
		if (data.dataProvider) {
			var dataProvider = transformer.addDataProviderToObject(result, data);
			var providableProperties = _GenericPlugIn_getProvidableProperties(info);
			if (Array.isArray(providableProperties)) providableProperties.every(function (prop) {
				alertd(prop);
				transformer.registerInverseBinding(result, data, prop, 'sourceObject', data.dataProvider.$id, dataProvider);return true; }, this);
			
		}
		
		
		return result;
	};
	
	var _GenericPlugIn_readableNameForProperty = function (propertyName) {
		

		if (this.objectProperties)
		for (var i in this.objectProperties) {
			if (isNaN(i)) continue;
			var p = this.objectProperties[i];
			
			if (!p.name && p.localizedName) {
				if(Array.isArray(p.localizedName)) {
					p.name = (p.localizedName[window.language] || p.localizedName['en']);
				} else {
					p.name = p.localizedName
				}
			}

			if (p.key === propertyName) {
				return p.name;
			}
			
		}
	}

	var _GenericPlugIn_dataRequiresPreviewBuildVersion = function (data) {
		var info = _GenericPlugIn_plugInInfoForUTI(data.pluginIdentifier);
		
		if (info && info.requiresPreviewBuildVersion) return info.requiresPreviewBuildVersion;
		return Infinity;
	};

	var _GenericPlugIn_readableTypeForData = function (data) {
		var info = _GenericPlugIn_plugInInfoForUTI(data.pluginIdentifier);
		if (info) return info.name;
	};

	var _GenericPlugIn_instancesCanBeLocal = function (obj) {
		if (!obj) console.trace();
		
		var info = _GenericPlugIn_plugInInfoForUTI(obj.pluginIdentifier);
		
		if (info) return !info.noLocalInstances;
		return false;
	};

	var _GenericPlugIn_instancesCanBeGlobal = function (obj) {
		
		var info = _GenericPlugIn_plugInInfoForUTI(obj.pluginIdentifier);
		
		if (info) return !info.noGlobalInstances;
		return false;
	};


	var _GenericPlugIn_instancesAreDataProviders = function (obj) {
		var info = _GenericPlugIn_plugInInfoForUTI(obj.pluginIdentifier);
		if (info) return info.isDataSource;
		return false;
	};


	var _GenericPlugIn_getProvidableProperties = function (pluginInfo) {
		var p = [];
    	var properties = pluginInfo.objectProperties;
    	if (Array.isArray(properties)) properties.every(function (prop) {
    		if (prop.providable) p.push(prop.key);return true; }, this);
    	
    	return p;
	};
	
	var _GenericPlugIn_needsNoObjCOutletForInstance = function (obj) {
		var info = _GenericPlugIn_plugInInfoForUTI(obj.pluginIdentifier);
		if (info) {
			return info.cocoaType ? false : true;
		}
		return true;
	};
}
registerType('info.appdoo-mac', (function () { function GenericPlugIn() {} var __super = setSupertypeFromDomain(GenericPlugIn, 'BasicObject', 'Core');

GenericPlugIn.prototype.init = function GenericPlugIn_init() {
		__super.prototype.init.call(this);
		_GenericPlugIn_init.call(this);
		return this;};
	

		
	Object.defineProperty(GenericPlugIn.prototype, "isPlugin", {
		value: true});
	

	Object.defineProperty(GenericPlugIn.prototype, "pluginIdentifier", {
	outlet: true, 
	enumerable: true, get:function () { return this._pluginIdentifier; }, set:function (v) {if (!Object.hasOwnProperty(this, "_pluginIdentifier")) Object.defineProperty(this, "_pluginIdentifier", { writable: true, configurable: true }); this._pluginIdentifier = v; }});
	

	Object.defineProperty(GenericPlugIn.prototype, "propertyValues", {
	outlet: true, 
	enumerable: true, 
		get: _GenericPlugIn_get_propertyValues, set:function (v) {if (!Object.hasOwnProperty(this, "_propertyValues")) Object.defineProperty(this, "_propertyValues", { writable: true, configurable: true }); this._propertyValues = v; }});
	
	








	Object.defineProperty(GenericPlugIn.prototype, "pluginInfo", {
		get: _GenericPlugIn_get_pluginInfo});
	
	
GenericPlugIn.prototype.plugInInfoForUTI = function GenericPlugIn_plugInInfoForUTI(uti) {
		return _GenericPlugIn_plugInInfoForUTI.call(this, uti);};
	

	Object.defineProperty(GenericPlugIn.prototype, "objectProperties", {
		get: _GenericPlugIn_get_objectProperties});
	
	
	Object.defineProperty(GenericPlugIn.prototype, "nameIsEditable", {
		value: true});
	
	
	Object.defineProperty(GenericPlugIn.prototype, "readableValue", {
		get: _GenericPlugIn_get_readableValue});
	

	Object.defineProperty(GenericPlugIn.prototype, "readableType", {
		get: _GenericPlugIn_get_readableType});
	
	
	Object.defineProperty(GenericPlugIn.prototype, "name", {
	outlet: true, 
	enumerable: true, get:function () { return this._name; }, set:function (v) {if (!Object.hasOwnProperty(this, "_name")) Object.defineProperty(this, "_name", { writable: true, configurable: true }); this._name = v; }});
	

	Object.defineProperty(GenericPlugIn.prototype, "outlineIconURL", {
		get: _GenericPlugIn_get_outlineIconURL});
	
	
GenericPlugIn.prototype.cocoaCustomTypeForData = function GenericPlugIn_cocoaCustomTypeForData(data) {
		return _GenericPlugIn_cocoaCustomTypeForData(data);};
	

GenericPlugIn.prototype.createForContext = function GenericPlugIn__createForContext(context) {

		return createComponentFromDomain(
			this.constructor.name,
			this.__domain,
			context,
			{

			}
		);
		};
	

GenericPlugIn.prototype.transformData = function GenericPlugIn_transformData(data, transformer) {
		if (transformer.isXIBGenerator)
			return _GenericPlugIn_transformDataForXIB.call(this, data, transformer);
		else
			return _GenericPlugIn_transformDataForPreview.call(this, data, transformer);};
	
	
	
	Object.defineProperty(GenericPlugIn.prototype, "inspectorProperties", {
		get: _GenericPlugIn_get_inspectorProperties});
	

	Object.defineProperty(GenericPlugIn.prototype, "cocoaType", {
		value: 'NSObject'});
	

	Object.defineProperty(GenericPlugIn.prototype, "performableActions", {
		get: _GenericPlugIn_get_performableActions});
	

	Object.defineProperty(GenericPlugIn.prototype, "bindableProperties", {
		get: function () {
			var result = [];

			if (this.objectProperties)
			for (var i in this.objectProperties) {
				if (isNaN(i)) continue;
				var p = this.objectProperties[i];

				if (p.bindable) {
					result.unshift([p.key, this.readableNameForProperty(p.key)]);
				}
			}

			return result;
		}});
	

GenericPlugIn.prototype.readableNameForProperty = function GenericPlugIn__readableNameForProperty(propertyName) {
		return _GenericPlugIn_readableNameForProperty.call(this, propertyName) || __super.prototype.readableNameForProperty.call(this, propertyName);};
	
	
	Object.defineProperty(GenericPlugIn.prototype, "isDataSource", {
		get: _GenericPlugIn_get_isDataSource});
	

	Object.defineProperty(GenericPlugIn.prototype, "storesContents", {
		get: _GenericPlugIn_get_storesContents});
	

GenericPlugIn.prototype.expectedTypeForPropertyWithData = function GenericPlugIn_expectedTypeForPropertyWithData(prop, data) {
		var info = _GenericPlugIn_plugInInfoForUTI(data.pluginIdentifier);
		if (!info) return;
		
		for (var i in info.objectProperties) {
			if (isNaN(i)) {
				continue;
			}
			var p = info.objectProperties[i];
			if (p.key === prop) {
				return p.propertyType||p.type;
			}
		}
		
		};
	

	Object.defineProperty(GenericPlugIn.prototype, "requiresPreviewBuildVersion", {
		get: _GenericPlugIn_get_requiresPreviewBuildVersion});
	
	
GenericPlugIn.prototype.dataRequiresPreviewBuildVersion = function GenericPlugIn_dataRequiresPreviewBuildVersion(data) {
		return _GenericPlugIn_dataRequiresPreviewBuildVersion(data);};
	

GenericPlugIn.prototype.readableTypeForData = function GenericPlugIn_readableTypeForData(data) {
		return _GenericPlugIn_readableTypeForData(data);};
	
	
GenericPlugIn.prototype.instancesCanBeLocal = function GenericPlugIn_instancesCanBeLocal(obj) {
		return _GenericPlugIn_instancesCanBeLocal(obj);};
	

GenericPlugIn.prototype.instancesCanBeGlobal = function GenericPlugIn_instancesCanBeGlobal(obj) {
		
		
		return _GenericPlugIn_instancesCanBeGlobal(obj);};
	


GenericPlugIn.prototype.instancesAreDataProviders = function GenericPlugIn_instancesAreDataProviders(obj) {
		return _GenericPlugIn_instancesAreDataProviders(obj);};
	


GenericPlugIn.prototype.prepareForEditor = function GenericPlugIn_prepareForEditor(editor) {
		setTimeout(function () {
			if (!this.pluginInfo) return;
			if (this.pluginInfo.dataProviderClass) {
				getPrototype('info.appdoo-mac.GenericPluginDataProvider').addDataProviderToObject(this);
			}
		}.bind(this),1);};
	

	Object.defineProperty(GenericPlugIn.prototype, "dataProvider", {
	outlet: true, 
	enumerable: true, get:function () { return this._dataProvider; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataProvider")) Object.defineProperty(this, "_dataProvider", { writable: true, configurable: true }); this._dataProvider = v; }});
	
	
	
	Object.defineProperty(GenericPlugIn.prototype, "dataSourceTestContentsJSON", {
	outlet: true, 
	enumerable: true, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_dataSourceTestContentsJSON")) Object.defineProperty(this, "_dataSourceTestContentsJSON", { writable: true, configurable: true });
			this._dataSourceTestContentsJSON = value;
			try { this.itemArray = null; this.itemArray = JSON.parse(value);
				if (Array.isArray(this.observers)) this.observers.every(function (observer) {
					observer.dataSourceDidLoad(this);return true; }, this);
				
				} catch (err) {}
		}, get:function () { return this._dataSourceTestContentsJSON; }});
	

	Object.defineProperty(GenericPlugIn.prototype, "itemArray", {
	synthesized: true, get:function () { return this._itemArray; }, set:function (v) {if (!Object.hasOwnProperty(this, "_itemArray")) Object.defineProperty(this, "_itemArray", { writable: true, configurable: true }); this._itemArray = v; }});
	
	
	Object.defineProperty(GenericPlugIn.prototype, "observers", {
	synthesized: true, 
		get: function () {
			if (!this._observers) this.observers = [];
			return this._observers;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_observers")) Object.defineProperty(this, "_observers", { writable: true, configurable: true }); this._observers = v; }});
	
	
	
	
// role DataSource (appdoo.DataSources) 
	
GenericPlugIn.prototype.numberOfItemsInSection = function GenericPlugIn_numberOfItemsInSection(section, keyPath) {
			if (!this.itemArray) return 0;
			return this.itemArray.length || 0;};
		

GenericPlugIn.prototype.numberOfItemsInSectionAtKeyPath = function GenericPlugIn_numberOfItemsInSectionAtKeyPath(section, keyPath) {
			return this.numberOfItemsInSection(section);};
		
		
GenericPlugIn.prototype.dataForItemInSectionAtIndex = function GenericPlugIn_dataForItemInSectionAtIndex(section, index) {
			if (!this.itemArray) return {};
			return this.itemArray[index] || {};};
		
		
GenericPlugIn.prototype.dataForIndexPath = function GenericPlugIn_dataForIndexPath(indexPath) {
			if (!indexPath) { console.trace(); return; }
			return this.dataForItemInSectionAtIndex(indexPath.section, indexPath.item);};
		
		
GenericPlugIn.prototype.dataForIndexPathInKeyPath = function GenericPlugIn_dataForIndexPathInKeyPath(indexPath, keyPath) {
			return this.dataForIndexPath(indexPath);};
		

GenericPlugIn.prototype.keyAtIndex = function GenericPlugIn_keyAtIndex(i) {
			if (!this.itemArray) return '';
			return Object.keys(this.itemArray)[i];};
		

GenericPlugIn.prototype.nameForKey = function GenericPlugIn_nameForKey(key) {
			if (!this.itemArray) return '';
			return key;};
		
		
GenericPlugIn.prototype.numberOfSections = function GenericPlugIn_numberOfSections() {
			
			return 1;};
		

GenericPlugIn.prototype.numberOfSectionsInKeyPath = function GenericPlugIn_numberOfSectionsInKeyPath(keyPath) {
			return this.numberOfSections();};
		

GenericPlugIn.prototype.addObserver = function GenericPlugIn_addObserver(observer, silent) {
		
			var index = this.observers.indexOf(observer);
			if (index === -1) {
				this.observers.push(observer);
				if ((this.contents||this.implementationHasObservable) && !silent) {
					observer.dataSourceDidLoad(this);
				}
			} else {
			}
			return true;};
		
	
GenericPlugIn.prototype.removeObserver = function GenericPlugIn_removeObserver(observer) {
			
			var index = this.observers.indexOf(observer);
			if (index !== -1) {
				this.observers.splice(index, 1);
			} else {
				console.warn('Could not remove non-existent observer.',observer);
			}};
		
		
	

GenericPlugIn.prototype.outlineIconURLDidChange = function GenericPlugIn__outlineIconURLDidChange() {
		this.context.broadcastValueChangeForKeyPathInObject('outlineIconURL', this, this);};
	

GenericPlugIn.prototype.needsNoObjCOutletForInstance = function GenericPlugIn_needsNoObjCOutletForInstance(obj) {
		return _GenericPlugIn_needsNoObjCOutletForInstance(obj);};
	

GenericPlugIn.prototype.initPropertiesFromData = function GenericPlugIn_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("pluginIdentifier")) this.pluginIdentifier = data.pluginIdentifier;
if (data.hasOwnProperty("propertyValues")) this.propertyValues = data.propertyValues;
if (data.hasOwnProperty("name")) this.name = data.name;
if (data.hasOwnProperty("dataProvider")) this.dataProvider = data.dataProvider;
if (data.hasOwnProperty("dataSourceTestContentsJSON")) this.dataSourceTestContentsJSON = data.dataSourceTestContentsJSON;
};

GenericPlugIn.prototype.decodeData = function GenericPlugIn_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("dataProvider")) decoded.dataProvider = this.context.decodeObjectTree(data.dataProvider);
return decoded; };

GenericPlugIn.prototype.encode = function GenericPlugIn_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encode();
}return encoded; };

GenericPlugIn.prototype.encodeCloned = function GenericPlugIn_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encodeCloned();
}return encoded; };

GenericPlugIn.prototype.expectedTypeForProperty = function GenericPlugIn_expectedTypeForProperty(key) {
	if (key === "isPlugin") return "";
	if (key === "pluginIdentifier") return "String";
	if (key === "propertyValues") return "Object";
	if (key === "pluginInfo") return "String";
	if (key === "objectProperties") return "Object";
	if (key === "nameIsEditable") return "";
	if (key === "readableValue") return "";
	if (key === "readableType") return "";
	if (key === "name") return "String";
	if (key === "outlineIconURL") return "";
	if (key === "inspectorProperties") return "";
	if (key === "cocoaType") return "";
	if (key === "performableActions") return "";
	if (key === "bindableProperties") return "";
	if (key === "isDataSource") return "";
	if (key === "storesContents") return "";
	if (key === "requiresPreviewBuildVersion") return "";
	if (key === "dataProvider") return "GenericPluginDataProvider";
	if (key === "dataSourceTestContentsJSON") return "String";
	if (key === "itemArray") return "";
	if (key === "observers") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return GenericPlugIn; }()));
registerType('info.appdoo-mac', (function () { function GenericViewPlugIn() {} var __super = setSupertypeFromDomain(GenericViewPlugIn, 'UIView', 'appdoo.iOS');

	Object.defineProperty(GenericViewPlugIn.prototype, "pluginIdentifier", {
	outlet: true, 
	enumerable: true, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_pluginIdentifier")) Object.defineProperty(this, "_pluginIdentifier", { writable: true, configurable: true });
			this._pluginIdentifier = value;
			if (this.placeholderLabel) this.placeholderLabel.text = this.readableType;

			var info = this.pluginInfo;
			if (!info) return;

			if (info.takesFullSpace && this.superview && this.superview.subviews) {
				this.size = this.superview.sizeCopy;
				this.position = { left: 0, top: 0 };
				this.autoresizingMask = 18;
			}
		}, get:function () { return this._pluginIdentifier; }});
	

	Object.defineProperty(GenericViewPlugIn.prototype, "propertyValues", {
	outlet: true, 
	enumerable: true, 
		get: _GenericPlugIn_get_propertyValues, set:function (v) {if (!Object.hasOwnProperty(this, "_propertyValues")) Object.defineProperty(this, "_propertyValues", { writable: true, configurable: true }); this._propertyValues = v; }});
	

GenericViewPlugIn.prototype.init = function GenericViewPlugIn_init() {
		__super.prototype.init.call(this);
		_GenericPlugIn_init.call(this);
		return this;};
	

GenericViewPlugIn.prototype.createForSuperview = function GenericViewPlugIn_createForSuperview(superview) {
		return superview.context.decodeObjectTree({
				$type: this.constructor.name,
				$domain: this.__domain,
				size: { width: 200, height: 200 },
				position: { left: 0, top: 0 },
			});
	};
	
	
GenericViewPlugIn.prototype.prepareForEditor = function GenericViewPlugIn_prepareForEditor(editor) {
		this.showPlaceholder();
		setTimeout(function () {
			if (!this.pluginInfo) return;
			if (this.pluginInfo.showsNoPlaceholder) {
				this.hidePlaceholder();
			}
			if (this.pluginInfo.dataProviderClass) {
				getPrototype('info.appdoo-mac.GenericPluginDataProvider').addDataProviderToObject(this);
			}
		}.bind(this),1);};
	

	Object.defineProperty(GenericViewPlugIn.prototype, "dataProvider", {
	outlet: true, 
	enumerable: true, get:function () { return this._dataProvider; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataProvider")) Object.defineProperty(this, "_dataProvider", { writable: true, configurable: true }); this._dataProvider = v; }});
	

	Object.defineProperty(GenericViewPlugIn.prototype, "readableType", {
		get: _GenericPlugIn_get_readableType});
	

	Object.defineProperty(GenericViewPlugIn.prototype, "readableValue", {
		get: _GenericPlugIn_get_readableValue});
	

GenericViewPlugIn.prototype.plugInInfoForUTI = function GenericViewPlugIn_plugInInfoForUTI(uti) {
		return _GenericPlugIn_plugInInfoForUTI(uti);};
	

	Object.defineProperty(GenericViewPlugIn.prototype, "inspectorProperties", {
		get: _GenericPlugIn_get_inspectorProperties});
	

GenericViewPlugIn.prototype.plugInInfoForUTI = function GenericViewPlugIn_plugInInfoForUTI(uti) {
		return _GenericPlugIn_plugInInfoForUTI.call(this, uti);};
	

	Object.defineProperty(GenericViewPlugIn.prototype, "objectProperties", {
		get: _GenericPlugIn_get_objectProperties});
	
	
	Object.defineProperty(GenericViewPlugIn.prototype, "nameIsEditable", {
		value: true});
	

	Object.defineProperty(GenericViewPlugIn.prototype, "pluginInfo", {
		get: _GenericPlugIn_get_pluginInfo});
	

GenericViewPlugIn.prototype.transformData = function GenericViewPlugIn_transformData(data, transformer) {
		if (transformer.isXIBGenerator) {
			return _GenericPlugIn_transformDataForXIB.call(this, data, transformer);
		} else {
			return _GenericPlugIn_transformDataForPreview.call(this, data, transformer);
		}};
	

GenericViewPlugIn.prototype.cocoaCustomTypeForData = function GenericViewPlugIn_cocoaCustomTypeForData(data) {
		return _GenericPlugIn_cocoaCustomTypeForData(data);};
	

	Object.defineProperty(GenericViewPlugIn.prototype, "cocoaType", {
		value: 'UIView'});
	
	
	Object.defineProperty(GenericViewPlugIn.prototype, "bindableProperties", {
		get: function () {
			var result = clone(__super.prototype.bindableProperties);
			if (this.objectProperties) {
				for (var i in this.objectProperties) {
					if (isNaN(i)) {
						continue;
					}
					var p = this.objectProperties[i];
					
					if (p.bindable) {
						result.unshift([p.key, this.readableNameForProperty(p.key)]);
					}
				}
			}

			return result;
		}});
	

	
GenericViewPlugIn.prototype.expectedTypeForPropertyWithData = function GenericViewPlugIn_expectedTypeForPropertyWithData(prop, data) {
		var info = _GenericPlugIn_plugInInfoForUTI(data.pluginIdentifier);
		if (!info) return;
		
		for (var i in info.objectProperties) {
			if (isNaN(i)) {
				continue;
			}
			var p = info.objectProperties[i];
			if (p.key === prop) {
				return p.propertyType||p.type;
			}
		}
		
		};
	

	Object.defineProperty(GenericViewPlugIn.prototype, "outlineIconURL", {
		get: _GenericPlugIn_get_outlineIconURL});
	

GenericViewPlugIn.prototype.needsNoObjCOutletForInstance = function GenericViewPlugIn_needsNoObjCOutletForInstance(obj) {
		alertd('needsNoObjCOutletForInstance() called', obj);
		return _GenericPlugIn_needsNoObjCOutletForInstance(obj);};
	

	Object.defineProperty(GenericViewPlugIn.prototype, "performableActions", {
		get: _GenericPlugIn_get_performableActions});
	

GenericViewPlugIn.prototype.readableNameForProperty = function GenericViewPlugIn__readableNameForProperty(propertyName) {
		return _GenericPlugIn_readableNameForProperty.call(this, propertyName) || __super.prototype.readableNameForProperty.call(this, propertyName);};
	

	Object.defineProperty(GenericViewPlugIn.prototype, "isDataSource", {
		get: _GenericPlugIn_get_isDataSource});
	

	Object.defineProperty(GenericViewPlugIn.prototype, "storesContents", {
		get: _GenericPlugIn_get_storesContents});
	

	Object.defineProperty(GenericViewPlugIn.prototype, "requiresPreviewBuildVersion", {
		get: _GenericPlugIn_get_requiresPreviewBuildVersion});
	

GenericViewPlugIn.prototype.dataRequiresPreviewBuildVersion = function GenericViewPlugIn_dataRequiresPreviewBuildVersion(data) {
		return _GenericPlugIn_dataRequiresPreviewBuildVersion(data);};
	

GenericViewPlugIn.prototype.readableTypeForData = function GenericViewPlugIn_readableTypeForData(data) {
		return _GenericPlugIn_readableTypeForData(data);};
	

GenericViewPlugIn.prototype.instancesCanBeLocal = function GenericViewPlugIn_instancesCanBeLocal(obj) {
		return _GenericPlugIn_instancesCanBeLocal(obj);};
	

GenericViewPlugIn.prototype.instancesCanBeGlobal = function GenericViewPlugIn_instancesCanBeGlobal(obj) {
		return _GenericPlugIn_instancesCanBeGlobal(obj);};
	
	

GenericViewPlugIn.prototype.instancesAreDataProviders = function GenericViewPlugIn_instancesAreDataProviders(obj) {
		return _GenericPlugIn_instancesAreDataProviders(obj);};
	


GenericViewPlugIn.prototype.outlineIconURLDidChange = function GenericViewPlugIn__outlineIconURLDidChange() {
		this.context.broadcastValueChangeForKeyPathInObject('outlineIconURL', this, this);};
	
GenericViewPlugIn.prototype.initPropertiesFromData = function GenericViewPlugIn_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("pluginIdentifier")) this.pluginIdentifier = data.pluginIdentifier;
if (data.hasOwnProperty("propertyValues")) this.propertyValues = data.propertyValues;
if (data.hasOwnProperty("dataProvider")) this.dataProvider = data.dataProvider;
};

GenericViewPlugIn.prototype.decodeData = function GenericViewPlugIn_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("dataProvider")) decoded.dataProvider = this.context.decodeObjectTree(data.dataProvider);
return decoded; };

GenericViewPlugIn.prototype.encode = function GenericViewPlugIn_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encode();
}return encoded; };

GenericViewPlugIn.prototype.encodeCloned = function GenericViewPlugIn_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encodeCloned();
}return encoded; };

GenericViewPlugIn.prototype.expectedTypeForProperty = function GenericViewPlugIn_expectedTypeForProperty(key) {
	if (key === "pluginIdentifier") return "String";
	if (key === "propertyValues") return "Object";
	if (key === "dataProvider") return "GenericPluginDataProvider";
	if (key === "readableType") return "";
	if (key === "readableValue") return "";
	if (key === "inspectorProperties") return "";
	if (key === "objectProperties") return "Object";
	if (key === "nameIsEditable") return "";
	if (key === "pluginInfo") return "String";
	if (key === "cocoaType") return "";
	if (key === "bindableProperties") return "";
	if (key === "outlineIconURL") return "";
	if (key === "performableActions") return "";
	if (key === "isDataSource") return "";
	if (key === "storesContents") return "";
	if (key === "requiresPreviewBuildVersion") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return GenericViewPlugIn; }()));
registerType('info.appdoo-mac', (function () { function GenericPluginDataProvider() {} var __super = setSupertypeFromDomain(GenericPluginDataProvider, 'DataProvider', 'info.appdoo-mac');

	Object.defineProperty(GenericPluginDataProvider.prototype, "propertiesForBindings", {
		get: function () {
			if (!this.plugin || !this.plugin.pluginInfo) return [];
			return _GenericPlugIn_getProvidableProperties(this.plugin.pluginInfo);
		}});
	
	
	Object.defineProperty(GenericPluginDataProvider.prototype, "plugin", {
	synthesized: true, get:function () { return this._plugin; }, set:function (v) {if (!Object.hasOwnProperty(this, "_plugin")) Object.defineProperty(this, "_plugin", { writable: true, configurable: true }); this._plugin = v; }});
	


	Object.defineProperty(GenericPluginDataProvider.prototype, "pluginIdentifier", {
	outlet: true, 
	enumerable: true, get:function () { return this._pluginIdentifier; }, set:function (v) {if (!Object.hasOwnProperty(this, "_pluginIdentifier")) Object.defineProperty(this, "_pluginIdentifier", { writable: true, configurable: true }); this._pluginIdentifier = v; }});
	

	
GenericPluginDataProvider.prototype.addDataProviderToObject = function GenericPluginDataProvider_addDataProviderToObject(plugin) {
		this.plugin = plugin;
		this.pluginIdentifier = plugin.pluginIdentifier;
		__super.prototype.addDataProviderToObject.call(this, plugin);};
	
	
	Object.defineProperty(GenericPluginDataProvider.prototype, "isPlugin", {
		value: true});
	

GenericPluginDataProvider.prototype.transformData = function GenericPluginDataProvider_transformData(data, transformer) {

		var result = __super.prototype.transformData.call(this, data, transformer);
		
		transformer.setType(result, this.cocoaCustomTypeForData(data));

		transformer.setReferenceProperty(result, 'sourceObject', data.$id, data.objectID);

		return result;};
	
	
GenericPluginDataProvider.prototype.cocoaCustomTypeForData = function GenericPluginDataProvider_cocoaCustomTypeForData(data) {
		var info = _GenericPlugIn_plugInInfoForUTI(data.pluginIdentifier);
		if (info) {
			return info.dataProviderClass;
		}};
	
	
	Object.defineProperty(GenericPluginDataProvider.prototype, "mutable", {
		value: true});
	
	

GenericPluginDataProvider.prototype.initPropertiesFromData = function GenericPluginDataProvider_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("pluginIdentifier")) this.pluginIdentifier = data.pluginIdentifier;
};

GenericPluginDataProvider.prototype.decodeData = function GenericPluginDataProvider_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

GenericPluginDataProvider.prototype.encode = function GenericPluginDataProvider_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

GenericPluginDataProvider.prototype.encodeCloned = function GenericPluginDataProvider_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

GenericPluginDataProvider.prototype.expectedTypeForProperty = function GenericPluginDataProvider_expectedTypeForProperty(key) {
	if (key === "propertiesForBindings") return "";
	if (key === "plugin") return "";
	if (key === "pluginIdentifier") return "String";
	if (key === "isPlugin") return "";
	if (key === "mutable") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return GenericPluginDataProvider; }()));
{
	[getType('info.appdoo-mac.GenericPlugIn'), getType('info.appdoo-mac.GenericViewPlugIn')].forEach(function (constructor) {
	
		var proto = constructor.prototype;
	
		Object.defineProperty(proto, 'mutable', {
			value: true 
		});
		
		proto.nameForKeyPath = function (keyPath) {
			return this.readableNameForProperty(keyPath);
		};
	
		Object.defineProperty(proto, 'providesRootData', {
			value: true
		});
	
		Object.defineProperty(proto, 'rootData', {
			get: function () {
				var obj = {};
				(this.objectProperties||[]).forEach(function (prop) {
					if (prop.observable)
						obj[prop.key] = this.propertyValues[prop.key];
				}, this);
				return obj;
			}
		});
	
		proto.implementationHasObservable = function(obj) {
			return this.pluginInfo && this.pluginInfo.isObservable;
		};
	
	});}