
registerType('info.appdoo-mac', (function () { function Hyperlink() {} var __super = setSupertypeFromDomain(Hyperlink, 'UIButton', 'appdoo.iOS');


var defaultLinkColor = 'rgb(60,130,219)',
	defaultActiveLinkColor = 'rgb(255,0,0)',
	defaultInactiveLinkColor = 'rgb(150,150,150)',
	defaultBackgroundColor = 'rgb(255,255,255,0)';


Hyperlink.prototype.initFromData = function Hyperlink_initFromData(data) {

	
	if (!data.CSSTextColor) data.CSSTextColor = defaultLinkColor

	data.buttonStyle = 'custom';
	
	__super.prototype.initFromData.call(this, data);
	
	if (!data.hyperlinkTarget) this.hyperlinkTarget = 'web';
	
	this.textAlignment = data.textAlignment || 'left';
	this.URLString = data.URL || data.URLString;
	this.highlightedColor = data.highlightedColor || defaultActiveLinkColor;
	this.inactiveColor = data.inactiveColor || defaultInactiveLinkColor;
	this.backgroundColor = data.backgroundColor || defaultBackgroundColor;

	this.DOMNode.onmouseup = function (event) {
		this.style({ color: this.CSSTextColor });
	}.bind(this);
	this.DOMNode.onmouseout = function (event) {
		this.style({ color: this.CSSTextColor });
	}.bind(this);
	this.DOMNode.onmousedown = function (event) {
		if (event.altKey && event.metaKey) {
			this.style({ color: this.highlightedColor });
		}
	}.bind(this);
	this.DOMNode.onclick = function (event) {
		if (event.altKey && event.metaKey) {
			location.href = this.URLString;
		}
	}.bind(this);

	this.style({
		textDecoration: 'underline',
		
		
		
		
	});
	return this;};


Object.defineProperty(Hyperlink.prototype, "isPlugin", {
	value: true});



Hyperlink.prototype.transformData = function Hyperlink_transformData(data, transformer) {
		if (transformer.isXIBGenerator) return this.hyperlink_transformDataForXIB(data, transformer);
		return this.hyperlink_transformDataForPreview(data, transformer);};
	


Hyperlink.prototype.hyperlink_transformDataForPreview = function Hyperlink_hyperlink_transformDataForPreview(data, transformer) {
		var result = __super.prototype.transformData.call(this, data, transformer);
		result.$type = 'Hyperlink';
		result.$domain = this.__domain;
		result.URLString = this.createURLFromData(data);
		result.$constructor.arguments[0] = 0;
		return result;
};
	

Hyperlink.prototype.hyperlink_transformDataForXIB = function Hyperlink_hyperlink_transformDataForXIB(data, transformer) {

	transformer.demandPlugin('info.appdoo-mac.NSStringPunycodeAdditions');

	var result = __super.prototype.transformData.call(this, data, transformer);
	
	delete result.buttonType;
	
	result['state normal'].color = transformer.transformCSSColor(data.CSSTextColor||defaultLinkColor, 'titleColor');

	result['state highlighted'].color = transformer.transformCSSColor(data.highlightedColor, 'titleColor');
	
	result['state disabled'] = {
		key: "disabled",
		color: transformer.transformCSSColor(data.inactiveColor, 'titleColor')
	};
	result.backgroundColor = data.backgroundColor;
	result.contentHorizontalAlignment=data.textAlignment;
	
	if (data.URLString) { 
		if (!result.userDefinedRuntimeAttributes) result.userDefinedRuntimeAttributes = {};
		result.userDefinedRuntimeAttributes['userDefinedRuntimeAttribute URLString'] = {
			type: "string",
			keyPath: "URLString",
			value: this.createURLFromData(data)
		};
	}

	return result;};


Object.defineProperty(Hyperlink.prototype, "URLString", {
enumerable: true, 
synthesized: true, 
	set: function (v) {if (!Object.hasOwnProperty(this, "_URLString")) Object.defineProperty(this, "_URLString", { writable: true, configurable: true });
		this._URLString = v;
		this.validateURL();
	}, get:function () { return this._URLString; }});

	Object.defineProperty(Hyperlink.prototype, "text", {
	enumerable: true, 
	outlet: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_text")) Object.defineProperty(this, "_text", { writable: true, configurable: true });
			this._text = v;
			if (this.label) this.label.text = v;
		}, get:function () { return this._text; }});
	

Object.defineProperty(Hyperlink.prototype, "inactiveColor", {
enumerable: true, 
synthesized: true, 
	set: function (v) {if (!Object.hasOwnProperty(this, "_inactiveColor")) Object.defineProperty(this, "_inactiveColor", { writable: true, configurable: true });
		this._inactiveColor = v;
		this.validateURL();
	}, get:function () { return this._inactiveColor; }});


Object.defineProperty(Hyperlink.prototype, "backgroundColor", {
enumerable: true, 
synthesized: true, 
	set: function (v) {if (!Object.hasOwnProperty(this, "_backgroundColor")) Object.defineProperty(this, "_backgroundColor", { writable: true, configurable: true });
		this._backgroundColor = v;
		if (this.label && this.label.DOMNode !== undefined) this.label.DOMNode.style.backgroundColor = v;
		this.validateURL();
	}, get:function () { return this._backgroundColor; }});


Hyperlink.prototype.validateURL = function Hyperlink__validateURL() {
	var isValidURL = (this.URLString && this.URLString.indexOf(':') !== -1);
	if (isValidURL) {
		this.style({
			textDecoration: 'underline',
			color: this.CSSTextColor
		});
	} else {
		this.style({
			textDecoration: 'none',
			color: this.inactiveColor
		});
	}};



Object.defineProperty(Hyperlink.prototype, "highlightedColor", {
enumerable: true, 
synthesized: true, get:function () { return this._highlightedColor; }, set:function (v) {if (!Object.hasOwnProperty(this, "_highlightedColor")) Object.defineProperty(this, "_highlightedColor", { writable: true, configurable: true }); this._highlightedColor = v; }});



Object.defineProperty(Hyperlink.prototype, "cocoaType", {
configurable: true, 
	value: 'UIButton'});


Object.defineProperty(Hyperlink.prototype, "cocoaCustomType", {
configurable: true, 
	
	
	
	value: 'Hyperlink'});


Object.defineProperty(Hyperlink.prototype, "pluginIdentifier", {
	value: 'info.appdoo-mac.Hyperlink'});


Object.defineProperty(Hyperlink.prototype, "e_hyperlinkTarget", {
	set: function (v) {
		this.hyperlinkTarget = v;
	}, 
	get: function () { return this.hyperlinkTarget; }});


Object.defineProperty(Hyperlink.prototype, "hyperlinkTarget", {
outlet: true, 
enumerable: true, get:function () { return this._hyperlinkTarget; }, set:function (v) {if (!Object.hasOwnProperty(this, "_hyperlinkTarget")) Object.defineProperty(this, "_hyperlinkTarget", { writable: true, configurable: true }); this._hyperlinkTarget = v; }});


Object.defineProperty(Hyperlink.prototype, "mapsQuery", {
outlet: true, 
enumerable: true, get:function () { return this._mapsQuery; }, set:function (v) {if (!Object.hasOwnProperty(this, "_mapsQuery")) Object.defineProperty(this, "_mapsQuery", { writable: true, configurable: true }); this._mapsQuery = v; }});


Object.defineProperty(Hyperlink.prototype, "mailRecipient", {
outlet: true, 
enumerable: true, get:function () { return this._mailRecipient; }, set:function (v) {if (!Object.hasOwnProperty(this, "_mailRecipient")) Object.defineProperty(this, "_mailRecipient", { writable: true, configurable: true }); this._mailRecipient = v; }});



Object.defineProperty(Hyperlink.prototype, "mailSubject", {
outlet: true, 
enumerable: true, get:function () { return this._mailSubject; }, set:function (v) {if (!Object.hasOwnProperty(this, "_mailSubject")) Object.defineProperty(this, "_mailSubject", { writable: true, configurable: true }); this._mailSubject = v; }});


Object.defineProperty(Hyperlink.prototype, "mailBody", {
outlet: true, 
enumerable: true, get:function () { return this._mailBody; }, set:function (v) {if (!Object.hasOwnProperty(this, "_mailBody")) Object.defineProperty(this, "_mailBody", { writable: true, configurable: true }); this._mailBody = v; }});


Object.defineProperty(Hyperlink.prototype, "phoneNumber", {
outlet: true, 
enumerable: true, get:function () { return this._phoneNumber; }, set:function (v) {if (!Object.hasOwnProperty(this, "_phoneNumber")) Object.defineProperty(this, "_phoneNumber", { writable: true, configurable: true }); this._phoneNumber = v; }});


Hyperlink.prototype.openURL = function Hyperlink_openURL() {
	this.context.nativeProxy.sendMessage('openURL', this.createURLFromData(this));};


Hyperlink.prototype.createURLFromData = function Hyperlink_createURLFromData(data) {
	switch (data.hyperlinkTarget) {
		case 'maps':
			return 'http://maps.apple.com/?q='+encodeURIComponent(data.mapsQuery||'');
		case 'mail':
			return 'mailto:'+data.mailRecipient+'?subject='+encodeURIComponent(data.mailSubject)+'&body='+encodeURIComponent(data.mailBody);
		case 'phone':
			return 'tel:'+(data.phoneNumber||'');
		case 'web':
		default:
			return data.URLString;
	}};


Hyperlink.prototype.dumpURL = function Hyperlink_dumpURL() {
	alertd(this.createURLFromDataL());};

	

Object.defineProperty(Hyperlink.prototype, "inspectorProperties", {
	get: function () {

		return [


			{
				type: 'group',
				title: 'Hyperlink',
				id: 'Hyperlink',
				items: [
					{ name: LocalizedString('Name'), keyPath: 'e_name', placeholder: 'Name', undefinedValue:'', type: 'text', placeholder:LocalizedString('Optional') },
					{ name: LocalizedString('Text'), keyPath: 'text', type:'textarea',textFieldHeight:28 },
					{ type: 'space' },

					{ name: LocalizedString('Action'), keyPath: 'e_hyperlinkTarget', type:'select', labelOnTop:true, numberOfVisibleItems:1, options: [

						['web', LocalizedString('Open URL in Safari'), [{ name: LocalizedString('URL'), keyPath: 'URLString', type: 'textarea', textFieldHeight:52 }]],
						
						['maps', LocalizedString('Search Location on the Map'), [
							{ name: LocalizedString('Search for'), keyPath: 'mapsQuery', type: 'textarea', textFieldHeight:28 },
							{ type: 'button', caption: LocalizedString('Test'), buttonStyle: 'flat', buttonWidth:49, align: 'right', actionKeyPath: 'openURL' }
						]],
						
						['mail', LocalizedString('New Email'), [
							{ name: LocalizedString('To'), keyPath: 'mailRecipient', type: 'text', labelOnTop: true },
							{ name: LocalizedString('Subject'), keyPath: 'mailSubject', placeholder: 'Optional', type: 'text', labelOnTop: true },
							{ name: '', keyPath: 'mailBody', placeholder: 'Optional', type: 'textarea', textFieldHeight:48, labelOnTop: true }
						]],
						
						['phone', LocalizedString('Call Phone Number'), [{ name: LocalizedString('Phone Number'), keyPath: 'phoneNumber', type: 'textarea', textFieldHeight:28 }]],
					] },
					


					{ type: 'space' },

											

				]
			},
			{
				type: 'group',
				title: LocalizedString('Format'),
				id: 'format',
				items: [

					{ name: LocalizedString('Color'), keyPath: 'CSSTextColor', type: 'color', marginTop: -4, undefinedValue: defaultLinkColor },
					{ name: LocalizedString('pressed'), keyPath: 'highlightedColor', type: 'color', marginTop: -4 },
					{ name: LocalizedString('disabled'), keyPath: 'inactiveColor', type: 'color', marginTop: -4 },
					{ name: LocalizedString('Background Color'), keyPath: 'backgroundColor', type: 'color', undefinedValue: 'rgba(255,255,255, 0)' }, 
					{ type: 'space' },
					{ type: 'textAlignment', undefinedValue: 'left'},
					{ type: 'space' },
				]
			},
				{
					type: 'group',
					title: LocalizedString('Font'),
					id: 'HyperlinkFont',
					items: [
					{ type: 'font' },
					{ type: 'space' },
					{ type: 'fontSize', keyPath: 'fontSize' },

		
				]
			},
				{
					type: 'group',
					title: LocalizedString('Advanced'),
					id: 'UILabelAdvanced',
					items: [
							{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft: true },
		
					]
				}, 

		];
	}});


Object.defineProperty(Hyperlink.prototype, "bindableProperties", {
	get: function () {
		var result = clone(__super.prototype.bindableProperties);
		result.unshift(
			
			['URLString', LocalizedString('URL')]
		);
		return result;
	}});


Object.defineProperty(Hyperlink.prototype, "textAlignment", {
enumerable: true, 
outlet: true, 
	set: function (v) {if (!Object.hasOwnProperty(this, "_textAlignment")) Object.defineProperty(this, "_textAlignment", { writable: true, configurable: true });
		this._textAlignment = v;
		if (this.label && this.label.DOMNode !== undefined) this.label.DOMNode.style.textAlign = v;
	}, get:function () { return this._textAlignment; }});


Object.defineProperty(Hyperlink.prototype, "outlineIconURL", {
	get: function () {
		return this.context.pathForResource('Hyperlink.png');
	}});


Object.defineProperty(Hyperlink.prototype, "readableType", {
	get: function () {
		return 'Hyperlink';
	}});


Hyperlink.prototype.readableNameForProperty = function Hyperlink__readableNameForProperty(propertyName) {
	switch (propertyName) {
		case 'URLString': return 'URL';
		case 'backgroundColor': return LocalizedString('Background Color');
	}
	return __super.prototype.readableNameForProperty.call(this, propertyName);};


Hyperlink.prototype.createForSuperview = function Hyperlink_createForSuperview(superview) {
	var instance = __super.prototype.createForSuperview.call(this, superview);
	if (instance) {
		instance.text = 'Link';
		instance.URL = 'http://';
		instance.CSSTextColor = system7DefaultTint;
		instance.highlightedColor = 'rgb(255, 0, 0)';
		instance.inactiveColor =  'rgb(120, 120, 120)';
	}
	return instance;};


Hyperlink.prototype.action = function Hyperlink_action() {
	this.openURL();};




Hyperlink.prototype.superviewDidChangeTintColor = function Hyperlink__superviewDidChangeTintColor(color) {};
	

Hyperlink.prototype.initPropertiesFromData = function Hyperlink_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("text")) this.text = data.text;
if (data.hasOwnProperty("hyperlinkTarget")) this.hyperlinkTarget = data.hyperlinkTarget;
if (data.hasOwnProperty("mapsQuery")) this.mapsQuery = data.mapsQuery;
if (data.hasOwnProperty("mailRecipient")) this.mailRecipient = data.mailRecipient;
if (data.hasOwnProperty("mailSubject")) this.mailSubject = data.mailSubject;
if (data.hasOwnProperty("mailBody")) this.mailBody = data.mailBody;
if (data.hasOwnProperty("phoneNumber")) this.phoneNumber = data.phoneNumber;
if (data.hasOwnProperty("textAlignment")) this.textAlignment = data.textAlignment;
};

Hyperlink.prototype.decodeData = function Hyperlink_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

Hyperlink.prototype.encode = function Hyperlink_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

Hyperlink.prototype.encodeCloned = function Hyperlink_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

Hyperlink.prototype.expectedTypeForProperty = function Hyperlink_expectedTypeForProperty(key) {
	if (key === "isPlugin") return "";
	if (key === "URLString") return "String";
	if (key === "text") return "String";
	if (key === "inactiveColor") return "";
	if (key === "backgroundColor") return "";
	if (key === "highlightedColor") return "";
	if (key === "cocoaType") return "";
	if (key === "cocoaCustomType") return "";
	if (key === "pluginIdentifier") return "";
	if (key === "e_hyperlinkTarget") return "";
	if (key === "hyperlinkTarget") return "";
	if (key === "mapsQuery") return "";
	if (key === "mailRecipient") return "";
	if (key === "mailSubject") return "";
	if (key === "mailBody") return "";
	if (key === "phoneNumber") return "";
	if (key === "inspectorProperties") return "";
	if (key === "bindableProperties") return "";
	if (key === "textAlignment") return "";
	if (key === "outlineIconURL") return "";
	if (key === "readableType") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return Hyperlink; }()));