
registerType('info.appdoo-mac', (function () { function ImagePicker() {} var __super = setSupertypeFromDomain(ImagePicker, 'BasicEditableObject', 'appdoo');

	Object.defineProperty(ImagePicker.prototype, "requiresPreviewBuildVersion", {
		value: 8});
	

	Object.defineProperty(ImagePicker.prototype, "readableType", {
		get: function () { return LocalizedString('Image Picker'); }});
	

	Object.defineProperty(ImagePicker.prototype, "readableDescription", {
		get: function () { return LocalizedString('Enables the user to pick or take a photo'); }});
	
	
ImagePicker.prototype.init = function ImagePicker_init() {
		__super.prototype.init.call(this);
		
		return this;};
	

	Object.defineProperty(ImagePicker.prototype, "performableActions", {
		get: function () {
			return {
				'choose:': { name: LocalizedString('Choose Image') },
			};
		}});
	

	Object.defineProperty(ImagePicker.prototype, "outlineIconURL", {
		get: function () {
			return this.iconURL;
		}});
	

	Object.defineProperty(ImagePicker.prototype, "iconURL", {
		get: function () {
			return 'PlugIns/ImagePicker.cpsplugin/Editor/ImagePicker48.png';
		}});
	

	var defaultEditableObjectSaveKey = 'Image';
	
ImagePicker.prototype.transformData = function ImagePicker_transformData(data, transformer) {
		var result = transformer.createObject(data);

		if (transformer.isXIBGenerator) {
			result.connections = {
				outlet: {
					property:"viewController",
					destination: transformer.currentViewControllerXID,
					id:transformer.createStoryboardID()
				}
			};
		}
		else {
			result.$needsViewControllerReference = true;
		}
		
		transformer.setBooleanProperty(result, 'shouldIncludeCameraInSources', data.shouldIncludeCameraInSources);
		transformer.setBooleanProperty(result, 'shouldIncludePhotoLibraryInSources', data.shouldIncludePhotoLibraryInSources);
		transformer.setBooleanProperty(result, 'allowEditing', data.allowEditing);
		
		transformer.setReferenceProperty(result, 'editableObject', data.$id, data.editableObjectID);
		transformer.setStringProperty(result, 'editableObjectSaveKey', data.editableObjectSaveKey||defaultEditableObjectSaveKey);

		return result;};
	


	Object.defineProperty(ImagePicker.prototype, "shouldIncludeCameraInSources", {
	outlet: true, 
	enumerable: true, get:function () { return this._shouldIncludeCameraInSources; }, set:function (v) {if (!Object.hasOwnProperty(this, "_shouldIncludeCameraInSources")) Object.defineProperty(this, "_shouldIncludeCameraInSources", { writable: true, configurable: true }); this._shouldIncludeCameraInSources = v; }});
	

	Object.defineProperty(ImagePicker.prototype, "shouldIncludePhotoLibraryInSources", {
	outlet: true, 
	enumerable: true, get:function () { return this._shouldIncludePhotoLibraryInSources; }, set:function (v) {if (!Object.hasOwnProperty(this, "_shouldIncludePhotoLibraryInSources")) Object.defineProperty(this, "_shouldIncludePhotoLibraryInSources", { writable: true, configurable: true }); this._shouldIncludePhotoLibraryInSources = v; }});
	

	Object.defineProperty(ImagePicker.prototype, "allowEditing", {
	outlet: true, 
	enumerable: true, get:function () { return this._allowEditing; }, set:function (v) {if (!Object.hasOwnProperty(this, "_allowEditing")) Object.defineProperty(this, "_allowEditing", { writable: true, configurable: true }); this._allowEditing = v; }});
	

	Object.defineProperty(ImagePicker.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
					
						{ name: this.readableNameForProperty('shouldIncludeCameraInSources'), keyPath: 'shouldIncludeCameraInSources', type: 'boolean', positionLeft:true },
						{ name: this.readableNameForProperty('shouldIncludePhotoLibraryInSources'), keyPath: 'shouldIncludePhotoLibraryInSources', type: 'boolean', positionLeft:true },

						{ type: 'space' },
						{ name: this.readableNameForProperty('allowEditing'), keyPath: 'allowEditing', type: 'boolean', positionLeft:true },
						
						{ type: 'space' },
						{ type: 'object', objectType: 'info.appdoo-mac.EditableObjectContainer', name: LocalizedString('Save Result In'), labelOnTop:true, canChooseNothing:true, numberOfVisibleItems:5, keyPath:'editableObjectID', placeholder:LocalizedString('You need to create an Editable Dataset and set the destination of this Image Picker to it.'), placeholderHeight:40 },
						{ type: 'text', keyPath: 'editableObjectSaveKey', name: LocalizedString('Attribute'), placeholder:defaultEditableObjectSaveKey },
					
					]
				}
			];
		}});
	

	Object.defineProperty(ImagePicker.prototype, "editableObjectID", {
	outlet: true, 
	enumerable: true, get:function () { return this._editableObjectID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_editableObjectID")) Object.defineProperty(this, "_editableObjectID", { writable: true, configurable: true }); this._editableObjectID = v; }});
	


	Object.defineProperty(ImagePicker.prototype, "editableObjectSaveKey", {
	outlet: true, 
	enumerable: true, get:function () { return this._editableObjectSaveKey; }, set:function (v) {if (!Object.hasOwnProperty(this, "_editableObjectSaveKey")) Object.defineProperty(this, "_editableObjectSaveKey", { writable: true, configurable: true }); this._editableObjectSaveKey = v; }});
	

	
ImagePicker.prototype.createForContext = function ImagePicker_createForContext(context) {
		return createComponentFromDomain(
			this.constructor.name,
			this.__domain,
			context,
			{
				shouldIncludeCameraInSources: true,
				shouldIncludePhotoLibraryInSources: true,
				editableObjectID: ''
			}
		);};
	

ImagePicker.prototype.readableNameForProperty = function ImagePicker_readableNameForProperty(name) {
		if (name === 'shouldIncludeCameraInSources') return LocalizedString('Include Camera');
		if (name === 'shouldIncludePhotoLibraryInSources') return LocalizedString('Include Photo Library');
		if (name === 'allowEditing') return LocalizedString('Allow Editing');
		return __super.prototype.readableNameForProperty.call(this, name);};
	

ImagePicker.prototype.initPropertiesFromData = function ImagePicker_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("shouldIncludeCameraInSources")) this.shouldIncludeCameraInSources = data.shouldIncludeCameraInSources;
if (data.hasOwnProperty("shouldIncludePhotoLibraryInSources")) this.shouldIncludePhotoLibraryInSources = data.shouldIncludePhotoLibraryInSources;
if (data.hasOwnProperty("allowEditing")) this.allowEditing = data.allowEditing;
if (data.hasOwnProperty("editableObjectID")) this.editableObjectID = data.editableObjectID;
if (data.hasOwnProperty("editableObjectSaveKey")) this.editableObjectSaveKey = data.editableObjectSaveKey;
};

ImagePicker.prototype.decodeData = function ImagePicker_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

ImagePicker.prototype.encode = function ImagePicker_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

ImagePicker.prototype.encodeCloned = function ImagePicker_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

ImagePicker.prototype.expectedTypeForProperty = function ImagePicker_expectedTypeForProperty(key) {
	if (key === "requiresPreviewBuildVersion") return "";
	if (key === "readableType") return "";
	if (key === "readableDescription") return "";
	if (key === "performableActions") return "";
	if (key === "outlineIconURL") return "";
	if (key === "iconURL") return "";
	if (key === "shouldIncludeCameraInSources") return "Boolean";
	if (key === "shouldIncludePhotoLibraryInSources") return "Boolean";
	if (key === "allowEditing") return "Boolean";
	if (key === "inspectorProperties") return "";
	if (key === "editableObjectID") return "String";
	if (key === "editableObjectSaveKey") return "String";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ImagePicker; }()));