
registerType('info.appdoo-mac', (function () { function JSONDataSource() {} var __super = setSupertypeFromDomain(JSONDataSource, 'BasicDataSource', 'appdoo');

	Object.defineProperty(JSONDataSource.prototype, "readableDescription", {
		get: function () {
			return LocalizedString('Provides data from the JSON format');
		}});
	

JSONDataSource.prototype.createForContext = function JSONDataSource_createForContext(context) {
		var inst = __super.prototype.createForContext.call(this, context);
		inst.location = 'local';
		return inst;};
	
	
JSONDataSource.prototype.setJSONData = function JSONDataSource__setJSONData(json) {
		
		try {
			var contents = JSON.parse(json);
			this.lastCheckWasValid = true;
			this.testObjectForKVCCompliance(contents);
		}
		catch (err) {
			console.warn('The JSON is invalid.', {JSON:json}, err);
			var contents = {};
			this.lastCheckWasValid = !json;
		}
		
		this.contents = contents;
		};
	

	Object.defineProperty(JSONDataSource.prototype, "data", {
		set: function (v) {
			this.setJSONData(v);
		}});
	


	Object.defineProperty(JSONDataSource.prototype, "rootData", {
		get: function () {
			if (Array.isArray(this.contents)) {
				return { '': this.contents };
			}
		
			var d = {};
			for (var key in this.contents) {
				
				
				d[key] = this.contents[key];
			}
			return d;
		}});
	
	
	Object.defineProperty(JSONDataSource.prototype, "rootDataKeyPath", {
		get: function () {
			if (Array.isArray(this.contents)) return '';
			return 'contents';
		}});
	

	Object.defineProperty(JSONDataSource.prototype, "itemArrayKeyPath", {
		value: ''});
	
	
	Object.defineProperty(JSONDataSource.prototype, "canBeKeyPathFiltered", {
		value: true});
	

	Object.defineProperty(JSONDataSource.prototype, "providesRootData", {
		get: function () {
			
			return typeof this.contents === 'object'
				
				&& this.contents !== null;
		}});
	

	Object.defineProperty(JSONDataSource.prototype, "localJSONData", {
		set: function (v) {
			this.localData = v;
		}, 
		get: function (v) {
			return this.localData;
		}});
	

JSONDataSource.prototype.numberOfItemsInSectionAtKeyPath = function JSONDataSource_numberOfItemsInSectionAtKeyPath(section, keyPath) {
		var obj = this.context.dissolveKeyPathWithContextObject(keyPath, this.contents);
		if (!Array.isArray(obj)) return 0;
		return obj.length;};
	

JSONDataSource.prototype.dataForIndexPathInKeyPath = function JSONDataSource_dataForIndexPathInKeyPath(indexPath, keyPath) {
		var obj = this.context.dissolveKeyPathWithContextObject(keyPath, this.contents);
		if (Array.isArray(obj)) return obj[indexPath.item];};
	

	Object.defineProperty(JSONDataSource.prototype, "iconURL", {
		get: function () {
			return 'Resources/JSONDataSource48.png';
		}});
	
	
	Object.defineProperty(JSONDataSource.prototype, "outlineIconURL", {
		get: function () {
			return 'Resources/JSONDataSource.png';
		}});
	
	
	Object.defineProperty(JSONDataSource.prototype, "readableType", {
		get: function () { return TRANSLATE({'de':"JSON",'en':'JSON'}); }});
	

	Object.defineProperty(JSONDataSource.prototype, "isPlugin", {
		value: true});
	
	





	
	Object.defineProperty(JSONDataSource.prototype, "fileExtensionsForImport", {
		value: ['json','txt']});
	
	
JSONDataSource.prototype.nameForKeyPath = function JSONDataSource_nameForKeyPath(keyPath) {
		if (keyPath === '') return LocalizedString('Values');
		return __super.prototype.nameForKeyPath.call(this, keyPath);};
	

JSONDataSource.prototype.determineFirstItemKey = function JSONDataSource__determineFirstItemKey(item) {
		if (typeof item === 'string' || typeof item === 'number')
			return '';
		return __super.prototype.determineFirstItemKey.call(this, item);};
	







	Object.defineProperty(JSONDataSource.prototype, "performableActions", {
		get: function () {
			var performableActions = Object.getOwnPropertyDescriptor(__super.prototype, "performableActions").get.call(this);







			return performableActions;
		}});
	

	Object.defineProperty(JSONDataSource.prototype, "inspectorProperties", {
		get: function () {
			var inspectorProperties = Object.getOwnPropertyDescriptor(__super.prototype, "inspectorProperties").get.call(this);

			
			
			return inspectorProperties;
		}});
	










JSONDataSource.prototype.expectedTypeForProperty = function JSONDataSource_expectedTypeForProperty(key) {
	if (key === "readableDescription") return "";
	if (key === "data") return "";
	if (key === "rootData") return "";
	if (key === "rootDataKeyPath") return "";
	if (key === "itemArrayKeyPath") return "";
	if (key === "canBeKeyPathFiltered") return "";
	if (key === "providesRootData") return "";
	if (key === "localJSONData") return "";
	if (key === "iconURL") return "";
	if (key === "outlineIconURL") return "";
	if (key === "readableType") return "";
	if (key === "isPlugin") return "";
	if (key === "fileExtensionsForImport") return "";
	if (key === "performableActions") return "";
	if (key === "inspectorProperties") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return JSONDataSource; }()));