
registerType('info.appdoo-mac', (function () { function JavaScriptContainer() {} var __super = setSupertypeFromDomain(JavaScriptContainer, 'BasicDataSource', 'appdoo');

JavaScriptContainer.prototype.createForContext = function JavaScriptContainer__createForContext(context) {

		return createComponentFromDomain(
			this.constructor.name,
			this.__domain,
			context,
			{
				script: 'var x = 1;\nreturn x;'
			}
		);
		};
	

	Object.defineProperty(JavaScriptContainer.prototype, "contents", {
	outlet: true, 
	enumerable: true, get:function () { return this._contents; }, set:function (v) {if (!Object.hasOwnProperty(this, "_contents")) Object.defineProperty(this, "_contents", { writable: true, configurable: true }); this._contents = v; }});
	
	
JavaScriptContainer.prototype.init = function JavaScriptContainer_init() {
		__super.prototype.init.call(this);
		
		return this;};
	
	







	Object.defineProperty(JavaScriptContainer.prototype, "outlineIconURL", {
		get: function () {
			return 'Resources/JavaScriptContainer.png';
		}});
	

	Object.defineProperty(JavaScriptContainer.prototype, "iconURL", {
		get: function () {
			return 'Resources/JavaScriptContainer48.png';
		}});
	
	
	Object.defineProperty(JavaScriptContainer.prototype, "readableType", {
		get: function () { return LocalizedString('Data Processing'); }});
	

	Object.defineProperty(JavaScriptContainer.prototype, "readableDescription", {
		get: function () {
			return LocalizedString('Evaluates JavaScript and provides the result');
		}});
	

	Object.defineProperty(JavaScriptContainer.prototype, "script", {
	outlet: true, 
	enumerable: true, get:function () { return this._script; }, set:function (v) {if (!Object.hasOwnProperty(this, "_script")) Object.defineProperty(this, "_script", { writable: true, configurable: true }); this._script = v; }});
	
	
	Object.defineProperty(JavaScriptContainer.prototype, "localData", {
		get: function () { return this.script; }, 
		set: function (v) { this.script = v; }});
	
	
	Object.defineProperty(JavaScriptContainer.prototype, "canReload", {
		value: true});
	

JavaScriptContainer.prototype.reload = function JavaScriptContainer_reload(callback) {
		callback();
		this.inputData = undefined;
		this.evaluateScript();};
	
	
JavaScriptContainer.prototype.prepareForEditor = function JavaScriptContainer_prepareForEditor(editor) {
		this.inputData = undefined;
		setTimeout(function () {
			if (this.evaluatesImmediately)
				this.evaluateScript();
		}.bind(this), 0);};
	

function maskedEval(scr, context)
{
    
    
    var mask = {};
    
    for (var p in this)
        mask[p] = undefined;
	if (context) for (var p in context)
		mask[p] = context[p];

    
	return (new Function( "with(this) { return " + scr + "}")).call(mask);
}

JavaScriptContainer.prototype.readableErrorName = function JavaScriptContainer__readableErrorName(err) {
		switch (err.name) {
			case 'ReferenceError': return LocalizedString('Reference error');
			case 'TypeError': return LocalizedString('Type error');
			case 'SyntaxError': return LocalizedString('Syntax error');
			case 'RangeError': return LocalizedString('Range error');
			case 'Error': return LocalizedString('Error');
		}
		return err.name;};
	

JavaScriptContainer.prototype.readableError = function JavaScriptContainer__readableError(err) {
		

		if (err.line === 1 || (err.line>2&&err.line > this._script.split('\n').length)) return this.readableErrorName(err);
		
		var str = this.readableErrorName(err);
		
		if (err.line) str += ' '+LocalizedString('in line')+' '+(err.line-1);
		var message;
		
		switch (err.name) {
			case 'ReferenceError':
				var search = "Can't find variable:";
				if (err.message.indexOf(search) === 0) {
					message = TRANSLATE({en:err.message,de:err.message.replace(search,'Die Variable kann nicht gefunden werden:')});
				}
				break;
			case 'TypeError':
				var search = " is not an object ";
				if (err.message.indexOf(search) !== -1) {
					message = TRANSLATE({en:err.message,de:err.message.replace(search,' is kein Objekt ').replace('(evaluating ','(betreffend ')});
				}
				break;
			case 'SyntaxError':
				var search = "Unexpected token";
				if (err.message.indexOf(search) !== -1) {
					message = TRANSLATE({en:err.message,de:err.message.replace(search,'Unerwartetes Zeichen')});
				}
				var search = "Unexpected string";
				if (err.message.indexOf(search) !== -1) {
					message = TRANSLATE({en:err.message,de:err.message.replace(search,'Unerwarteter String')});
				}
				break;
			
		}
		if (!message) message = err.message;
		if (message) str += ': '+message;
		return str;};
	
	
	Object.defineProperty(JavaScriptContainer.prototype, "evalTimeout", {
	synthesized: true, get:function () { return this._evalTimeout; }, set:function (v) {if (!Object.hasOwnProperty(this, "_evalTimeout")) Object.defineProperty(this, "_evalTimeout", { writable: true, configurable: true }); this._evalTimeout = v; }});
	
	
JavaScriptContainer.prototype.evaluateScriptFromButton = function JavaScriptContainer__evaluateScriptFromButton() {
		
		if (document.activeElement.tagName === 'TEXTAREA') {
			document.activeElement.dispatchEvent(new Event('change'));
		}
		
		if (this.evalTimeout) return;
		
		this.evalTimeout = setTimeout(function () {
			this.evaluateScript();
			this.evalTimeout = null;
		}.bind(this), 50);};
	

JavaScriptContainer.prototype.evaluateScript = function JavaScriptContainer__evaluateScript() {
		
	
		var v = this._script;
		
		var contents = null;
		try {
			this.loadInputDataIfNecessary();
			
			
			
			




			if (v) {
				if (v.length > 1024*100) {
					var err = Error('The script is too long.','',1);
					this.displayErrorResult(err);
					return;
				}
				contents = maskedEval(
					'(function () {\n'+v+'\n})()',
					
					{input:this.inputData,input2:this.inputData2,alertd:alertd});
				this.displayNormalResult(contents);
			}
			else this.displayNormalResult();
		} catch (err) {
			
			this.displayErrorResult(err);
			console.log(err);
		}
		this.contents = contents;
		
		this.notifyObservers();
		
	};
	

	Object.defineProperty(JavaScriptContainer.prototype, "extraButton", {
	synthesized: true, get:function () { return this._extraButton; }, set:function (v) {if (!Object.hasOwnProperty(this, "_extraButton")) Object.defineProperty(this, "_extraButton", { writable: true, configurable: true }); this._extraButton = v; }});
	
	

JavaScriptContainer.prototype.displayNormalResult = function JavaScriptContainer__displayNormalResult(result) {
		if (!this.isSelected) {
			return;
		}
		var textarea = document.getElementById('evaluationResultTextarea');
		if (!textarea) {
			return;
		}
		textarea.style.color = result === undefined ? '#888':'';
		textarea.style.paddingRight = '';
		if (this.extraButton) {
			this.extraButton.hidden = true;
		}
		textarea.value = JSON.stringify(result);};
	
	
JavaScriptContainer.prototype.displayErrorResult = function JavaScriptContainer__displayErrorResult(err) {
		if (!this.isSelected) return;
		var textarea = document.getElementById('evaluationResultTextarea');
		if (!textarea) return;
		textarea.style.color = '#c03';
		textarea.value = this.readableError(err);
		if (err.line) {
			
			textarea.style.paddingRight = '24px';
			if (!this.extraButton) {
			  this.extraButton = createComponentFromDomain(
				'SpriteButton', 'Core.UI', this.context,
				{
					position: { right: -15, top: 8 },
					size: { width: 18, height: 18 },
					autoresizingMask: 1,
					sprite: 'Resources/SelectObjectButton.png',
					highlightOnMouseOver: true,
				});
			  textarea.parentNode.appendChild(this.extraButton.DOMNode);
			}
			this.extraButton.hidden = false;
			this.extraButton.action = function () {
						var tf = window.javaScriptTextField;
						if (tf) {
							var line = err.line || 0;
							
							var arrayOfLines = this._script.split("\n");
							var start = 0, end;
							for (var i = 0, c = err.line-2; i < c; i++) {
								start += arrayOfLines[i].length+1;
							}
							
							end = start+arrayOfLines[line-2].length
							javaScriptTextField.selectionStart = start;
							javaScriptTextField.selectionEnd = end;
						}
					}.bind(this);

		}
		else {
			textarea.style.paddingRight = '';
			if (this.extraButton) this.extraButton.hidden = true;
		}};
	

	Object.defineProperty(JavaScriptContainer.prototype, "rootData", {
		get: function () {




			
			return this.contents;
		}});
	

	Object.defineProperty(JavaScriptContainer.prototype, "providesRootData", {
		get: function () {
			
			
			return true;
		}});
	


	Object.defineProperty(JavaScriptContainer.prototype, "inputDataSourceID", {
	outlet: true, 
	enumerable: true, 
		get: function () { return this._inputDataSourceID||''; }, set:function (v) {if (!Object.hasOwnProperty(this, "_inputDataSourceID")) Object.defineProperty(this, "_inputDataSourceID", { writable: true, configurable: true }); this._inputDataSourceID = v; }});
	

	Object.defineProperty(JavaScriptContainer.prototype, "inputDataSource2ID", {
	outlet: true, 
	enumerable: true, 
		get: function () { return this._inputDataSource2ID||''; }, set:function (v) {if (!Object.hasOwnProperty(this, "_inputDataSource2ID")) Object.defineProperty(this, "_inputDataSource2ID", { writable: true, configurable: true }); this._inputDataSource2ID = v; }});
	

	Object.defineProperty(JavaScriptContainer.prototype, "inputData", {
	synthesized: true, get:function () { return this._inputData; }, set:function (v) {if (!Object.hasOwnProperty(this, "_inputData")) Object.defineProperty(this, "_inputData", { writable: true, configurable: true }); this._inputData = v; }});
	

	Object.defineProperty(JavaScriptContainer.prototype, "inputData2", {
	synthesized: true, get:function () { return this._inputData2; }, set:function (v) {if (!Object.hasOwnProperty(this, "_inputData2")) Object.defineProperty(this, "_inputData2", { writable: true, configurable: true }); this._inputData2 = v; }});
	
	
JavaScriptContainer.prototype.loadInputDataIfNecessary = function JavaScriptContainer__loadInputDataIfNecessary() {
		
		
		this.inputData = undefined;
		this.inputData2 = undefined;
		var dataKey = {'inputDataSourceID':'inputData','inputDataSource2ID':'inputData2'};
		['inputDataSourceID', 'inputDataSource2ID'].every(function (key) {
			
			if (!this[key]) return true;

			var obj = this.context.connectableObjects[this[key]];
			
			if (obj && obj.providesRootData) {
				this[dataKey[key]] = obj.contents;
				if (obj.addObserver) obj.addObserver(this, true);
			}
			else {
				
				this[key] = '';
			}return true; }, this);
		};
	
	
JavaScriptContainer.prototype.dataSourceDidLoad = function JavaScriptContainer_dataSourceDidLoad(dataSource) {
		
		if (dataSource.$id !== this.inputDataSourceID && dataSource.$id !== this.inputDataSource2ID) {
			dataSource.removeObserver(this);
			return;
		}
		
		

		if (this.evaluatesImmediately) {
			
				this.inputData = undefined;
				this.evaluateScript();
			
		}};
	
	
	Object.defineProperty(JavaScriptContainer.prototype, "isSelected", {
	synthesized: true, get:function () { return this._isSelected; }, set:function (v) {if (!Object.hasOwnProperty(this, "_isSelected")) Object.defineProperty(this, "_isSelected", { writable: true, configurable: true }); this._isSelected = v; }});
	
	
JavaScriptContainer.prototype.selectForEditor = function JavaScriptContainer_selectForEditor(editor) {
		this.isSelected = true;
		this.evaluateScriptFromButton(); };
	

JavaScriptContainer.prototype.unselectForEditor = function JavaScriptContainer_unselectForEditor(editor) {
		this.isSelected = false;





};
	

	Object.defineProperty(JavaScriptContainer.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
						{ name: this.readableNameForProperty('name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },

						
						
						
					
						{ type: 'info', html:'JavaScript',left:26,style:{textAlign:'right',color:'#888'},height:6 },
						{ name: '', keyPath: 'script', type: 'textarea', spellcheck: false, textFieldHeight: 200-30, acceptsReturn: true, textareaID:'javaScriptTextField' },
						{ type: 'button', caption: LocalizedString('Evaluate'), buttonWidth: 80, buttonStyle: 'flat', positionLeft: true, actionKeyPath: 'evaluateScriptFromButton' },
						{ type: 'info', html:selectableTextElement('',50,null,null,'evaluationResultTextarea'), left: 26, height:60,style:{overflow:''} },

						{ type: 'object', objectType: 'dataSource', 'keyPath': 'inputDataSourceID', name: LocalizedString('Variable')+' \'input\'', labelOnTop: true, excludeSelection: true, canChooseNothing: true, numberOfVisibleItems: 4.5 },
						{ type: 'object', objectType: 'dataSource', 'keyPath': 'inputDataSource2ID', name: LocalizedString('Variable')+' \'input2\'', labelOnTop: true, excludeSelection: true, canChooseNothing: true, numberOfVisibleItems: 4.5 },
						
						{ type: 'boolean', keyPath: 'evaluatesImmediately', positionLeft: true, name: LocalizedString('Evaluate immediately') },
					]
				},
			]
		}});
	
	
JavaScriptContainer.prototype.transformData = function JavaScriptContainer_transformData(data, transformer) {
		transformer.demandPlugin('info.appdoo-mac.DataSourceBase');
		transformer.demandPlugin('info.appdoo-mac.NSStringPunycodeAdditions');
		transformer.demandPlugin('info.appdoo-mac.JavaScriptContainer');

		var result = transformer.createObject(data);
		transformer.setStringProperty(result, 'script', data.script);
		['inputDataSourceID','inputDataSource2ID'].every(function (key) {
			if (data[key]) {
				transformer.setReferenceProperty(result, key.substr(0,key.length-2), data.$id, data[key]);
			}return true; }, this);
		
		
		transformer.setBooleanProperty(result, 'evaluatesImmediately', data.evaluatesImmediately);
		
		return result;
		};
	


	Object.defineProperty(JavaScriptContainer.prototype, "evaluatesImmediately", {
	outlet: true, 
	enumerable: true, get:function () { return this._evaluatesImmediately; }, set:function (v) {if (!Object.hasOwnProperty(this, "_evaluatesImmediately")) Object.defineProperty(this, "_evaluatesImmediately", { writable: true, configurable: true }); this._evaluatesImmediately = v; }});
	


	Object.defineProperty(JavaScriptContainer.prototype, "performableActions", {
		get: function () {
			return {
				'evaluate': { name: LocalizedString('Evaluate'), },
				'evaluateWithData:<#dataSourceContents#>': { name: LocalizedString('Evaluate With Data'), parameters: [{ type:'dataSourceContents', name:LocalizedString('Data'), key:'dataSourceContents', canChooseNothing:true, includeDynamicContext:true, numberOfVisibleItems: 1 }] },
			};
		}});
	
	
JavaScriptContainer.prototype.simulateAction = function JavaScriptContainer_simulateAction(name) {
	
		
		this.inputData = undefined;
		this.evaluateScript();
		};
	

	Object.defineProperty(JavaScriptContainer.prototype, "bindableProperties", {
		value: null});
	

JavaScriptContainer.prototype.determineFirstItemKey = function JavaScriptContainer__determineFirstItemKey(item) {
		var key = __super.prototype.determineFirstItemKey.call(this, item);
		return key || '';};
	
	
JavaScriptContainer.prototype.initPropertiesFromData = function JavaScriptContainer_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("contents")) this.contents = data.contents;
if (data.hasOwnProperty("script")) this.script = data.script;
if (data.hasOwnProperty("inputDataSourceID")) this.inputDataSourceID = data.inputDataSourceID;
if (data.hasOwnProperty("inputDataSource2ID")) this.inputDataSource2ID = data.inputDataSource2ID;
if (data.hasOwnProperty("evaluatesImmediately")) this.evaluatesImmediately = data.evaluatesImmediately;
};

JavaScriptContainer.prototype.decodeData = function JavaScriptContainer_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

JavaScriptContainer.prototype.encode = function JavaScriptContainer_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

JavaScriptContainer.prototype.encodeCloned = function JavaScriptContainer_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

JavaScriptContainer.prototype.expectedTypeForProperty = function JavaScriptContainer_expectedTypeForProperty(key) {
	if (key === "contents") return "";
	if (key === "outlineIconURL") return "";
	if (key === "iconURL") return "";
	if (key === "readableType") return "";
	if (key === "readableDescription") return "";
	if (key === "script") return "String";
	if (key === "localData") return "";
	if (key === "canReload") return "";
	if (key === "evalTimeout") return "";
	if (key === "extraButton") return "";
	if (key === "rootData") return "";
	if (key === "providesRootData") return "";
	if (key === "inputDataSourceID") return "String";
	if (key === "inputDataSource2ID") return "String";
	if (key === "inputData") return "";
	if (key === "inputData2") return "";
	if (key === "isSelected") return "";
	if (key === "inspectorProperties") return "";
	if (key === "evaluatesImmediately") return "Boolean";
	if (key === "performableActions") return "";
	if (key === "bindableProperties") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return JavaScriptContainer; }()));