//
//  KeyValueStore.m
//
//

#import "KeyValueStore.h"
#import "SimpleDatabase.h"

@implementation KeyValueStore

- (void)setDataString:(NSString *)dataString {
	self.contents = [[NSJSONSerialization JSONObjectWithData:[dataString dataUsingEncoding:NSUTF8StringEncoding] options:0 error:0] mutableCopy];
}

- (NSData *)data {
	return [NSJSONSerialization dataWithJSONObject:self.contents options:0 error:0];
}

- (NSString *)dataString {
	return [NSString.alloc initWithData:self.data encoding:NSUTF8StringEncoding];
}

- (void)setValue:(id)value forKeyPath:(NSString *)keyPath {
	if ([keyPath hasPrefix:@"contents."]) {
		[self.contents setValue:value forKeyPath:[keyPath substringFromIndex:9]];
		[self notifyObserversForKeyPath:keyPath];
		return;
	}
	[super setValue:value forKeyPath:keyPath];
}

- (void)saveInDatabase:(id)database {
	if ([database isKindOfClass:[SimpleDatabase class]]) {
		SimpleDatabase * db = (SimpleDatabase *)database;
		[db saveEntry:_contents];
	}
}

- (void)replaceContentsWithDictionary:(NSDictionary *)dict {
	
}

@end
