//
//  MapActions.m
//
//

#import "MapActions.h"

@implementation MapActions

+ (void)searchMap:(MKMapView *)mapView withQuery:(NSString *)query {
	
	CLGeocoder *geocoder = [[CLGeocoder alloc] init];
    [geocoder geocodeAddressString:query completionHandler:^(NSArray *placemarks, NSError *error) {

		if (error) {
			NSLog(@"%@", error);
		} else {
			CLPlacemark *placemark = [placemarks objectAtIndex:0];
			MKCoordinateRegion region;
#ifdef __IPHONE_7_0
			region.center.latitude = placemark.location.coordinate.latitude;
			region.center.longitude = placemark.location.coordinate.longitude;

			//float spanX = 0.00725;
			//float spanY = 0.00725;
			//region.span = MKCoordinateSpanMake(spanX, spanY);
			CLCircularRegion * placemarkRegion = (CLCircularRegion*)[placemark region];
			
			MKCoordinateSpan span;
			double radius = placemarkRegion.radius / 1000; // convert to km
			span.latitudeDelta = radius / 112.0;
			span.longitudeDelta = span.latitudeDelta;
			region.span = span;

			[mapView setRegion:region animated:YES];
#else
			region.center.latitude = placemark.region.center.latitude;
			region.center.longitude = placemark.region.center.longitude;
			
			MKCoordinateSpan span;
			double radius = placemark.region.radius / 1000; // convert to km
			span.latitudeDelta = radius / 112.0;
			span.longitudeDelta = span.latitudeDelta;
			region.span = span;
#endif
			[mapView setRegion:region animated:YES];
		}
		
		
    }];
	
}

@end
