
registerType('info.appdoo-mac', (function () { function MoviePlayerView() {} var __super = setSupertypeFromDomain(MoviePlayerView, 'UIView', 'appdoo.iOS');

	Object.defineProperty(MoviePlayerView.prototype, "nameIsEditable", {
		value: true});
	
	
	Object.defineProperty(MoviePlayerView.prototype, "isPlugin", {
		value: true});
	

	Object.defineProperty(MoviePlayerView.prototype, "pluginIdentifier", {
		value: 'info.appdoo-mac.MoviePlayerView'});
	
	
	Object.defineProperty(MoviePlayerView.prototype, "movieURLString", {
	outlet: true, 
	enumerable: true, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_movieURLString")) Object.defineProperty(this, "_movieURLString", { writable: true, configurable: true });
			if (this._movieURLString === value) return;
			this._movieURLString = value;
			this.removePlayer();
		}, get:function () { return this._movieURLString; }});
	
	







	Object.defineProperty(MoviePlayerView.prototype, "autoplay", {
	outlet: true, 
	enumerable: true, get:function () { return this._autoplay; }, set:function (v) {if (!Object.hasOwnProperty(this, "_autoplay")) Object.defineProperty(this, "_autoplay", { writable: true, configurable: true }); this._autoplay = v; }});
	

	Object.defineProperty(MoviePlayerView.prototype, "repeat", {
	outlet: true, 
	enumerable: true, get:function () { return this._repeat; }, set:function (v) {if (!Object.hasOwnProperty(this, "_repeat")) Object.defineProperty(this, "_repeat", { writable: true, configurable: true }); this._repeat = v; }});
	

	Object.defineProperty(MoviePlayerView.prototype, "backgroundPlayback", {
	outlet: true, 
	enumerable: true, 
		get: function ( ) { return this._backgroundPlayback; }, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_backgroundPlayback")) Object.defineProperty(this, "_backgroundPlayback", { writable: true, configurable: true });
			if(v != this._backgroundPlayback) {
				this._backgroundPlayback = v;
				this.context.metadata.requiresBackgroundAudioPlayback = v;
			}
		}});
	

	Object.defineProperty(MoviePlayerView.prototype, "showsControls", {
	outlet: true, 
	enumerable: true, get:function () { return this._showsControls; }, set:function (v) {if (!Object.hasOwnProperty(this, "_showsControls")) Object.defineProperty(this, "_showsControls", { writable: true, configurable: true }); this._showsControls = v; }});
	
	
	Object.defineProperty(MoviePlayerView.prototype, "dissolvedMovieURLString", {
		get: function () {
			if (this.sourceType === 'local') {
				var movieObject = this.context.fileReferenceWithID(this.localMovieObjectID);
				if (movieObject) return movieObject.filePath;
			}
			
			if (this.movieURLString && this.movieURLString.indexOf('file:') === 0) {
				var movieName = this.movieURLString.substr(5);
				var movieObject = this.context.resourceNamed(movieName);
				if (movieObject)
					return movieObject.filePath;
				return null;
			}
				
			return this.movieURLString;
		}});
	
	
	Object.defineProperty(MoviePlayerView.prototype, "playerNode", {
	synthesized: true, get:function () { return this._playerNode; }, set:function (v) {if (!Object.hasOwnProperty(this, "_playerNode")) Object.defineProperty(this, "_playerNode", { writable: true, configurable: true }); this._playerNode = v; }});
	
	
MoviePlayerView.prototype.init = function MoviePlayerView_init() {
		__super.prototype.init.call(this);
		this.styleDefault();
		if (this.autoplay === undefined) this.autoplay = true;
		if (this.repeat === undefined) this.repeat = false;
		if (this.backgroundPlayback === undefined) this.backgroundPlayback = false;
		if (this.showsControls === undefined) this.showsControls = true;
		
		return this;};
	
	
MoviePlayerView.prototype.styleDefault = function MoviePlayerView__styleDefault() {
		this.style({
			
			background: this.backgroundColor + ' url(Resources/Movie.png) no-repeat 50% 50%'
		});};
	
	
MoviePlayerView.prototype.removePlayer = function MoviePlayerView__removePlayer() {
		if (this.playerNode) this.playerNode.parentNode.removeChild(this.playerNode);};
	

MoviePlayerView.prototype.resetPlayer = function MoviePlayerView__resetPlayer() {
		if (!this.DOMNode) return;
		
		this.removePlayer();
		this.style({background: this.backgroundColor + ' url(Resources/Movie.png) no-repeat 50% 50%'});
		
		this.playerNode = document.createElement('video');
		this.playerNode.src = this.dissolvedMovieURLString;
		this.playerNode.width = this.size.width;
		this.playerNode.height = this.size.height;
		this.playerNode.style.width = '100%';
		this.playerNode.style.height = '100%';
		this.playerNode.style.height = '100%';
		
		this.playerNode.ondblclick = function (e) {
			this.controls = true;
		};
		this.DOMNode.appendChild(this.playerNode);

		if (this.interval) clearInterval(this.interval);};
	
	
MoviePlayerView.prototype.createForSuperview = function MoviePlayerView_createForSuperview(superview) {

		var makeFullSize = (superview.subviews.length === 0);
		var size = makeFullSize ? superview.sizeCopy :
			{ width: Math.min(320, superview.size.width), height: 180 };

		return superview.context.decodeObjectTree({
				$type: this.constructor.name,
				$domain: this.__domain,
				size: size,
				position: { left: 0, top: 0 },
				autoresizingMask: makeFullSize ? 18 : 36,
				sourceType: 'remote',
				backgroundColor: 'rgb(0,0,0)' 
			});
	};
	
	
	Object.defineProperty(MoviePlayerView.prototype, "sourceType", {
	outlet: true, 
	enumerable: true, get:function () { return this._sourceType; }, set:function (v) {if (!Object.hasOwnProperty(this, "_sourceType")) Object.defineProperty(this, "_sourceType", { writable: true, configurable: true }); this._sourceType = v; }});
	














	
	Object.defineProperty(MoviePlayerView.prototype, "localMovieObjectID", {
	outlet: true, 
	enumerable: true, get:function () { return this._localMovieObjectID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_localMovieObjectID")) Object.defineProperty(this, "_localMovieObjectID", { writable: true, configurable: true }); this._localMovieObjectID = v; }});
	
	
	Object.defineProperty(MoviePlayerView.prototype, "inspectorProperties", {
		get: function () {
			var self = this;

			return [

				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
						{ name: LocalizedString('Name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
						{ name: LocalizedString('Source'), type: 'select', keyPath: 'sourceType', options: [
							['local',LocalizedString('local'), [
								{ name: '', keyPath: 'localMovieObjectID', type:'fileReference', numberOfVisibleItems: 4, labelOnTop: true, filter: function (item) { return item.isVideo||item.isAudio; } },
								
							]],
							['remote',LocalizedString('remote'), [
								{ name: LocalizedString('URL'), keyPath: 'movieURLString', type:'textarea' },
								
							]],
						] },
	
						{ type: 'boolean', name: this.readableNameForProperty('showsControls'), positionLeft: true, keyPath: 'showsControls' },
						{ type: 'boolean', name: LocalizedString("Play Immediately"), positionLeft: true, keyPath: 'autoplay' },
						{ type: 'boolean', name: LocalizedString("Repeat Endlessly"), positionLeft: true, keyPath: 'repeat' },
						{ type: 'boolean', name: LocalizedString("Background Playback"), positionLeft: true, keyPath: 'backgroundPlayback'},
						{ type: 'info', html: LocalizedString("Background playback is only effective for audio files/streams"), height:50, showIcon:true, positionLeft: true,  },

						{ type: 'space' },

						{ type: 'button', caption: this.isPlaying ? '◼︎' : '▶︎', buttonWidth: 70, buttonStyle: 'flat', positionLeft: 0, 
							
							action: function () {
								self.playFromButton(this);
							}
						},
						{ name: LocalizedString('Background Color'), keyPath: 'backgroundColor', type: 'color', undefinedValue: 'rgba(0,0,0,1)' , marginTop: 3 },
						{ type: 'space' },
					]
				},
				{
					type: 'group',
					title: LocalizedString('Advanced'),
					id: this.constructor.name+'Advanced',
					items: [
		
							{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft: true },
		
					]
				}, 
		
			];

		}});
	
	
MoviePlayerView.prototype.openURL = function MoviePlayerView__openURL() {
		this.context.nativeProxy.sendMessage('openURL', this.movieURLString, 'QuickTime Player');};
	

	Object.defineProperty(MoviePlayerView.prototype, "bindableProperties", {
		get: function () {
			var result = clone(__super.prototype.bindableProperties);
			result.unshift(
				['movieURLString', this.readableNameForProperty('movieURLString')]
			);
			return result;
		}});
	
	
MoviePlayerView.prototype.readableNameForProperty = function MoviePlayerView_readableNameForProperty(p) {
		switch (p) {
			case 'movieURLString':				return LocalizedString('Movie URL');
			case 'currentPlaybackTime':			return LocalizedString('aktuelle Zeit (Sekunden)');
			case 'currentPlaybackTimeString':	return LocalizedString('aktuelle Zeit, formatiert');
			case 'remainingPlaybackTimeString':	return LocalizedString('verbleibende Zeit, formatiert');
			case 'currentPlaybackProgress':		return LocalizedString('Fortschritt');
			case 'isPlaying':					return LocalizedString('spielt ab');
			case 'isNotPlaying':				return LocalizedString('spielt nicht ab');
			case 'showsControls':				return LocalizedString('Show Controls');
		}
		return __super.prototype.readableNameForProperty.call(this, p);};
	
	
	Object.defineProperty(MoviePlayerView.prototype, "readableType", {
		get: function () { return LocalizedString('Media Player') }});
	

	Object.defineProperty(MoviePlayerView.prototype, "outlineIconURL", {
		get: function () {
			return this.context.pathForResource('MoviePlayerView.png')
		}});
	

	Object.defineProperty(MoviePlayerView.prototype, "iconURL", {
		get: function () {
			return _context.pathForResource('MoviePlayerView48.png')
		}});
	
	
	Object.defineProperty(MoviePlayerView.prototype, "cocoaType", {
		value: 'UIView'});
	

	Object.defineProperty(MoviePlayerView.prototype, "cocoaCustomType", {
		value: 'MoviePlayerView'});
	

MoviePlayerView.prototype.cocoaCustomTypeForData = function MoviePlayerView_cocoaCustomTypeForData(data) {
		return 'MoviePlayerView';};
	

MoviePlayerView.prototype.transformData = function MoviePlayerView_transformData(data, transformer) {
		if (transformer.isXIBGenerator) return this.moviePlayer_transformDataForXIB(data, transformer);
		else return this.moviePlayer_transformDataForPreview(data, transformer);};
	

MoviePlayerView.prototype.moviePlayer_transformDataForXIB = function MoviePlayerView_moviePlayer_transformDataForXIB(data, transformer) {

		transformer.demandPlugin('info.appdoo-mac.FileURLHelper');

		var result = __super.prototype.transformData.call(this, data, transformer);

		var url;
		if (data.sourceType === 'local') {
			var ref = _context.projectContext.fileReferenceWithID(data.localMovieObjectID);
			if (ref) {
				url = 'file:'+ref.name;
				transformer.productGenerator.registerResourceUsage(ref, data);
			}
		}
		else {
			url = data.movieURLString;
		}
		
		result.userDefinedRuntimeAttributes = {
			'userDefinedRuntimeAttribute 2': {
				type: 'boolean',
				keyPath: 'autoplay',
				value: transformer.transformBoolean(data.autoplay)
			},
			'userDefinedRuntimeAttribute 3': {
				type: 'boolean',
				keyPath: 'showsControls',
				value: transformer.transformBoolean(data.showsControls)
			},
			'userDefinedRuntimeAttribute 4': {
				type: 'boolean',
				keyPath: 'repeat',
				value: transformer.transformBoolean(data.repeat)





			}

		};

		if (url && !this.bindingForKey.call(data,'movieURLString')) {
			
			result.userDefinedRuntimeAttributes['userDefinedRuntimeAttribute movieURLString'] = {
				type: 'string',
				keyPath: 'movieURLString',
				value: url
			};
		}

		if (data.dataProvider) {
			var dataProvider = _context.projectContext.decodeObjectTree(data.dataProvider);
			transformer.registerInlineObject(dataProvider);
			transformer.connectOutletNamed__in__to__result__('dataProvider', data.$id, dataProvider.$id, result);
		}
		
		if (transformer.productGenerator) {
			transformer.productGenerator.addViewControllerImplementationCode(transformer.currentViewControllerId, 'viewWillAppear:', ['	[self.'+transformer.productGenerator.outletNameForProjectID[data.$id]+' viewWillAppear:animated];']);
		}
		
		
		return result;};
	

MoviePlayerView.prototype.moviePlayer_transformDataForPreview = function MoviePlayerView_moviePlayer_transformDataForPreview(data, transformer) {
		var result = __super.prototype.transformData.call(this, data, transformer);
		result.$type = this.constructor.name;
		result.$domain = this.__domain;
		result.autoplay = transformer.transformBoolean(data.autoplay);
		result.repeat = transformer.transformBoolean(data.repeat);
		result.backgroundPlayback = transformer.transformBoolean(data.backgroundPlayback);
		result.showsControls = transformer.transformBoolean(data.showsControls);

		var url;
		if (data.sourceType === 'local') {
			var movieObject = _context.projectContext.fileReferenceWithID(data.localMovieObjectID);
			if (movieObject) {
				
				url = transformer.transformLocalFileToURL(movieObject.name, movieObject.resourceID);
			}
		}
		else {
			url = data.movieURLString;
		}
		
		if (url) result.movieURLString = transformer.transformString(url);

		if (data.dataProvider) {
			result.dataProvider = getPrototype(utiFromData(data.dataProvider)).transformData(data.dataProvider, transformer);
			result.$propertyPriorities['dataProvider'] = -1;
		}
		result.$propertyPriorities['movieURLString'] = -2;


		return result;};
	

	Object.defineProperty(MoviePlayerView.prototype, "performableActions", {
		get: function () {
			return {
				'play': { name: LocalizedString('play') },
				'pause': { name: LocalizedString('pause') },
				'pauseOrPlay': { name: LocalizedString('play/pause') },
				'toggleFullScreen': { name: LocalizedString('Fullscreen') },


				'seekBackward': { name: LocalizedString('rewind') },
				'seekForward': { name: LocalizedString('fast-forward') },
			};
		}});
	
	
MoviePlayerView.prototype.simulateAction = function MoviePlayerView_simulateAction(actionID) {
		if (actionID === 'play') this.play();
		if (actionID === 'pause') this.pause();
		if (actionID === 'pauseOrPlay') this.pauseOrPlay();
		if (actionID === 'toggleFullScreen') this.toggleFullScreen();
		
		if (actionID === 'seekBackward') this.skipSeconds(-5);
		if (actionID === 'seekForward') this.skipSeconds(+5);};
	
	
MoviePlayerView.prototype.playFromButton = function MoviePlayerView__playFromButton(button) {
		
		
		this.pauseOrPlay();
		button.text = !this.isPaused ? '◼︎' : '▶︎';
		if (this.playerNode)
		this.playerNode.addEventListener('ended',function (e) {
			button.text = '▶︎';
		},false);};
	
	
	Object.defineProperty(MoviePlayerView.prototype, "interval", {
	synthesized: true, get:function () { return this._interval; }, set:function (v) {if (!Object.hasOwnProperty(this, "_interval")) Object.defineProperty(this, "_interval", { writable: true, configurable: true }); this._interval = v; }});
	
	
MoviePlayerView.prototype.play = function MoviePlayerView__play() {
		if (!this.playerNode) this.resetPlayer();
		this.playerNode.play();
		if (this.interval) clearInterval(this.interval);

		this.collectCurrentStateData();

		this.interval = setInterval(function () {
			this.collectCurrentStateData();
		}.bind(this), 250);};
	
	
	function formatTimeInSeconds(totalSeconds) {
		if (!(totalSeconds > 0)) return '0:00';
		var minutes = (totalSeconds/60)|0,
			seconds = (totalSeconds-minutes*60)|0;
		return minutes+':'+zeroFill(seconds,2);
	
	}
	
MoviePlayerView.prototype.collectCurrentStateData = function MoviePlayerView__collectCurrentStateData() {
		if (this.playerNode) {
			this.currentPlaybackTime = this.playerNode.currentTime|0;
			this.totalPlaybackTime = this.playerNode.duration|0;
		}
		else {
			this.currentPlaybackTime = 0;
			this.totalPlaybackTime = -1;
		}
		
		
		formatTimeInSeconds();

		this.currentPlaybackTimeString = formatTimeInSeconds(this.currentPlaybackTime);
		this.remainingPlaybackTimeString = formatTimeInSeconds(this.totalPlaybackTime-this.currentPlaybackTime);
		this.currentPlaybackProgress = this.currentPlaybackTime / this.totalPlaybackTime;

		this.dataProvider.notifyObservers();};
	


	Object.defineProperty(MoviePlayerView.prototype, "currentPlaybackTime", {
	synthesized: true, get:function () { return this._currentPlaybackTime; }, set:function (v) {if (!Object.hasOwnProperty(this, "_currentPlaybackTime")) Object.defineProperty(this, "_currentPlaybackTime", { writable: true, configurable: true }); this._currentPlaybackTime = v; }});
	

	Object.defineProperty(MoviePlayerView.prototype, "currentPlaybackTimeString", {
	synthesized: true, get:function () { return this._currentPlaybackTimeString; }, set:function (v) {if (!Object.hasOwnProperty(this, "_currentPlaybackTimeString")) Object.defineProperty(this, "_currentPlaybackTimeString", { writable: true, configurable: true }); this._currentPlaybackTimeString = v; }});
	

	Object.defineProperty(MoviePlayerView.prototype, "remainingPlaybackTimeString", {
	synthesized: true, get:function () { return this._remainingPlaybackTimeString; }, set:function (v) {if (!Object.hasOwnProperty(this, "_remainingPlaybackTimeString")) Object.defineProperty(this, "_remainingPlaybackTimeString", { writable: true, configurable: true }); this._remainingPlaybackTimeString = v; }});
	

	Object.defineProperty(MoviePlayerView.prototype, "currentPlaybackProgress", {
	synthesized: true, get:function () { return this._currentPlaybackProgress; }, set:function (v) {if (!Object.hasOwnProperty(this, "_currentPlaybackProgress")) Object.defineProperty(this, "_currentPlaybackProgress", { writable: true, configurable: true }); this._currentPlaybackProgress = v; }});
	

	Object.defineProperty(MoviePlayerView.prototype, "totalPlaybackTime", {
	synthesized: true, get:function () { return this._totalPlaybackTime; }, set:function (v) {if (!Object.hasOwnProperty(this, "_totalPlaybackTime")) Object.defineProperty(this, "_totalPlaybackTime", { writable: true, configurable: true }); this._totalPlaybackTime = v; }});
	

MoviePlayerView.prototype.pause = function MoviePlayerView__pause() {
		if (!this.playerNode) this.resetPlayer();
		this.playerNode.pause();
		this.collectCurrentStateData();
		if (this.interval) clearInterval(this.interval);};
	

MoviePlayerView.prototype.pauseOrPlay = function MoviePlayerView__pauseOrPlay() {
		if (!this.playerNode) this.play();
		else {
			if (this.playerNode.paused)
				this.play();
			else
				this.pause();
		}};
	
	
	Object.defineProperty(MoviePlayerView.prototype, "isPaused", {
		get: function () { return this.playerNode && this.playerNode.paused; }});
	

	Object.defineProperty(MoviePlayerView.prototype, "isPlaying", {
		get: function () { return this.playerNode && !this.playerNode.paused; }});
	

	Object.defineProperty(MoviePlayerView.prototype, "isNotPlaying", {
		get: function () { return !this.isPlaying; }});
	


MoviePlayerView.prototype.toggleFullScreen = function MoviePlayerView__toggleFullScreen() {
		if (!this.playerNode) return;
		
		this.playerNode.webkitEnterFullScreen();};
	
	
MoviePlayerView.prototype.skipSeconds = function MoviePlayerView__skipSeconds(seconds) {
		if (!this.playerNode) return;
		this.playerNode.currentTime += seconds;};
	
	



MoviePlayerView.prototype.prepareForEditor = function MoviePlayerView_prepareForEditor(editor) {
		getPrototype('info.appdoo-mac.MoviePlayerDataProvider').addDataProviderToObject(this);
		this.collectCurrentStateData();};
	

	Object.defineProperty(MoviePlayerView.prototype, "dataProvider", {
	outlet: true, 
	enumerable: true, get:function () { return this._dataProvider; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataProvider")) Object.defineProperty(this, "_dataProvider", { writable: true, configurable: true }); this._dataProvider = v; }});
	

MoviePlayerView.prototype.initPropertiesFromData = function MoviePlayerView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("movieURLString")) this.movieURLString = data.movieURLString;
if (data.hasOwnProperty("autoplay")) this.autoplay = data.autoplay;
if (data.hasOwnProperty("repeat")) this.repeat = data.repeat;
if (data.hasOwnProperty("backgroundPlayback")) this.backgroundPlayback = data.backgroundPlayback;
if (data.hasOwnProperty("showsControls")) this.showsControls = data.showsControls;
if (data.hasOwnProperty("sourceType")) this.sourceType = data.sourceType;
if (data.hasOwnProperty("localMovieObjectID")) this.localMovieObjectID = data.localMovieObjectID;
if (data.hasOwnProperty("dataProvider")) this.dataProvider = data.dataProvider;
};

MoviePlayerView.prototype.decodeData = function MoviePlayerView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("dataProvider")) decoded.dataProvider = this.context.decodeObjectTree(data.dataProvider);
return decoded; };

MoviePlayerView.prototype.encode = function MoviePlayerView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encode();
}return encoded; };

MoviePlayerView.prototype.encodeCloned = function MoviePlayerView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encodeCloned();
}return encoded; };

MoviePlayerView.prototype.expectedTypeForProperty = function MoviePlayerView_expectedTypeForProperty(key) {
	if (key === "nameIsEditable") return "";
	if (key === "isPlugin") return "";
	if (key === "pluginIdentifier") return "";
	if (key === "movieURLString") return "String";
	if (key === "autoplay") return "Boolean";
	if (key === "repeat") return "Boolean";
	if (key === "backgroundPlayback") return "Boolean";
	if (key === "showsControls") return "Boolean";
	if (key === "dissolvedMovieURLString") return "";
	if (key === "playerNode") return "";
	if (key === "sourceType") return "String";
	if (key === "localMovieObjectID") return "String";
	if (key === "inspectorProperties") return "";
	if (key === "bindableProperties") return "";
	if (key === "readableType") return "";
	if (key === "outlineIconURL") return "";
	if (key === "iconURL") return "";
	if (key === "cocoaType") return "";
	if (key === "cocoaCustomType") return "";
	if (key === "performableActions") return "";
	if (key === "interval") return "Interval";
	if (key === "currentPlaybackTime") return "Number";
	if (key === "currentPlaybackTimeString") return "String";
	if (key === "remainingPlaybackTimeString") return "String";
	if (key === "currentPlaybackProgress") return "{";
	if (key === "totalPlaybackTime") return "Number";
	if (key === "isPaused") return "";
	if (key === "isPlaying") return "";
	if (key === "isNotPlaying") return "";
	if (key === "dataProvider") return "MoviePlayerDataProvider";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return MoviePlayerView; }()));
registerType('info.appdoo-mac', (function () { function MoviePlayerDataProvider() {} var __super = setSupertypeFromDomain(MoviePlayerDataProvider, 'DataProvider', 'info.appdoo-mac');

	Object.defineProperty(MoviePlayerDataProvider.prototype, "pluginIdentifier", {
		value: 'info.appdoo-mac.MoviePlayerView'});
	

	Object.defineProperty(MoviePlayerDataProvider.prototype, "propertiesForBindings", {
		value: ['currentPlaybackTime', 'currentPlaybackTimeString', 'remainingPlaybackTimeString', 'currentPlaybackProgress', 'isPlaying', 'isNotPlaying']});
	
	




	Object.defineProperty(MoviePlayerDataProvider.prototype, "mutable", {
		value: true});
	

MoviePlayerDataProvider.prototype.expectedTypeForProperty = function MoviePlayerDataProvider_expectedTypeForProperty(key) {
	if (key === "pluginIdentifier") return "";
	if (key === "propertiesForBindings") return "";
	if (key === "mutable") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return MoviePlayerDataProvider; }()));
