//
//  MoviePlayerDataProvider.m
//
//

#import "MoviePlayerDataProvider.h"
#import "MoviePlayerView.h"
#import <AVKit/AVKit.h>
#import <CoreMedia/CoreMedia.h>

static NSString * formatTimeInSeconds(int totalSeconds) {

	if (totalSeconds <= 0)
		return @"0:00";

	int minutes = (totalSeconds/60),
		seconds = (totalSeconds-minutes*60);
		
	return [NSString stringWithFormat:@"%d:%02d", minutes, seconds];
	
}

@implementation MoviePlayerDataProvider {
	NSDictionary * _contents;
}

- (void)updateContents {
    double currentPlaybackTime = CMTimeGetSeconds(_playerView.moviePlayer.player.currentTime);
    double totalPlaybackTime = CMTimeGetSeconds(_playerView.moviePlayer.player.currentItem.duration);
	if (isnan(currentPlaybackTime)) {
        currentPlaybackTime = 0;
    }
	if (!totalPlaybackTime || isnan(totalPlaybackTime)) {
        totalPlaybackTime = -1;
    }
	
	_contents = @{
				  @"currentPlaybackTime": [NSNumber numberWithDouble:currentPlaybackTime],
				  @"currentPlaybackTimeString": formatTimeInSeconds((int)currentPlaybackTime),
				  @"remainingPlaybackTimeString": formatTimeInSeconds((int)totalPlaybackTime - (int)currentPlaybackTime),
				  @"currentPlaybackProgress": [NSNumber numberWithDouble:currentPlaybackTime/totalPlaybackTime],
				  @"isPlaying": _playerView.isPlaying ? @YES : @NO,
				  @"isNotPlaying": !_playerView.isPlaying ? @YES : @NO
				  };
	[self notifyObservers];
}

- (id)contents {
	return _contents;
}

- (void)setValue:(id)value forKeyPath:(NSString *)keyPath {
	if ([keyPath hasPrefix:@"contents."]) {
		NSString * key = [keyPath substringFromIndex:9];
		if ([key isEqualToString:@"currentPlaybackProgress"]) {
			//[_playerView pause];
            CGFloat totalPlaybackTime = CMTimeGetSeconds(_playerView.moviePlayer.player.currentItem.duration);
            CGFloat currentPlaybackTime = CMTimeGetSeconds(_playerView.moviePlayer.player.currentTime);
			double current = totalPlaybackTime * [value doubleValue];
			currentPlaybackTime = current;
			//NSLog(@"current: %f -> %f", current, _playerView.moviePlayer.currentPlaybackTime);
			[self updateContents];
			
		}
		//NSLog(@"setValue: %@ forKeyPath: %@", value, keyPath);
	}
	else {
		[super setValue:value forKeyPath:keyPath];
	}
}

@end
