//
//  MoviePlayerView.h
//

#import <UIKit/UIKit.h>
#import "MoviePlayerDataProvider.h"
#import <AVKit/AVKit.h>
#import <AVFoundation/AVFoundation.h>

@interface MoviePlayerView : UIView

@property (strong, nonatomic) NSString * movieURLString;
@property (nonatomic) BOOL autoplay;
@property (nonatomic) BOOL showsControls;
@property (nonatomic) BOOL backgroundPlayback;
@property (nonatomic) BOOL repeat;
@property (readonly, nonatomic) BOOL isPlaying;
@property (nonatomic, weak) MoviePlayerDataProvider * dataProvider;

@property (strong, nonatomic) AVPlayerViewController * moviePlayer;

- (void)play;
- (void)pause;
- (void)pauseOrPlay;
- (void)toggleFullScreen;
- (void)seekBackward;
- (void)seekForward;
- (void)beginSeekingBackward;
- (void)beginSeekingForward;
- (void)endSeeking;

- (void)viewWillAppear:(BOOL)animated;

@end
