
registerType('info.appdoo-mac', (function () { function NativeObjectPlaceholder() {} var __super = setSupertypeFromDomain(NativeObjectPlaceholder, 'BasicEditableObject', 'appdoo');

	
NativeObjectPlaceholder.prototype.createForSuperview = function NativeObjectPlaceholder_createForSuperview(superview) {

		return superview.context.decodeObjectTree({
			$type: this.constructor.name,
			$domain: this.__domain,
			size: { width: 200, height: 200 },
			position: { left: 0, top: 0 },
			autoresizingMask: 36,
			isAUIView: true
		});
	};
	

	Object.defineProperty(NativeObjectPlaceholder.prototype, "readableType", {
		value: 'Eigenes Objekt'});
	
	
	Object.defineProperty(NativeObjectPlaceholder.prototype, "readableValue", {
		get: function () {
			return this.className || this.readableType;
		}});
	
	
NativeObjectPlaceholder.prototype.readableValueDidChange = function NativeObjectPlaceholder_readableValueDidChange() {
		__super.prototype.readableValueDidChange.call(this);
		};
	
	
	Object.defineProperty(NativeObjectPlaceholder.prototype, "inspectorProperties", {
		get: function () {
		
		
			var groups = [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
						{ name: LocalizedString('Class'), keyPath: 'e_className', placeholder: 'NSObject' },
						
						






						
					]
				},
			];

			var interface = this.getInterface();
			
			if (interface) {
				var classGroup = {
					type: 'group',
					title: this.className,
					id: this.className,
					items: [],
					groupIsVisible: function () {return 0}
				};
				
				if (Array.isArray(interface.properties)) interface.properties.every(function (properyInfo) {
					if (!properyInfo.isIBOutlet) return true;
					if (properyInfo.type.indexOf('*') === -1) return true;
					classGroup.items.push({ name: properyInfo.name, type: 'object', includesViews:true, allowsEmptySelection: true, keyPath: 'properties.'+properyInfo.name });return true; }, this);
				
			
				groups.push(classGroup);
			}

			return groups;
		}});
	
	
	Object.defineProperty(NativeObjectPlaceholder.prototype, "properties", {
	outlet: true, 
	enumerable: true, 
		get: function () { if (!this._properties) this.properties = {}; return this._properties; }, set:function (v) {if (!Object.hasOwnProperty(this, "_properties")) Object.defineProperty(this, "_properties", { writable: true, configurable: true }); this._properties = v; }});
	
	
	Object.defineProperty(NativeObjectPlaceholder.prototype, "className", {
	outlet: true, 
	enumerable: true, get:function () { return this._className; }, set:function (v) {if (!Object.hasOwnProperty(this, "_className")) Object.defineProperty(this, "_className", { writable: true, configurable: true }); this._className = v; }});
	

	Object.defineProperty(NativeObjectPlaceholder.prototype, "isAUIView", {
	outlet: true, 
	enumerable: true, get:function () { return this._isAUIView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_isAUIView")) Object.defineProperty(this, "_isAUIView", { writable: true, configurable: true }); this._isAUIView = v; }});
	
	
	Object.defineProperty(NativeObjectPlaceholder.prototype, "doSimulateState", {
	outlet: true, 
	enumerable: true, get:function () { return this._doSimulateState; }, set:function (v) {if (!Object.hasOwnProperty(this, "_doSimulateState")) Object.defineProperty(this, "_doSimulateState", { writable: true, configurable: true }); this._doSimulateState = v; }});
	
	
	Object.defineProperty(NativeObjectPlaceholder.prototype, "simulatedState", {
	outlet: true, 
	enumerable: true, 
		get: function () { if (!this._simulatedState) this.simulatedState = {}; return this._simulatedState; }, set:function (v) {if (!Object.hasOwnProperty(this, "_simulatedState")) Object.defineProperty(this, "_simulatedState", { writable: true, configurable: true }); this._simulatedState = v; }});
	




	
	Object.defineProperty(NativeObjectPlaceholder.prototype, "e_className", {
		get: function ( ) { return this.className; }, 
		set: function (v) { this.className = v; this.properties = {}; this.readableValueDidChange(); _context.editor.refreshInspector(); }});
	

	Object.defineProperty(NativeObjectPlaceholder.prototype, "e_doSimulateState", {
		get: function ( ) { return this.doSimulateState; }, 
		set: function (v) { this.doSimulateState = v; this.updateSimulatedState(); _context.editor.refreshInspector(); }});
	
	









	


	
	
NativeObjectPlaceholder.prototype.init = function NativeObjectPlaceholder_init() {
		__super.prototype.init.call(this);
		this.updateSimulatedState();
		











		
		
		return this;};
	


NativeObjectPlaceholder.prototype.transformData = function NativeObjectPlaceholder_transformData(data, transformer) {
	
		if (!transformer.isXIBGenerator) return {};
	
		if (data.isAUIView) {
			return {};
		}

		if (data.className) {
			var interface = this.getInterface.call(data);
			if (interface && interface.headerFile) {
				
				transformer.productGenerator.addIncludeHeaderForThingWithOriginalID(interface.headerFile, transformer.currentViewControllerId);
			}
			else {
				transformer.registerClassWithoutHeader(data.className);
			}
		}
		
		var result = {
					customClass: this.cocoaCustomTypeForData(data)
		};
		
		for (var key in data.properties) {
			alertd('key:',key);
			var value = data.properties[key];
			var isObjectReference = true;
			var isStringValue = false;
			
			if (isObjectReference) {
				transformer.connectOutletNamed__in__to__result__(key, data.$id, value, result);
			}
			else if (isStringValue) {
				transformer.object__addUserDefinedRuntimeAttribute__(result, {
					type: 'string',
					keyPath: key,
					value: value
				});
			}
		}

		return result;};
	

NativeObjectPlaceholder.prototype.cocoaTypeForData = function NativeObjectPlaceholder_cocoaTypeForData(data) {
		if (data.isAUIView) return 'UIView';
		return 'NSObject';};
	

NativeObjectPlaceholder.prototype.cocoaCustomTypeForData = function NativeObjectPlaceholder_cocoaCustomTypeForData(data) {
		alertd('cocoaCustomTypeForData', data.className);
		return data.className||'';};
	
	
	Object.defineProperty(NativeObjectPlaceholder.prototype, "encodesSubviews", {
		value: false});
	
	
NativeObjectPlaceholder.prototype.updateSimulatedState = function NativeObjectPlaceholder_updateSimulatedState() {
		if (this.doSimulateState) this.contents = this.simulatedState;
		else this.contents = null;
		};
	
	
	Object.defineProperty(NativeObjectPlaceholder.prototype, "providesRootData", {
		get: function () { return this.doSimulateState; }});
	
	
	Object.defineProperty(NativeObjectPlaceholder.prototype, "rootDataKeyPath", {
		value: 'contents'});
	
	

	Object.defineProperty(NativeObjectPlaceholder.prototype, "performableActions", {
		get: function () {
			var interface = this.getInterface();
			var actions = {};
			if (Array.isArray(interface.methods)) interface.methods.every(function (method) {
				if (method.returnType !== 'IBAction') return true;
				actions[method.selectorName] = { name: method.selectorName };return true; }, this);
			
			return actions;
		}});
	
	
NativeObjectPlaceholder.prototype.getInterface = function NativeObjectPlaceholder__getInterface() {
		return getPrototype('appdoo.ObjCHeaderResourceReference').interfaceForClass(this.className);};
	

NativeObjectPlaceholder.prototype.initPropertiesFromData = function NativeObjectPlaceholder_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("properties")) this.properties = data.properties;
if (data.hasOwnProperty("className")) this.className = data.className;
if (data.hasOwnProperty("isAUIView")) this.isAUIView = data.isAUIView;
if (data.hasOwnProperty("doSimulateState")) this.doSimulateState = data.doSimulateState;
if (data.hasOwnProperty("simulatedState")) this.simulatedState = data.simulatedState;
};

NativeObjectPlaceholder.prototype.decodeData = function NativeObjectPlaceholder_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

NativeObjectPlaceholder.prototype.encode = function NativeObjectPlaceholder_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

NativeObjectPlaceholder.prototype.encodeCloned = function NativeObjectPlaceholder_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

NativeObjectPlaceholder.prototype.expectedTypeForProperty = function NativeObjectPlaceholder_expectedTypeForProperty(key) {
	if (key === "readableType") return "";
	if (key === "readableValue") return "";
	if (key === "inspectorProperties") return "";
	if (key === "properties") return "Object";
	if (key === "className") return "String";
	if (key === "isAUIView") return "Boolean";
	if (key === "doSimulateState") return "";
	if (key === "simulatedState") return "Object";
	if (key === "e_className") return "String";
	if (key === "e_doSimulateState") return "Boolean";
	if (key === "encodesSubviews") return "";
	if (key === "providesRootData") return "";
	if (key === "rootDataKeyPath") return "";
	if (key === "performableActions") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return NativeObjectPlaceholder; }()));