
registerType('info.appdoo-mac', (function () { function ObjectProxy() {} var __super = setSupertypeFromDomain(ObjectProxy, 'BasicEditableObject', 'appdoo');
	
ObjectProxy.prototype.instancesCanBeLocal = function ObjectProxy_instancesCanBeLocal() {
		return true;};
	

ObjectProxy.prototype.instancesCanBeGlobal = function ObjectProxy_instancesCanBeGlobal() {
		return false;};
	

	Object.defineProperty(ObjectProxy.prototype, "originalObjectRef", {
		
		set: function (v) {
			if (typeof v === 'string')
				this.originalObjectID = v.substr('***REF*'.length);
		}, 
		get: function () { if (this.originalObjectID) return '***REF*'+this.originalObjectID; }});
	

	Object.defineProperty(ObjectProxy.prototype, "originalObjectID", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_originalObjectID")) Object.defineProperty(this, "_originalObjectID", { writable: true, configurable: true });
			
			this._originalObjectID = v;
			
			this.loadOriginalObject();
		}, get:function () { return this._originalObjectID; }});
	
	
ObjectProxy.prototype.loadOriginalObject = function ObjectProxy__loadOriginalObject() {
		
		
		if (!window._context) {
			this.loadOriginalObjectAfterDelay(1);
			return;
		}
		
		var obj = _context.projectContext.connectableObjects[this._originalObjectID];
		if (!obj) {
			this.loadOriginalObjectAfterDelay(1000);
		}
		else {
			this.originalObject = obj;
			this.outlineIconURLDidChange();
			this.readableValueDidChange();
		}
		};
	
	
	Object.defineProperty(ObjectProxy.prototype, "originalObject", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_originalObject")) Object.defineProperty(this, "_originalObject", { writable: true, configurable: true });
			if (v.addObserver)
				v.addObserver(this);
			if (this.originalObject && this.originalObject.removeObserver)
				this.originalObject.removeObserver(this);
			this._originalObject = v;
		}, get:function () { return this._originalObject; }});
	
	
ObjectProxy.prototype.dataSourceDidLoad = function ObjectProxy_dataSourceDidLoad(dataSource) {
		if (dataSource === this.originalObject) {
			this.outlineIconURLDidChange();
			this.readableValueDidChange();
		}};
	
	
ObjectProxy.prototype.loadOriginalObjectAfterDelay = function ObjectProxy__loadOriginalObjectAfterDelay(ms) {
		setTimeout(function () { this.loadOriginalObject(); }.bind(this), ms);};
	


	Object.defineProperty(ObjectProxy.prototype, "outlineIconURL", {
		get: function () {
			if (this.originalObject)
				return this.originalObject.outlineIconURL;
		}});
	

	Object.defineProperty(ObjectProxy.prototype, "iconURL", {
		get: function () {
			if (this.originalObject)
				return this.originalObject.iconURL;
		}});
	

	Object.defineProperty(ObjectProxy.prototype, "inspectorProperties", {
		get: function () {
			
			
		}});
	
	
	Object.defineProperty(ObjectProxy.prototype, "nameIsEditable", {
		value: false});
	

	Object.defineProperty(ObjectProxy.prototype, "readableValue", {
		get: function () {
			if (this.originalObject) {
				return this.originalObject.readableValue+' ('+TRANSLATE({'en':'Alias','de':'Alias'})+')';
			}
		}});
	

	Object.defineProperty(ObjectProxy.prototype, "performableActions", {
		get: function () {
			if (this.originalObject)
				return this.originalObject.performableActions;
		}});
	
	
ObjectProxy.prototype.iconURLForData = function ObjectProxy_iconURLForData(data) {
		return this.propertyForData('iconURL', data);};
	
	
ObjectProxy.prototype.propertyForData = function ObjectProxy__propertyForData(key, data) {
		if (data && data.originalObjectID) {
			if (!window._context) return;
			var obj = _context.projectContext.connectableObjects[data.originalObjectID];
			if (obj) return _context.dissolveKeyPathWithContextObject(key, obj);
		}};
	
	




ObjectProxy.prototype.transformData = function ObjectProxy_transformData(data, transformer) {
		
		return transformer.registerObjectProxy(data);};
	
	
	Object.defineProperty(ObjectProxy.prototype, "needsNoObjCOutlet", {
		value: true});
	

ObjectProxy.prototype.generatePostBindingsCodeFromData = function ObjectProxy_generatePostBindingsCodeFromData(data, transformer) {
		
		
		
		transformer.demandPlugin('info.appdoo-mac.ObjectProxy');
		
		var binding = this.bindingForKey.call(data, 'originalObjectRef');
		if (!binding) return;
		
		
		return '	[ObjectProxy setReferenceProperty:'+transformer.productGenerator.ObjCStringify(transformer.productGenerator.propertyNameForProjectID[data.$id])+' inObject:self toValueAtKeyPath:'+transformer.productGenerator.ObjCStringify(binding.destinationKeyPath)+' inObject:'+transformer.productGenerator.codePathForProjectIDOrNil(binding.destination)+'];';
			};
	
	
	Object.defineProperty(ObjectProxy.prototype, "bindableProperties", {
		get: function () {
			return [
				['originalObjectRef', this.readableNameForProperty('originalObjectRef')]
			];
		}});
	
	
ObjectProxy.prototype.readableNameForProperty = function ObjectProxy_readableNameForProperty(p) {
		if (p === 'originalObjectRef') return TRANSLATE({
					en:'Reference to Object',
					de:'Objekt-Referenz',
				});
		return __super.prototype.readableNameForProperty.call(this, p);};
	

ObjectProxy.prototype.initPropertiesFromData = function ObjectProxy_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("originalObjectID")) this.originalObjectID = data.originalObjectID;
};

ObjectProxy.prototype.decodeData = function ObjectProxy_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

ObjectProxy.prototype.encode = function ObjectProxy_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

ObjectProxy.prototype.encodeCloned = function ObjectProxy_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

ObjectProxy.prototype.expectedTypeForProperty = function ObjectProxy_expectedTypeForProperty(key) {
	if (key === "originalObjectRef") return "";
	if (key === "originalObjectID") return "String";
	if (key === "originalObject") return "";
	if (key === "outlineIconURL") return "";
	if (key === "iconURL") return "";
	if (key === "inspectorProperties") return "";
	if (key === "nameIsEditable") return "";
	if (key === "readableValue") return "";
	if (key === "performableActions") return "";
	if (key === "needsNoObjCOutlet") return "";
	if (key === "bindableProperties") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ObjectProxy; }()));