
#import "ObjectProxy.h"

@implementation ObjectProxy

+ (void)setReferenceProperty:(NSString *)propertyKey inObject:(NSObject *)destinationObject toValueAtKeyPath:(NSString *)keyPath inObject:(NSObject *)sourceObject {
	
	@try {
		id reference = [sourceObject valueForKeyPath:keyPath];
		if (!reference) return;
		if (![destinationObject respondsToSelector:NSSelectorFromString(propertyKey)]) return;
		
		[destinationObject setValue:reference forKey:propertyKey];
	}
	@catch (NSException *exception) {

	}
	@finally {

	}
	
	
}

@end