//
//  OutletCollectionExtensions.m
//

#import "OutletCollectionExtensions.h"

// Unfortunately IBOutletCollections are unordered.
// These methods order the objects by their tag value.

@implementation UINavigationItem (OutletCollectionExtensions)

- (void)setLeftBarButtonItemsOrderedByTag:(NSArray *)items {
	self.leftBarButtonItems = [items sortedArrayUsingComparator:^NSComparisonResult(UIBarButtonItem * obj1, UIBarButtonItem * obj2) {
		return obj2.tag < obj1.tag;
	}];
}

- (void)setRightBarButtonItemsOrderedByTag:(NSArray *)items {
	self.rightBarButtonItems = [items sortedArrayUsingComparator:^NSComparisonResult(UIBarButtonItem * obj1, UIBarButtonItem * obj2) {
		return obj2.tag < obj1.tag;
	}];
}

@end
