
registerType('info.appdoo-mac', (function () { function PDFImageView() {} var __super = setSupertypeFromDomain(PDFImageView, 'UIView', 'appdoo.iOS');

	Object.defineProperty(PDFImageView.prototype, "imageNode", {
	synthesized: true, get:function () { return this._imageNode; }, set:function (v) {if (!Object.hasOwnProperty(this, "_imageNode")) Object.defineProperty(this, "_imageNode", { writable: true, configurable: true }); this._imageNode = v; }});
	

PDFImageView.prototype.init = function PDFImageView_init() {
		__super.prototype.init.call(this);

		this.urlInfo;

		var img = document.createElement('img');
		
		this.DOMNode.appendChild(img);
		this.imageNode = img;
		this.imageNode.style.position = 'absolute';
		this.loadImage();

		return this;};
	

PDFImageView.prototype.createForSuperview = function PDFImageView_createForSuperview(superview) {

		return superview.context.decodeObjectTree({
			$type: this.constructor.name,
			$domain: this.__domain,
			size: { width: 250, height: 160 },
			position: { left: 0, top: 0 },
			autoresizingMask: 36,
		});
};
	
	
PDFImageView.prototype.layoutSubviews = function PDFImageView__layoutSubviews() {

		if (!this.imageRatio)
			return;

		var viewRatio = this.size.width / this.size.height;
	
		if (viewRatio < this.imageRatio) {
			var h = (this.size.width/this.imageRatio);
			this.imageNode.style.width = this.size.width+'px';
			this.imageNode.style.height = h+'px';
			this.imageNode.style.top = (this.size.height-h)/2+'px';
			this.imageNode.style.left = '0';
		}
		else {
			var w = (this.size.height*this.imageRatio);
			this.imageNode.style.height = this.size.height+'px';
			this.imageNode.style.width = w+'px';
			this.imageNode.style.left = (this.size.width-w)/2+'px';
			this.imageNode.style.top = '0';
		}
};
	
	
	Object.defineProperty(PDFImageView.prototype, "cocoaType", {
		value: 'UIView'});
	

	Object.defineProperty(PDFImageView.prototype, "cocoaCustomType", {
		value: 'PDFImageView'});
	
	
	Object.defineProperty(PDFImageView.prototype, "isPlugin", {
		value: true});
	
	
	Object.defineProperty(PDFImageView.prototype, "encodesSubviews", {
		value: false});
	
	
	Object.defineProperty(PDFImageView.prototype, "readableType", {
		get: function () { return LocalizedString('PDF Image View'); }});
	
	
	Object.defineProperty(PDFImageView.prototype, "urlInfo", {
	outlet: true, 
	enumerable: true, 
		get: function () { if (!this._urlInfo) this.urlInfo = {}; return this._urlInfo; }, set:function (v) {if (!Object.hasOwnProperty(this, "_urlInfo")) Object.defineProperty(this, "_urlInfo", { writable: true, configurable: true }); this._urlInfo = v; }});
	

	Object.defineProperty(PDFImageView.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [

							{ keyPath: 'pdfFileID', type: 'fileReference', filter: function (ref) { return ref.isPDF; }, numberOfVisibleItems:7.5, positionLeft: true, showsSelectButton: true },

						
						
					]
				},
		
			];

		}});
	
	
PDFImageView.prototype.loadImage = function PDFImageView__loadImage() {
		if (!this.imageNode) return;
		if (!this.pdfFileID) return;
		
		var img = this.imageNode;
		
		
		
		var ref = _context.projectContext.fileReferenceWithID(this.pdfFileID);
		if (ref) {
			var imageSrc = _context.projectContext.urlForResourceWithID(ref.resourceID);
			
	
			this.context.whenImageIsReady(imageSrc, function (image) {
				this.imageRatio = image.width/image.height;
				img.src = imageSrc;
				this.layoutSubviews();
				this.outlineIconURLDidChange();
			}.bind(this));
		}
		};
	
	
	Object.defineProperty(PDFImageView.prototype, "pdfFileID", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_pdfFileID")) Object.defineProperty(this, "_pdfFileID", { writable: true, configurable: true });
			this._pdfFileID = v;
			this.loadImage();
		}, get:function () { return this._pdfFileID; }});
	

	Object.defineProperty(PDFImageView.prototype, "name", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_name")) Object.defineProperty(this, "_name", { writable: true, configurable: true });
			this._name = v;
			this.readableValueDidChange();
		}, get:function () { return this._name; }});
	


PDFImageView.prototype.transformData = function PDFImageView_transformData(data, transformer) {
	
		transformer.demandPlugin('info.appdoo-mac.FileURLHelper');

		var result = __super.prototype.transformData.call(this, data, transformer);
		
		if (transformer.isXIBGenerator) {
			result.contentMode = 'scaleAspectFit';
			
			var ref = _context.projectContext.fileReferenceWithID(data.pdfFileID);
			if (ref) {
				result.userDefinedRuntimeAttributes = {
					'userDefinedRuntimeAttribute 1': {
						type: "string",
						keyPath: 'pdfName',
						value: ref.name,
					}
				};
			}
		}
		else {
			result.$type = 'PDFImageView';
			result.contentMode = 1;
			var ref = _context.projectContext.fileReferenceWithID(data.pdfFileID);
			if (ref) {
				result.pdfName = transformer.transformString(ref.name);
			}
		}
		
		return result;
};
	

	Object.defineProperty(PDFImageView.prototype, "outlineIconURL", {
		get: function () {
			return this.imageNode.src;
		}});
	


PDFImageView.prototype.fileReferenceDidUpdate = function PDFImageView_fileReferenceDidUpdate(fileReference) {
		if (this.pdfFileID === fileReference.$id) {
			this.loadImage();
		}};
	

PDFImageView.prototype.initPropertiesFromData = function PDFImageView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("urlInfo")) this.urlInfo = data.urlInfo;
if (data.hasOwnProperty("pdfFileID")) this.pdfFileID = data.pdfFileID;
if (data.hasOwnProperty("name")) this.name = data.name;
};

PDFImageView.prototype.decodeData = function PDFImageView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

PDFImageView.prototype.encode = function PDFImageView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

PDFImageView.prototype.encodeCloned = function PDFImageView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

PDFImageView.prototype.expectedTypeForProperty = function PDFImageView_expectedTypeForProperty(key) {
	if (key === "imageNode") return "";
	if (key === "cocoaType") return "";
	if (key === "cocoaCustomType") return "";
	if (key === "isPlugin") return "";
	if (key === "encodesSubviews") return "";
	if (key === "readableType") return "";
	if (key === "urlInfo") return "Object";
	if (key === "inspectorProperties") return "";
	if (key === "pdfFileID") return "String";
	if (key === "name") return "String";
	if (key === "outlineIconURL") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return PDFImageView; }()));