
registerType('info.appdoo-mac', (function () { function RSS2DataSource() {} var __super = setSupertypeFromDomain(RSS2DataSource, 'BasicDataSource', 'appdoo');

	Object.defineProperty(RSS2DataSource.prototype, "readableDescription", {
		get: function () {
			return LocalizedString('Provides data from the RSS 2.0 format');
		}});
	

RSS2DataSource.prototype.init = function RSS2DataSource_init() {
		__super.prototype.init.call(this);
		if (!this.location) this.location = 'remote';
		return this;};
	




RSS2DataSource.prototype.createForContext = function RSS2DataSource_createForContext(context, options) {
		var inst = __super.prototype.createForContext.call(this, context);
		if (options && options.droppedOnView) {
			this.createUITableViewForSuperview(options.droppedOnView, inst);
		}
		return inst;};
	

	Object.defineProperty(RSS2DataSource.prototype, "channelObject", {
	synthesized: true, get:function () { return this._channelObject; }, set:function (v) {if (!Object.hasOwnProperty(this, "_channelObject")) Object.defineProperty(this, "_channelObject", { writable: true, configurable: true }); this._channelObject = v; }});
	

	Object.defineProperty(RSS2DataSource.prototype, "rootData", {
		get: function () {
			var r = {};
			if (!this.channelObject) {
				return r;
			}
			r.item = this.channelObject.item;
			r.title = this.channelObject.title;
			r.description = this.channelObject.description;
			for (var key in this.channelObject) {
				r[key] = this.channelObject[key];
			}
			
			
			delete r.links;
			return r;
		}});
	

	Object.defineProperty(RSS2DataSource.prototype, "providesRootData", {
		value: true});
	

	Object.defineProperty(RSS2DataSource.prototype, "itemArray", {
		get: function () {
			if (this.channelObject) return this.channelObject.item;
		}});
	

	Object.defineProperty(RSS2DataSource.prototype, "itemArrayKeyPath", {
		value: 'item'});
	

	Object.defineProperty(RSS2DataSource.prototype, "data", {
		set: function (data) {

			var contents;

			try {
				var jsonString = this.context.nativeProxy.sendMessage('convertRSS2ToJSON', data);
				this.channelObject = JSON.parse(jsonString);
				contents = this.channelObject;
				if (!this.name) this.e_name = contents.title;
			}
			catch (err) {
				console.warn('The feed JSON could not be parsed.', err);
				contents = [];
			}
			this.lastCheckWasValid = (contents&&(contents.title||contents.link)) || !data;
			
			this.contents = contents;

		}});
	

RSS2DataSource.prototype.determineFirstItemKey = function RSS2DataSource__determineFirstItemKey(item) {
		return 'title';};
	

	Object.defineProperty(RSS2DataSource.prototype, "readableType", {
		get: function () { return LocalizedString('RSS 2.0 Feed'); }});
	

	Object.defineProperty(RSS2DataSource.prototype, "readableValue", {
		get: function () { return this.name || this.readableType; }});
	






	Object.defineProperty(RSS2DataSource.prototype, "iconURL", {
		get: function () {
			return 'Resources/RSS2DataSource48.png';
		}});
	
	
	Object.defineProperty(RSS2DataSource.prototype, "outlineIconURL", {
		get: function () {
			return 'Resources/RSS2DataSource.png';
		}});
	

RSS2DataSource.prototype.nameForKeyPath = function RSS2DataSource_nameForKeyPath(keyPath) {
		if (keyPath === 'contents.link' || keyPath === 'link') return LocalizedString('Link');
		if (keyPath === 'contents.title' || keyPath === 'title') return LocalizedString('Title');
		if (keyPath === 'contents.content' || keyPath === 'content') return LocalizedString('Content');
		if (keyPath === 'contents.description' || keyPath === 'description') return LocalizedString('Description');
		if (keyPath === 'contents.pubDate' || keyPath === 'pubDate') return LocalizedString('Date');
		if (keyPath === 'contents.media:thumbnail' || keyPath === 'media:thumbnail') return LocalizedString('Thumbnail');
		if (keyPath === 'contents.copyright') return LocalizedString('Copyright');
		if (keyPath === 'contents.language') return LocalizedString('Language');
		if (keyPath === 'contents.item') return LocalizedString('Items');
		if (keyPath === 'contents.enclosure' || keyPath === 'enclosure') return TRANSLATE({'de':'Anhang','en':'Enclosure'});
		if (keyPath === 'contents.enclosure.type' || keyPath === 'enclosure.type') return TRANSLATE({'de':'Anhang-Typ','en':'Enclosure Type'});
		if (keyPath === 'contents.enclosure.size' || keyPath === 'enclosure.size') return TRANSLATE({'de':'Anhang-Größe','en':'Enclosure Size'});
		if (keyPath === 'contents.enclosure.url' || keyPath === 'enclosure.url') return LocalizedString('URL');
		return keyPath;};
	


	
	Object.defineProperty(RSS2DataSource.prototype, "URLString", {
		set: function (v) { this.e_URL = v; }, 
		get: function ( ) { return this.e_URL; }});
	

	Object.defineProperty(RSS2DataSource.prototype, "isPlugin", {
		value: true});
	
	
	Object.defineProperty(RSS2DataSource.prototype, "supportsPagination", {
		value: true});
	

RSS2DataSource.prototype.expectedTypeForProperty = function RSS2DataSource_expectedTypeForProperty(key) {
	if (key === "readableDescription") return "";
	if (key === "channelObject") return "";
	if (key === "rootData") return "";
	if (key === "providesRootData") return "";
	if (key === "itemArray") return "";
	if (key === "itemArrayKeyPath") return "";
	if (key === "data") return "";
	if (key === "readableType") return "";
	if (key === "readableValue") return "";
	if (key === "iconURL") return "";
	if (key === "outlineIconURL") return "";
	if (key === "URLString") return "String";
	if (key === "isPlugin") return "";
	if (key === "supportsPagination") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return RSS2DataSource; }()));