
@interface RSS2ChannelImage : NSObject

@property (strong, nonatomic) NSURL * url;
@property (strong, nonatomic) NSString * title;
@property (strong, nonatomic) NSURL * link;

@property (readonly) NSDictionary * dictionaryRepresentation;

@end


@interface RSS2Item : NSObject

@property (strong, nonatomic) NSString * title;
@property (strong, nonatomic) NSString * itemDescription;
@property (strong, nonatomic) NSURL * link;
@property (strong, nonatomic) NSString * author;
@property (strong, nonatomic) NSString * guid;
@property (strong, nonatomic) NSDate * pubDate;
@property (strong, nonatomic) NSString * content;
@property (strong, nonatomic) NSString * media_thumbnail;
@property (strong, nonatomic) NSDictionary * enclosure;

@property (readonly) NSDictionary * dictionaryRepresentation;

@end


@interface RSS2Channel : NSObject

@property (strong, nonatomic) NSString * title;
@property (strong, nonatomic) NSURL * link;
@property (strong, nonatomic) NSString * channelDescription;
@property (strong, nonatomic) NSString * language;
@property (strong, nonatomic) NSString * copyright;
@property (strong, nonatomic) NSDate * pubDate;
@property (strong, nonatomic) RSS2ChannelImage * image;
@property (strong, nonatomic) NSArray * items;
@property (strong, nonatomic) NSArray * links;

@property (readonly) NSDictionary * dictionaryRepresentation;

@end





@interface RSS2Parser : NSObject

@property (nonatomic, strong) NSData * inputData;
@property (readonly) RSS2Channel * channel;
@property (readonly) NSDictionary * channelDictionaryRepresentation;

- (BOOL)parse;

@end
