//
//  SceneInputDataSource.h
//

#import "DataSourceBase.h"
@class SceneInputDataSource;

@protocol ViewControllerWithInputDataSource <NSObject>
- (SceneInputDataSource *)sceneInputDataSource;
@end


@interface SceneInputDataSource : DataSourceBase

@property (strong, nonatomic) NSString * dataString;

@property (nonatomic, strong) id contents;
//@property (nonatomic, copy) NSIndexPath * indexPath;
@property (nonatomic, weak) DataSourceBase * originalDataSource;

- (void)setContents:(id)contents indexPath:(NSIndexPath *)indexPath originalDataSource:(DataSourceBase *)originalDataSource;
- (void)updateContents;

- (void)navigateToPreviousItem;
- (void)navigateToNextItem;
- (void)navigateToItemAtIndex:(NSUInteger)index;
- (BOOL)canNavigateBack;
- (BOOL)canNavigateForward;
- (BOOL)canNavigate;

- (NSArray *)collectedValuesForKeyPath:(NSString *)keyPath;

@end
