//
//  SegmentedControlDataProvider.m
//
//

#import "SegmentedControlDataProvider.h"

@implementation SegmentedControlDataProvider {
	NSDictionary * _contents;
}

- (void)valueDidChange:(UISegmentedControl *)segmentedControl {
	[self updateContents];
	[self notifyObservers];
}

- (void)updateContents {
	NSString * text = @"";
	if (_control.numberOfSegments > _control.selectedSegmentIndex)
		text = [_control titleForSegmentAtIndex:_control.selectedSegmentIndex];
	_contents = @{
				  @"selectedSegmentIndex": [NSNumber numberWithInteger:_control.selectedSegmentIndex],
				  @"selectedSegmentIndex1": [NSNumber numberWithInteger:_control.selectedSegmentIndex + 1],
				  @"selectedSegmentText": text
				  };
}

- (id)contents {
	return _contents;
}

@end

@implementation UISegmentedControl (DataProvider)

- (void)setDataProvider:(SegmentedControlDataProvider *)provider {
	provider.control = self;
	[self addTarget:provider action:@selector(valueDidChange:) forControlEvents:UIControlEventValueChanged];
	[provider updateContents];
}

@end