
registerType('info.appdoo-mac', (function () { function SegmentedNavigationArrows() {} var __super = setSupertypeFromDomain(SegmentedNavigationArrows, 'UIBarButtonItem', 'appdoo.iOS');

	Object.defineProperty(SegmentedNavigationArrows.prototype, "positionIsEditable", {
	configurable: true, 
		value: false});
	

	Object.defineProperty(SegmentedNavigationArrows.prototype, "sizeIsEditable", {
	configurable: true, 
		value: false});
	

	Object.defineProperty(SegmentedNavigationArrows.prototype, "xIsEditable", {
		get: function () { return this.positionIsEditable; }});
	

	Object.defineProperty(SegmentedNavigationArrows.prototype, "yIsEditable", {
		get: function () { return this.positionIsEditable; }});
	

	Object.defineProperty(SegmentedNavigationArrows.prototype, "widthIsEditable", {
		get: function () { return this.sizeIsEditable; }});
	

	Object.defineProperty(SegmentedNavigationArrows.prototype, "heightIsEditable", {
		get: function () { return this.sizeIsEditable; }});
	

SegmentedNavigationArrows.prototype.createForContext = function SegmentedNavigationArrows_createForContext(context) {

		return createComponentFromDomain(
			this.constructor.name,
			this.__domain,
			context,
			{
				
				
				
				
			}
		);
		};
	

	Object.defineProperty(SegmentedNavigationArrows.prototype, "readableDescription", {
		get: function () { return TRANSLATE({'en':'Bar buttons to browse context-sensitive data, e.g. from feeds','de':'Navigationsleisten-Buttons für kontext-abhängige Daten wie Feeds'}); }});
	

	Object.defineProperty(SegmentedNavigationArrows.prototype, "defaultPadding", {
		get: function () {
			var isLandscape = this.context.metadata.simulatedInterfaceOrientation === 'landscape';
			return isLandscape ? 6 : 4;
		}	});
	

	Object.defineProperty(SegmentedNavigationArrows.prototype, "readableType", {
		get: function () {
			return LocalizedString('Navigation Arrows');
		}});
	

	Object.defineProperty(SegmentedNavigationArrows.prototype, "outlineIconURL", {
		value: 'Resources/SegmentedNavigationArrows.png'});
	

	Object.defineProperty(SegmentedNavigationArrows.prototype, "iconURL", {
		value: 'Resources/SegmentedNavigationArrows48.png'});
	
	
	Object.defineProperty(SegmentedNavigationArrows.prototype, "inspectorProperties", {
		value: undefined});
	

	Object.defineProperty(SegmentedNavigationArrows.prototype, "bindableProperties", {
		get: function () {
			var result = [];
			
			return result;
		}});
	
	
SegmentedNavigationArrows.prototype.readableNameForProperty = function SegmentedNavigationArrows_readableNameForProperty(p) {
		switch (p) {
			case 'inputDataIndexPath': return LocalizedString('Index Path');
		}
		return __super.prototype.readableNameForProperty.call(this, p);};
	

SegmentedNavigationArrows.prototype.createView = function SegmentedNavigationArrows__createView() {
		if (this._view) return;
		this.view = createComponentFromDomain("SegmentedNavigationArrowsView", "info.appdoo-mac", this.context, {
			controller: this,
			barButtonItem: this})
		;
		};
	

SegmentedNavigationArrows.prototype.navigateToPreviousItem = function SegmentedNavigationArrows__navigateToPreviousItem() {
		if (this.inputDataSource && this.inputDataSource.navigateUp)
			this.inputDataSource.navigateUp();};
	

SegmentedNavigationArrows.prototype.navigateToNextItem = function SegmentedNavigationArrows__navigateToNextItem() {
		if (this.inputDataSource && this.inputDataSource.navigateUp)
			this.inputDataSource.navigateDown();};
	

	Object.defineProperty(SegmentedNavigationArrows.prototype, "isPlugin", {
		value: true});
	
	



	
	
	Object.defineProperty(SegmentedNavigationArrows.prototype, "inputDataSource", {
		get: function () { if (_context.editor.editedScene) return _context.editor.editedScene.inputDataSource; }});
	

SegmentedNavigationArrows.prototype.transformData = function SegmentedNavigationArrows_transformData(data, transformer) {
		if (transformer.isXIBGenerator) {
			var result = {
				title: '',
				id: transformer.createStoryboardID(),
				customClass: 'SegmentedNavigationArrows',
			};
			
			result.connections = {
				outlet: {
					property:"viewController",
					destination: transformer.currentViewControllerXID,
					id:transformer.createStoryboardID()
				}
			};
			
		transformer.demandPlugin('info.appdoo-mac.DataSourceBase');
		transformer.demandPlugin('info.appdoo-mac.NSStringPunycodeAdditions');
			transformer.addOutletForDataAndId(data, result.id, 'segmentedNavigationArrows');
			transformer.demandPlugin('info.appdoo-mac.SceneInputDataSource');
			transformer.demandPlugin('info.appdoo-mac.SegmentedNavigationArrows');
			







			
				
			return result;
		}
		else {
			var result = {
				$type: this.constructor.name,
				$domain: 'com.apple',
				$id: data.$id,
				$initialMethodCalls: [],
				$needsViewControllerReference: true
			};

			return result;
		}
};
	

SegmentedNavigationArrows.prototype.validate = function SegmentedNavigationArrows__validate() {
		

		var canNavigateUp, canNavigateDown;
		var ipds = this.inputDataSource;
		
		
		if (!ipds) {
			canNavigateUp = false;
			canNavigateDown = false;
		}
		else {
			
			canNavigateUp = ipds.canNavigateUp;
			canNavigateDown = ipds.canNavigateDown;
		}

		this.upArrowDisabled = !canNavigateUp;
		this.downArrowDisabled = !canNavigateDown;
		
		if (this.view) this.view.enableButtons();
		};
	
	
	Object.defineProperty(SegmentedNavigationArrows.prototype, "upArrowDisabled", {
	synthesized: true, get:function () { return this._upArrowDisabled; }, set:function (v) {if (!Object.hasOwnProperty(this, "_upArrowDisabled")) Object.defineProperty(this, "_upArrowDisabled", { writable: true, configurable: true }); this._upArrowDisabled = v; }});
	

	Object.defineProperty(SegmentedNavigationArrows.prototype, "downArrowDisabled", {
	synthesized: true, get:function () { return this._downArrowDisabled; }, set:function (v) {if (!Object.hasOwnProperty(this, "_downArrowDisabled")) Object.defineProperty(this, "_downArrowDisabled", { writable: true, configurable: true }); this._downArrowDisabled = v; }});
	

SegmentedNavigationArrows.prototype.prepareForEditor = function SegmentedNavigationArrows_prepareForEditor(editor) {
		
		
		if (!this.bindings && this.inputDataSource) {
			this.bindings = [{sourceKeyPath:'inputDataIndexPath',destination:this.inputDataSource.identify(),destinationKeyPath:'indexPath'}];
		}
		this.identify();
		
		this.view.prepareForEditor(editor);};
	

	Object.defineProperty(SegmentedNavigationArrows.prototype, "inputDataIndexPath", {
	synthesized: true, get:function () { return this._inputDataIndexPath; }, set:function (v) {if (!Object.hasOwnProperty(this, "_inputDataIndexPath")) Object.defineProperty(this, "_inputDataIndexPath", { writable: true, configurable: true }); this._inputDataIndexPath = v; }});
	

SegmentedNavigationArrows.prototype.expectedTypeForProperty = function SegmentedNavigationArrows_expectedTypeForProperty(key) {
	if (key === "positionIsEditable") return "";
	if (key === "sizeIsEditable") return "";
	if (key === "xIsEditable") return "";
	if (key === "yIsEditable") return "";
	if (key === "widthIsEditable") return "";
	if (key === "heightIsEditable") return "";
	if (key === "readableDescription") return "";
	if (key === "defaultPadding") return "";
	if (key === "readableType") return "";
	if (key === "outlineIconURL") return "";
	if (key === "iconURL") return "";
	if (key === "inspectorProperties") return "";
	if (key === "bindableProperties") return "";
	if (key === "isPlugin") return "";
	if (key === "inputDataSource") return "";
	if (key === "upArrowDisabled") return "";
	if (key === "downArrowDisabled") return "";
	if (key === "inputDataIndexPath") return "NSIndexPath";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SegmentedNavigationArrows; }()));
registerType('info.appdoo-mac', (function () { function SegmentedNavigationArrowsView() {} var __super = setSupertypeFromDomain(SegmentedNavigationArrowsView, 'UIBarButtonItemView', 'appdoo.iOS');

SegmentedNavigationArrowsView.prototype.init = function SegmentedNavigationArrowsView_init() {
		__super.prototype.init.call(this);
		var isBeingDragged = !this.controller;
		this.size = { width: 89, height: !isBeingDragged ? 32:44 };
		if (!isBeingDragged) {
			this.DOMNode.onmousedown = this.onMouseDown.bind(this);
			this.DOMNode.onclick = this.onClick.bind(this);
			this.controller.upArrowDisabled = true;
			this.controller.downArrowDisabled = true;
		}
		else {
			this.createSubviews();
			this.redraw();
		}
		
		this.didInit = true;
		
		return this;};
	
	
SegmentedNavigationArrowsView.prototype.destroy = function SegmentedNavigationArrowsView_destroy() {
		this.DOMNode.onmousedown = null;
		this.DOMNode.onclick = null;};
	
	
SegmentedNavigationArrowsView.prototype.encode = function SegmentedNavigationArrowsView_encode() {
		return {
			$type: this.constructor.name,
			$domain: this.__domain
		};};
	


	Object.defineProperty(SegmentedNavigationArrowsView.prototype, "controller", {
	outlet: true, get:function () { return this._controller; }, set:function (v) {if (!Object.hasOwnProperty(this, "_controller")) Object.defineProperty(this, "_controller", { writable: true, configurable: true }); this._controller = v; }});
	

SegmentedNavigationArrowsView.prototype.layoutSubviews = function SegmentedNavigationArrowsView_layoutSubviews() {
		if (!this.backgroundCanvas) return;
		var w = 89, h = 32;
		var top = (this.size.height/2-h/2)|0;
		this.backgroundCanvas.style.top = top+'px';};
	
	
	
SegmentedNavigationArrowsView.prototype.updateContents = function SegmentedNavigationArrowsView_updateContents() {
		if (!this.didInit) return;
		this.controller.validate();
		
		
		this.destroySubviews();
		this.createSubviews();
		this.redraw();};
	
	
SegmentedNavigationArrowsView.prototype.createSubviews = function SegmentedNavigationArrowsView__createSubviews() {
		
	
		

		var isSystem7 = this.context.simulatedSystemVersion >= 7;
		var top = (!isSystem7 && this.shouldDisplaySlim) ? 4 : 1;
		var scale = this.context.highResolutionEnabled ? 2 : 1;
		
		if (!this.backgroundCanvas) {
			var w = 89, h = 32;
			var top = (this.size.height/2-h/2)|0;
			this.backgroundCanvas = document.createElement('canvas');
			this.backgroundCanvas.width = w*scale;
			this.backgroundCanvas.height = h*scale;
			this.backgroundCanvas.style.position = 'absolute';
			this.backgroundCanvas.style.width = w+'px';
			this.backgroundCanvas.style.height = h+'px';
			this.backgroundCanvas.style.left = '0px';
			this.backgroundCanvas.style.top = top+'px';
			this.DOMNode.appendChild(this.backgroundCanvas);
		}
		
		if (this.context.simulatedSystemVersion >= 7) return;
		
		
		if (!this.background || !this.background.DOMNode) {

			var background = createComponentFromDomain("ImageView", "Core.UI", this.context, {
				size: {
				width: 92,
				height: this.shouldDisplaySlim ? 25 : 31
				},
				position: {
				left: -1,
				top:top
				},
				imageSrc: this.shouldDisplaySlim ? 'Plugins/SegmentedNavigationArrows.cpsplugin/Editor/SegmentedStepperSmall.png' : 'Plugins/SegmentedNavigationArrows.cpsplugin/Editor/SegmentedStepper.png',
				style: { pointerEvents: 'none'}})
			;
			this.addSubview(background);
			this.background = background;
			
			
			var upArrow = createComponentFromDomain("ImageView", "Core.UI", this.context, {
				size: {
				width:20,height:17
				},
				position: { left: 13, top: this.shouldDisplaySlim ? 4+top : 7+top },
				imageSrc: 'Plugins/SegmentedNavigationArrows.cpsplugin/Shared/System6ArrowUp.png',
				style: { pointerEvents: 'none' },
				disabled: this.controller.upArrowDisabled})
			;
			this.addSubview(upArrow);

		
			var downArrow = createComponentFromDomain("ImageView", "Core.UI", this.context, {
				size: {
				width:20,height:17
				},
				position: { left: 57, top: this.shouldDisplaySlim ? 4+top : 7+top },
				imageSrc: 'Plugins/SegmentedNavigationArrows.cpsplugin/Shared/System6ArrowDown.png',
				style: { pointerEvents: 'none'},
				disabled: this.controller.downArrowDisabled})
			;
			this.addSubview(downArrow);

			this.upArrow = upArrow;
			this.downArrow = downArrow;
		
		}
};
	
	
SegmentedNavigationArrowsView.prototype.redraw = function SegmentedNavigationArrowsView__redraw() {

		if (this.context.simulatedSystemVersion >= 7) {
			this.drawArrows();
			this.removeAllSubviewsAndNullifyReferences();
		}
		else {
			this.createSubviews();
			this.drawBackground();
		}};
	
	
SegmentedNavigationArrowsView.prototype.removeAllSubviewsAndNullifyReferences = function SegmentedNavigationArrowsView_removeAllSubviewsAndNullifyReferences() {
		__super.prototype.removeAllSubviews.call(this);
		this.upArrow = null;
		this.downArrow = null;
		this.background = null;};
	
	
	function drawArrow(ctx, scale) {
	
		var divider = scale === 1 ? 2 : 1;

		ctx.beginPath();
		ctx.moveTo(0, 21/divider);
		ctx.lineTo(2.5/divider, 23/divider);
		ctx.lineTo(20.5/divider, 4/divider);
		ctx.lineTo(38.5/divider, 23/divider);
		ctx.lineTo(41/divider, 21/divider);
		ctx.lineTo(20.5/divider, 0/divider);
		ctx.lineTo(0/divider, 21/divider);
		ctx.fill();
	
	}
	
SegmentedNavigationArrowsView.prototype.drawArrows = function SegmentedNavigationArrowsView__drawArrows() {
		if (!this.backgroundCanvas) return;

		var navigationBar = this.superview;
	
		
	
		var scale = this.context.highResolutionEnabled ? 2 : 1;
		var activeTint = navigationBar ? navigationBar.e_tintColor : _context.projectContext.defaultOrSystemTintColor;
		var disabledTint = 'rgba(128,128,128,.3)';
		var ctx = this.backgroundCanvas.getContext("2d");
		ctx.clearRect(0,0,this.size.width*scale, this.size.height*scale);
		
		


		
		ctx.fillStyle = !this.controller || this.controller.upArrowDisabled ? disabledTint : activeTint;
		ctx.save();
		ctx.translate(16*scale,(9+2)*scale);
		drawArrow(ctx, scale);
		ctx.restore();

		
		ctx.fillStyle = !this.controller || this.controller.downArrowDisabled ? disabledTint : activeTint;
		ctx.save();
		ctx.translate((16+50+10+1)*scale,(9+12-0.5+2)*scale);
		ctx.rotate( (Math.PI / 180) * 180);
		drawArrow(ctx, scale);
		ctx.restore();
};
	

SegmentedNavigationArrowsView.prototype.destroySubviews = function SegmentedNavigationArrowsView__destroySubviews() {
		if (!this.backgroundCanvas) return;
		
		this.backgroundCanvas.parentNode.removeChild(this.backgroundCanvas);
		this.backgroundCanvas = null;
		this.removeAllSubviews();};
	

SegmentedNavigationArrowsView.prototype.drawBackground = function SegmentedNavigationArrowsView__drawBackground() {
	
		if (!this.backgroundCanvas) return;
	
		var scale = this.context.highResolutionEnabled ? 2 : 1;
		var ctx = this.backgroundCanvas.getContext("2d");
		
		var navigationBar = this.superview;
		var drawNoBackground = !navigationBar.tintColor;
		
		if (drawNoBackground) {
			ctx.clearRect(0,0,this.backgroundCanvas.width*scale,this.backgroundCanvas.height*scale);
			return;
		}
		
		var maxY = this.shouldDisplaySlim ? 23 : 29;
		
		ctx.save();
		ctx.scale(scale, scale);

		ctx.beginPath();
		ctx.moveTo(44, 0);
		ctx.lineTo(44, maxY);
		ctx.arcTo(0, maxY, 0, maxY-10, 5);
		ctx.arcTo(0, 0, 10, 0, 5);
		ctx.moveTo(44, 0);
		ctx.arcTo(88, 0, 88, 10, 5);
		ctx.arcTo(88, maxY, 79, maxY, 5);
		ctx.lineTo(44, maxY);
		
		if (navigationBar.translucent) {
			var lineargradient = ctx.createLinearGradient(0,0,0,29);
			lineargradient.addColorStop(0,'hsl(0,0%,60%)');
			lineargradient.addColorStop(0.49,'hsl(0,0%,22%)');
			lineargradient.addColorStop(0.5,'hsl(0,0%,0%)');
			lineargradient.addColorStop(1,'hsl(0,0%,0%)');
			ctx.fillStyle = lineargradient;
		} else {
			
			var tintColor = navigationBar.tintColor,
				color1, color2;
			
			
			
			var hsv = cssRgbToHsv(tintColor),
				hue = hsv[0], saturation = hsv[1], brightness = hsv[2];
	
			color1 = rgbToCss(hsvToRgb(hue, changeSaturation(saturation, 0.24, brightness), changeLightness(brightness, 0.43)));
			color2 = rgbToCss(hsvToRgb(hue, changeSaturation(saturation, 1.6, brightness), changeLightness(brightness, -0.35, false)));
	
			var lineargradient = ctx.createLinearGradient(0,0,0,29);
			lineargradient.addColorStop(0,color1);
			lineargradient.addColorStop(1,color2);
			ctx.fillStyle = lineargradient;
		}

		ctx.fill();
		ctx.restore();
};
	
	
SegmentedNavigationArrowsView.prototype.getClickedSegmentFromEvent = function SegmentedNavigationArrowsView__getClickedSegmentFromEvent(e) {
		return parseInt((e.offsetX/this.size.width)*2);};
	
	
SegmentedNavigationArrowsView.prototype.onMouseDown = function SegmentedNavigationArrowsView__onMouseDown(e) {
	return;
		
		
		
	
		var segmentClicked = this.getClickedSegmentFromEvent(e);
		
		
		if (segmentClicked === 0 && this.controller.upArrowDisabled) return;
		if (segmentClicked === 1 && this.controller.downArrowDisabled) return;
		
		this.lastMouseDownOnSegment = segmentClicked;
		
		if (this.context.simulatedSystemVersion >= 7)	this.onMouseDownSystem7(segmentClicked);
		else											this.onMouseDownSystem6(segmentClicked);
	};
	

SegmentedNavigationArrowsView.prototype.onMouseDownSystem7 = function SegmentedNavigationArrowsView__onMouseDownSystem7(segmentClicked) {
	};
	
	
SegmentedNavigationArrowsView.prototype.onMouseDownSystem6 = function SegmentedNavigationArrowsView__onMouseDownSystem6(segmentClicked) {

		var offsetY = this.shouldDisplaySlim ? 4 : 1;
		var maxY = this.shouldDisplaySlim ? 23 : 29,
			borderRadius = this.shouldDisplaySlim ? 3 : 5;

		var hotspotCanvas = document.createElement('canvas');
		hotspotCanvas.width = 89;
		hotspotCanvas.height = maxY;
		hotspotCanvas.style.position = 'absolute';
		hotspotCanvas.style.left = '1px';
		hotspotCanvas.style.top = offsetY+'px';
		hotspotCanvas.style.pointerEvents = 'none';
		this.DOMNode.insertBefore(hotspotCanvas, this.background.DOMNode);
		var ctx = hotspotCanvas.getContext('2d');
		
		
		
		if (segmentClicked === 0) {
			ctx.beginPath();
			ctx.moveTo(44, 0);
			ctx.lineTo(44, maxY);
			ctx.arcTo(0, maxY, 0, maxY-10, borderRadius);
			ctx.arcTo(0, 0, 10, 0, borderRadius);
		}
		else if (segmentClicked === 1) {
			ctx.beginPath();
			ctx.moveTo(44, 0);
			ctx.arcTo(88, 0, 88, 10, borderRadius);
			ctx.arcTo(88, maxY, 79, maxY, borderRadius);
			ctx.lineTo(44, maxY);
		}
		
		var lineargradient = ctx.createLinearGradient(0,0,0,29);
		if (navigationBar.translucent) {
			lineargradient.addColorStop(0,'rgba(255,255,255,.2)');
			lineargradient.addColorStop(1,'rgba(255,255,255,.2)');
		}
		else {
			lineargradient.addColorStop(0,'rgba(0,0,0,.1)');
			lineargradient.addColorStop(1,'rgba(0,0,0,.2)');
		}
		
		ctx.fillStyle = lineargradient;
	
		
		ctx.fill();

		

		window.addEventListener('mouseup', function onMouseUp(e) {
		
			if (hotspotCanvas.parentNode === this.DOMNode)
				this.DOMNode.removeChild(hotspotCanvas);
			
			window.removeEventListener('mouseup', arguments.callee);
		}.bind(this));
	};
	
	
SegmentedNavigationArrowsView.prototype.onClick = function SegmentedNavigationArrowsView__onClick(e) {

		e.preventDefault();
		e.stopPropagation();

		var segmentClicked = this.getClickedSegmentFromEvent(e);

		
		
		
		
		if (segmentClicked === 0) {
			this.controller.navigateToPreviousItem();
		}
		else if (segmentClicked === 1) {
			this.controller.navigateToNextItem();
		}

		this.controller.validate();};
	
	
	







	
	
SegmentedNavigationArrowsView.prototype.enableButtons = function SegmentedNavigationArrowsView_enableButtons() {

		if (this.upArrow) {
			this.upArrow.disabled = this.controller.upArrowDisabled;
			this.upArrow.style({pointerEvents:'none'});
		}
		if (this.downArrow) {
			this.downArrow.disabled = this.controller.downArrowDisabled;
			this.downArrow.style({pointerEvents:'none'});
		}
		
		if (!this.upArrow) this.drawArrows();
	};
	

SegmentedNavigationArrowsView.prototype.superviewDidChangeTintColor = function SegmentedNavigationArrowsView_superviewDidChangeTintColor() {
		this.redraw();};
	
	
SegmentedNavigationArrowsView.prototype.initPropertiesFromData = function SegmentedNavigationArrowsView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("controller")) this.controller = data.controller;
};

SegmentedNavigationArrowsView.prototype.decodeData = function SegmentedNavigationArrowsView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

SegmentedNavigationArrowsView.prototype.encodeCloned = function SegmentedNavigationArrowsView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

SegmentedNavigationArrowsView.prototype.expectedTypeForProperty = function SegmentedNavigationArrowsView_expectedTypeForProperty(key) {
	if (key === "controller") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SegmentedNavigationArrowsView; }()));