//
//  SegmentedNavigationArrows.m
//
//

#import "SegmentedNavigationArrows.h"


#define SYSTEM_VERSION_LESS_THAN(v)                 ([[[UIDevice currentDevice] systemVersion] compare:v options:NSNumericSearch] == NSOrderedAscending)

@protocol ViewControllerWithInputDataSource <NSObject>
- (id)sceneInputDataSource;
@end

@interface SegmentedArrowsControl : UISegmentedControl
@end

@implementation SegmentedArrowsControl

- (void)setFrame:(CGRect)frame {

	// iOS 7.0 bug: sets the height to 0 on rotation.
	if (frame.size.width && frame.size.height == 0) {
		frame.size.height = self.frame.size.height;
	}
	
	[super setFrame:frame];

}
@end


@implementation SegmentedNavigationArrows {
}

- (void)awakeFromNib {
	[super awakeFromNib];
	self.customView.backgroundColor = [UIColor clearColor];
	
	UISegmentedControl * segmentedControl;
	NSString * leftImageName, * rightImageName;
	int width;//, height;
	
	
	segmentedControl = [[SegmentedArrowsControl alloc] initWithFrame: CGRectZero];
#if  __IPHONE_OS_VERSION_MIN_REQUIRED < __IPHONE_7_0
	segmentedControl.segmentedControlStyle = UISegmentedControlStyleBar;
#endif
	segmentedControl.autoresizingMask = 0;
	
	
	if (SYSTEM_VERSION_LESS_THAN(@"7.0") == NO) {
		[segmentedControl setBackgroundImage:[UIImage new] forState:UIControlStateNormal barMetrics:UIBarMetricsDefault];
		[segmentedControl setDividerImage:[UIImage new] forLeftSegmentState:UIControlStateNormal rightSegmentState:UIControlStateNormal barMetrics:UIBarMetricsDefault];
		leftImageName = @"System7ArrowUp";
		rightImageName = @"System7ArrowDown";
		width = 81;
	}
	else {
		leftImageName = @"System6ArrowUp";
		rightImageName = @"System6ArrowDown";
		width = 89;
	}
	
	
	segmentedControl.momentary = YES;
	[segmentedControl insertSegmentWithImage:[UIImage imageNamed:leftImageName] atIndex:0 animated:NO];
	[segmentedControl insertSegmentWithImage:[UIImage imageNamed:rightImageName] atIndex:1 animated:NO];
	[segmentedControl sizeToFit];
	[segmentedControl addTarget:self action:@selector(segementedControlDidFire:) forControlEvents:UIControlEventValueChanged];
	
	self.customView = segmentedControl;
	self.segmentedControl = segmentedControl;
	
	CGFloat height = segmentedControl.bounds.size.height;
	if (!height) height = 36;
	[segmentedControl setFrame:CGRectMake(0, 2, width, height)];
	
}

- (void)segementedControlDidFire:(id)sender {
    switch ([sender selectedSegmentIndex]) {
		case 0: {
			[self navigateToPreviousItem];
			break;
		}
		case 1: {
			[self navigateToNextItem];
			break;
		}
	}
	if ([self.viewController.view isKindOfClass:[UIScrollView class]]) {
		[((UIScrollView *)self.viewController.view) setContentOffset:CGPointZero animated:NO];
	}
	[self validate];
}

- (void)navigateToPreviousItem {
	[_inputDataSource navigateToPreviousItem];
}

- (void)navigateToNextItem {
	[_inputDataSource navigateToNextItem];
}

- (void)validate {
	
	BOOL canNavigate = [[_inputDataSource valueForKey:@"canNavigate"] boolValue];
	_segmentedControl.hidden = !canNavigate;
	
	BOOL canNavigateBack = [[_inputDataSource valueForKey:@"canNavigateBack"] boolValue];
	BOOL canNavigateForward = [[_inputDataSource valueForKey:@"canNavigateForward"] boolValue];

	[_segmentedControl setEnabled:canNavigateBack forSegmentAtIndex:0];
	[_segmentedControl setEnabled:canNavigateForward forSegmentAtIndex:1];
}


- (void)setViewController:(UIViewController *)viewController {
	_viewController = viewController;
	
	[[NSOperationQueue mainQueue] addOperationWithBlock:^{
		if (_viewController.navigationItem.rightBarButtonItem == self) {
			if (SYSTEM_VERSION_LESS_THAN(@"7.0") == NO) {
				NSMutableArray * items = _viewController.navigationItem.rightBarButtonItems.mutableCopy;
				UIBarButtonItem * spaceFix = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemFixedSpace target:nil action:NULL];
				spaceFix.width = -11;
				[items insertObject:spaceFix atIndex:0];
				_viewController.navigationItem.rightBarButtonItems = items;
			}
		}
		[self readProperties];
	}];

}

- (void)readProperties {
	
	if ([_viewController respondsToSelector:@selector(sceneInputDataSource)]) {
		_inputDataSource = [_viewController performSelector:@selector(sceneInputDataSource)];
	}
	
	
	[self validate];
	
}

- (void)setInputDataIndexPath:(NSIndexPath *)inputDataIndexPath {
	[self validate];
}

- (NSIndexPath *)inputDataIndexPath {
	return [_inputDataSource valueForKey:@"indexPath"];
}

@end
