
registerType('info.appdoo-mac', (function () { function SimpleAnimation() {} var __super = setSupertypeFromDomain(SimpleAnimation, 'BasicEditableObject', 'appdoo');

SimpleAnimation.prototype.createForContext = function SimpleAnimation_createForContext(context) {
	
		var view = _context.editor.editedView.subviews[0];
		return createComponentFromDomain(
			this.constructor.name,
			this.__domain,
			context,
			{
				animationTimingFunction: 'ease-in-out',
				viewID: view ? view.identify() : undefined,
				animationValues: { opacity: 0, scaleX: 100, scaleY: 100 },
				remainInFinalState: true,
				repeatCount: 0,
				currentRepeatCount: 0,
				animationDuration: -1
			}
		);
		};
	

	Object.defineProperty(SimpleAnimation.prototype, "readableType", {
		get: function () {
			return LocalizedString('Animation');
		}});
	

	Object.defineProperty(SimpleAnimation.prototype, "readableDescription", {
		get: function () {
			return LocalizedString('Prepares an animation');
		}});
	
	
	Object.defineProperty(SimpleAnimation.prototype, "outlineIconURL", {
		get: function () { return 'Resources/SimpleAnimation.png'; }});
	

	Object.defineProperty(SimpleAnimation.prototype, "iconURL", {
		get: function () { return 'Resources/SimpleAnimation48.png'; }});
	

	var defaultDurationMsec = 300;
	
SimpleAnimation.prototype.init = function SimpleAnimation_init() {
		__super.prototype.init.call(this);
		
		return this;};
	
	
	
	Object.defineProperty(SimpleAnimation.prototype, "animationKeyPaths", {
	outlet: true, 
	enumerable: true, 
		get: function () { if (!this._animationKeyPaths) this.animationKeyPaths = {}; return this._animationKeyPaths; }, set:function (v) {if (!Object.hasOwnProperty(this, "_animationKeyPaths")) Object.defineProperty(this, "_animationKeyPaths", { writable: true, configurable: true }); this._animationKeyPaths = v; }});
	

	Object.defineProperty(SimpleAnimation.prototype, "animationValues", {
	outlet: true, 
	enumerable: true, 
		get: function () { if (!this._animationValues) this.animationValues = {}; return this._animationValues; }, set:function (v) {if (!Object.hasOwnProperty(this, "_animationValues")) Object.defineProperty(this, "_animationValues", { writable: true, configurable: true }); this._animationValues = v; }});
	

	Object.defineProperty(SimpleAnimation.prototype, "$animationProgress1000", {
		set: function (v) {
			if (isNaN(v)) v = 0;
			
			this.setAnimationProgress(v/1000);
		}, 
		get: function () {
			return this.currentAnimationProgress*1000;
		}});
	
	
	function getScaleXFromCSSTransform(str) {
		return 1;
	}

	function getScaleYFromCSSTransform(str) {
		return 1;
	}
	
	function getRotationFromCSSTransform(str) {
		return 0;
	}
	
	function weigthedMultiplier(m, msec, timingFunction) {
		if (!timingFunction) return m;

		
		
		
		if (timingFunction === 'ease-in') return Bezier.easeIn(m, msec);
		if (timingFunction === 'ease-out') return Bezier.easeOut(m, msec);
		if (timingFunction === 'ease-in-out') return Bezier.easeInOut(m, msec);
		if (timingFunction === 'linear') return m;
		return 0;
	}
	
SimpleAnimation.prototype.setAnimationProgress = function SimpleAnimation__setAnimationProgress(p) {
	
		var view = this.view;
		if (!view) return;
		if (!this.viewState) return;

		_context.undoManager.disableRegistration();

		if (p < 0) p = 0;
		if (p > 1) p = 1;
		if (p > 0.99) p = 1;
		if (p < 0.01) p = 0;
		
		this.currentAnimationProgress = p;
		var multiplier = p;
		if (this.isCurrentlyRepeating) multiplier = 1-multiplier;
		multiplier = weigthedMultiplier(multiplier, this.animationDurationMsec, this.animationTimingFunction);
		if (this.isReverse) multiplier = 1-multiplier;
		

		

		if (this.animationKeyPaths.position) {
			var dx = (this.animationValues.x||0)-this.viewState.position.left,
				dy = (this.animationValues.y||0)-this.viewState.position.top;

			view.position = {
				left:	this.viewState.position.left+dx*multiplier,
				top:	this.viewState.position.top+dy*multiplier
			};

			
			
		}

		if (this.animationKeyPaths.size) {
			var dw = (this.animationValues.width||0)-this.viewState.size.width,
				dh = (this.animationValues.height||0)-this.viewState.size.height;
				
			if (view.sizeIsEditable) {
				if (view.widthIsEditable) {
					view.size.width = (this.viewState.size.width+dw*multiplier)||0;
					
				}
				if (view.heightIsEditable) {
					view.size.height = (this.viewState.size.height+dh*multiplier)||0;
					
				}
			}

			



		}

		if (this.animationKeyPaths.opacity) {

			var a = this.viewState.alpha; if (a === undefined) a = 1;

			var d = (this.animationValues.opacity||0)-a*100;

			view.alpha = ((a*100)+d*multiplier)/100;
			

			



		}

		if (this.animationKeyPaths.transform) {
			var sxBefore = getScaleXFromCSSTransform(this.viewState.transform);
			var syBefore = getScaleYFromCSSTransform(this.viewState.transform);
			var rBefore = getRotationFromCSSTransform(this.viewState.transform);
			var dsx = (this.animationValues.scaleX||0)/100-sxBefore;
			var dsy = (this.animationValues.scaleY||0)/100-syBefore;
			var dr = (this.animationValues.rotate||0)-rBefore;

			
			view.transform = 'scaleX('+(sxBefore+dsx*multiplier)+') scaleY('+(syBefore+dsy*multiplier)+') rotate('+(rBefore+dr*multiplier)+'deg)';
			

			



		}


		_context.undoManager.enableRegistration();};
	
	
	Object.defineProperty(SimpleAnimation.prototype, "isPlaying", {
	synthesized: true, get:function () { return this._isPlaying; }, set:function (v) {if (!Object.hasOwnProperty(this, "_isPlaying")) Object.defineProperty(this, "_isPlaying", { writable: true, configurable: true }); this._isPlaying = v; }});
	
	
	Object.defineProperty(SimpleAnimation.prototype, "timer", {
	synthesized: true, get:function () { return this._timer; }, set:function (v) {if (!Object.hasOwnProperty(this, "_timer")) Object.defineProperty(this, "_timer", { writable: true, configurable: true }); this._timer = v; }});
	
	
	Object.defineProperty(SimpleAnimation.prototype, "isCurrentlyRepeating", {
	synthesized: true, get:function () { return this._isCurrentlyRepeating; }, set:function (v) {if (!Object.hasOwnProperty(this, "_isCurrentlyRepeating")) Object.defineProperty(this, "_isCurrentlyRepeating", { writable: true, configurable: true }); this._isCurrentlyRepeating = v; }});
	
		
SimpleAnimation.prototype.play = function SimpleAnimation__play(sender) {
		var view = this.view;
		if (!view) return;
		if (this.isPlaying) return;
		
		var progress = this.currentAnimationProgress||0;

		var duration = (this.animationDurationMsec||defaultDurationMsec);
		this.animationDurationMsec = duration;
		
		var intervalDuration = 25;
		var stepPerSec = 1000/intervalDuration; 
		var step = (1/stepPerSec)*(1000/duration);
		

		var interval = setInterval(function () {
			if (!this.isPlaying) { clearInterval(interval); return; }
			progress += step;
			this.setAnimationProgress(progress);
			if (progress >= 1 || !this.isPlaying) clearInterval(interval);
			if (progress >= 1) {
				
				if (!this.isPlaying) return;
				
				
				
				if (!this.remainInFinalState || !this.isSelected)
					this.setAnimationProgress(this.isReverse ? 1 : 0);
				this.stop(sender);
				
				this.timer = null;
				
				if (this.animationRepeats) {
					if(this.repeatCount > 0) {
						this.currentRepeatCount += 1;
					}
					if(this.repeatCount > 0 && this.currentRepeatCount == this.repeatCount) {
						this.isCurrentlyRepeating = false;
						this.currentRepeatCount = 0;
					}
					else if (this.isSelected) {
						if (this.animationRepeatsInReverse)
							this.isCurrentlyRepeating = !this.isCurrentlyRepeating;
						this.simulateAction('play',sender);
					}
					else {
						this.isCurrentlyRepeating = false;
						this.currentRepeatCount = 0;
					}
				}
			}
			
		}.bind(this), intervalDuration);
		this.timer = interval;
		

		
















		
		
		this.isPlaying = true;
		if (sender) sender.text = '◼︎';
























		};
	
	
SimpleAnimation.prototype.stop = function SimpleAnimation__stop(sender) {
		this.isPlaying = false;
		if (sender) sender.text = '▶︎';
		if (!this.isSelected) this.viewState = null;
		clearInterval(this.timer);};
	
	
	Object.defineProperty(SimpleAnimation.prototype, "viewState", {
	synthesized: true, get:function () { return this._viewState; }, set:function (v) {if (!Object.hasOwnProperty(this, "_viewState")) Object.defineProperty(this, "_viewState", { writable: true, configurable: true }); this._viewState = v; }});
	
	
SimpleAnimation.prototype.saveState = function SimpleAnimation__saveState() {
		
		if (this.view && !this.view._isDestroyed && this.view.encode) this.viewState = this.view.encode();};
	

SimpleAnimation.prototype.restoreState = function SimpleAnimation__restoreState() {
		
		if (!this.viewState || !this.view) return;
		this.view.position = this.viewState.position;
		this.view.size = this.viewState.size;
		this.view.alpha = this.viewState.alpha;
		this.view.transform = this.viewState.transform;
		
		};
	
	
SimpleAnimation.prototype.unselectForEditor = function SimpleAnimation_unselectForEditor(editor) {
		
		
		
		if (editor.isSaving) return;
		this.simulateAction('stop');
		
		this.disableState();
		this.viewState = null;};
	

SimpleAnimation.prototype.selectForEditor = function SimpleAnimation_selectForEditor(editor) {
		if (editor.isSaving) return;
		if (this.view && this.view._isDestroyed) this.view = null;
		
		if (!this.isPlaying) {
			this.saveState();
			this.setAnimationProgress(this.currentAnimationProgress);
		}};
	

	
	Object.defineProperty(SimpleAnimation.prototype, "viewID", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_viewID")) Object.defineProperty(this, "_viewID", { writable: true, configurable: true });
			this._viewID = v;
			this.view = null;
				this.saveState();
		}, get:function () { return this._viewID; }});
	
	
	Object.defineProperty(SimpleAnimation.prototype, "view", {
	synthesized: true, 
		get: function () {
			if (!this._view) {
				this.view = this.context.connectableObjects[this.viewID];
				
				
			}
			return this._view;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_view")) Object.defineProperty(this, "_view", { writable: true, configurable: true }); this._view = v; }});
	
	
SimpleAnimation.prototype.action = function SimpleAnimation_action() {
		this.currentRepeatCount = 0;
		this.simulateAction('play');};
	

	Object.defineProperty(SimpleAnimation.prototype, "animationStartsImmediately", {
	outlet: true, 
	enumerable: true, get:function () { return this._animationStartsImmediately; }, set:function (v) {if (!Object.hasOwnProperty(this, "_animationStartsImmediately")) Object.defineProperty(this, "_animationStartsImmediately", { writable: true, configurable: true }); this._animationStartsImmediately = v; }});
	

	Object.defineProperty(SimpleAnimation.prototype, "animationRepeats", {
	outlet: true, 
	enumerable: true, get:function () { return this._animationRepeats; }, set:function (v) {if (!Object.hasOwnProperty(this, "_animationRepeats")) Object.defineProperty(this, "_animationRepeats", { writable: true, configurable: true }); this._animationRepeats = v; }});
	

	Object.defineProperty(SimpleAnimation.prototype, "animationRepeatsInReverse", {
	outlet: true, 
	enumerable: true, get:function () { return this._animationRepeatsInReverse; }, set:function (v) {if (!Object.hasOwnProperty(this, "_animationRepeatsInReverse")) Object.defineProperty(this, "_animationRepeatsInReverse", { writable: true, configurable: true }); this._animationRepeatsInReverse = v; }});
	

	Object.defineProperty(SimpleAnimation.prototype, "isReverse", {
	outlet: true, 
	enumerable: true, get:function () { return this._isReverse; }, set:function (v) {if (!Object.hasOwnProperty(this, "_isReverse")) Object.defineProperty(this, "_isReverse", { writable: true, configurable: true }); this._isReverse = v; }});
	

	Object.defineProperty(SimpleAnimation.prototype, "animationDurationMsec", {
	outlet: true, 
	enumerable: true, get:function () { return this._animationDurationMsec; }, set:function (v) {if (!Object.hasOwnProperty(this, "_animationDurationMsec")) Object.defineProperty(this, "_animationDurationMsec", { writable: true, configurable: true }); this._animationDurationMsec = v; }});
	

	Object.defineProperty(SimpleAnimation.prototype, "animationDuration", {
		get: function () {
			if(typeof(this.animationDurationMsec) == "undefined" || this.animationDurationMsec < 0) {
				return (defaultDurationMsec/1000);
			} else {
				return (this.animationDurationMsec/1000);
			}
		}, 
		set: function (v) {
			if(v < 0) {
				this.animationDurationMsec = defaultDurationMsec;
			} else {
				this.animationDurationMsec = (v*1000);
			}
			
		}});
	

	Object.defineProperty(SimpleAnimation.prototype, "animationTimingFunction", {
	outlet: true, 
	enumerable: true, get:function () { return this._animationTimingFunction; }, set:function (v) {if (!Object.hasOwnProperty(this, "_animationTimingFunction")) Object.defineProperty(this, "_animationTimingFunction", { writable: true, configurable: true }); this._animationTimingFunction = v; }});
	
	
	Object.defineProperty(SimpleAnimation.prototype, "remainInFinalState", {
	outlet: true, 
	enumerable: true, get:function () { return this._remainInFinalState; }, set:function (v) {if (!Object.hasOwnProperty(this, "_remainInFinalState")) Object.defineProperty(this, "_remainInFinalState", { writable: true, configurable: true }); this._remainInFinalState = v; }});
	
	
	Object.defineProperty(SimpleAnimation.prototype, "repeatCount", {
	outlet: true, 
	enumerable: true, get:function () { return this._repeatCount; }, set:function (v) {if (!Object.hasOwnProperty(this, "_repeatCount")) Object.defineProperty(this, "_repeatCount", { writable: true, configurable: true }); this._repeatCount = v; }});
	

	Object.defineProperty(SimpleAnimation.prototype, "currentRepeatCount", {
	outlet: true, 
	enumerable: true, get:function () { return this._currentRepeatCount; }, set:function (v) {if (!Object.hasOwnProperty(this, "_currentRepeatCount")) Object.defineProperty(this, "_currentRepeatCount", { writable: true, configurable: true }); this._currentRepeatCount = v; }});
	

	Object.defineProperty(SimpleAnimation.prototype, "inspectorProperties", {
		get: function () {
			var ref = this;
			return [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name+'General',
					items: [
						{ name: LocalizedString('Name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
						
						{ type: 'space' },
						{ type: 'range', keyPath: '$animationProgress1000', range: [0,1000], positionLeft: true, sliderOnly: true, marginRight: 50, undefinedValue: 0, notUndoable: true },
						{ type: 'button', caption: this.isPlaying ? '◼︎' : '▶︎', buttonWidth: 40, buttonStyle: 'flat', positionLeft: 0, align: 'right',
							
						
							action: function () {
								if (ref.isPlaying) {
									
									ref.simulateAction('stop', this);
								}
								else {
									ref.currentRepeatCount = 0;
									ref.simulateAction('play', this);
								}
							},
							offsetY: -32,
							noLinebreak: true
						},
						

						{ type: 'space' },
						{ type: 'view', keyPath: 'viewID', name: LocalizedString('Object'), canChooseNothing: true },
						{ type: 'space' },
					]
				},
				{
					type: 'group',
					title: LocalizedString('Options'),
					id: this.constructor.name+'Options',
					items: [


						{ type: 'number', keyPath: 'animationDuration', name: LocalizedString('Duration'), undefinedValue: 0.0, onlyPositive: true, suffix: LocalizedString('sec.'), step: 0.1 },

						
						{ type: 'select', keyPath: "animationTimingFunction", name: 'Timing', options:[
							['ease-in-out',LocalizedString('Ease In and Out')],
							['ease-in',LocalizedString('Ease In')],
							['ease-out',LocalizedString('Ease Out')],
							['linear',LocalizedString('Linear')],
						]},
						
						{ type:"boolean", name:LocalizedString("Play Immediately"), keyPath: "animationStartsImmediately", positionLeft:true},
						{ type:"boolean", keyPath: "isReverse",  name:LocalizedString("Reverse playback"), positionLeft:true},
						
						
						{ type:"boolean", keyPath: "animationRepeats",  name:LocalizedString("Repeat"), positionLeft:true, conditionalProperties: [
							{ type:"number", keyPath: "repeatCount",  name: '', dataKeyPath: 'repeatCount', positionLeft:true, suffix:LocalizedString("times"), zeroIsInfinite: true, onlyPositive: true, width: 90, offsetY: -22, noLinebreak: true },
							{ type:"boolean", keyPath: "animationRepeatsInReverse",  name:LocalizedString("Repeat backwards"), positionLeft:true, offsetX: 20, offsetY: 0 },
						] },
						{ type:"boolean", keyPath: "remainInFinalState",  name:LocalizedString("Remain in Final State"), positionLeft:true },
						{ type: 'space' },
						
						
						
					]
				},
				{
					type: 'group',
					title: LocalizedString('Values'),
					id: this.constructor.name+'Values',
					items: [

						
						{ type: 'boolean', keyPath: 'animationKeyPaths.position', name: LocalizedString1('Animate %1', LocalizedString('Position')), positionLeft:true, conditionalProperties: [
							{type:'space'},
							{ type: 'number', keyPath: 'animationValues.x', name: 'X' },
							{ type: 'number', keyPath: 'animationValues.y', name: 'Y' },
						] },

						
						
							
							
						

						

						{ type: 'boolean', keyPath: 'animationKeyPaths.opacity', name: LocalizedString1('Animate %1', LocalizedString('Opacity')), positionLeft:true, conditionalProperties: [
							{type:'space'},
							{ type: 'range', keyPath: 'animationValues.opacity', range: [0,100], name: LocalizedString('Opacity'), undefinedValue: 0 },
						] },

						{ type: 'boolean', keyPath: 'animationKeyPaths.transform', name: LocalizedString('Scale')+'/'+LocalizedString('Rotate'), positionLeft:true, conditionalProperties: [
							{type:'space'},
							{ type: 'range', keyPath: 'animationValues.scaleX', range: [1,1000], name: '% '+LocalizedString('Width'), undefinedValue: 0 },
							{ type: 'range', keyPath: 'animationValues.scaleY', range: [1,1000], name: '% '+LocalizedString('Height'), undefinedValue: 0 },
							{ type: 'range', keyPath: 'animationValues.rotate', range: [-180,180], name: LocalizedString('Rotation'), undefinedValue: 0 },
						] },
						

































						
					]
				},









			];
		}});
	
	
SimpleAnimation.prototype.prepareForEditor = function SimpleAnimation_prepareForEditor(editor) {
		editor.registerStateModifier(this);
		};
	
	
SimpleAnimation.prototype.unprepareForEditor = function SimpleAnimation_unprepareForEditor(editor) {
		editor.unregisterStateModifier(this);
		this.view = null;
		this.viewState = null;
		this.stop();};
	
	
	Object.defineProperty(SimpleAnimation.prototype, "currentAnimationProgress", {
	outlet: true, 
	enumerable: true, get:function () { return this._currentAnimationProgress; }, set:function (v) {if (!Object.hasOwnProperty(this, "_currentAnimationProgress")) Object.defineProperty(this, "_currentAnimationProgress", { writable: true, configurable: true }); this._currentAnimationProgress = v; }});
	
	
SimpleAnimation.prototype.disableState = function SimpleAnimation_disableState() {
		
		this.restoreState();};
	
	
SimpleAnimation.prototype.enableState = function SimpleAnimation_enableState() {
		
		
		
			this.setAnimationProgress(this.currentAnimationProgress || 0);
		};
	
	
	Object.defineProperty(SimpleAnimation.prototype, "performableActions", {
		get: function () {
			return {
				'start': { name: LocalizedString('play') },
				
			};
		}});
	
	
SimpleAnimation.prototype.simulateAction = function SimpleAnimation_simulateAction(id, sender) {
		if (id === 'play' || id === 'start') { if (this.isPlaying) return; if (!this.isSelected) this.saveState(); this.setAnimationProgress(0); this.play(sender);  }
		if (id === 'stop') { this.setAnimationProgress(this.isReverse ? 1 : 0); this.stop(sender); this.isCurrentlyRepeating = false; }};
	
	
	Object.defineProperty(SimpleAnimation.prototype, "isSelected", {
		get: function () {
			return _context.editor.selection.items.indexOf(this) !== -1;
		}});
	

	Object.defineProperty(SimpleAnimation.prototype, "canPlay", {
		value: true});
	
	
SimpleAnimation.prototype.transformData = function SimpleAnimation_transformData(data, transformer) {

		transformer.demandPlugin('info.appdoo-mac.SimpleAnimation');
			
		var result = transformer.createObject(data);

		transformer.setReferenceProperty(result, 'view', data.$id, data.viewID);
		
		['animationTimingFunction'].every(function (key) {
			transformer.setStringProperty(result, key, data[key]);return true; }, this);
		

		['animationDurationMsec', 'repeatCount'].every(function (key) {
			transformer.setFloatProperty(result, key, data[key]);return true; }, this);
		

		transformer.setIntegerProperty(result, 'repeatCount', data.repeatCount);

		['animationStartsImmediately', 'animationRepeats', 'isReverse', 'animationRepeatsInReverse', 'remainInFinalState'].every(function (key) {
			transformer.setBooleanProperty(result, key, data[key]);return true; }, this);
		
		
		transformer.setStringProperty(result, 'animationKeyPathsJSON', JSON.stringify(data.animationKeyPaths));
		transformer.setStringProperty(result, 'animationValuesJSON', JSON.stringify(data.animationValues));

		if (transformer.productGenerator) {
			transformer.productGenerator.addViewControllerImplementationCode(transformer.currentViewControllerId, 'viewWillAppear:', ['	[self.'+transformer.productGenerator.outletNameForProjectID[data.$id]+' viewWillAppear:animated];']);
		}

		return result;
		};
	


































 




var Bezier = (function(){
	'use strict';
 




	
	var DEFAULT_DURATION = 400;
 




	
	var solveEpsilon = function(duration) {
		return 1.0 / (200.0 * duration);
	};
 







	
	var unitBezier = function(p1x, p1y, p2x, p2y) {
	
		
 
		
 




		
		var cx = 3.0 * p1x;
 




		
		var bx = 3.0 * (p2x - p1x) - cx;
 




		
		var ax = 1.0 - cx -bx;
 




		
		var cy = 3.0 * p1y;
 




		
		var by = 3.0 * (p2y - p1y) - cy;
 




		
		var ay = 1.0 - cy - by;
 



		
		var sampleCurveX = function(t) {
			
			return ((ax * t + bx) * t + cx) * t;
		};
 



		
		var sampleCurveY = function(t) {
			return ((ay * t + by) * t + cy) * t;
		};
 



		
		var sampleCurveDerivativeX = function(t) {
			return (3.0 * ax * t + 2.0 * bx) * t + cx;
		};
 





		
		var solveCurveX = function(x, epsilon) {
			var t0;
			var t1;
			var t2;
			var x2;
			var d2;
			var i;
 
			
			for (t2 = x, i = 0; i < 8; i++) {
				x2 = sampleCurveX(t2) - x;
				if (Math.abs (x2) < epsilon) {
					return t2;
				}
				d2 = sampleCurveDerivativeX(t2);
				if (Math.abs(d2) < 1e-6) {
					break;
				}
				t2 = t2 - x2 / d2;
			}
 
			
			t0 = 0.0;
			t1 = 1.0;
			t2 = x;
 
			if (t2 < t0) {
				return t0;
			}
			if (t2 > t1) {
				return t1;
			}
 
			while (t0 < t1) {
				x2 = sampleCurveX(t2);
				if (Math.abs(x2 - x) < epsilon) {
					return t2;
				}
				if (x > x2) {
					t0 = t2;
				} else {
					t1 = t2;
				}
				t2 = (t1 - t0) * 0.5 + t0;
			}
 
			
			return t2;
		};
 




		
		var solve = function(x, epsilon) {
			return sampleCurveY(solveCurveX(x, epsilon));
		};
 
		
 





		
		return function(x, duration) {
			return solve(x, solveEpsilon(+duration || DEFAULT_DURATION));
		};
	};
 
	
	return {




		
		linear: unitBezier(0.0, 0.0, 1.0, 1.0),
 




		
		ease: unitBezier(0.25, 0.1, 0.25, 1.0),
 




		
		easeIn: unitBezier(0.42, 0, 1.0, 1.0),
 




		
		easeOut: unitBezier(0, 0, 0.58, 1.0),
 




		
		easeInOut: unitBezier(0.42, 0, 0.58, 1.0),
 








		
		cubicBezier: function(p1x, p1y, p2x, p2y, x, duration) {
			return unitBezier(p1x, p1y, p2x, p2y)(x, duration);
		}
	};
})();





var Easing = (function(){
	'use strict';
 


	
	var EASE_IN_OUT_CONST = 0.5 * Math.pow(0.5, 1.925);
 
	return {
 



		
		linear: function(x) {
			return x;
		},
 








 



		
		easeInApprox: function(x) {
			
			return Math.pow(x, 1.685);
		},
 



		
		easeInQuadratic: function(x) {
			return (x * x);
		},
 



		
		easeInCubic: function(x) {
			return (x * x * x);
		},
 



		
		easeOutApprox: function(x) {
			
			return 1 - Math.pow(1-x, 1.685);
		},
 



		
		easeOutQuadratic: function(x) {
			x -= 1;
			return 1 - (x * x);
		},
 



		
		easeOutCubic: function(x) {
			x -= 1;
			return 1 + (x * x * x);
		},
 



		
		easeInOutApprox: function(x) {
			
			if (x < 0.5) {
				return EASE_IN_OUT_CONST * Math.pow(x, 1.925);
	
			} else {
				return 1 - EASE_IN_OUT_CONST * Math.pow(1-x, 1.925);
			}
		},
 



		
		easeInOutQuadratic: function(x) {
			if (x < 0.5) {
				return (2 * x * x);
	
			} else {
				x -= 1;
				return 1 - (2 * x * x);
			}
		},
 



		
		easeInOutCubic: function(x) {
			if (x < 0.5) {
				return (4 * x * x * x);
	
			} else {
				x -= 1;
				return 1 + (4 * x * x * x);
			}
		},
 



		
		easeInOutQuartic: function(x) {
			if (x < 0.5) {
				return (8 * x * x * x * x);
	
			} else {
				x -= 1;
				return 1 + (8 * x * x * x * x);
			}
		},
 



		
		easeInOutQuintic: function(x) {
			if (x < 0.5) {
				return (16 * x * x * x * x * x);
	
			} else {
				x -= 1;
				return 1 + (16 * x * x * x * x * x);
			}
		}
	};
})();

SimpleAnimation.prototype.initPropertiesFromData = function SimpleAnimation_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("animationKeyPaths")) this.animationKeyPaths = data.animationKeyPaths;
if (data.hasOwnProperty("animationValues")) this.animationValues = data.animationValues;
if (data.hasOwnProperty("viewID")) this.viewID = data.viewID;
if (data.hasOwnProperty("animationStartsImmediately")) this.animationStartsImmediately = data.animationStartsImmediately;
if (data.hasOwnProperty("animationRepeats")) this.animationRepeats = data.animationRepeats;
if (data.hasOwnProperty("animationRepeatsInReverse")) this.animationRepeatsInReverse = data.animationRepeatsInReverse;
if (data.hasOwnProperty("isReverse")) this.isReverse = data.isReverse;
if (data.hasOwnProperty("animationDurationMsec")) this.animationDurationMsec = data.animationDurationMsec;
if (data.hasOwnProperty("animationTimingFunction")) this.animationTimingFunction = data.animationTimingFunction;
if (data.hasOwnProperty("remainInFinalState")) this.remainInFinalState = data.remainInFinalState;
if (data.hasOwnProperty("repeatCount")) this.repeatCount = data.repeatCount;
if (data.hasOwnProperty("currentRepeatCount")) this.currentRepeatCount = data.currentRepeatCount;
if (data.hasOwnProperty("currentAnimationProgress")) this.currentAnimationProgress = data.currentAnimationProgress;
};

SimpleAnimation.prototype.decodeData = function SimpleAnimation_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

SimpleAnimation.prototype.encode = function SimpleAnimation_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

SimpleAnimation.prototype.encodeCloned = function SimpleAnimation_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

SimpleAnimation.prototype.expectedTypeForProperty = function SimpleAnimation_expectedTypeForProperty(key) {
	if (key === "readableType") return "";
	if (key === "readableDescription") return "";
	if (key === "outlineIconURL") return "";
	if (key === "iconURL") return "";
	if (key === "animationKeyPaths") return "Object";
	if (key === "animationValues") return "Object";
	if (key === "$animationProgress1000") return "Number";
	if (key === "isPlaying") return "Boolean";
	if (key === "timer") return "";
	if (key === "isCurrentlyRepeating") return "";
	if (key === "viewState") return "";
	if (key === "viewID") return "String";
	if (key === "view") return "";
	if (key === "animationStartsImmediately") return "Boolean";
	if (key === "animationRepeats") return "Boolean";
	if (key === "animationRepeatsInReverse") return "Boolean";
	if (key === "isReverse") return "Boolean";
	if (key === "animationDurationMsec") return "Number";
	if (key === "animationDuration") return "Number";
	if (key === "animationTimingFunction") return "String";
	if (key === "remainInFinalState") return "Boolean";
	if (key === "repeatCount") return "Number";
	if (key === "currentRepeatCount") return "Number";
	if (key === "inspectorProperties") return "";
	if (key === "currentAnimationProgress") return "Number";
	if (key === "performableActions") return "";
	if (key === "isSelected") return "";
	if (key === "canPlay") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SimpleAnimation; }()));