//
//  SimpleAnimation.h
//

#import <Foundation/Foundation.h>


@interface SimpleAnimation : NSObject

@property UIView * view;

@property double animationDurationMsec;
@property BOOL animationRepeats;
@property BOOL animationRepeatsInReverse;
@property BOOL animationStartsImmediately;
@property (nonatomic, retain) NSString * animationTimingFunction;
@property BOOL isReverse;
@property BOOL remainInFinalState;
@property NSDictionary * animationValues;
@property NSDictionary * animationKeyPaths;
@property NSUInteger repeatCount;

- (IBAction)start;
- (IBAction)stop;
- (IBAction)reset;

- (void)setAnimationValuesJSON:(NSString *)json;
- (void)setAnimationKeyPathsJSON:(NSString *)json;

- (void)viewWillAppear:(BOOL)animated;

@end
