
registerType('info.appdoo-mac', (function () { function SimpleAudioPlayer() {} var __super = setSupertypeFromDomain(SimpleAudioPlayer, 'BasicEditableObject', 'appdoo');

	Object.defineProperty(SimpleAudioPlayer.prototype, "outlineIconURL", {
		value: 'Resources/SimpleAudioPlayer.png'});
	

	Object.defineProperty(SimpleAudioPlayer.prototype, "iconURL", {
		value: 'Resources/SimpleAudioPlayer48.png'});
	

	Object.defineProperty(SimpleAudioPlayer.prototype, "readableType", {
		get: function () { return LocalizedString('Audio Player'); }});
	
	
	Object.defineProperty(SimpleAudioPlayer.prototype, "readableDescription", {
		get: function () {
			return LocalizedString('Plays an audio file');
		}});
	

	Object.defineProperty(SimpleAudioPlayer.prototype, "soundFileReferenceID", {
	outlet: true, 
	enumerable: true, get:function () { return this._soundFileReferenceID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_soundFileReferenceID")) Object.defineProperty(this, "_soundFileReferenceID", { writable: true, configurable: true }); this._soundFileReferenceID = v; }});
	

	Object.defineProperty(SimpleAudioPlayer.prototype, "autoplay", {
	outlet: true, 
	enumerable: true, get:function () { return this._autoplay; }, set:function (v) {if (!Object.hasOwnProperty(this, "_autoplay")) Object.defineProperty(this, "_autoplay", { writable: true, configurable: true }); this._autoplay = v; }});
	

	Object.defineProperty(SimpleAudioPlayer.prototype, "e_soundFileReferenceID", {
		set: function (v) { delete this.soundURLString; this.soundFileReferenceID = v; _context.editor.refreshInspector(); }, 
		get: function ( ) { return this.soundFileReferenceID; }});
	
	
	Object.defineProperty(SimpleAudioPlayer.prototype, "instancesCanBeGlobal", {
		value: true});
	

SimpleAudioPlayer.prototype.createForContext = function SimpleAudioPlayer__createForContext(context) {

		return createComponentFromDomain(
			this.constructor.name,
			this.__domain,
			context,
			{

			}
		);
		};
	
	
	Object.defineProperty(SimpleAudioPlayer.prototype, "isPlugin", {
		value: true});
	
	
	Object.defineProperty(SimpleAudioPlayer.prototype, "pluginIdentifier", {
		value: 'info.appdoo-mac.SimpleAudioPlayer'});
	

	Object.defineProperty(SimpleAudioPlayer.prototype, "inspectorProperties", {
		get: function () {
			var ref = this;

			return [

				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
						{ name: LocalizedString('Name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
						{ name: '', keyPath: 'e_soundFileReferenceID', type:'fileReference', numberOfVisibleItems: 1, labelOnTop: true, filter: function (item) { return item.isAudio||item.isVideo; }, dataKeyPath: 'soundURLString', dataName: this.readableNameForProperty('soundURLString'), name:LocalizedString('Audio File') },
						{ type: 'button', buttonStyle: 'flat', caption: LocalizedString('Import')+'…', buttonWidth: TRANSLATE({'de':100,'en':70}), align: "right", marginTop:-8+5, action: function (selection) {

						var fileInfo = _context.fileInfoByDialog();
						if (!fileInfo) return;
						
						if (fileInfo.type && fileInfo.type.indexOf('audio/') === 0) {
							var resourceID = _context.nativeProxy.sendMessage('importResourceFromFile', fileInfo.path);
							
							if (!resourceID) return;
							
							var ref = _context.editor.addResourceReference(resourceID, _context.editor.filenameFromPath(fileInfo.path), fileInfo.type, undefined, fileInfo.path);
							
							if (!ref) return;
							_context.editor.addUndoStepForInsertOperation(ref);
							if (Array.isArray(selection)) selection.every(function (obj) {
								obj.dataController.setValueForKeyPath(ref.$id, 'e_soundFileReferenceID');return true; }, this);
							
							
							_context.editor.refreshInspector();

						} else {
							alertd(1);
							_context.showIncompatibilityErrorForFile(fileInfo, false, this.supportedMimeTypes, null);
						}

					}.bind(this) },

						{ type: 'boolean', name: LocalizedString("Play Immediately"), positionLeft: true, keyPath: 'autoplay' },
						{ type: 'space' },
						
						{  type: 'button', caption: this.isPlaying ? '◼︎' : '▶︎', buttonWidth: 70, buttonStyle: 'flat', positionLeft: 0, 
							disabled: !this.soundFileReferenceID&&!this.soundURLString,
						
							action: function () {
								if (ref.isPlaying) {
									ref.stopSound(this);
								}
								else {
									ref.playSound(this);
								}
							},
							
						}
					]
				},
		
			];

		}});
	
	
	Object.defineProperty(SimpleAudioPlayer.prototype, "supportedMimeTypes", {
		value: ['audio/mp3', 'audio/x-m4a', 'audio/mp4', 'audio/mpeg']});
	

	Object.defineProperty(SimpleAudioPlayer.prototype, "performableActions", {
		get: function () {
			return {
				'play': { name: LocalizedString('play') },
				'pause': { name: LocalizedString('pause') },
				'playOrPause': { name: LocalizedString('play/pause') },
				'stop': { name: LocalizedString('stop') },
				'seekBackward': { name: LocalizedString('rewind') },
				'seekForward': { name: LocalizedString('fast-forward') },
			};
		}});
	
	
SimpleAudioPlayer.prototype.simulateAction = function SimpleAudioPlayer_simulateAction(actionID) {
		if (actionID === 'play') this.playSound();
		if (actionID === 'pause') this.pauseSound();
		if (actionID === 'playOrPause') this.playOrPauseSound();
		if (actionID === 'stop') this.stopSound();
		if (actionID === 'seekBackward') this.skipSeconds(-5);
		if (actionID === 'seekForward') this.skipSeconds(+5);};
	

SimpleAudioPlayer.prototype.skipSeconds = function SimpleAudioPlayer__skipSeconds(seconds) {
		if (!this.playingSound) return;
		this.playingSound.currentTime += seconds;};
	

	Object.defineProperty(SimpleAudioPlayer.prototype, "isPlaying", {
		get: function () { return this.playingSound && !this.playingSound.paused; }});
	

	Object.defineProperty(SimpleAudioPlayer.prototype, "isNotPlaying", {
		get: function () { return !this.isPlaying; }});
	

	Object.defineProperty(SimpleAudioPlayer.prototype, "playingSound", {
	synthesized: true, get:function () { return this._playingSound; }, set:function (v) {if (!Object.hasOwnProperty(this, "_playingSound")) Object.defineProperty(this, "_playingSound", { writable: true, configurable: true }); this._playingSound = v; }});
	
	
	Object.defineProperty(SimpleAudioPlayer.prototype, "filePath", {
		get: function () {
			if (this.soundURLString && this.soundURLString.indexOf('file:') === 0) {
				var name = this.soundURLString.substr(5);
				var resource = this.context.resourceNamed(name);
				if (resource) return resource.filePath;
				return null;
			}
			var ref = _context.projectContext.fileReferenceWithID(this.soundFileReferenceID);
			if (ref) return ref.filePath;
		}});
	
	
	Object.defineProperty(SimpleAudioPlayer.prototype, "interval", {
	synthesized: true, get:function () { return this._interval; }, set:function (v) {if (!Object.hasOwnProperty(this, "_interval")) Object.defineProperty(this, "_interval", { writable: true, configurable: true }); this._interval = v; }});
	

SimpleAudioPlayer.prototype.playSound = function SimpleAudioPlayer_playSound(sender) {
		
		
		
		if (!this.playingSound) {
			var path = this.filePath;
			
			this.playingSound = new Audio(path);
			this.playingSound.addEventListener('play', function () {
				if (sender) sender.text = '◼︎';
			});
			this.playingSound.addEventListener('ended', function () {
				if (sender) sender.text = ' ▶︎';
			});
			this.playingSound.addEventListener('pause', function () {
				if (sender) sender.text = ' ▶︎';
			});
		}
		this.playingSound.play();

		this.collectCurrentStateData();

		this.interval = setInterval(function () {
			this.collectCurrentStateData();
		}.bind(this), 250);};
	

SimpleAudioPlayer.prototype.pauseSound = function SimpleAudioPlayer_pauseSound(sender) {
		if (!this.playingSound) return;
		this.playingSound.pause();
		this.collectCurrentStateData();};
	
	
SimpleAudioPlayer.prototype.playOrPauseSound = function SimpleAudioPlayer_playOrPauseSound(sender) {
		if (!this.playingSound) return this.playSound();
		if (this.playingSound.paused)
			this.playingSound.play();
		else
			this.playingSound.pause();};
	
	
SimpleAudioPlayer.prototype.stopSound = function SimpleAudioPlayer_stopSound(sender) {
		
		if (!this.playingSound) return;
		this.playingSound.pause();
		this.playingSound = null;};
	
	
SimpleAudioPlayer.prototype.unselectForEditor = function SimpleAudioPlayer_unselectForEditor(editor) {
		this.stopSound();};
	

SimpleAudioPlayer.prototype.transformData = function SimpleAudioPlayer_transformData(data, transformer) {
		if (transformer.isXIBGenerator) return this.audioPlayer_transformDataForXIB(data, transformer);
		else return this.audioPlayer_transformDataForPreview(data, transformer);};
	

SimpleAudioPlayer.prototype.audioPlayer_transformDataForXIB = function SimpleAudioPlayer_audioPlayer_transformDataForXIB(data, transformer) {

		transformer.demandPlugin('info.appdoo-mac.FileURLHelper');
		
		var result = {
			customClass: 'SimpleAudioPlayer',
			userDefinedRuntimeAttributes: {
			},
			userLabel: data.name||undefined
		};
		
		if (!this.bindingForKey.call(data, 'soundURLString')) {
			var ref = _context.projectContext.fileReferenceWithID(data.soundFileReferenceID);
			if (ref) {
				result.userDefinedRuntimeAttributes['userDefinedRuntimeAttribute soundName'] = {
					type: 'string',
					keyPath: 'soundName',
					value: ref.name
				};
				result.userDefinedRuntimeAttributes['userDefinedRuntimeAttribute soundIdentifier'] = {
					type: 'string',
					keyPath: 'soundIdentifier',
					value: ref.resourceID
				};
				transformer.productGenerator.registerResourceUsage(ref, data);
			}
		
		}
		
		if (data.dataProvider) {
			var dataProvider = _context.projectContext.decodeObjectTree(data.dataProvider);
			transformer.registerInlineObject(dataProvider);
			transformer.connectOutletNamed__in__to__result__('dataProvider', data.$id, dataProvider.$id, result);
			
		}
		
			result.userDefinedRuntimeAttributes['userDefinedRuntimeAttribute autoplay'] = {
					type: 'boolean',
					keyPath: 'autoplay',
					value: transformer.transformBoolean(data.autoplay)
				};
		
		if (!transformer.isTransformingGlobalObjects) {
			transformer.addDeallocMethod(data.$id, 'destroy');
		}

		

		return result;};
	

SimpleAudioPlayer.prototype.audioPlayer_transformDataForPreview = function SimpleAudioPlayer_audioPlayer_transformDataForPreview(data, transformer) {
		var result = __super.prototype.transformData.call(this, data, transformer);

		if (!this.bindingForKey.call(data, 'soundURLString')) {
			var ref = _context.projectContext.fileReferenceWithID(data.soundFileReferenceID);
			if (ref) {
				result.soundName = ref.name;
				result.soundIdentifier = ref.resourceID;
			}
		}

		if (data.dataProvider) {
			result.dataProvider = getPrototype(utiFromData(data.dataProvider)).transformData(data.dataProvider, transformer);
			result.$propertyPriorities['dataProvider'] = -1;
		}
		
		result.autoplay = transformer.transformBoolean(data.autoplay);




		
		return result;};
	
	
	Object.defineProperty(SimpleAudioPlayer.prototype, "bindableProperties", {
		get: function () {
			var result = clone(__super.prototype.bindableProperties);
			result.unshift(
				['soundURLString', this.readableNameForProperty('soundURLString')]
			);
			return result;
		}});
	

	Object.defineProperty(SimpleAudioPlayer.prototype, "soundURLString", {
	outlet: true, 
	enumerable: true, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_soundURLString")) Object.defineProperty(this, "_soundURLString", { writable: true, configurable: true });
			if (this._soundURLString === value) return;
			this._soundURLString = value;
			this.stopSound();
			
		}, get:function () { return this._soundURLString; }});
	

SimpleAudioPlayer.prototype.readableNameForProperty = function SimpleAudioPlayer_readableNameForProperty(p) {
		switch (p) {
			case 'soundURLString':				return LocalizedString('File URL');
			case 'currentPlaybackTime':			return TRANSLATE({'de':'aktuelle Abspielzeit','en':'Current Playback Time'});
			case 'currentPlaybackTimeString':			return TRANSLATE({'de':'aktuelle Abspielzeit (formatiert)','en':'Current Playback Time (Formatted)'});
			case 'remainingPlaybackTimeString':			return TRANSLATE({'de':'verbleibende Abspielzeit (formatiert)','en':'Remaining Playback Time (Formatted)'});
			case 'currentPlaybackProgress':			return TRANSLATE({'de':'Abspielfortschritt','en':'Playback Progress'});
			case 'isPlaying':			return TRANSLATE({'de':'spielt ab','en':'Is Playing'});
			case 'isNotPlaying':			return TRANSLATE({'de':'spielt nicht ab','en':'Is Not Playing'});
		}
		return __super.prototype.readableNameForProperty.call(this, p);};
	

SimpleAudioPlayer.prototype.collectCurrentStateData = function SimpleAudioPlayer__collectCurrentStateData() {
		if (this.playingSound) {
			this.currentPlaybackTime = this.playingSound.currentTime;
			this.totalPlaybackTime = this.playingSound.duration|0;
		}
		else {
			this.currentPlaybackTime = 0;
			this.totalPlaybackTime = -1;
		}
		
		formatTimeInSeconds();

		this.currentPlaybackTimeString = formatTimeInSeconds(this.currentPlaybackTime);
		this.remainingPlaybackTimeString = formatTimeInSeconds(this.totalPlaybackTime-this.currentPlaybackTime);
		this.currentPlaybackProgress = this.currentPlaybackTime / this.totalPlaybackTime;

		this.dataProvider.notifyObservers();};
	

SimpleAudioPlayer.prototype.prepareForEditor = function SimpleAudioPlayer_prepareForEditor(editor) {
		getPrototype('info.appdoo-mac.SimpleAudioPlayerDataProvider').addDataProviderToObject(this);
		this.collectCurrentStateData();};
	

	Object.defineProperty(SimpleAudioPlayer.prototype, "dataProvider", {
	outlet: true, 
	enumerable: true, get:function () { return this._dataProvider; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataProvider")) Object.defineProperty(this, "_dataProvider", { writable: true, configurable: true }); this._dataProvider = v; }});
	

	Object.defineProperty(SimpleAudioPlayer.prototype, "currentPlaybackTime", {
	synthesized: true, get:function () { return this._currentPlaybackTime; }, set:function (v) {if (!Object.hasOwnProperty(this, "_currentPlaybackTime")) Object.defineProperty(this, "_currentPlaybackTime", { writable: true, configurable: true }); this._currentPlaybackTime = v; }});
	

	Object.defineProperty(SimpleAudioPlayer.prototype, "currentPlaybackTimeString", {
	synthesized: true, get:function () { return this._currentPlaybackTimeString; }, set:function (v) {if (!Object.hasOwnProperty(this, "_currentPlaybackTimeString")) Object.defineProperty(this, "_currentPlaybackTimeString", { writable: true, configurable: true }); this._currentPlaybackTimeString = v; }});
	

	Object.defineProperty(SimpleAudioPlayer.prototype, "remainingPlaybackTimeString", {
	synthesized: true, get:function () { return this._remainingPlaybackTimeString; }, set:function (v) {if (!Object.hasOwnProperty(this, "_remainingPlaybackTimeString")) Object.defineProperty(this, "_remainingPlaybackTimeString", { writable: true, configurable: true }); this._remainingPlaybackTimeString = v; }});
	

	Object.defineProperty(SimpleAudioPlayer.prototype, "currentPlaybackProgress", {
	synthesized: true, get:function () { return this._currentPlaybackProgress; }, set:function (v) {if (!Object.hasOwnProperty(this, "_currentPlaybackProgress")) Object.defineProperty(this, "_currentPlaybackProgress", { writable: true, configurable: true }); this._currentPlaybackProgress = v; }});
	

	Object.defineProperty(SimpleAudioPlayer.prototype, "totalPlaybackTime", {
	synthesized: true, get:function () { return this._totalPlaybackTime; }, set:function (v) {if (!Object.hasOwnProperty(this, "_totalPlaybackTime")) Object.defineProperty(this, "_totalPlaybackTime", { writable: true, configurable: true }); this._totalPlaybackTime = v; }});
	

	function formatTimeInSeconds(totalSeconds) {
		if (!(totalSeconds > 0)) return '0:00';
		var minutes = (totalSeconds/60)|0,
			seconds = (totalSeconds-minutes*60)|0;
		return minutes+':'+zeroFill(seconds,2);
	
	}
	

SimpleAudioPlayer.prototype.initPropertiesFromData = function SimpleAudioPlayer_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("soundFileReferenceID")) this.soundFileReferenceID = data.soundFileReferenceID;
if (data.hasOwnProperty("autoplay")) this.autoplay = data.autoplay;
if (data.hasOwnProperty("soundURLString")) this.soundURLString = data.soundURLString;
if (data.hasOwnProperty("dataProvider")) this.dataProvider = data.dataProvider;
};

SimpleAudioPlayer.prototype.decodeData = function SimpleAudioPlayer_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("dataProvider")) decoded.dataProvider = this.context.decodeObjectTree(data.dataProvider);
return decoded; };

SimpleAudioPlayer.prototype.encode = function SimpleAudioPlayer_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encode();
}return encoded; };

SimpleAudioPlayer.prototype.encodeCloned = function SimpleAudioPlayer_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encodeCloned();
}return encoded; };

SimpleAudioPlayer.prototype.expectedTypeForProperty = function SimpleAudioPlayer_expectedTypeForProperty(key) {
	if (key === "outlineIconURL") return "";
	if (key === "iconURL") return "";
	if (key === "readableType") return "";
	if (key === "readableDescription") return "";
	if (key === "soundFileReferenceID") return "String";
	if (key === "autoplay") return "Boolean";
	if (key === "e_soundFileReferenceID") return "String";
	if (key === "instancesCanBeGlobal") return "Boolean";
	if (key === "isPlugin") return "";
	if (key === "pluginIdentifier") return "";
	if (key === "inspectorProperties") return "";
	if (key === "supportedMimeTypes") return "";
	if (key === "performableActions") return "";
	if (key === "isPlaying") return "";
	if (key === "isNotPlaying") return "";
	if (key === "playingSound") return "Audio";
	if (key === "filePath") return "String";
	if (key === "interval") return "Interval";
	if (key === "bindableProperties") return "";
	if (key === "soundURLString") return "String";
	if (key === "dataProvider") return "SimpleAudioPlayerDataProvider";
	if (key === "currentPlaybackTime") return "Number";
	if (key === "currentPlaybackTimeString") return "String";
	if (key === "remainingPlaybackTimeString") return "String";
	if (key === "currentPlaybackProgress") return "{";
	if (key === "totalPlaybackTime") return "Number";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SimpleAudioPlayer; }()));
registerType('info.appdoo-mac', (function () { function SimpleAudioPlayerDataProvider() {} var __super = setSupertypeFromDomain(SimpleAudioPlayerDataProvider, 'DataProvider', 'info.appdoo-mac');

	Object.defineProperty(SimpleAudioPlayerDataProvider.prototype, "propertiesForBindings", {
		value: ['currentPlaybackTime', 'currentPlaybackTimeString', 'remainingPlaybackTimeString', 'currentPlaybackProgress', 'isPlaying', 'isNotPlaying']});
	
	




	Object.defineProperty(SimpleAudioPlayerDataProvider.prototype, "mutable", {
		value: true});
	

SimpleAudioPlayerDataProvider.prototype.expectedTypeForProperty = function SimpleAudioPlayerDataProvider_expectedTypeForProperty(key) {
	if (key === "propertiesForBindings") return "";
	if (key === "mutable") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SimpleAudioPlayerDataProvider; }()));