//
//  SimpleAudioPlayer.h
//

#import <AVFoundation/AVFoundation.h>
#import "SimpleAudioPlayerDataProvider.h"

@interface SimpleAudioPlayer : UIResponder

@property (nonatomic, copy)		NSString * soundName;
@property (nonatomic, copy)		NSString * soundIdentifier;
@property (nonatomic, copy)		NSString * soundURLString;
@property (nonatomic, strong)	AVAudioPlayer * player;
@property (nonatomic, strong)	SimpleAudioPlayerDataProvider * dataProvider;
@property (nonatomic) BOOL		autoplay;

- (BOOL)prepareToPlay;
- (void)play;
- (void)pause;
- (void)playOrPause;
- (void)stop;
- (void)beginSeekingForward;
- (void)beginSeekingBackward;
- (void)endSeeking;
- (void)destroy;

+ (void)playSoundNamed:(NSString *)soundName;

@end
