
registerType('info.appdoo-mac', (function () { function SimpleDatabase() {} var __super = setSupertypeFromDomain(SimpleDatabase, 'BasicDataSource', 'appdoo');

	
	Object.defineProperty(SimpleDatabase.prototype, "rootData", {
		get: function () {
			return this.testDataSource.contents;
		}});
	
	Object.defineProperty(SimpleDatabase.prototype, "providesRootData", {
		get: function () {
			return !!this.testDataSource;
		}});
	
	Object.defineProperty(SimpleDatabase.prototype, "bindableProperties", {
		get: function () {
			return [];
		}});
	

	Object.defineProperty(SimpleDatabase.prototype, "requiresPreviewBuildVersion", {
		value: 8});
	

SimpleDatabase.prototype.prepareForEditor = function SimpleDatabase_prepareForEditor(editor) {
		
		setTimeout(function () {
			if (!this.testContents) this.loadTestContents();
		}.bind(this), 1);};
	
	
	Object.defineProperty(SimpleDatabase.prototype, "outlineIconURL", {
		get: function () {
			return _context.pathForResource('SimpleDatabase.png')
		}});
	

	Object.defineProperty(SimpleDatabase.prototype, "iconURL", {
		get: function () {
			return _context.pathForResource('SimpleDatabase48.png')
		}});
	

	Object.defineProperty(SimpleDatabase.prototype, "readableDescription", {
		get: function () {
			return TRANSLATE({'de':'Verwaltet mehrere Datensätze auf dem Gerät','en':'Manages multiple data sets on the device'});
		}});
	

	Object.defineProperty(SimpleDatabase.prototype, "readableType", {
		get: function () {
			return TRANSLATE({'de':'Datensatz-Speicher','en':'Dataset Store'});
		}});
	

	Object.defineProperty(SimpleDatabase.prototype, "isPlugin", {
		value: true});
	
	
	Object.defineProperty(SimpleDatabase.prototype, "contentType", {
		value: 'application/x-sqlite'});
	
	




SimpleDatabase.prototype.createForContext = function SimpleDatabase_createForContext(context) {

		var instance = createComponentFromDomain(
    		this.constructor.name,
    		this.__domain,
    		context,
    		{
    		}
    	);

		instance.replaceContents([]);


    	
    	return instance;
		};
	
	
SimpleDatabase.prototype.replaceContents = function SimpleDatabase_replaceContents(array) {
		this.contents = array;};
	
	
	Object.defineProperty(SimpleDatabase.prototype, "testContents", {
	synthesized: true, get:function () { return this._testContents; }, set:function (v) {if (!Object.hasOwnProperty(this, "_testContents")) Object.defineProperty(this, "_testContents", { writable: true, configurable: true }); this._testContents = v; }});
	
	
SimpleDatabase.prototype.loadTestContents = function SimpleDatabase__loadTestContents() {
		if (!this.testDataSource) {
			this.testDataSource = this.context.connectableObjects[this.testDataSourceID];
			
			if (this.testDataSource) this.testDataSource.addObserver(this);
		}};
	
	
SimpleDatabase.prototype.dataSourceDidLoad = function SimpleDatabase_dataSourceDidLoad(dataSource) {
		
		if (Array.isArray(dataSource.contents)) {
		
			this.testContents = this.testDataSource.contents;
			
			this.notifyObservers();
		}
		else
			this.clear();};
	
	
SimpleDatabase.prototype.clear = function SimpleDatabase__clear() {
		this.testContents = [];
		this.notifyObservers();};
	
	
	Object.defineProperty(SimpleDatabase.prototype, "contents", {
	outlet: true, 
		set: function (obj) {if (!Object.hasOwnProperty(this, "_contents")) Object.defineProperty(this, "_contents", { writable: true, configurable: true }); this.testContents = obj; }, 
		get: function () { return this.testContents; }});
	
	
	Object.defineProperty(SimpleDatabase.prototype, "testDataSourceID", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_testDataSourceID")) Object.defineProperty(this, "_testDataSourceID", { writable: true, configurable: true }); if (this.testDataSource) this.testDataSource.removeObserver(this); this.testDataSource = null; this._testDataSourceID = v; if (this.testContents) this.loadTestContents(); }, 
		get: function () { return this._testDataSourceID || ''; }});
	

	Object.defineProperty(SimpleDatabase.prototype, "testDataSource", {
	synthesized: true, get:function () { return this._testDataSource; }, set:function (v) {if (!Object.hasOwnProperty(this, "_testDataSource")) Object.defineProperty(this, "_testDataSource", { writable: true, configurable: true }); this._testDataSource = v; }});
	

	Object.defineProperty(SimpleDatabase.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
						{ name: LocalizedString('Name'), keyPath: 'e_name' },










						
						
						
						
						
						
						
						
						
						
						
						
						
						{ type: 'space' },
						{ name: TRANSLATE({'de':'Testdaten','en':'Test Data'}), keyPath: 'testDataSourceID', 'type': 'dataSource', numberOfVisibleItems: 4.5, allowsEmptySelection: true, labelOnTop: true },
						
					]

				},














			];
		}});
	

	Object.defineProperty(SimpleDatabase.prototype, "canBeKeyPathFiltered", {
		value: false});
	











SimpleDatabase.prototype.transformData = function SimpleDatabase_transformData(data, transformer) {

		
		transformer.demandPlugin('info.appdoo-mac.FileURLHelper');

		var result = __super.prototype.transformData.call(this, data, transformer);
		



		
		transformer.setStringProperty(result, 'name', data.name);
		
		return result;};
	



























































































































































SimpleDatabase.prototype.instancesCanBeLocal = function SimpleDatabase_instancesCanBeLocal(obj) {
		return false;};
	

SimpleDatabase.prototype.instancesCanBeGlobal = function SimpleDatabase_instancesCanBeGlobal(obj) {
		return true;};
	


	Object.defineProperty(SimpleDatabase.prototype, "performableActions", {
		get: function () {
			return {
			
				'clear': { name: LocalizedString('Clear All') },
			
				'saveEntry:<#dataSourceContents#>': { name: LocalizedString('Save Entry')+':', parameters: [{ type:'dataSourceContents', name:LocalizedString('Entry'), key:'dataSourceContents', canChooseNothing:true, includeDynamicContext:true, numberOfVisibleItems: 1 }] },
				
				'deleteEntry:<#dataSourceContents#>': { name: LocalizedString('Delete Entry')+':', parameters: [{ type:'dataSourceContents', name:LocalizedString('Entry'), key:'dataSourceContents', objectType:'info.appdoo-mac.SimpleDatabase', canChooseNothing:true, includeDynamicContext:true, numberOfVisibleItems: 1 }] },
				
				'addEntries:<#dataSourceContents#>': { name: LocalizedString('Save Multiple Entries')+':', parameters: [{ type:'dataSourceContents', name:LocalizedString('Entries'), key:'dataSourceContents', canChooseNothing:true, includeDynamicContext:true, numberOfVisibleItems: 1 }] },

			};
		}});
	
SimpleDatabase.prototype.initPropertiesFromData = function SimpleDatabase_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("contents")) this.contents = data.contents;
if (data.hasOwnProperty("testDataSourceID")) this.testDataSourceID = data.testDataSourceID;
};

SimpleDatabase.prototype.decodeData = function SimpleDatabase_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

SimpleDatabase.prototype.encode = function SimpleDatabase_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

SimpleDatabase.prototype.encodeCloned = function SimpleDatabase_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

SimpleDatabase.prototype.expectedTypeForProperty = function SimpleDatabase_expectedTypeForProperty(key) {
	if (key === "rootData") return "";
	if (key === "providesRootData") return "";
	if (key === "bindableProperties") return "";
	if (key === "requiresPreviewBuildVersion") return "";
	if (key === "outlineIconURL") return "";
	if (key === "iconURL") return "";
	if (key === "readableDescription") return "";
	if (key === "readableType") return "";
	if (key === "isPlugin") return "";
	if (key === "contentType") return "";
	if (key === "testContents") return "Array";
	if (key === "contents") return "";
	if (key === "testDataSourceID") return "String";
	if (key === "testDataSource") return "BasicDataSource";
	if (key === "inspectorProperties") return "";
	if (key === "canBeKeyPathFiltered") return "";
	if (key === "performableActions") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SimpleDatabase; }()));
registerType('info.appdoo-mac', (function () { function SimpleDatabaseSearch() {} var __super = setSupertypeFromDomain(SimpleDatabaseSearch, 'BasicDataSource', 'appdoo');





	Object.defineProperty(SimpleDatabaseSearch.prototype, "readableType", {
		get: function () {
			return LocalizedString('Datenbank-Abfrage');
		}});
	
	
SimpleDatabaseSearch.prototype.readableNameForProperty = function SimpleDatabaseSearch_readableNameForProperty(key) {
		switch (key) {
			case 'databaseID': return 'databaseID';
			case 'attribute': return 'attribute';
			case 'value': return 'value';
			case 'match': return 'match';
		}
		return __super.prototype.readableNameForProperty.call(this, key);};
	
	
	Object.defineProperty(SimpleDatabaseSearch.prototype, "databaseID", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_databaseID")) Object.defineProperty(this, "_databaseID", { writable: true, configurable: true });
			this.setStringPropertyAndReload('databaseID', v);
		}, get:function () { return this._databaseID; }});
	


	Object.defineProperty(SimpleDatabaseSearch.prototype, "attribute", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_attribute")) Object.defineProperty(this, "_attribute", { writable: true, configurable: true });
			this.setStringPropertyAndReload('attribute', v);
		}, get:function () { return this._attribute; }});
	


	Object.defineProperty(SimpleDatabaseSearch.prototype, "match", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_match")) Object.defineProperty(this, "_match", { writable: true, configurable: true });
			this.setStringPropertyAndReload('match', v);
		}, get:function () { return this._match; }});
	


	Object.defineProperty(SimpleDatabaseSearch.prototype, "value", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_value")) Object.defineProperty(this, "_value", { writable: true, configurable: true });
			this.setStringPropertyAndReload('value', v);
		}, get:function () { return this._value; }});
	
	
SimpleDatabaseSearch.prototype.setStringPropertyAndReload = function SimpleDatabaseSearch__setStringPropertyAndReload(key, value) {
		value = (value||'')+'';
		if (this[key] === undefined) {
			this['_'+key] = value; return;
		}
		if (this[key] === value) return
		this['_'+key] = value;
		this.reload();};
	



	Object.defineProperty(SimpleDatabaseSearch.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
						{ name: this.readableNameForProperty('databaseID'), keyPath: 'databaseID', type: 'object', objectType: 'info.appdoo-mac.SimpleDatabase', canChooseNothing: true },
					
						{ name: this.readableNameForProperty('attribute'), keyPath: 'attribute' },
						{ dataName: this.readableNameForProperty('match'), keyPath: 'match', type: 'select', labelOnTop: true, options: [

['NSFEqualTo','Equal to (case sensitive)'],
['NSFBeginsWith','Begins with (case sensitive)'],
['NSFContains','Contains (case sensitive)'],
['NSFEndsWith','Ends with (case sensitive)'],

['NSFInsensitiveEqualTo','Equal to (case insensitive)'],
['NSFInsensitiveBeginsWith','Begins with (case insensitive)'],
['NSFInsensitiveContains','Contains (case insensitive)'],
['NSFInsensitiveEndsWith','Ends with (case insensitive)'],

['NSFGreaterThan','Greater than'],
['NSFLessThan','Less than'],
['NSFNotEqualTo','Not Equal to from'],
						
						] },
						{ name: this.readableNameForProperty('value'), keyPath: 'value' },
					]
				}
			];
		}});
	
	
	Object.defineProperty(SimpleDatabaseSearch.prototype, "canReload", {
		value: true});
	

	Object.defineProperty(SimpleDatabaseSearch.prototype, "bindableProperties", {
		get: function () {
			var result = [];
			['value'].every(function (key) {
				result.push([key, this.readableNameForProperty(key)]);
				return true;
			}, this);
			return result;
		}});
	

	Object.defineProperty(SimpleDatabaseSearch.prototype, "database", {
		get: function () {
			return this.context.fileReferenceWithID(this.databaseID);
		}});
	
	
SimpleDatabaseSearch.prototype.prepareForEditor = function SimpleDatabaseSearch_prepareForEditor(editor) {
		
		setTimeout(function () {
			
			this.reload();
		}.bind(this), 1);};
	
	
SimpleDatabaseSearch.prototype.reload = function SimpleDatabaseSearch_reload(callback) {
		if (this.database) {
			
			var results = _context.nativeProxy.sendMessage('searchDatabaseWithInfo', this.database.resourceID, JSON.stringify({
				attribute: this.attribute,
				value: this.value,
				match: this.match
			}));
			this.contents = results?JSON.parse(results)||'':'';
			this.notifyObservers();
		}
		if (callback) callback();};
	
	
SimpleDatabaseSearch.prototype.transformData = function SimpleDatabaseSearch_transformData(data, transformer) {
		var result = transformer.createObject(data);
		transformer.demandPlugin('info.appdoo-mac.SimpleDatabase');
		transformer.demandPlugin('info.appdoo-mac.FileURLHelper');
		
		['attribute','value','match'].every(function (key) {
			transformer.setStringProperty(result, key, data[key]);return true; }, this);
		
		
		var ref = _context.projectContext.fileReferenceWithID(data.databaseID);
		if (ref) {
			transformer.setStringProperty(result, 'databaseName', ref.name);
		}
		
		return result;};
	
SimpleDatabaseSearch.prototype.initPropertiesFromData = function SimpleDatabaseSearch_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("databaseID")) this.databaseID = data.databaseID;
if (data.hasOwnProperty("attribute")) this.attribute = data.attribute;
if (data.hasOwnProperty("match")) this.match = data.match;
if (data.hasOwnProperty("value")) this.value = data.value;
};

SimpleDatabaseSearch.prototype.decodeData = function SimpleDatabaseSearch_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

SimpleDatabaseSearch.prototype.encode = function SimpleDatabaseSearch_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

SimpleDatabaseSearch.prototype.encodeCloned = function SimpleDatabaseSearch_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

SimpleDatabaseSearch.prototype.expectedTypeForProperty = function SimpleDatabaseSearch_expectedTypeForProperty(key) {
	if (key === "readableType") return "";
	if (key === "databaseID") return "String";
	if (key === "attribute") return "String";
	if (key === "match") return "String";
	if (key === "value") return "String";
	if (key === "inspectorProperties") return "";
	if (key === "canReload") return "";
	if (key === "bindableProperties") return "";
	if (key === "database") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SimpleDatabaseSearch; }()));
registerType('info.appdoo-mac', (function () { function SimpleDatabaseEntry() {} var __super = setSupertypeFromDomain(SimpleDatabaseEntry, 'BasicDataSource', 'appdoo');


SimpleDatabaseEntry.prototype.transformData = function SimpleDatabaseEntry_transformData(data, transformer) {
		var result = transformer.createObject(data);
		transformer.demandPlugin('info.appdoo-mac.SimpleDatabase');
		transformer.demandPlugin('info.appdoo-mac.FileURLHelper');
		return result;};
	

	Object.defineProperty(SimpleDatabaseEntry.prototype, "readableType", {
		get: function () {
			return LocalizedString('Datenbank-Eintrag');
		}});
	

	Object.defineProperty(SimpleDatabaseEntry.prototype, "performableActions", {
		get: function () {
			return {
				'delete': { name: LocalizedString('delete'), 





				},
				'save': { name: LocalizedString('save'), },
			};
		}});
	


	Object.defineProperty(SimpleDatabaseEntry.prototype, "syncWithContextDependentData", {
	outlet: true, 
	enumerable: true, get:function () { return this._syncWithContextDependentData; }, set:function (v) {if (!Object.hasOwnProperty(this, "_syncWithContextDependentData")) Object.defineProperty(this, "_syncWithContextDependentData", { writable: true, configurable: true }); this._syncWithContextDependentData = v; }});
	

	Object.defineProperty(SimpleDatabaseEntry.prototype, "askUserBeforeDeletion", {
	outlet: true, 
	enumerable: true, get:function () { return this._askUserBeforeDeletion; }, set:function (v) {if (!Object.hasOwnProperty(this, "_askUserBeforeDeletion")) Object.defineProperty(this, "_askUserBeforeDeletion", { writable: true, configurable: true }); this._askUserBeforeDeletion = v; }});
	

	Object.defineProperty(SimpleDatabaseEntry.prototype, "confirmDeletionText", {
	outlet: true, 
	enumerable: true, get:function () { return this._confirmDeletionText; }, set:function (v) {if (!Object.hasOwnProperty(this, "_confirmDeletionText")) Object.defineProperty(this, "_confirmDeletionText", { writable: true, configurable: true }); this._confirmDeletionText = v; }});
	

	Object.defineProperty(SimpleDatabaseEntry.prototype, "actionAfterDeletion", {
	outlet: true, 
	enumerable: true, get:function () { return this._actionAfterDeletion; }, set:function (v) {if (!Object.hasOwnProperty(this, "_actionAfterDeletion")) Object.defineProperty(this, "_actionAfterDeletion", { writable: true, configurable: true }); this._actionAfterDeletion = v; }});
	

	Object.defineProperty(SimpleDatabaseEntry.prototype, "databaseID", {
	outlet: true, 
	enumerable: true, get:function () { return this._databaseID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_databaseID")) Object.defineProperty(this, "_databaseID", { writable: true, configurable: true }); this._databaseID = v; }});
	

	Object.defineProperty(SimpleDatabaseEntry.prototype, "contentsDataSourceID", {
	outlet: true, 
	enumerable: true, get:function () { return this._contentsDataSourceID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_contentsDataSourceID")) Object.defineProperty(this, "_contentsDataSourceID", { writable: true, configurable: true }); this._contentsDataSourceID = v; }});
	

	Object.defineProperty(SimpleDatabaseEntry.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
						{ name: this.readableNameForProperty('databaseID'), keyPath: 'databaseID', type: 'fileReference', canChooseNothing: true, numberOfVisibleItems: 3.5 },


						
						{ type: 'space' },
						{type:'object', objectType:'dataSource',
							
							keyPath:'contentsDataSourceID', labelOnTop:0, isFirstInGroup:1,numberOfVisibleItems:3.5, name:'Contents', canChooseNothing: true },
						
					]
				},








				{
					type: 'group',
					title: LocalizedString('On Save'),
					id: this.constructor.name+'OnSave',
					items: [
						{type:'action', keyPath:'actionAfterSave', name:'   '+LocalizedString('Action')},
					]
				},
				{
					type: 'group',
					title: LocalizedString('On Delete'),
					id: this.constructor.name+'OnDelete',
					items: [
						
						{type:'action',keyPath:'actionAfterDeletion',name:'   '+LocalizedString('Action')},
						{type:'space'},

						{ name: LocalizedString('Ask for Confirmation'), keyPath: 'askUserBeforeDeletion', type: 'boolean', positionLeft: true, conditionalProperties: [{type:'textarea',keyPath:'confirmDeletionText',name:'', acceptsReturn:true, },]  },
						
					]
				},
			];
		}});
	

SimpleDatabaseEntry.prototype.readableNameForProperty = function SimpleDatabaseEntry_readableNameForProperty(key) {
		switch (key) {
			case 'databaseID': return LocalizedString('Datenbank');
		}
		return __super.prototype.readableNameForProperty.call(this, key);};
	

SimpleDatabaseEntry.prototype.initPropertiesFromData = function SimpleDatabaseEntry_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("syncWithContextDependentData")) this.syncWithContextDependentData = data.syncWithContextDependentData;
if (data.hasOwnProperty("askUserBeforeDeletion")) this.askUserBeforeDeletion = data.askUserBeforeDeletion;
if (data.hasOwnProperty("confirmDeletionText")) this.confirmDeletionText = data.confirmDeletionText;
if (data.hasOwnProperty("actionAfterDeletion")) this.actionAfterDeletion = data.actionAfterDeletion;
if (data.hasOwnProperty("databaseID")) this.databaseID = data.databaseID;
if (data.hasOwnProperty("contentsDataSourceID")) this.contentsDataSourceID = data.contentsDataSourceID;
};

SimpleDatabaseEntry.prototype.decodeData = function SimpleDatabaseEntry_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("actionAfterDeletion")) decoded.actionAfterDeletion = this.context.decodeObjectTree(data.actionAfterDeletion);
return decoded; };

SimpleDatabaseEntry.prototype.encode = function SimpleDatabaseEntry_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._actionAfterDeletion && this._actionAfterDeletion.encode) {encoded.actionAfterDeletion = this.actionAfterDeletion.encode();
}return encoded; };

SimpleDatabaseEntry.prototype.encodeCloned = function SimpleDatabaseEntry_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._actionAfterDeletion && this._actionAfterDeletion.encode) {encoded.actionAfterDeletion = this.actionAfterDeletion.encodeCloned();
}return encoded; };

SimpleDatabaseEntry.prototype.expectedTypeForProperty = function SimpleDatabaseEntry_expectedTypeForProperty(key) {
	if (key === "readableType") return "";
	if (key === "performableActions") return "";
	if (key === "syncWithContextDependentData") return "Boolean";
	if (key === "askUserBeforeDeletion") return "Boolean";
	if (key === "confirmDeletionText") return "String";
	if (key === "actionAfterDeletion") return "ActionInfo";
	if (key === "databaseID") return "String";
	if (key === "contentsDataSourceID") return "String";
	if (key === "inspectorProperties") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SimpleDatabaseEntry; }()));
registerType('info.appdoo-mac', (function () { function EditableObjectContainer() {} var __super = setSupertypeFromDomain(EditableObjectContainer, 'JSONDataSource', 'info.appdoo-mac');

	Object.defineProperty(EditableObjectContainer.prototype, "requiresPreviewBuildVersion", {
		value: 8});
	

	Object.defineProperty(EditableObjectContainer.prototype, "iconURL", {
		get: function () {
			return 'Resources/EditableObjectContainer48.png';
		}});
	

	Object.defineProperty(EditableObjectContainer.prototype, "outlineIconURL", {
		get: function () {
			return 'Resources/EditableObjectContainer.png';
		}});
	

EditableObjectContainer.prototype.createForContext = function EditableObjectContainer_createForContext(context) {
		var inst = __super.prototype.createForContext.call(this, context);
		inst.initialContentsSource = 'json';
		inst.initialContentsDataSourceID = '';
		return inst;};
	

	Object.defineProperty(EditableObjectContainer.prototype, "mutable", {
		value: true});
	

	Object.defineProperty(EditableObjectContainer.prototype, "readableType", {
		get: function () { return TRANSLATE({'de':"Datensatz",'en':'Data Set'}); }});
	


	Object.defineProperty(EditableObjectContainer.prototype, "initialContentsSource", {
	outlet: true, 
	enumerable: true, get:function () { return this._initialContentsSource; }, set:function (v) {if (!Object.hasOwnProperty(this, "_initialContentsSource")) Object.defineProperty(this, "_initialContentsSource", { writable: true, configurable: true }); this._initialContentsSource = v; }});
	

	Object.defineProperty(EditableObjectContainer.prototype, "initialContentsDataSourceID", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_initialContentsDataSourceID")) Object.defineProperty(this, "_initialContentsDataSourceID", { writable: true, configurable: true });
			var isUpdating = this._initialContentsDataSourceID !== undefined;
			this._initialContentsDataSourceID = v;
			if (isUpdating) this.getLocalDataFromDataSourceContents(v);
		}, get:function () { return this._initialContentsDataSourceID; }});
	
	
EditableObjectContainer.prototype.getLocalDataFromDataSourceContents = function EditableObjectContainer__getLocalDataFromDataSourceContents(dataSourceID) {
		var dataSource = this.context.connectableObjects[dataSourceID];
		if (!dataSource) return;
		try {
			this.localData = JSON.stringify(dataSource.contents, true, '	');
			
		} catch (err) {}
		};
	
	
	Object.defineProperty(EditableObjectContainer.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
						{ keyPath: 'initialContentsSource', type: 'select', name: LocalizedString('Initial Content'), labelOnTop:1, numberOfVisibleItems: 1, showsIcons:false, options: [
								['json',TRANSLATE({'de':'Durch JSON definieren','en':'Define Using JSON'}),[
									{ keyPath: 'localData', type:'textarea', textFieldHeight:250, acceptsReturn: true },
									{ type: 'button', caption: LocalizedString('Load From File …'), buttonWidth: 110, buttonStyle: 'flat', positionLeft: true, actionKeyPath: 'importFile' },
								]],
								['dataSource',LocalizedString('Obtain From Data Source'),[
									{ keyPath: 'initialContentsDataSourceID', type:'dataSource', canChooseNothing: true, positionLeft: true, numberOfVisibleItems: 4.5, isFirstInGroup: true },
								]],
							] },
							
						{ type: 'space' },
						{ type: 'boolean', name:TRANSLATE({'de':"Auf dem Gerät speichern",'en':'Save On Device'}), positionLeft:1, keyPath: 'shouldSaveOnDevice' },
		
					]
				}
			];
		}});
	


	Object.defineProperty(EditableObjectContainer.prototype, "shouldSaveOnDevice", {
	outlet: true, 
	enumerable: true, get:function () { return this._shouldSaveOnDevice; }, set:function (v) {if (!Object.hasOwnProperty(this, "_shouldSaveOnDevice")) Object.defineProperty(this, "_shouldSaveOnDevice", { writable: true, configurable: true }); this._shouldSaveOnDevice = v; }});
	

	
EditableObjectContainer.prototype.prepareForEditor = function EditableObjectContainer_prepareForEditor(editor) {
		
		if (this.initialContentsSource === 'dataSource') {
			setTimeout(function () {
				this.initialContentsDataSourceID = this.initialContentsDataSourceID;
			}.bind(this), 1);
		}};
	

	Object.defineProperty(EditableObjectContainer.prototype, "performableActions", {
		get: function () {
			var performableActions = Object.getOwnPropertyDescriptor(__super.prototype, "performableActions").get.call(this);

			performableActions['replaceContentsWithDictionary:<#dataSourceContents#>'] = { name: LocalizedString('Replace Contents'), parameters: [{ type:'dataSourceContents', name:LocalizedString('Source'), key:'dataSourceContents', canChooseNothing:true, includeDynamicContext:true }] };
			performableActions['resetContents'] = { name: LocalizedString('Reset Contents') };
			performableActions['clearContents'] = { name: LocalizedString('Clear Contents') };





			return performableActions;
		}});
	
	
	Object.defineProperty(EditableObjectContainer.prototype, "bindableProperties", {
		value: null});
	

EditableObjectContainer.prototype.transformData = function EditableObjectContainer_transformData(data, transformer) {

		transformer.demandPlugin('info.appdoo-mac.FileURLHelper');
		transformer.demandPlugin('info.appdoo-mac.DataSourceBase');
		var result = transformer.createObject(data);

		transformer.setStringProperty(result, 'identifier', data.$id);
		transformer.setBooleanProperty(result, 'shouldSaveOnDevice', data.shouldSaveOnDevice);
		
		if (data.initialContentsSource === 'json') {
			transformer.setStringProperty(result, 'dataString', data.localData);
		}
		else {
			transformer.setReferenceProperty(result, 'initialContentsDataSource', data.$id, data.initialContentsDataSourceID);
		}
		
		return result;};
	

	Object.defineProperty(EditableObjectContainer.prototype, "readableDescription", {
		get: function () {
			return TRANSLATE({'de':'Beinhaltet Daten, die veränderbar sind','en':'A container for data that can be modified'});
		}});
	

EditableObjectContainer.prototype.initPropertiesFromData = function EditableObjectContainer_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("initialContentsSource")) this.initialContentsSource = data.initialContentsSource;
if (data.hasOwnProperty("initialContentsDataSourceID")) this.initialContentsDataSourceID = data.initialContentsDataSourceID;
if (data.hasOwnProperty("shouldSaveOnDevice")) this.shouldSaveOnDevice = data.shouldSaveOnDevice;
};

EditableObjectContainer.prototype.decodeData = function EditableObjectContainer_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

EditableObjectContainer.prototype.encode = function EditableObjectContainer_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

EditableObjectContainer.prototype.encodeCloned = function EditableObjectContainer_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

EditableObjectContainer.prototype.expectedTypeForProperty = function EditableObjectContainer_expectedTypeForProperty(key) {
	if (key === "requiresPreviewBuildVersion") return "";
	if (key === "iconURL") return "";
	if (key === "outlineIconURL") return "";
	if (key === "mutable") return "";
	if (key === "readableType") return "";
	if (key === "initialContentsSource") return "String";
	if (key === "initialContentsDataSourceID") return "String";
	if (key === "inspectorProperties") return "";
	if (key === "shouldSaveOnDevice") return "Boolean";
	if (key === "performableActions") return "";
	if (key === "bindableProperties") return "";
	if (key === "readableDescription") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return EditableObjectContainer; }()));
