//
//  SimpleDatabase.h
//

#import <Foundation/Foundation.h>
#import "DataSourceBase.h"

// This class is required to import legacy documents from Version 1.0.

@interface SimpleDatabase : DataSourceBase

@property (nonatomic, strong) NSString * name;
@property (nonatomic, strong) NSString * initialContentsJSON;

+ (instancetype)databaseFromFile:(NSString *)path;
+ (instancetype)databaseNamed:(NSString *)identifier;

// Adds or updates an entry to the database
- (void)saveEntry:(NSDictionary *)entry;

// Deletes an entry from the database
- (void)deleteEntry:(NSDictionary *)entry;

// Adds a list of entries to the database
- (void)addEntries:(NSArray *)entries;

// Clears the database
- (void)clear;

// Performs a search using the given parameters
- (NSArray *)searchWithInfo:(NSDictionary *)info;

@end


@interface SimpleDatabaseSearch : DataSourceBase

@property (nonatomic, weak) SimpleDatabase * database;
@property (nonatomic, strong) NSString * attribute;
@property (nonatomic, strong) NSString * match;
@property (nonatomic, strong) NSString * value;

@end
