
registerType('info.appdoo-mac', (function () { function SimpleHTMLView() {} var __super = setSupertypeFromDomain(SimpleHTMLView, 'UIView', 'appdoo.iOS');
	
	Object.defineProperty(SimpleHTMLView.prototype, "nameIsEditable", {
		value: true});
	

	Object.defineProperty(SimpleHTMLView.prototype, "content", {
	outlet: true, 
	enumerable: true, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_content")) Object.defineProperty(this, "_content", { writable: true, configurable: true });
			this._content = value;
			this.updateContent();
		}, get:function () { return this._content; }});
	

	Object.defineProperty(SimpleHTMLView.prototype, "location", {
	outlet: true, 
	enumerable: true, get:function () { return this._location; }, set:function (v) {if (!Object.hasOwnProperty(this, "_location")) Object.defineProperty(this, "_location", { writable: true, configurable: true }); this._location = v; }});
	

	Object.defineProperty(SimpleHTMLView.prototype, "margin", {
	outlet: true, 
	enumerable: true, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_margin")) Object.defineProperty(this, "_margin", { writable: true, configurable: true });
			this._margin = value;
			if (this._contentNode) this._contentNode.style.margin = value+'px';
		}, get:function () { return this._margin; }});
	

	
	Object.defineProperty(SimpleHTMLView.prototype, "fontFamily", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_fontFamily")) Object.defineProperty(this, "_fontFamily", { writable: true, configurable: true });
			if (this._fontFamily) {
				var firstChoice = firstChoiceForFontFamily(v, this._fontName);
				this._fontFamily = v;
				this.dataController.setValueForKeyPath(firstChoice, 'fontName', this);
			}
			else this._fontFamily = v;
		}, get:function () { return this._fontFamily; }});
	

	Object.defineProperty(SimpleHTMLView.prototype, "fontName", {
	outlet: true, 
	enumerable: true, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_fontName")) Object.defineProperty(this, "_fontName", { writable: true, configurable: true });
			this._fontName = value;
			if (this._containerNode) this._containerNode.style.fontFamily = this.CSSFontFamily;
		}, get:function () { return this._fontName; }});
	

	Object.defineProperty(SimpleHTMLView.prototype, "fontSize", {
	outlet: true, 
	enumerable: true, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_fontSize")) Object.defineProperty(this, "_fontSize", { writable: true, configurable: true });
			this._fontSize = value;
			if (this._containerNode) this._containerNode.style.fontSize = value+'px';
		}, get:function () { return this._fontSize; }});
	


	Object.defineProperty(SimpleHTMLView.prototype, "CSSTextColor", {
	outlet: true, 
	enumerable: true, 
		set: function (value) {if (!Object.hasOwnProperty(this, "_CSSTextColor")) Object.defineProperty(this, "_CSSTextColor", { writable: true, configurable: true });
			this._CSSTextColor = value;
			if (this._containerNode) this._containerNode.style.color = value;
		}, get:function () { return this._CSSTextColor; }});
	
	
	Object.defineProperty(SimpleHTMLView.prototype, "linkColor", {
	outlet: true, 
	enumerable: true, get:function () { return this._linkColor; }, set:function (v) {if (!Object.hasOwnProperty(this, "_linkColor")) Object.defineProperty(this, "_linkColor", { writable: true, configurable: true }); this._linkColor = v; }});
	

	Object.defineProperty(SimpleHTMLView.prototype, "linkVisitedColor", {
	outlet: true, 
	enumerable: true, get:function () { return this._linkVisitedColor; }, set:function (v) {if (!Object.hasOwnProperty(this, "_linkVisitedColor")) Object.defineProperty(this, "_linkVisitedColor", { writable: true, configurable: true }); this._linkVisitedColor = v; }});
	

	Object.defineProperty(SimpleHTMLView.prototype, "e_linkColor", {
		get: function ( ) { return this.linkColor; }, 
		set: function (v) { this.linkColor = v; this.updateLinkColor(); }});
	

	Object.defineProperty(SimpleHTMLView.prototype, "e_linkVisitedColor", {
		get: function ( ) { return this.linkVisitedColor; }, 
		set: function (v) { this.linkVisitedColor = v; this.updateLinkColor(); }});
	


	Object.defineProperty(SimpleHTMLView.prototype, "canScroll", {
	synthesized: true, 
		set: function(v) {if (!Object.hasOwnProperty(this, "_canScroll")) Object.defineProperty(this, "_canScroll", { writable: true, configurable: true }); this._canScroll = v; if(this._containerNode) this._containerNode.style.overflow = v?'auto':'hidden'; }, get:function () { return this._canScroll; }});
	

	Object.defineProperty(SimpleHTMLView.prototype, "localData", {
		get: function ( ) { return this.content; }, 
		set: function (v) { this.content = v;  }});
	
	
	Object.defineProperty(SimpleHTMLView.prototype, "CSSFontFamily", {
		get: function () { return realIOSFont(this.fontName||'_DEFAULT_'); }});
	
	
	
	


	Object.defineProperty(SimpleHTMLView.prototype, "outlineIconURL", {
		get: function () {
			return this.context.pathForResource('SimpleHTMLView.png')
		}});
	

	Object.defineProperty(SimpleHTMLView.prototype, "readableType", {
		get: function () { return LocalizedString('HTML Container'); }});
	

	Object.defineProperty(SimpleHTMLView.prototype, "readableValue", {
		get: function () { return this.name||this.readableType; }});
	
	
	Object.defineProperty(SimpleHTMLView.prototype, "cocoaType", {
		value: 'UIWebView'});
	

	Object.defineProperty(SimpleHTMLView.prototype, "cocoaCustomType", {
		value: 'SimpleHTMLView'});
	

	var lineHeight = '1.3em';

	
	var htmlViewsUIDs = {};
	Object.defineProperty(SimpleHTMLView.prototype, "uid", {
	synthesized: true, get:function () { return this._uid; }, set:function (v) {if (!Object.hasOwnProperty(this, "_uid")) Object.defineProperty(this, "_uid", { writable: true, configurable: true }); this._uid = v; }});
	

SimpleHTMLView.prototype.init = function SimpleHTMLView_init() {

		__super.prototype.init.call(this);

		Object.defineProperty(this, '_containerNode', {
			value: document.createElement('div'),
		});

		Object.defineProperty(this, '_contentNode', {
			value: document.createElement('div'),
		});
		

		this.style.call({ DOMNode: this._containerNode }, {
			height: this.size.height+'px',
			border: 0,
			fontSize: (this.fontSize||15)+'px',
			overflowY: this.autoHeight ? 'hidden' : 'auto',
			fontFamily: this.CSSFontFamily,
			lineHeight: lineHeight,
			color: this.CSSTextColor
		});
		
		this.style.call({ DOMNode: this._contentNode }, {
			margin: (!isNaN(this.margin) ? this.margin : 15)+'px',
		});
		
		this.style({
			overflow: 'hidden'
		});
		
		
		this.uid = getPrototype('Core.BindingsContext').createUID('htmlview-', htmlViewsUIDs);
		this._containerNode.appendChild(this._contentNode);
		this._containerNode.id = this.uid 
		this.DOMNode.appendChild(this._containerNode);
		
		this.updateLinkColor();
		
		this.updateContent();

		return this;};
	
	
SimpleHTMLView.prototype.destroy = function SimpleHTMLView_destroy() {
		if (this.linkCSSRule) {
			var styleSheet = document.styleSheets[0];
			styleSheet.deleteRule(this.linkCSSRuleIndex);
		}
		__super.prototype.destroy.call(this);};
	
	
	
SimpleHTMLView.prototype.layoutSubviews = function SimpleHTMLView_layoutSubviews() {
		__super.prototype.layoutSubviews.call(this);
		this._containerNode.style.height = this._size.height+'px';};
	
	
	Object.defineProperty(SimpleHTMLView.prototype, "contentType", {
		get: function () { return 'text/html' }});
	

SimpleHTMLView.prototype.loadContents = function SimpleHTMLView__loadContents() {};
	

SimpleHTMLView.prototype.updateContent = function SimpleHTMLView__updateContent() {
	
		if (!this._contentNode) return;
	
		switch (this.contentType) {
			case 'text/html':
				this._contentNode.innerHTML = this.processHTML(this.content);
				break;
			case 'text/plain':
				this._contentNode.textContent = this.content || '';
				break;
			default:
				this._contentNode.innerHTML = '';
		};
		
		if (this.autoHeight) {
			this.setHeightByContent();
			
			
		}

		setTimeout(function () {
			
			
			if (!this.DOMNode) return;
			if (this.autoHeight) this.setHeightByContent();
		}.bind(this), 50);
	};
	
	
SimpleHTMLView.prototype.processHTML = function SimpleHTMLView__processHTML(HTML) {
		if (typeof HTML !== 'string') return '';
		HTML = HTML.replace(/nativeProxy/g,'');
		HTML = HTML.replace(/<script/g,'<noscript');
		HTML = HTML.replace(/<\/script/g,'</noscript');
		HTML = HTML.replace(/<iframe/g,'<noscript');
		HTML = HTML.replace(/<\/iframe/g,'</noscript');
		HTML = HTML.replace(/<link /g,'<span ');
		HTML = HTML.replace(/<html/g,'<span');
		HTML = HTML.replace(/<\/html/g,'</span');
		HTML = HTML.replace(/<body/g,'<span');
		HTML = HTML.replace(/<\/body/g,'</span');
		HTML = HTML.replace(/<meta/g,'<span');
		HTML = HTML.replace(/<a /g,'<a style="pointer-events: none" class="canClickInActionMode" onclick="_context.nativeProxy.sendMessage(\'openURL\',this.href)" ');

		var expression = /file:[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)?/gi;
		var regex = new RegExp(expression);
		var matches = HTML.match(expression);
		
		if (Array.isArray(matches)) matches.every(function (match) {
			var filename = match.substr(5);
			HTML = HTML.replace(match, this.context.pathForResourceNamed(filename));
			return true; }, this);
		

		HTML = this.parseCustomCSS()+HTML;
		return HTML;};
	
	
SimpleHTMLView.prototype.parseCustomCSS = function SimpleHTMLView__parseCustomCSS() {
		
		if (!this.customCSS) return '';
		var id = this.uid;
		var cssID = '#'+id;
		
		var rulesForCssText = function (styleContent) {
			var doc = document.implementation.createHTMLDocument(""),
				styleElement = document.createElement("style");
			
			styleElement.textContent = styleContent;
			
			doc.body.appendChild(styleElement);
			
			return styleElement.sheet.cssRules;
		};		
		var rules = rulesForCssText(this.customCSS);
		var str = '<style>';
		
		for (var i = 0, c = rules.length; i < c; i++) {
			var rule = rules[i];
			if (rule.selectorText === 'body' || rule.selectorText === 'html') {
				str += cssID+rule.cssText.substr(rule.selectorText.length);
			}
			else {
				str += cssID+' '+rule.cssText;
			}
		}
		str += '</style>';
		
		return str;

		
		};
	
	
SimpleHTMLView.prototype.updateLinkColor = function SimpleHTMLView__updateLinkColor() {
	
		var id = this.uid,
			styleSheet = document.styleSheets[0],
			cssText = "#"+id+" a:link, #"+id+" a:visited { color: "+this._linkColor+"; }",
			ruleIndex = styleSheet.cssRules.length;
		
		if (this.linkCSSRule) {
			
			this.linkCSSRule.style.color = this._linkColor;
		}
		else {
			styleSheet.insertRule(cssText, ruleIndex);
			Object.defineProperty(this, "linkCSSRule", {
			writable: true, 
				value: styleSheet.cssRules[ruleIndex]});
			
		}
};
	
	
	Object.defineProperty(SimpleHTMLView.prototype, "linkCSSRuleIndex", {
		get: function () {
			var styleSheet = document.styleSheets[0],
				theRule = this.linkCSSRule,
				i = 0;

			for (var index in styleSheet.cssRules) {
				if (styleSheet.cssRules[index] === theRule) {
					
					return index;
				}
			}
			return -1;
		}});
	



	function contentHeaderForData(data) {
		
		return '<html><head><style type="text/css">\
	body { background-color: transparent; font-family: '+realIOSFont(data.fontName)+'; font-size: '+(data.fontSize||15)+'px; line-height:'+lineHeight+'; margin: '+(data.margin||0)+'px; color: '+(data.CSSTextColor||'#000')+'; } a:link, a:visited { color: '+(data.linkColor||'blue')+'; }'+(data.customCSS||'')+'</style></head><body>';
	}
	
	function contentFooterForData(data) {
		return '</body></html>';
	}
	
SimpleHTMLView.prototype.transformData = function SimpleHTMLView_transformData(data, transformer) {

		transformer.demandPlugin('info.appdoo-mac.FileURLHelper');

		var result = __super.prototype.transformData.call(this, data, transformer);

		if (transformer.isXIBGenerator) {
			var result = __super.prototype.transformData.call(this, data, transformer);
			
			result.dataDetectorType = { key: 'dataDetectorType' };
			result.clipsSubviews = 'YES';
			result.opaque = "NO";
	
			result.connections = {
				'outlet 1': {
					property: "delegate",
					destination: transformer.currentViewController.id,
					id: transformer.createStoryboardID()
				}
			};
			
			
			result.userDefinedRuntimeAttributes = {};
			
	
			if (data.location !== 'remote' && data.content) { 
				transformer.demandPlugin('info.appdoo-mac.SimpleHTMLView');
	
				result.userDefinedRuntimeAttributes['userDefinedRuntimeAttribute content'] = {
					type: "string",
					keyPath: "content",
					value: contentHeaderForData(data)+data.content+contentFooterForData(data)
				};
				
			} else {
			
			}
	
			result.userDefinedRuntimeAttributes['userDefinedRuntimeAttribute contentHeader'] = {
					type: "string",
					keyPath: "contentHeader",
					value: contentHeaderForData(data)
				};
	
			result.userDefinedRuntimeAttributes['userDefinedRuntimeAttribute contentFooter'] = {
					type: "string",
					keyPath: "contentFooter",
					value: contentFooterForData(data)
				};
			
			if (transformer.isTransformingCell) {
				transformer.object__addOutlet__from__to__(result, 'controller', data.$id, '$CurrentCell');
			}
			else {
				transformer.object__addOutlet__from__to__(result, 'controller', data.$id, transformer.currentViewControllerId);
			}
			
		}
		else {
			result.$type = this.constructor.name;
			result.$domain = this.__domain;
			result.content = transformer.transformString(contentHeaderForData(data)+data.content+contentFooterForData(data));
			result.contentHeader = transformer.transformString(contentHeaderForData(data));
			result.contentFooter = transformer.transformString(contentFooterForData(data));
			if (!result.backgroundColor) result.backgroundColor = transformer.transformCSSColor('rgba(0,0,0,0)');
			result.opaque = transformer.transformBoolean(false);
			
			if (transformer.isTransformingCell) {
				
				result.controller = { $type: '$CurrentCell' };
			}
			else {
				
				result.controller = { $type: '$CurrentViewController' };
			};
		}
		
		transformer.setBooleanProperty(result, 'autoHeight', data.autoHeight);
		
		return result;};
	

	
	Object.defineProperty(SimpleHTMLView.prototype, "isPlugin", {
		value: true});
	
	

SimpleHTMLView.prototype.createForSuperview = function SimpleHTMLView_createForSuperview(superview) {

		var makeFullSize = (superview.subviews.length === 0);
	
		var size = makeFullSize ? superview.sizeCopy :
			{ width: Math.min(320, superview.size.width), height: 160 };

		return superview.context.decodeObjectTree({
			$type: this.constructor.name,
			$domain: this.__domain,
			size: size,
			position: { left: 0, top: 0 },
			autoresizingMask: makeFullSize ? 18 : 36,
			fontFamily: 'System',
			fontName: '_DEFAULT_',
			fontSize: 15,
			margin: 0,
			content: ''
		});
	};
	

	Object.defineProperty(SimpleHTMLView.prototype, "fileExtensionsForImport", {
		value: ['html','htm','xhtml','txt']});
	

SimpleHTMLView.prototype.importFile = function SimpleHTMLView_importFile() {

		var fileInfoJSON = this.context.nativeProxy.sendMessage('chooseFileForImport', JSON.stringify({
			title: LocalizedString('Import'),
			allowedFileTypes: this.fileExtensionsForImport,
			prompt: LocalizedString("Import File"),
			message: ""
		}));
		if (!fileInfoJSON) return;
		var fileInfo = JSON.parse(fileInfoJSON);
		var path = fileInfo.path;
		
		var data = this.context.nativeProxy.sendMessage('stringFromFile', path);
		if (!data) return;
		
		this.dataController.setValueForKeyPath(data, 'content');
		_context.editor.refreshInspector(this);

		};
	
	
SimpleHTMLView.prototype.importCSSFile = function SimpleHTMLView_importCSSFile() {

		var fileInfoJSON = this.context.nativeProxy.sendMessage('chooseFileForImport', JSON.stringify({
			title: LocalizedString('Import'),
			allowedFileTypes: ['css','txt'],
			prompt: LocalizedString("Import File"),
			message: ""
		}));
		if (!fileInfoJSON) return;
		var fileInfo = JSON.parse(fileInfoJSON);
		var path = fileInfo.path;
		
		var data = this.context.nativeProxy.sendMessage('stringFromFile', path);
		if (!data) return;
		
		this.dataController.setValueForKeyPath(data, 'e_customCSS');
		_context.editor.refreshInspector(this);

		};
	

	Object.defineProperty(SimpleHTMLView.prototype, "inspectorProperties", {
		get: function () {

			return [

				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name+'General',
					items: [
						{ name: LocalizedString('Name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft:true, alignLabel:true, placeholder:LocalizedString('Optional')
						},
						{ type: 'boolean', name: LocalizedString('Auto Height'), offsetX:-40, keyPath: 'e_autoHeight' },
						{ type: 'boolean', name: LocalizedString('Allow User Interactions'), offsetX:-40, keyPath: 'userInteractionEnabled' },
						{ type: 'space' },
					]
				},
				{
					type: 'group',
					title: LocalizedString('HTML Source Code'),
					id: this.constructor.name+'Content',
					items: [
						{
							
							keyPath: 'localData', dataKeyPath:'content', type:'textarea', spellcheck: false, textFieldHeight:200, acceptsReturn: true, positionLeft:0, dataName:LocalizedString('Content') },
						
						{ type: 'button', caption: LocalizedString('Load From File …'), buttonWidth: 110, buttonStyle: 'flat', positionLeft: true, actionKeyPath: 'importFile', hidden: this.hasBindingForKey('content') },
					]
				},
				{
					type: 'group',
					title: LocalizedString('Format'),
					id: 'SimpleHTMLViewFormat',
					items: [

						{ name: LocalizedString('Color'), keyPath: 'CSSTextColor', type: 'color',
							undefinedValue: 'rgba(0, 0, 0, 1.00)',
							caption: '' },
							
						{ name: LocalizedString('Hyperlinks'), keyPath: 'e_linkColor', type: 'color',
							undefinedValue: 'blue',
							caption: '' },

						{ type: 'space' },

						{ name: LocalizedString('Margin'), keyPath: 'margin', type: 'number', range: [0, 1000],
							
							}, 

						
						
					]
				},
				{
					type: 'group',
					title: LocalizedString('Font'),
					id: this.constructor.name+'Font',
					items: [
						{ type: 'font' },
						{type: 'space'},
						{ type: 'fontSize', keyPath: 'fontSize' },
					]
				},
				{
					type: 'group',
					title: LocalizedString('Custom CSS'),
					id: this.constructor.name+'CSS',
					items: [
						{ type: 'textarea', keyPath: 'e_customCSS', acceptsReturn: true, textFieldHeight:150 },
						{ type: 'button', caption: LocalizedString('Load From File …'), buttonWidth: 110, buttonStyle: 'flat', positionLeft: true, actionKeyPath: 'importCSSFile' },
					]
				},
				{
					type: 'group',
					title: LocalizedString('Advanced'),
					id: this.constructor.name+'Advanced',
					items: [
		
							{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft: true },
		
					]
				}, 
		
			];

		}});
	
	
	Object.defineProperty(SimpleHTMLView.prototype, "autoHeight", {
	outlet: true, 
	enumerable: true, get:function () { return this._autoHeight; }, set:function (v) {if (!Object.hasOwnProperty(this, "_autoHeight")) Object.defineProperty(this, "_autoHeight", { writable: true, configurable: true }); this._autoHeight = v; }});
	

	Object.defineProperty(SimpleHTMLView.prototype, "e_autoHeight", {
		set: function (v) {
			this.autoHeight = v;
			if (v) this.setHeightByContent();
			this.heightIsEditable = !v;
			this.style.call({ DOMNode: this._containerNode }, {
				overflowY: this.autoHeight ? 'hidden' : 'auto',
			});
			if (v && (this.autoresizingMask & 16)) {
				if (this.dataController)
					this.dataController.setValueForKeyPath(this.autoresizingMask^16, 'autoresizingMask');
			}
		}, 
		get: function () { return this.autoHeight; }});
	

SimpleHTMLView.prototype.viewDidResize = function SimpleHTMLView_viewDidResize() {
	
		var widthDidChange = this.autoHeight && (this._lastStableContentSize.width !== this._size.width);

		__super.prototype.viewDidResize.call(this);
		
		if (widthDidChange)
			this.setHeightByContent();
		};
	
	
SimpleHTMLView.prototype.setHeightByContent = function SimpleHTMLView__setHeightByContent() {
		var h = this._contentNode.clientHeight+this._contentNode.offsetTop+(this.margin||0)*2;
		if (!h) return;
		
		
		
		
		_context.editor.setValueWithoutUndoSupport(this, h, 'size.height');};
		


	Object.defineProperty(SimpleHTMLView.prototype, "bindableProperties", {
		get: function () {
			var result = clone(__super.prototype.bindableProperties);
			result.unshift(
				['content', LocalizedString('Content')]
				
			);
			return result;
		}});
	


SimpleHTMLView.prototype.readableNameForProperty = function SimpleHTMLView__readableNameForProperty(propertyName) {
		switch (propertyName) {
			case 'content': return LocalizedString('HTML Content');
		}
		return __super.prototype.readableNameForProperty.call(this, propertyName);};
	

	
	
	Object.defineProperty(SimpleHTMLView.prototype, "customCSS", {
	outlet: true, 
	enumerable: true, get:function () { return this._customCSS; }, set:function (v) {if (!Object.hasOwnProperty(this, "_customCSS")) Object.defineProperty(this, "_customCSS", { writable: true, configurable: true }); this._customCSS = v; }});
	

	Object.defineProperty(SimpleHTMLView.prototype, "e_customCSS", {
		get: function ( ) { return this.customCSS||'html {\n\t\n}'; }, 
		set: function (v) { this.customCSS = v; this.updateContent(); }});
	

SimpleHTMLView.prototype.generateLayoutCodeFromData = function SimpleHTMLView_generateLayoutCodeFromData(data, propertyKeyPath, appGenerator) {
	
		
		if (data.autoHeight) {
			return '\t['+propertyKeyPath+' sizeToFitWidth];\n'
		}
		};
	
	
SimpleHTMLView.prototype.initPropertiesFromData = function SimpleHTMLView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("content")) this.content = data.content;
if (data.hasOwnProperty("location")) this.location = data.location;
if (data.hasOwnProperty("margin")) this.margin = data.margin;
if (data.hasOwnProperty("fontFamily")) this.fontFamily = data.fontFamily;
if (data.hasOwnProperty("fontName")) this.fontName = data.fontName;
if (data.hasOwnProperty("fontSize")) this.fontSize = data.fontSize;
if (data.hasOwnProperty("CSSTextColor")) this.CSSTextColor = data.CSSTextColor;
if (data.hasOwnProperty("linkColor")) this.linkColor = data.linkColor;
if (data.hasOwnProperty("linkVisitedColor")) this.linkVisitedColor = data.linkVisitedColor;
if (data.hasOwnProperty("autoHeight")) this.autoHeight = data.autoHeight;
if (data.hasOwnProperty("customCSS")) this.customCSS = data.customCSS;
};

SimpleHTMLView.prototype.decodeData = function SimpleHTMLView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

SimpleHTMLView.prototype.encode = function SimpleHTMLView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

SimpleHTMLView.prototype.encodeCloned = function SimpleHTMLView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

SimpleHTMLView.prototype.expectedTypeForProperty = function SimpleHTMLView_expectedTypeForProperty(key) {
	if (key === "nameIsEditable") return "";
	if (key === "content") return "String";
	if (key === "location") return "String";
	if (key === "margin") return "Number";
	if (key === "fontFamily") return "String";
	if (key === "fontName") return "String";
	if (key === "fontSize") return "Number";
	if (key === "CSSTextColor") return "String";
	if (key === "linkColor") return "String";
	if (key === "linkVisitedColor") return "String";
	if (key === "e_linkColor") return "String";
	if (key === "e_linkVisitedColor") return "String";
	if (key === "canScroll") return "Boolean";
	if (key === "localData") return "String";
	if (key === "CSSFontFamily") return "String";
	if (key === "outlineIconURL") return "String";
	if (key === "readableType") return "String";
	if (key === "readableValue") return "String";
	if (key === "cocoaType") return "String";
	if (key === "cocoaCustomType") return "String";
	if (key === "uid") return "String";
	if (key === "contentType") return "";
	if (key === "linkCSSRule") return "";
	if (key === "linkCSSRuleIndex") return "";
	if (key === "isPlugin") return "";
	if (key === "fileExtensionsForImport") return "";
	if (key === "inspectorProperties") return "";
	if (key === "autoHeight") return "Boolean";
	if (key === "e_autoHeight") return "Boolean";
	if (key === "bindableProperties") return "";
	if (key === "customCSS") return "String";
	if (key === "e_customCSS") return "String";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SimpleHTMLView; }()));
registerType('info.appdoo-mac', (function () { function UIWebView() {} var __super = setSupertypeFromDomain(UIWebView, 'UIView', 'appdoo.iOS');

	Object.defineProperty(UIWebView.prototype, "canReload", {
		get: function () {




			
		}});
	
	
UIWebView.prototype.reload = function UIWebView_reload(callback) {
		this.loadContents();
		if (callback) callback();};
	

	Object.defineProperty(UIWebView.prototype, "readableType", {
		get: function () { return LocalizedString('Web View'); }});
	


UIWebView.prototype.createForSuperview = function UIWebView_createForSuperview(superview) {
		var makeFullSize = !superview.subviews.length;
		var size = !makeFullSize ?
			{ width: Math.min(320, superview.size.width), height: 160 } :
			superview.sizeCopy;

		return superview.context.decodeObjectTree({
			$type: this.constructor.name,
			$domain: this.__domain,
			size: size,
			position: { left: 0, top: 0 },
			autoresizingMask: makeFullSize ? 18 : 36,
			showActivityIndicator: false
		});
	};
	

UIWebView.prototype.prepareForEditor = function UIWebView_prepareForEditor(editor) {
		getPrototype('info.appdoo-mac.WebViewDataProvider').addDataProviderToObject(this);};
	

	Object.defineProperty(UIWebView.prototype, "dataProvider", {
	outlet: true, 
	enumerable: true, get:function () { return this._dataProvider; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataProvider")) Object.defineProperty(this, "_dataProvider", { writable: true, configurable: true }); this._dataProvider = v; }});
	
	
	Object.defineProperty(UIWebView.prototype, "URLString", {
	outlet: true, 
	enumerable: true, 
		get: function ( ) { return this._URLString; }, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_URLString")) Object.defineProperty(this, "_URLString", { writable: true, configurable: true }); if (this._URLString === v) return; this._URLString = v; this.loadContents(); }});
	






	Object.defineProperty(UIWebView.prototype, "inspectorProperties", {
		get: function () {

			return [

				{
					type: 'group',
					title: this.readableType,
					id: this.UTI,
					items: [
						{ name: LocalizedString('Name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },

						{ name: LocalizedString('URL'), keyPath: 'URLString', dataKeyPath:'URLString', type:'textarea', textFieldHeight:50, acceptsReturn: false, positionLeft:true },
						
						{ name: LocalizedString('Open Links in Safari'), keyPath: 'openLinksInSafari', type: 'boolean', positionLeft:1 },
						{ name: LocalizedString('Show Activity Indicator'), keyPath: 'showActivityIndicator', type: 'boolean', positionLeft:1 },

						{ type: 'space' },
						{ name: LocalizedString('Zoom Contents Automatically'), keyPath: 'scalesPageToFit', type: 'boolean', positionLeft:1 },
						{ type: 'info', html: LocalizedString('<span style="color:#666;position:relative;top:1px">'+LocalizedString('No Preview')+'</span>'), showIcon:true, left: 25+18 },
						
						{ type: 'space' },

						{ name: LocalizedString('Background Color'), keyPath: 'e_backgroundColor', type: 'color', undefinedValue: 'rgba(255,255,255, 1)' },
						{ type: 'space' },

					]
				},
				{
					type: 'group',
					title: LocalizedString('Advanced'),
					id: this.constructor.name+'Advanced',
					items: [
		
							{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft: true },
		
					]
				}, 
			];

		}});
	
	
	Object.defineProperty(UIWebView.prototype, "nameIsEditable", {
		value: true});
	
	
	Object.defineProperty(UIWebView.prototype, "iframe", {
	synthesized: true, get:function () { return this._iframe; }, set:function (v) {if (!Object.hasOwnProperty(this, "_iframe")) Object.defineProperty(this, "_iframe", { writable: true, configurable: true }); this._iframe = v; }});
	
	
UIWebView.prototype.loadContents = function UIWebView__loadContents() {
		














		
		this.showPlaceholder();};
	
	
	
UIWebView.prototype.init = function UIWebView_init() {
		__super.prototype.init.call(this);
		this.loadContents();
		return this;};
	
	
UIWebView.prototype.destroy = function UIWebView_destroy() {
		this.iframe = null;
		__super.prototype.destroy.call(this);};
	

	Object.defineProperty(UIWebView.prototype, "openLinksInSafari", {
	outlet: true, 
	enumerable: true, get:function () { return this._openLinksInSafari; }, set:function (v) {if (!Object.hasOwnProperty(this, "_openLinksInSafari")) Object.defineProperty(this, "_openLinksInSafari", { writable: true, configurable: true }); this._openLinksInSafari = v; }});
	

	Object.defineProperty(UIWebView.prototype, "showActivityIndicator", {
	outlet: true, 
	enumerable: true, get:function () { return this._showActivityIndicator; }, set:function (v) {if (!Object.hasOwnProperty(this, "_showActivityIndicator")) Object.defineProperty(this, "_showActivityIndicator", { writable: true, configurable: true }); this._showActivityIndicator = v; }});
	

	Object.defineProperty(UIWebView.prototype, "scalesPageToFit", {
	outlet: true, 
	enumerable: true, get:function () { return this._scalesPageToFit; }, set:function (v) {if (!Object.hasOwnProperty(this, "_scalesPageToFit")) Object.defineProperty(this, "_scalesPageToFit", { writable: true, configurable: true }); this._scalesPageToFit = v; }});
	

	Object.defineProperty(UIWebView.prototype, "performableActions", {
		get: function () {
			return {
				'goBack': { name: LocalizedString('Go Back') },
				'goForward': { name: LocalizedString('Go Forward') },
				'reload': { name: LocalizedString('Reload') },
			};
		}});
	
	
UIWebView.prototype.simulateAction = function UIWebView_simulateAction(actionID) {
		if (this.iframe) {
			if (actionID === 'goBack') this.iframe.contentWindow.history.back(); 
			if (actionID === 'pause') this.iframe.contentWindow.history.forward(); 
			if (actionID === 'reload') this.iframe.contentWindow.location.reload();
		}};
	
	
UIWebView.prototype.layoutSubviews = function UIWebView_layoutSubviews() {
		__super.prototype.layoutSubviews.call(this);
		if (this.iframe) {
			this.iframe.style.width = this.size.width+'px';
			this.iframe.style.height = this.size.height+'px';
		}};
	

	Object.defineProperty(UIWebView.prototype, "bindableProperties", {
		get: function () {
			var result = clone(__super.prototype.bindableProperties);
			result.unshift(['URLString', LocalizedString('URL')]);
			return result;
		}});
	


UIWebView.prototype.readableNameForProperty = function UIWebView__readableNameForProperty(propertyName) {
		switch (propertyName) {
			case 'URLString': return LocalizedString('URL');
			case 'canGoBack': return LocalizedString('can go back');
			case 'canGoForward': return LocalizedString('can go forward');
		}
		return __super.prototype.readableNameForProperty.call(this, propertyName);};
	
	
UIWebView.prototype.encodesSubviews = function UIWebView__encodesSubviews() {
		value: false};
	

	Object.defineProperty(UIWebView.prototype, "outlineIconURL", {
		get: function () {
			return this.context.pathForResource('UIWebView.png')
		}});
	
	
	Object.defineProperty(UIWebView.prototype, "canGoBack", {
		get: function () {
			if (!this.iframe) return;
			return this.iframe.contentWindow.history.length > 1;
		}});
	

	Object.defineProperty(UIWebView.prototype, "canGoForward", {
		get: function () {
			if (!this.iframe) return;
			return this.iframe.contentWindow.history.length > 1;
		}});
	

UIWebView.prototype.transformData = function UIWebView_transformData(data, transformer) {
	
		var result = __super.prototype.transformData.call(this, data, transformer);

		if (transformer.isXIBGenerator) {
	
			result.dataDetectorType = { key: 'dataDetectorType' };
			result.clipsSubviews = 'YES';
			result.opaque = "NO";
			if (data.scalesPageToFit) result.scalesPageToFit = 'YES';
	
			var delegate = createComponentFromDomain('WebViewDelegate', 'info.appdoo-mac', _context.projectContext, {
				openLinksInSafari: data.openLinksInSafari,
				showActivityIndicator: data.showActivityIndicator
			});
			
			transformer.registerInlineObject(delegate);
	
			result.connections = {
				'outlet 1': {
					property: "delegate",
					destination: transformer.storyboardIDForComposeObject(delegate),
					id: transformer.createStoryboardID()
				}
			};
	
			result.userDefinedRuntimeAttributes = {};
	
			if (data.URLString || this.bindingForKey.call(data, 'URLString')) {
				transformer.demandPlugin('info.appdoo-mac.NSStringPunycodeAdditions');
				transformer.demandPlugin('info.appdoo-mac.UIWebViewURLString');
				transformer.demandPlugin('info.appdoo-mac.WebViewDelegate');
			}
	
			if (data.URLString && !this.bindingForKey.call(data, 'URLString')) {
				result.userDefinedRuntimeAttributes['userDefinedRuntimeAttribute URLString'] = {
						type: "string",
						keyPath: "URLString",
						value: data.URLString
					};
			}
			
			
			
		}
		else {

			result.$type = this.constructor.name;
			result.$domain = this.__domain;
			result.$categories.push('URLString');
			result.URLString = transformer.transformString(data.URLString);
			
			result.opaque = 0;
			if (data.scalesPageToFit) result.scalesPageToFit = 1;
			if (!result.backgroundColor) result.backgroundColor = transformer.transformCSSColor('rgba(0,0,0,0)');
		

			var delegate = createComponentFromDomain('WebViewDelegate', 'info.appdoo-mac', _context.projectContext, {
				openLinksInSafari: data.openLinksInSafari,
				showActivityIndicator: data.showActivityIndicator
			});
			delegate.$id = data.$id+'Delegate';
			
			var delegateInfo = delegate.transformData(delegate.encode(), transformer);
			
			transformer.currentObjects.push(delegateInfo);
			transformer.setReferenceProperty(result, 'delegate', data.$id, delegate.$id);
			
			

		}

		if (data.dataProvider) {
			transformer.demandPlugin('info.appdoo-mac.WebViewDataProvider');
			var dataProvider = transformer.addDataProviderToObject(result, data);
			transformer.registerInverseBinding(result, data, 'canGoBack', 'view', data.dataProvider.$id, dataProvider);
			transformer.registerInverseBinding(result, data, 'canGoForward', 'view', data.dataProvider.$id, dataProvider);
		}
		
		return result;};
	

UIWebView.prototype.initPropertiesFromData = function UIWebView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("dataProvider")) this.dataProvider = data.dataProvider;
if (data.hasOwnProperty("URLString")) this.URLString = data.URLString;
if (data.hasOwnProperty("openLinksInSafari")) this.openLinksInSafari = data.openLinksInSafari;
if (data.hasOwnProperty("showActivityIndicator")) this.showActivityIndicator = data.showActivityIndicator;
if (data.hasOwnProperty("scalesPageToFit")) this.scalesPageToFit = data.scalesPageToFit;
};

UIWebView.prototype.decodeData = function UIWebView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("dataProvider")) decoded.dataProvider = this.context.decodeObjectTree(data.dataProvider);
return decoded; };

UIWebView.prototype.encode = function UIWebView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encode();
}return encoded; };

UIWebView.prototype.encodeCloned = function UIWebView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encodeCloned();
}return encoded; };

UIWebView.prototype.expectedTypeForProperty = function UIWebView_expectedTypeForProperty(key) {
	if (key === "canReload") return "";
	if (key === "readableType") return "";
	if (key === "dataProvider") return "WebViewDataProvider";
	if (key === "URLString") return "String";
	if (key === "inspectorProperties") return "";
	if (key === "nameIsEditable") return "";
	if (key === "iframe") return "";
	if (key === "openLinksInSafari") return "Boolean";
	if (key === "showActivityIndicator") return "Boolean";
	if (key === "scalesPageToFit") return "Boolean";
	if (key === "performableActions") return "";
	if (key === "bindableProperties") return "";
	if (key === "outlineIconURL") return "";
	if (key === "canGoBack") return "Boolean";
	if (key === "canGoForward") return "Boolean";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UIWebView; }()));
registerType('info.appdoo-mac', (function () { function WebViewDelegate() {} var __super = setSupertypeFromDomain(WebViewDelegate, 'BasicObject', 'Core');

	Object.defineProperty(WebViewDelegate.prototype, "needsNoObjCOutlet", {
		value: true});
	

	Object.defineProperty(WebViewDelegate.prototype, "openLinksInSafari", {
	outlet: true, 
	enumerable: true, get:function () { return this._openLinksInSafari; }, set:function (v) {if (!Object.hasOwnProperty(this, "_openLinksInSafari")) Object.defineProperty(this, "_openLinksInSafari", { writable: true, configurable: true }); this._openLinksInSafari = v; }});
	
	
	Object.defineProperty(WebViewDelegate.prototype, "showActivityIndicator", {
	outlet: true, 
	enumerable: true, get:function () { return this._showActivityIndicator; }, set:function (v) {if (!Object.hasOwnProperty(this, "_showActivityIndicator")) Object.defineProperty(this, "_showActivityIndicator", { writable: true, configurable: true }); this._showActivityIndicator = v; }});
	

WebViewDelegate.prototype.transformData = function WebViewDelegate_transformData(data, transformer) {
		var result = transformer.createObject(data);
		transformer.setBooleanProperty(result, 'openLinksInSafari', data.openLinksInSafari);
		transformer.setBooleanProperty(result, 'showActivityIndicator', data.showActivityIndicator);
		return result; };
	

WebViewDelegate.prototype.initPropertiesFromData = function WebViewDelegate_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("openLinksInSafari")) this.openLinksInSafari = data.openLinksInSafari;
if (data.hasOwnProperty("showActivityIndicator")) this.showActivityIndicator = data.showActivityIndicator;
};

WebViewDelegate.prototype.decodeData = function WebViewDelegate_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

WebViewDelegate.prototype.encode = function WebViewDelegate_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

WebViewDelegate.prototype.encodeCloned = function WebViewDelegate_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

WebViewDelegate.prototype.expectedTypeForProperty = function WebViewDelegate_expectedTypeForProperty(key) {
	if (key === "needsNoObjCOutlet") return "Boolean";
	if (key === "openLinksInSafari") return "Boolean";
	if (key === "showActivityIndicator") return "Boolean";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return WebViewDelegate; }()));
registerType('info.appdoo-mac', (function () { function WebViewDataProvider() {} var __super = setSupertypeFromDomain(WebViewDataProvider, 'DataProvider', 'info.appdoo-mac');











	Object.defineProperty(WebViewDataProvider.prototype, "propertiesForBindings", {
		value: ['canGoForward','canGoBack']});
	
	
	Object.defineProperty(WebViewDataProvider.prototype, "mutable", {
		value: true});
	

WebViewDataProvider.prototype.expectedTypeForProperty = function WebViewDataProvider_expectedTypeForProperty(key) {
	if (key === "propertiesForBindings") return "";
	if (key === "mutable") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return WebViewDataProvider; }()));