
registerType('info.appdoo-mac', (function () { function SimpleMapView() {} var __super = setSupertypeFromDomain(SimpleMapView, 'UIView', 'appdoo.iOS');

SimpleMapView.prototype.transformChangeForAppdooPreview = function SimpleMapView_transformChangeForAppdooPreview(change, transformer, result) {
		
		switch (change.keyPath) {
		
			case 'latitudinalMeters':
				result.keyPath = 'latitudinalMetersByUpdate';
				result.value = transformer.transformFloat(change.valueNow);
				return true;
		}

		return __super.prototype.transformChangeForAppdooPreview.call(this, change, transformer, result);};
	

SimpleMapView.prototype.init = function SimpleMapView_init() {
		__super.prototype.init.call(this);
		
		
		this.usesLivePreview = true;
		this.prepare();
		return this;};
	
	
SimpleMapView.prototype.prepare = function SimpleMapView__prepare() {
		if (this.usesLivePreview) {
			return this.prepareWithStaticImage();
			
		}
		else this.prepareWithLabel();};
	
	
SimpleMapView.prototype.prepareWithLabel = function SimpleMapView__prepareWithLabel() {

		this.styleDefault();
		if (!this.label)
		this.label = createComponentFromDomain("UILabel", "appdoo.iOS", this.context, {
			text: this.readableValue, 
			style: { textAlign: 'center', color: 'rgb(187,172,131)', textShadow: 'rgba(255,255,255,.3)' },
			size: { width: 200, height: 20 },
			position: { left: (this.size.width-200)/2, top: (this.size.height-20)/2 },
			autoresizingMask: 45})
		;
		else this.label.hidden = false;
		this.addSubview(this.label);};
	

SimpleMapView.prototype.prepareWithIframe = function SimpleMapView__prepareWithIframe() {
		if (!this.iframe)
			this.iframe = document.createElement('iframe');

		this.iframe.src = 'https://maps.google.com/maps?f=q&amp;source=s_q&amp;hl=de&amp;geocode=&amp;q=T%C3%BCbingen&amp;aq=&amp;sll=37.0625,-95.677068&amp;sspn=43.443045,23.994141&amp;ie=UTF8&amp;hq=&amp;hnear=T%C3%BCbingen,+Baden-W%C3%BCrttemberg,+Deutschland&amp;ll=48.521636,9.057645&amp;spn=0.285153,0.187454&amp;t=m&amp;z=11&amp;output=embed';
		
		this.iframe.style.border = 0;
		this.iframe.scrolling = 'no';
		this.iframe.width = this.size.width;
		this.iframe.height = this.size.height;
		
		this.DOMNode.appendChild(this.iframe);};
	
	
	var currentRequestCallback;
SimpleMapView.prototype.stopCurrentRequest = function SimpleMapView__stopCurrentRequest() {
		if (currentRequestCallback) currentRequestCallback();
		currentRequestCallback = null;
		this.hideSpinner();};
	

	
	var zoomLevelsMpp = [
		91022.23,
		45511.17,
		22755.58,
		11377.79,
		5688.88,
		2844.44,
		1422.22,
		711.11,
		355.55,
		177.78,
		88.88,
		44.44,
		22.22,
		11.11,
		5.55,
		2.78,
		1.39
	];
	
SimpleMapView.prototype.latitudinalMetersForZoomLevel = function SimpleMapView__latitudinalMetersForZoomLevel(zoomLevel) {
		var mpp = zoomLevelsMpp[zoomLevel];
		if (!mpp) return;
		return this.size.width*mpp;};
	

SimpleMapView.prototype.getCurrentZoomLevel = function SimpleMapView__getCurrentZoomLevel() {
		var zoomLevel = zoomLevelsMpp[zoomLevelsMpp.length-2];
		
		var mpp = this.latitudinalMeters/this.size.width;

		
		for (var i = 0, c = zoomLevelsMpp.length; i < c; i++) {
			if (zoomLevelsMpp[i] < mpp) {
				if (Math.abs(zoomLevelsMpp[i]-mpp) > Math.abs(zoomLevelsMpp[i+1]-mpp))
					zoomLevel = i+1;
				else
					zoomLevel = i;
				
				break;
			}
		}
		zoomLevel++;
		if (mpp < 2) zoomLevel = 16;
		return zoomLevel;};
	

	Object.defineProperty(SimpleMapView.prototype, "urlBefore", {
	synthesized: true, get:function () { return this._urlBefore; }, set:function (v) {if (!Object.hasOwnProperty(this, "_urlBefore")) Object.defineProperty(this, "_urlBefore", { writable: true, configurable: true }); this._urlBefore = v; }});
	
	
SimpleMapView.prototype.prepareForMapKitJS = function SimpleMapView__prepareForMapKitJS(callback) {
		};
	
	
SimpleMapView.prototype.prepareWithStaticImage = function SimpleMapView__prepareWithStaticImage(callback) {
		
		
		if (!this.DOMNode) {
			if (callback) callback();
			return;
		}
		if (this.label) this.label.hidden = true;
		
		this.styleDefault();
		currentRequestCallback = callback;
		
		var staticImageBefore = this.staticImage;
		this.staticImage = document.createElement('img');
		
		this.staticImage.onload = function (e) {
			this.stopCurrentRequest();
			if (staticImageBefore) staticImageBefore.parentNode.removeChild(staticImageBefore);
			this.layoutSubviews(true);
		}.bind(this);
		
		this.staticImage.onerror = function (e) {
			this.stopCurrentRequest();
			this.staticImage.parentNode.removeChild(this.staticImage);
			this.prepareWithLabel();
		}.bind(this);
		
		
		this.staticImage.src = ' data:image/png;base64,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';

		
		this.DOMNode.appendChild(this.staticImage);
		this.staticImage.style.position = 'relative';
		this.layoutSubviews(true);
		
		return;
		
		































































		};
	
	
	var reloadMapTimeout;
SimpleMapView.prototype.layoutSubviews = function SimpleMapView_layoutSubviews(doNotReload) {
		if (this.staticImage) {
			
			this.staticImage.style.width = '100px';
			this.staticImage.width = '100';
			this.staticImage.style.height = '100px';
			this.staticImage.height = '100';
			this.staticImage.style.left = ((this.size.width-100)/2)+'px';
			this.staticImage.style.top = ((this.size.height-100)/2)+'px';
			this.staticImage.style.opacity = '0.2';
















			
		}
		if (!doNotReload) {
			if (reloadMapTimeout) clearTimeout(reloadMapTimeout);
			reloadMapTimeout = setTimeout(function () {
				this.prepareWithStaticImage();
				
				reloadMapTimeout = null;
			}.bind(this), 1000);
		}};
	
	
	Object.defineProperty(SimpleMapView.prototype, "spinningWheel", {
	synthesized: true, get:function () { return this._spinningWheel; }, set:function (v) {if (!Object.hasOwnProperty(this, "_spinningWheel")) Object.defineProperty(this, "_spinningWheel", { writable: true, configurable: true }); this._spinningWheel = v; }});
	

	Object.defineProperty(SimpleMapView.prototype, "spinningWheelView", {
	synthesized: true, get:function () { return this._spinningWheelView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_spinningWheelView")) Object.defineProperty(this, "_spinningWheelView", { writable: true, configurable: true }); this._spinningWheelView = v; }});
	
	
SimpleMapView.prototype.showSpinner = function SimpleMapView__showSpinner() {

		var sv = createComponentFromDomain("View", "Core.UI", this.context, {
			size: {width:20,height:20},
			position: { left: this.size.width/2-13, top: this.size.height/2-13 },
			autoresizingMask: 45,
			style: { opacity: .7 }})
		;
		this.addSubview(sv);
		this.spinningWheelView = sv;

		var opts = {
		  lines: 11, 
		  length: 4, 
		  width: 3, 
		  radius: 6, 
		  corners: 1, 
		  rotate: 45, 
		  direction: 1, 
		  color: '#000', 
		  speed: 1, 
		  trail: 54, 
		  shadow: false, 
		  hwaccel: false, 
		  className: 'spinner', 
		  zIndex: 0, 
		  top: '0px', 
		  left: '0px' 
		};
		this.spinningWheel = new Spinner(opts).spin(sv.DOMNode);

	};
	
	
SimpleMapView.prototype.hideSpinner = function SimpleMapView__hideSpinner() {
		if (this.spinningWheel) {
			this.spinningWheel.stop();
			delete this.spinningWheel;
			this.spinningWheelView.removeFromSuperview();
		}};
	
	
	Object.defineProperty(SimpleMapView.prototype, "canReload", {
		get: function () {
			
			return false;
		}});
	
	
SimpleMapView.prototype.reload = function SimpleMapView_reload(callback) {
		this.prepareWithStaticImage(callback);
		};
	

SimpleMapView.prototype.reloadFromButton = function SimpleMapView_reloadFromButton(sender) {
		this.prepareWithStaticImage();
		};
	
	
SimpleMapView.prototype.previewFromButton = function SimpleMapView_previewFromButton(button) {
		this.prepareWithStaticImage();
		
		return;









		};
	

	Object.defineProperty(SimpleMapView.prototype, "iframe", {
	synthesized: true, get:function () { return this._iframe; }, set:function (v) {if (!Object.hasOwnProperty(this, "_iframe")) Object.defineProperty(this, "_iframe", { writable: true, configurable: true }); this._iframe = v; }});
	

	Object.defineProperty(SimpleMapView.prototype, "staticImage", {
	synthesized: true, get:function () { return this._staticImage; }, set:function (v) {if (!Object.hasOwnProperty(this, "_staticImage")) Object.defineProperty(this, "_staticImage", { writable: true, configurable: true }); this._staticImage = v; }});
	
	
	Object.defineProperty(SimpleMapView.prototype, "label", {
	synthesized: true, get:function () { return this._label; }, set:function (v) {if (!Object.hasOwnProperty(this, "_label")) Object.defineProperty(this, "_label", { writable: true, configurable: true }); this._label = v; }});
	
	
SimpleMapView.prototype.styleDefault = function SimpleMapView_styleDefault() {
		this.style({ backgroundColor: 'rgb(250,245,227)', overflow: 'hidden' });};
	

SimpleMapView.prototype.createForSuperview = function SimpleMapView_createForSuperview(superview) {

		var fullScreen = !superview.subviews.length;
		var size = fullScreen ? superview.sizeCopy :
			{ width: Math.min(320, superview.size.width), height: 160 };

		return superview.context.decodeObjectTree({
			$type: this.constructor.name,
			$domain: this.__domain,
			size: size,
			position: { left: 0, top: 0 },
			mapType: 2,
			autoresizingMask: fullScreen ? 18 : 36,
			
			latitudinalMeters: 7500,
			annotations: [
				{
				  $type: "SimpleMapAnnotation",
				  $domain: "info.appdoo-mac",
				  title: "",
				  subtitle: "",
				  positionMode: 'search',
				  query: ['Bogotá','Tianjin','London','Rio de Janeiro','Lagos','Ottawa','Vancouver','Wellington','Buenos Aires','Dhaka','Bangkok','Kolkata','Los Angeles','Cairo','Moscow','Kobe','Mumbai','Guangzhou','Beijing','Mexico City','São Paulo','New York City','Karachi','Manila','Shanghai','Delhi','Seoul','Jakarta','Tokyo','Stuttgart','Munich','Zürich','Wien','Dresden','Praha','Oslo'][Math.floor((Math.random()*20))]
				}
			],
			isExpandedInEditorOutline: true,
			usesLivePreview: true
		});
	};
	
	
	Object.defineProperty(SimpleMapView.prototype, "storyboardTagName", {
		value: 'mapView'});
	

	Object.defineProperty(SimpleMapView.prototype, "cocoaType", {
		value: 'MKMapView'});
	

	Object.defineProperty(SimpleMapView.prototype, "cocoaCustomType", {
		value: 'SimpleMapView'});
	
	
	Object.defineProperty(SimpleMapView.prototype, "isPlugin", {
		value: true});
	
	
	Object.defineProperty(SimpleMapView.prototype, "encodesSubviews", {
		value: false});
	
	
	Object.defineProperty(SimpleMapView.prototype, "readableValue", {
		get: function () {
			if (this.name) return this.name;
			if (this.annotations && this.annotations.length === 1) {
				if (this.annotations[0].title) return this.annotations[0].title;
				if (this.annotations[0].positionMode === 'search' &&
					this.annotations[0].query)
					return this.annotations[0].query;
			}
			return this.readableType;
		}});
	
	
	Object.defineProperty(SimpleMapView.prototype, "readableType", {
		get: function () { return LocalizedString('Map View'); }});
	


	Object.defineProperty(SimpleMapView.prototype, "singleAnnotationQuery", {
		set: function (v) {
			this.annotations[0].query = v;
			this.layoutSubviews();
			this.readableValueDidChange();
		}, 
		get: function () {
			return this.annotations[0].query;
		}});
	

	Object.defineProperty(SimpleMapView.prototype, "singleAnnotationLatitude", {
		set: function (v) {
			this.annotations[0].latitude = v;
			this.layoutSubviews();
		}, 
		get: function () {
			return this.annotations[0].latitude;
		}});
	

	Object.defineProperty(SimpleMapView.prototype, "singleAnnotationLongitude", {
		set: function (v) {
			this.annotations[0].longitude = v;
			this.layoutSubviews();
		}, 
		get: function () {
			return this.annotations[0].longitude;
		}});
	

	Object.defineProperty(SimpleMapView.prototype, "inspectorProperties", {
		get: function () {
			var mapGroup = {
				type: 'group',
				title: this.readableType,
				id: this.constructor.name,
				items: [
					{ name: LocalizedString('Name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
					{ name: LocalizedString('Type'), keyPath: 'e_mapType', dataKeyPath: 'mapType', type: 'select', positionLeft: false, numberOfVisibleItems:1, labelOnTop: false, options:[
						['0', LocalizedString('Map'), []],
						['1', LocalizedString('Satellite'), []],
						['2', LocalizedString('Hybrid'), []],
					]},
					
					
					
					
					
					
						{ name: LocalizedString('Position'), keyPath: 'annotations.0.positionMode', type: 'select', options: [
							['search', LocalizedString('Search'),[
								{
									
									type:'textarea',
									keyPath: 'singleAnnotationQuery',
									placeholder: LocalizedString('Address or Search Term'), textFieldHeight: 46 },
								
									
									{ type: 'info', html: LocalizedString('The search result shown on iOS may differ.'), showIcon: true, positionLeft: true, height: 28, style: {color:''} },

							]],
							['coordinates', LocalizedString('Coordinates'),[
								{ type: 'textarea', name: 'Latitude', spellcheck: false, keyPath: 'singleAnnotationLatitude', textFieldHeight: 13, allowTabs:false },
								{ type: 'textarea', name: 'Longitude', spellcheck: false, keyPath: 'singleAnnotationLongitude', textFieldHeight: 13, allowTabs:false },
								
								

							]],
						] },
						

						{ type: 'space' },
					
					{ name: LocalizedString('Width'), type: 'number', keyPath: 'latitudinalMeters', suffix: LocalizedString('Meters'),
						
						
					},
					{ type: 'button', actionKeyPath: 'zoomOut', marginTop: -5, buttonStyle: 'flat', buttonImageSrc: this.context.pathForResource('RemoveButtonMini.png'), buttonWidth: 30-2, noLinebreak: true },
					{ type: 'button', actionKeyPath: 'zoomIn', buttonStyle: 'flat', buttonImageSrc: this.context.pathForResource('AddButtonMini.png'), buttonWidth: 30-2, left: 120-3-2 },
					
					
					
					
				]
			};
			var annotationGroup = {
				type: 'group',
				title: LocalizedString('Annotation'),
				id: this.constructor.name,
				items: [
						
						{ name: LocalizedString('Title'), keyPath: 'annotations.0.title', placeholder: LocalizedString('Optional') },
						{ name: LocalizedString('Subtitle'), keyPath: 'annotations.0.subtitle', placeholder: LocalizedString('Optional') },

						{ type: 'info', html: LocalizedString('The caption is only shown on iOS.'), showIcon: false, positionLeft: true, height: 28, style: {color:'#777', textAlign:'center'}, marginTop:-5 },

						
				]
			};
			var advancedGroup = {
					type: 'group',
					title: LocalizedString('Advanced'),
					id: this.constructor.name+'Advanced',
					items: [
		
							{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft: true },
		
					]
				};
			
			return [mapGroup, annotationGroup, advancedGroup];

		}});
	

SimpleMapView.prototype.zoomIn = function SimpleMapView__zoomIn() {
		var zoomLevel = this.getCurrentZoomLevel();
		
		if (zoomLevel >= 16) return;
		
		var meters = this.latitudinalMetersForZoomLevel(zoomLevel-1)|0;
		if (!meters) return;
		this.dataController.setValueForKey(meters, 'latitudinalMeters');

		_context.editor.refreshInspector();
		this.reload();};
	

SimpleMapView.prototype.zoomOut = function SimpleMapView__zoomOut() {
		var zoomLevel = this.getCurrentZoomLevel();
		
		if (zoomLevel <= 0) return;
		var meters = this.latitudinalMetersForZoomLevel(zoomLevel-3)|0;
		if (!meters) return;

		this.dataController.setValueForKey(meters, 'latitudinalMeters');
		
		
		_context.editor.refreshInspector();
		this.reload();};
	
	
	Object.defineProperty(SimpleMapView.prototype, "usesLivePreview", {
	outlet: true, 
	enumerable: true, get:function () { return this._usesLivePreview; }, set:function (v) {if (!Object.hasOwnProperty(this, "_usesLivePreview")) Object.defineProperty(this, "_usesLivePreview", { writable: true, configurable: true }); this._usesLivePreview = v; }});
	

	Object.defineProperty(SimpleMapView.prototype, "e_usesLivePreview", {
		get: function ( ) { return this.usesLivePreview; },  
		set: function (v) { this.usesLivePreview = v; }});
	

	Object.defineProperty(SimpleMapView.prototype, "mapType", {
	outlet: true, 
	enumerable: true, get:function () { return this._mapType; }, set:function (v) {if (!Object.hasOwnProperty(this, "_mapType")) Object.defineProperty(this, "_mapType", { writable: true, configurable: true }); this._mapType = v; }});
	

	Object.defineProperty(SimpleMapView.prototype, "e_mapType", {
		get: function ( ) { return this.mapType; }, 
		set: function (v) {
			if(v != this.g) {
				this.mapType = parseInt(v);
				this.prepareWithStaticImage();
				
			}
		}});
	

	Object.defineProperty(SimpleMapView.prototype, "nameIsEditable", {
		value: true});
	

SimpleMapView.prototype.readableValueDidChange = function SimpleMapView_readableValueDidChange() {
		__super.prototype.readableValueDidChange.call(this);
		this.label.text = this.readableValue;};
	
	
	Object.defineProperty(SimpleMapView.prototype, "latitude", {
	enumerable: true, 
	outlet: true, get:function () { return this._latitude; }, set:function (v) {if (!Object.hasOwnProperty(this, "_latitude")) Object.defineProperty(this, "_latitude", { writable: true, configurable: true }); this._latitude = v; }});
	

	Object.defineProperty(SimpleMapView.prototype, "longitude", {
	enumerable: true, 
	outlet: true, get:function () { return this._longitude; }, set:function (v) {if (!Object.hasOwnProperty(this, "_longitude")) Object.defineProperty(this, "_longitude", { writable: true, configurable: true }); this._longitude = v; }});
	

	Object.defineProperty(SimpleMapView.prototype, "latitudinalMeters", {
	enumerable: true, 
	outlet: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_latitudinalMeters")) Object.defineProperty(this, "_latitudinalMeters", { writable: true, configurable: true });
			if (this._latitudinalMeters === undefined)
				this._latitudinalMeters = v;
			else {
				this._latitudinalMeters = v;
				this.layoutSubviews();
			}
		}, get:function () { return this._latitudinalMeters; }});
	

	Object.defineProperty(SimpleMapView.prototype, "annotations", {
	enumerable: true, 
	outlet: true, get:function () { return this._annotations; }, set:function (v) {if (!Object.hasOwnProperty(this, "_annotations")) Object.defineProperty(this, "_annotations", { writable: true, configurable: true }); this._annotations = v; }});
	

SimpleMapView.prototype.transformData = function SimpleMapView_transformData(data, transformer) {
		
		var result = __super.prototype.transformData.call(this, data, transformer);
		transformer.setType(result, this.constructor.name);

		transformer.setFloatProperty(result, 'latitude', data.annotations[0].latitude);
		transformer.setFloatProperty(result, 'longitude', data.annotations[0].latitude);
		transformer.setFloatProperty(result, 'latitudinalMeters', data.latitudinalMeters);
		transformer.setStringProperty(result, 'firstAnnotationJSONString', JSON.stringify(data.annotations[0]));
		transformer.setIntegerProperty(result, 'mapType', data.mapType);

		if (!transformer.isXIBGenerator) {
			result.$propertyPriorities['firstAnnotationJSONString'] = -1;
		}

		return result;
	};
	




















	

	Object.defineProperty(SimpleMapView.prototype, "outlineIconURL", {
		get: function () {
			return 'PlugIns/SimpleMapView.cpsplugin/Editor/SimpleMapView@2x.png';
		}});
	

	Object.defineProperty(SimpleMapView.prototype, "bindableProperties", {
		get: function () {
			var bindableProperties = Object.getOwnPropertyDescriptor(__super.prototype, "bindableProperties").get.call(this);
			bindableProperties.unshift(
				['singleAnnotationQuery', this.readableNameForProperty('singleAnnotationQuery')],
				['singleAnnotationLatitude', this.readableNameForProperty('singleAnnotationLatitude')],
				['singleAnnotationLongitude', this.readableNameForProperty('singleAnnotationLongitude')]
			);
			return bindableProperties;
		}});
	

SimpleMapView.prototype.readableNameForProperty = function SimpleMapView_readableNameForProperty(name) {
		switch (name) {
			case 'singleAnnotationQuery': return LocalizedString('Search Term');
			case 'singleAnnotationLatitude': return LocalizedString('Latitude');
			case 'singleAnnotationLongitude': return LocalizedString('Longitude');
		}
		return __super.prototype.readableNameForProperty.call(this, name);};
	

SimpleMapView.prototype.initPropertiesFromData = function SimpleMapView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("usesLivePreview")) this.usesLivePreview = data.usesLivePreview;
if (data.hasOwnProperty("mapType")) this.mapType = data.mapType;
if (data.hasOwnProperty("latitude")) this.latitude = data.latitude;
if (data.hasOwnProperty("longitude")) this.longitude = data.longitude;
if (data.hasOwnProperty("latitudinalMeters")) this.latitudinalMeters = data.latitudinalMeters;
if (data.hasOwnProperty("annotations")) this.annotations = data.annotations;
};

SimpleMapView.prototype.decodeData = function SimpleMapView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("annotations")) decoded.annotations = []; if (Array.isArray(data.annotations)) { data.annotations.forEach(function (o) { decoded.annotations.push(this.context.decodeObjectTree(o)); }.bind(this)); }
return decoded; };

SimpleMapView.prototype.encode = function SimpleMapView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._annotations && this._annotations.encode) {encoded.annotations = []; this._annotations.forEach(function (o) { encoded.annotations.push(o.encode()); });
}return encoded; };

SimpleMapView.prototype.encodeCloned = function SimpleMapView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._annotations && this._annotations.encode) {encoded.annotations = []; this._annotations.forEach(function (o) { encoded.annotations.push(o.encodeCloned()); });
}return encoded; };

SimpleMapView.prototype.expectedTypeForProperty = function SimpleMapView_expectedTypeForProperty(key) {
	if (key === "urlBefore") return "";
	if (key === "spinningWheel") return "";
	if (key === "spinningWheelView") return "";
	if (key === "canReload") return "";
	if (key === "iframe") return "";
	if (key === "staticImage") return "";
	if (key === "label") return "";
	if (key === "storyboardTagName") return "";
	if (key === "cocoaType") return "";
	if (key === "cocoaCustomType") return "";
	if (key === "isPlugin") return "";
	if (key === "encodesSubviews") return "";
	if (key === "readableValue") return "";
	if (key === "readableType") return "";
	if (key === "singleAnnotationQuery") return "String";
	if (key === "singleAnnotationLatitude") return "String";
	if (key === "singleAnnotationLongitude") return "String";
	if (key === "inspectorProperties") return "";
	if (key === "usesLivePreview") return "Boolean";
	if (key === "e_usesLivePreview") return "Boolean";
	if (key === "mapType") return "Number";
	if (key === "e_mapType") return "Number";
	if (key === "nameIsEditable") return "";
	if (key === "latitude") return "String";
	if (key === "longitude") return "String";
	if (key === "latitudinalMeters") return "Number";
	if (key === "annotations") return "SimpleMapAnnotation[]";
	if (key === "outlineIconURL") return "";
	if (key === "bindableProperties") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SimpleMapView; }()));
registerType('info.appdoo-mac', (function () { function SimpleMapAnnotation() {} var __super = setSupertypeFromDomain(SimpleMapAnnotation, 'BasicObject', 'Core');

	Object.defineProperty(SimpleMapAnnotation.prototype, "positionMode", {
	outlet: true, 
	enumerable: true, get:function () { return this._positionMode; }, set:function (v) {if (!Object.hasOwnProperty(this, "_positionMode")) Object.defineProperty(this, "_positionMode", { writable: true, configurable: true }); this._positionMode = v; }});
	

	Object.defineProperty(SimpleMapAnnotation.prototype, "latitude", {
	enumerable: true, 
	outlet: true, get:function () { return this._latitude; }, set:function (v) {if (!Object.hasOwnProperty(this, "_latitude")) Object.defineProperty(this, "_latitude", { writable: true, configurable: true }); this._latitude = v; }});
	

	Object.defineProperty(SimpleMapAnnotation.prototype, "longitude", {
	enumerable: true, 
	outlet: true, get:function () { return this._longitude; }, set:function (v) {if (!Object.hasOwnProperty(this, "_longitude")) Object.defineProperty(this, "_longitude", { writable: true, configurable: true }); this._longitude = v; }});
	

	Object.defineProperty(SimpleMapAnnotation.prototype, "title", {
	enumerable: true, 
	outlet: true, get:function () { return this._title; }, set:function (v) {if (!Object.hasOwnProperty(this, "_title")) Object.defineProperty(this, "_title", { writable: true, configurable: true }); this._title = v; }});
	

	Object.defineProperty(SimpleMapAnnotation.prototype, "subtitle", {
	enumerable: true, 
	outlet: true, get:function () { return this._subtitle; }, set:function (v) {if (!Object.hasOwnProperty(this, "_subtitle")) Object.defineProperty(this, "_subtitle", { writable: true, configurable: true }); this._subtitle = v; }});
	

	Object.defineProperty(SimpleMapAnnotation.prototype, "query", {
	enumerable: true, 
	outlet: true, get:function () { return this._query; }, set:function (v) {if (!Object.hasOwnProperty(this, "_query")) Object.defineProperty(this, "_query", { writable: true, configurable: true }); this._query = v; }});
	
	

	Object.defineProperty(SimpleMapAnnotation.prototype, "readableType", {
		get: function () { return LocalizedString('Annotation'); }});
	

	Object.defineProperty(SimpleMapAnnotation.prototype, "readableValue", {
		get: function () { return this.title || this.readableType; }});
	
	

	Object.defineProperty(SimpleMapAnnotation.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
						{ name: LocalizedString('Title'), keyPath: 'title' },
						{ name: LocalizedString('Subtitle'), keyPath: 'subtitle' },
						
						
						{ name: 'Lat.', keyPath: 'latitude', marginTop: -4 },
						{ name: 'Long.', keyPath: 'longitude' },
						
					]
				},
		
			];

		}});
	

	Object.defineProperty(SimpleMapAnnotation.prototype, "outlineIconURL", {
		get: function () {
			return 'PlugIns/SimpleMapView.cpsplugin/Editor/SimpleMapAnnotation@2x.png';
		}});
	

SimpleMapAnnotation.prototype.initPropertiesFromData = function SimpleMapAnnotation_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("positionMode")) this.positionMode = data.positionMode;
if (data.hasOwnProperty("latitude")) this.latitude = data.latitude;
if (data.hasOwnProperty("longitude")) this.longitude = data.longitude;
if (data.hasOwnProperty("title")) this.title = data.title;
if (data.hasOwnProperty("subtitle")) this.subtitle = data.subtitle;
if (data.hasOwnProperty("query")) this.query = data.query;
};

SimpleMapAnnotation.prototype.decodeData = function SimpleMapAnnotation_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

SimpleMapAnnotation.prototype.encode = function SimpleMapAnnotation_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

SimpleMapAnnotation.prototype.encodeCloned = function SimpleMapAnnotation_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

SimpleMapAnnotation.prototype.expectedTypeForProperty = function SimpleMapAnnotation_expectedTypeForProperty(key) {
	if (key === "positionMode") return "String";
	if (key === "latitude") return "String";
	if (key === "longitude") return "String";
	if (key === "title") return "String";
	if (key === "subtitle") return "String";
	if (key === "query") return "String";
	if (key === "readableType") return "";
	if (key === "readableValue") return "";
	if (key === "inspectorProperties") return "";
	if (key === "outlineIconURL") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SimpleMapAnnotation; }()));
registerType('info.appdoo-mac', (function () { function SearchPlaceOnMap() {} var __super = setSupertypeFromDomain(SearchPlaceOnMap, 'iOSInstruction', 'appdoo.iOS');

	Object.defineProperty(SearchPlaceOnMap.prototype, "query", {
	outlet: true, 
	enumerable: true, get:function () { return this._query; }, set:function (v) {if (!Object.hasOwnProperty(this, "_query")) Object.defineProperty(this, "_query", { writable: true, configurable: true }); this._query = v; }});
	

	Object.defineProperty(SearchPlaceOnMap.prototype, "mapID", {
	outlet: true, 
	enumerable: true, get:function () { return this._mapID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_mapID")) Object.defineProperty(this, "_mapID", { writable: true, configurable: true }); this._mapID = v; }});
	







	Object.defineProperty(SearchPlaceOnMap.prototype, "readableValue", {
		get: function () { return LocalizedString('Find Location on the Map'); }});
	

	Object.defineProperty(SearchPlaceOnMap.prototype, "inspectorProperties", {
		get: function () {

			return [
		
				{
					type: 'group',
					title: this.readableValue,
					id: this.constructor.name,
					items: [
					
						{ type:'info', html: LocalizedString('This action searches a location on the map.'), left: 26, height: 46, showIcon: false },
						
						{ name: LocalizedString('Object'), keyPath: 'mapID',
							type: 'view', viewType: 'SimpleMapView' },

						{ name: LocalizedString('Search Term'), keyPath: 'query' },
		
					]
				},
			];
		}});
	

SearchPlaceOnMap.prototype.transformDataForObjectiveC = function SearchPlaceOnMap_transformDataForObjectiveC(instruction, generator) {
		
		generator.demandPluginWithIdentifier('info.appdoo-mac.MapActions');
		
		var viewOutletName = generator.outletNameForProjectID[instruction.mapID];
		
		var queryString = generator.generateStringValueFromObjectProperty(instruction, 'query');
		
		return '[MapActions searchMap:self.'+viewOutletName+' withQuery:'+queryString+'];';
		};
	

	Object.defineProperty(SearchPlaceOnMap.prototype, "bindableProperties", {
		get: function () {
			return [
				['query', LocalizedString('Search Term')]
			];
		}});
	


SearchPlaceOnMap.prototype.initPropertiesFromData = function SearchPlaceOnMap_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("query")) this.query = data.query;
if (data.hasOwnProperty("mapID")) this.mapID = data.mapID;
};

SearchPlaceOnMap.prototype.decodeData = function SearchPlaceOnMap_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

SearchPlaceOnMap.prototype.encode = function SearchPlaceOnMap_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

SearchPlaceOnMap.prototype.encodeCloned = function SearchPlaceOnMap_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

SearchPlaceOnMap.prototype.expectedTypeForProperty = function SearchPlaceOnMap_expectedTypeForProperty(key) {
	if (key === "query") return "String";
	if (key === "mapID") return "String";
	if (key === "readableValue") return "";
	if (key === "inspectorProperties") return "";
	if (key === "bindableProperties") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SearchPlaceOnMap; }()));