//
//  StaticCollectionViewDataSource.m
//

#import "StaticCollectionViewDataSource.h"

@implementation StaticCollectionViewDataSource {
	NSArray * cellSizes;
}

- (void)setCellSizesString:(NSString *)cellSizesString {
	cellSizes = [cellSizesString componentsSeparatedByString:@"	"];
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
	return cellSizes.count;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {

	NSInteger number = (indexPath.item+1);
	NSString * reuseIdentifier = [NSString stringWithFormat:@"Cell %ld", (long)number];

	UICollectionViewCell * cell = [collectionView dequeueReusableCellWithReuseIdentifier:reuseIdentifier forIndexPath:indexPath];

	return cell;
}

// Delegate method
-(CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath *)indexPath {
	
	return CGSizeFromString(cellSizes[indexPath.item]);
	
}

@end
