//
//  StepperDataProvider.m
//
//

#import "StepperDataProvider.h"

@implementation StepperDataProvider {
	NSDictionary * _contents;
	BOOL _didLoad;
	NSDateFormatter * _dateFormatter;
}

- (BOOL)didLoad {
	return _didLoad;
}

- (void)setControl:(UIStepper *)control {
	_control = control;
	_didLoad = YES;
}

- (void)valueDidChange:(UIDatePicker *)control {
	[self updateContents];
	[self notifyObservers];
}

- (void)updateContents {
	_contents = @{ @"value": [NSNumber numberWithDouble:_control.value] };
}

- (id)contents {
	return _contents;
}

@end


@implementation UIStepper (DataProvider)

- (void)setDataProvider:(StepperDataProvider *)provider {
	provider.control = self;
	[provider updateContents];
	[self addTarget:provider action:@selector(valueDidChange:) forControlEvents:UIControlEventValueChanged];
}

@end